/*
 * Decompiled with CFR 0.152.
 */
package org.minidns.dnsname;

public abstract class InvalidDnsNameException
extends IllegalStateException {
    private static final long serialVersionUID = 1L;
    protected final String ace;

    protected InvalidDnsNameException(String ace) {
        this.ace = ace;
    }

    public static class DNSNameTooLongException
    extends InvalidDnsNameException {
        private static final long serialVersionUID = 1L;
        private final byte[] bytes;

        public DNSNameTooLongException(String ace, byte[] bytes) {
            super(ace);
            this.bytes = bytes;
        }

        @Override
        public String getMessage() {
            return "The DNS name '" + this.ace + "' exceeds the maximum name length of 255 octets by " + (this.bytes.length - 255) + " octets.";
        }
    }

    public static class LabelTooLongException
    extends InvalidDnsNameException {
        private static final long serialVersionUID = 1L;
        private final String label;

        public LabelTooLongException(String ace, String label) {
            super(ace);
            this.label = label;
        }

        @Override
        public String getMessage() {
            return "The DNS name '" + this.ace + "' contains the label '" + this.label + "' which exceeds the maximum label length of 63 octets by " + (this.label.length() - 63) + " octets.";
        }
    }
}

