/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.thing.internal;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.model.core.ModelCoreConstants;
import org.openhab.core.model.item.BindingConfigParseException;
import org.openhab.core.model.item.BindingConfigReader;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.link.ItemChannelLink;
import org.openhab.core.thing.link.ItemChannelLinkProvider;
import org.osgi.service.component.annotations.Component;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={GenericItemChannelLinkProvider.class, ItemChannelLinkProvider.class, BindingConfigReader.class})
public class GenericItemChannelLinkProvider
extends AbstractProvider<ItemChannelLink>
implements BindingConfigReader,
ItemChannelLinkProvider {
    private final Logger logger = LoggerFactory.getLogger(GenericItemChannelLinkProvider.class);
    protected Map<String, Map<String, Map<ChannelUID, ItemChannelLink>>> itemChannelLinkMap = new ConcurrentHashMap<String, Map<String, Map<ChannelUID, ItemChannelLink>>>();
    private Map<String, Set<ChannelUID>> addedItemChannels = new ConcurrentHashMap<String, Set<ChannelUID>>();
    protected Map<String, Set<String>> contextMap = new ConcurrentHashMap<String, Set<String>>();
    private @Nullable Set<String> previousItemNames;

    public String getBindingType() {
        return "channel";
    }

    public void validateItemType(String itemType, String bindingConfig) throws BindingConfigParseException {
    }

    public void processBindingConfiguration(String context, String itemType, String itemName, String bindingConfig, Configuration configuration) throws BindingConfigParseException {
        String[] uids = bindingConfig.split(",");
        if (uids.length == 0) {
            throw new BindingConfigParseException("At least one Channel UID should be provided: <bindingID>.<thingTypeId>.<thingId>.<channelId>");
        }
        String[] stringArray = uids;
        int n = uids.length;
        int n2 = 0;
        while (n2 < n) {
            String uid = stringArray[n2];
            this.createItemChannelLink(context, itemName, uid.trim(), configuration);
            ++n2;
        }
    }

    private void createItemChannelLink(String context, String itemName, String channelUID, Configuration configuration) throws BindingConfigParseException {
        String profile;
        Object object;
        ChannelUID channelUIDObject;
        try {
            channelUIDObject = new ChannelUID(channelUID);
        }
        catch (IllegalArgumentException e) {
            throw new BindingConfigParseException(e.getMessage());
        }
        if (configuration.containsKey("profile") && (object = configuration.get("profile")) instanceof String && (profile = (String)object).indexOf(":") == -1) {
            String fullProfile = "system:" + profile;
            configuration.put("profile", (Object)fullProfile);
            this.logger.info("Profile '{}' for channel '{}' is missing the scope prefix, assuming the correct UID is '{}'. Check your configuration.", new Object[]{profile, channelUID, fullProfile});
        }
        ItemChannelLink itemChannelLink = new ItemChannelLink(itemName, channelUIDObject, configuration);
        Set itemNames = Objects.requireNonNull(this.contextMap.computeIfAbsent(context, k -> new HashSet()));
        itemNames.add(itemName);
        if (this.previousItemNames != null) {
            this.previousItemNames.remove(itemName);
        }
        Map channelLinkMap = Objects.requireNonNull(this.itemChannelLinkMap.computeIfAbsent(context, k -> new ConcurrentHashMap()));
        Map links = Objects.requireNonNull(channelLinkMap.computeIfAbsent(itemName, k -> new HashMap(2)));
        ItemChannelLink oldLink = links.put(channelUIDObject, itemChannelLink);
        if (this.isValidContextForListeners(context)) {
            if (oldLink == null) {
                this.notifyListenersAboutAddedElement(itemChannelLink);
            } else {
                this.notifyListenersAboutUpdatedElement(oldLink, itemChannelLink);
            }
        }
        this.addedItemChannels.computeIfAbsent(itemName, k -> new HashSet(2)).add(channelUIDObject);
    }

    public void startConfigurationUpdate(String context) {
        Set<String> previous;
        if (this.previousItemNames != null) {
            this.logger.warn("There already is an update transaction for generic item channel links. Continuing anyway.");
        }
        this.previousItemNames = (previous = this.contextMap.get(context)) != null ? new HashSet<String>(previous) : new HashSet();
    }

    public void stopConfigurationUpdate(String context) {
        Set<String> previousItemNames = this.previousItemNames;
        this.previousItemNames = null;
        if (previousItemNames == null) {
            return;
        }
        Map channelLinkMap = this.itemChannelLinkMap.getOrDefault(context, new HashMap());
        for (String itemName2 : previousItemNames) {
            Map links = (Map)channelLinkMap.remove(itemName2);
            if (links == null || !this.isValidContextForListeners(context)) continue;
            links.values().forEach(arg_0 -> ((GenericItemChannelLinkProvider)this).notifyListenersAboutRemovedElement(arg_0));
        }
        Optional.ofNullable(this.contextMap.get(context)).ifPresent(ctx -> {
            boolean bl = ctx.removeAll(previousItemNames);
        });
        this.addedItemChannels.forEach((itemName, addedChannelUIDs) -> {
            Map links = channelLinkMap.getOrDefault(itemName, Map.of());
            HashSet removedChannelUIDs = new HashSet(links.keySet());
            removedChannelUIDs.removeAll((Collection<?>)addedChannelUIDs);
            removedChannelUIDs.forEach(removedChannelUID -> {
                ItemChannelLink link = (ItemChannelLink)links.remove(removedChannelUID);
                if (link != null && this.isValidContextForListeners(context)) {
                    this.notifyListenersAboutRemovedElement(link);
                }
            });
        });
        this.addedItemChannels.clear();
        if (channelLinkMap.isEmpty()) {
            this.itemChannelLinkMap.remove(context);
        }
    }

    public Collection<ItemChannelLink> getAll() {
        return this.itemChannelLinkMap.keySet().stream().filter(context -> this.isValidContextForListeners((String)context)).map(name -> this.itemChannelLinkMap.getOrDefault(name, Map.of())).flatMap(m -> m.values().stream()).flatMap(m -> m.values().stream()).toList();
    }

    public Collection<ItemChannelLink> getAllFromContext(String context) {
        return this.itemChannelLinkMap.getOrDefault(context, Map.of()).values().stream().flatMap(m -> m.values().stream()).toList();
    }

    private boolean isValidContextForListeners(String context) {
        return !ModelCoreConstants.isIsolatedModel((String)context);
    }
}

