/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.things.fileconverter;

import java.io.ByteArrayInputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.items.ItemUtil;
import org.openhab.core.model.yaml.YamlElement;
import org.openhab.core.model.yaml.YamlModelRepository;
import org.openhab.core.model.yaml.internal.items.YamlChannelLinkProvider;
import org.openhab.core.model.yaml.internal.things.YamlChannelDTO;
import org.openhab.core.model.yaml.internal.things.YamlThingDTO;
import org.openhab.core.model.yaml.internal.things.YamlThingProvider;
import org.openhab.core.thing.Bridge;
import org.openhab.core.thing.Channel;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.fileconverter.AbstractThingFileGenerator;
import org.openhab.core.thing.fileconverter.ThingFileGenerator;
import org.openhab.core.thing.fileconverter.ThingFileParser;
import org.openhab.core.thing.link.ItemChannelLink;
import org.openhab.core.thing.type.ChannelKind;
import org.openhab.core.thing.type.ChannelType;
import org.openhab.core.thing.type.ChannelTypeRegistry;
import org.openhab.core.thing.type.ChannelTypeUID;
import org.openhab.core.thing.type.ThingType;
import org.openhab.core.thing.type.ThingTypeRegistry;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@NonNullByDefault
@Component(immediate=true, service={ThingFileGenerator.class, ThingFileParser.class})
public class YamlThingFileConverter
extends AbstractThingFileGenerator
implements ThingFileParser {
    private final YamlModelRepository modelRepository;
    private final YamlThingProvider thingProvider;
    private final YamlChannelLinkProvider itemChannelLinkProvider;
    private final LocaleProvider localeProvider;

    @Activate
    public YamlThingFileConverter(@Reference YamlModelRepository modelRepository, @Reference YamlThingProvider thingProvider, @Reference YamlChannelLinkProvider itemChannelLinkProvider, @Reference ThingTypeRegistry thingTypeRegistry, @Reference ChannelTypeRegistry channelTypeRegistry, @Reference ConfigDescriptionRegistry configDescRegistry, @Reference LocaleProvider localeProvider) {
        super(thingTypeRegistry, channelTypeRegistry, configDescRegistry);
        this.modelRepository = modelRepository;
        this.thingProvider = thingProvider;
        this.itemChannelLinkProvider = itemChannelLinkProvider;
        this.localeProvider = localeProvider;
    }

    public String getFileFormatGenerator() {
        return "YAML";
    }

    public void setThingsToBeGenerated(String id, List<Thing> things, boolean hideDefaultChannels, boolean hideDefaultParameters) {
        ArrayList<YamlElement> elements = new ArrayList<YamlElement>();
        things.forEach(thing -> elements.add(this.buildThingDTO((Thing)thing, hideDefaultChannels, hideDefaultParameters)));
        this.modelRepository.addElementsToBeGenerated(id, elements);
    }

    public void generateFileFormat(String id, OutputStream out) {
        this.modelRepository.generateFileFormat(id, out);
    }

    private YamlThingDTO buildThingDTO(Thing thing, boolean hideDefaultChannels, boolean hideDefaultParameters) {
        YamlThingDTO dto = new YamlThingDTO();
        dto.uid = thing.getUID().getAsString();
        dto.isBridge = thing instanceof Bridge ? Boolean.valueOf(true) : null;
        ThingUID bridgeUID = thing.getBridgeUID();
        dto.bridge = bridgeUID == null ? null : bridgeUID.getAsString();
        ThingType thingType = this.thingTypeRegistry.getThingType(thing.getThingTypeUID(), this.localeProvider.getLocale());
        dto.label = thingType != null && thingType.getLabel().equals(thing.getLabel()) ? null : thing.getLabel();
        dto.location = thing.getLocation();
        LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>();
        this.getConfigurationParameters(thing, hideDefaultParameters).forEach(param -> {
            Object object = param.value();
            if (object instanceof List) {
                List list = (List)object;
                if (!list.isEmpty()) {
                    config.put(param.name(), param.value());
                }
            } else {
                config.put(param.name(), param.value());
            }
        });
        dto.config = config.isEmpty() ? null : config;
        LinkedHashMap<String, YamlChannelDTO> channels = new LinkedHashMap<String, YamlChannelDTO>();
        List channelList = hideDefaultChannels ? this.getNonDefaultChannels(thing) : thing.getChannels();
        channelList.forEach(channel -> channels.put(channel.getUID().getId(), this.buildChannelDTO((Channel)channel, hideDefaultParameters)));
        dto.channels = channels.isEmpty() ? null : channels;
        return dto;
    }

    private YamlChannelDTO buildChannelDTO(Channel channel, boolean hideDefaultParameters) {
        YamlChannelDTO dto = new YamlChannelDTO();
        ChannelTypeUID channelTypeUID = channel.getChannelTypeUID();
        if (channelTypeUID != null) {
            dto.type = channelTypeUID.getId();
            ChannelType channelType = this.channelTypeRegistry.getChannelType(channelTypeUID, this.localeProvider.getLocale());
            dto.label = channelType != null && channelType.getLabel().equals(channel.getLabel()) ? null : channel.getLabel();
            String descr = channelType != null ? channelType.getDescription() : null;
            dto.description = descr != null && descr.equals(channel.getDescription()) ? null : channel.getDescription();
        } else {
            dto.kind = channel.getKind() == ChannelKind.STATE ? null : "trigger";
            String itemType = channel.getAcceptedItemType();
            dto.itemType = itemType != null ? ItemUtil.getMainItemType((String)itemType) : null;
            dto.itemDimension = ItemUtil.getItemTypeExtension((String)itemType);
            dto.label = channel.getLabel();
            dto.description = channel.getDescription();
        }
        LinkedHashMap<String, Object> config = new LinkedHashMap<String, Object>();
        this.getConfigurationParameters(channel, hideDefaultParameters).forEach(param -> {
            Object object = param.value();
            if (object instanceof List) {
                List list = (List)object;
                if (!list.isEmpty()) {
                    config.put(param.name(), param.value());
                }
            } else {
                config.put(param.name(), param.value());
            }
        });
        dto.config = config.isEmpty() ? null : config;
        return dto;
    }

    public String getFileFormatParser() {
        return "YAML";
    }

    public @Nullable String startParsingFileFormat(String syntax, List<String> errors, List<String> warnings) {
        ByteArrayInputStream inputStream = new ByteArrayInputStream(syntax.getBytes());
        return this.modelRepository.createIsolatedModel(inputStream, errors, warnings);
    }

    public Collection<Thing> getParsedThings(String modelName) {
        return this.thingProvider.getAllFromModel(modelName);
    }

    public Collection<ItemChannelLink> getParsedChannelLinks(String modelName) {
        return this.itemChannelLinkProvider.getAllFromModel(modelName);
    }

    public void finishParsingFileFormat(String modelName) {
        this.modelRepository.removeIsolatedModel(modelName);
    }
}

