﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/cloudhsmv2/model/BackupPolicy.h>
#include <aws/core/Globals.h>
#include <aws/core/utils/EnumParseOverflowContainer.h>
#include <aws/core/utils/HashingUtils.h>

using namespace Aws::Utils;

namespace Aws {
namespace CloudHSMV2 {
namespace Model {
namespace BackupPolicyMapper {

static const int DEFAULT_HASH = HashingUtils::HashString("DEFAULT");

BackupPolicy GetBackupPolicyForName(const Aws::String& name) {
  int hashCode = HashingUtils::HashString(name.c_str());
  if (hashCode == DEFAULT_HASH) {
    return BackupPolicy::DEFAULT;
  }
  EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
  if (overflowContainer) {
    overflowContainer->StoreOverflow(hashCode, name);
    return static_cast<BackupPolicy>(hashCode);
  }

  return BackupPolicy::NOT_SET;
}

Aws::String GetNameForBackupPolicy(BackupPolicy enumValue) {
  switch (enumValue) {
    case BackupPolicy::NOT_SET:
      return {};
    case BackupPolicy::DEFAULT:
      return "DEFAULT";
    default:
      EnumParseOverflowContainer* overflowContainer = Aws::GetEnumOverflowContainer();
      if (overflowContainer) {
        return overflowContainer->RetrieveOverflow(static_cast<int>(enumValue));
      }

      return {};
  }
}

}  // namespace BackupPolicyMapper
}  // namespace Model
}  // namespace CloudHSMV2
}  // namespace Aws
