﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codepipeline/model/OverrideStageConditionRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::CodePipeline::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String OverrideStageConditionRequest::SerializePayload() const {
  JsonValue payload;

  if (m_pipelineNameHasBeenSet) {
    payload.WithString("pipelineName", m_pipelineName);
  }

  if (m_stageNameHasBeenSet) {
    payload.WithString("stageName", m_stageName);
  }

  if (m_pipelineExecutionIdHasBeenSet) {
    payload.WithString("pipelineExecutionId", m_pipelineExecutionId);
  }

  if (m_conditionTypeHasBeenSet) {
    payload.WithString("conditionType", ConditionTypeMapper::GetNameForConditionType(m_conditionType));
  }

  return payload.View().WriteReadable();
}

Aws::Http::HeaderValueCollection OverrideStageConditionRequest::GetRequestSpecificHeaders() const {
  Aws::Http::HeaderValueCollection headers;
  headers.insert(Aws::Http::HeaderValuePair("X-Amz-Target", "CodePipeline_20150709.OverrideStageCondition"));
  return headers;
}
