/* do not edit automatically generated by mc from wrapc.  */
/* wrapc.def provides access to more of the C library.

Copyright (C) 2001-2026 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

Under Section 7 of GPL version 3, you are granted additional
permissions described in the GCC Runtime Library Exception, version
3.1, as published by the Free Software Foundation.

You should have received a copy of the GNU General Public License and
a copy of the GCC Runtime Library Exception along with this program;
see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see
<http://www.gnu.org/licenses/>.  */


#if !defined (_wrapc_H)
#   define _wrapc_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GSYSTEM.h"

#   if defined (_wrapc_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif


/*
   strtime - returns the C string for the equivalent C asctime
             function.
*/

EXTERN void * wrapc_strtime (void);

/*
   filesize - assigns the size of a file, f, into low, high and
              returns zero if successful.
*/

EXTERN int wrapc_filesize (int f, unsigned int *low, unsigned int *high);

/*
   fileinode - return the inode associated with file, f.
*/

EXTERN int wrapc_fileinode (int f, unsigned int *low, unsigned int *high);

/*
   filemtime - returns the mtime of a file, f.
*/

EXTERN int wrapc_filemtime (int f);

/*
   getrand - returns a random number between 0..n-1
*/

EXTERN int wrapc_getrand (int n);

/*
   getusername - returns a C string describing the current user.
*/

EXTERN void * wrapc_getusername (void);

/*
   getnameuidgid - fills in the, uid, and, gid, which represents
                   user, name.
*/

EXTERN void wrapc_getnameuidgid (void * name, int *uid, int *gid);
EXTERN int wrapc_signbit (double r);
EXTERN int wrapc_signbitf (float s);
EXTERN int wrapc_signbitl (long double l);

/*
   isfinite - provide non builtin alternative to the gcc builtin isfinite.
              Returns 1 if x is finite and 0 if it is not.
*/

EXTERN int wrapc_isfinite (double x);

/*
   isfinitef - provide non builtin alternative to the gcc builtin isfinite.
               Returns 1 if x is finite and 0 if it is not.
*/

EXTERN int wrapc_isfinitef (float x);

/*
   isfinitel - provide non builtin alternative to the gcc builtin isfinite.
               Returns 1 if x is finite and 0 if it is not.
*/

EXTERN int wrapc_isfinitel (long double x);

/*
   isnan - provide non builtin alternative to the gcc builtin isnan.
           Returns 1 if x is a NaN otherwise return 0.
*/

EXTERN int wrapc_isnan (double x);

/*
   isnanf - provide non builtin alternative to the gcc builtin isnanf.
            Returns 1 if x is a NaN otherwise return 0.
*/

EXTERN int wrapc_isnanf (float x);

/*
   isnanl - provide non builtin alternative to the gcc builtin isnanl.
            Returns 1 if x is a NaN otherwise return 0.
*/

EXTERN int wrapc_isnanl (long double x);

/*
   SeekSet - return the system libc SEEK_SET value.
*/

EXTERN int wrapc_SeekSet (void);

/*
    SeekEnd - return the system libc SEEK_END value.
*/

EXTERN int wrapc_SeekEnd (void);

/*
   ReadOnly - return the system value of O_RDONLY.
*/

EXTERN unsigned int wrapc_ReadOnly (void);

/*
   WriteOnly - return the system value of O_WRONLY.
*/

EXTERN unsigned int wrapc_WriteOnly (void);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
