/*
 * pi3's Linux kernel Runtime Guard
 *
 * Component:
 *  - Intercept 'capable' function
 *
 * Notes:
 *  - Enforce Exploit Detection validation
 *
 * Caveats:
 *  - None
 *
 * Timeline:
 *  - Created: 22.III.2020
 *
 * Author:
 *  - Adam 'pi3' Zabrocki (http://pi3.com.pl)
 *
 */

#include "../../../../p_lkrg_main.h"


char p_capable_kretprobe_state = 0;

static struct kretprobe p_capable_kretprobe = {
    .kp.symbol_name = "security_capable",
    .handler = p_capable_ret,
    .entry_handler = p_capable_entry,
    .data_size = sizeof(struct p_capable_data),
};

/*
 * x86-64 syscall ABI:
 *  *rax - syscall_number
 *    rdi - 1st argument
 *    rsi - 2nd argument
 *    rdx - 3rd argument
 *    rcx - 4th argument
 *
 *    r8  - 5th one
 *    r9  - 6th one
 */

int p_capable_entry(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   struct p_ed_process *p_tmp = NULL;
   unsigned long p_flags;

   p_ed_pcfi_cpu(1);

//   p_ed_enforce_validation();

   if (p_is_ed_task(current)) {
      p_tasks_read_lock(&p_flags);
      if ( (p_tmp = p_find_ed_by_pid(task_pid_nr(current))) != NULL) {
         p_ed_enforce_pcfi(current, p_tmp, p_regs);
      }
      p_ed_validate_current();
      p_tasks_read_unlock(&p_flags);
   }

   return 0;
}


int p_capable_ret(struct kretprobe_instance *p_ri, struct pt_regs *p_regs) {

   return 0;
}


GENERATE_INSTALL_FUNC(capable)
