package org.checkerframework.checker.lock;

import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.framework.flow.CFAbstractAnalysis;
import org.checkerframework.framework.flow.CFStore;
import org.checkerframework.framework.flow.CFValue;
import org.checkerframework.javacutil.AnnotationMirrorSet;

/**
 * The analysis class for the lock type system.
 *
 * <p>This class extends {@link CFAbstractAnalysis} so that {@link LockStore} is used rather than
 * {@link CFStore}.
 */
public class LockAnalysis extends CFAbstractAnalysis<CFValue, LockStore, LockTransfer> {

  /**
   * Creates a new {@link LockAnalysis}.
   *
   * @param checker the checker
   * @param factory the factory
   */
  public LockAnalysis(BaseTypeChecker checker, LockAnnotatedTypeFactory factory) {
    super(checker, factory);
  }

  @Override
  public LockTransfer createTransferFunction() {
    return new LockTransfer(this, (LockChecker) checker);
  }

  @Override
  public LockStore createEmptyStore(boolean sequentialSemantics) {
    return new LockStore(this, sequentialSemantics);
  }

  @Override
  public LockStore createCopiedStore(LockStore s) {
    return new LockStore(this, s);
  }

  @Override
  public @Nullable CFValue createAbstractValue(
      AnnotationMirrorSet annotations, TypeMirror underlyingType) {
    return getCfValue(this, annotations, underlyingType);
  }
}
