//! linux_raw syscalls supporting `rustix::rand`.
//!
//! # Safety
//!
//! See the `rustix::backend` module documentation for details.
#![allow(unsafe_code, clippy::undocumented_unsafe_blocks)]

use crate::backend::conv::{pass_usize, ret_usize};
use crate::io;
use crate::rand::GetRandomFlags;

#[inline]
pub(crate) unsafe fn getrandom(buf: (*mut u8, usize), flags: GetRandomFlags) -> io::Result<usize> {
    let r = ret_usize(syscall!(__NR_getrandom, buf.0, pass_usize(buf.1), flags));

    #[cfg(sanitize_memory)]
    if let Ok(len) = r {
        crate::msan::unpoison(buf.0, len);
    }

    r
}
