//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use core::ffi::*;
#[cfg(feature = "objc2")]
use objc2::__framework_prelude::*;

use crate::*;

/// Flags to be used for the display and render call back functions.
///
/// ***Values to be defined***
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvoptionflags?language=objc)
pub type CVOptionFlags = u64;

/// A structure for holding a SMPTE time.
/// Field: subframes
/// The number of subframes in the full message.
/// Field: subframeDivisor
/// The number of subframes per frame (typically 80).
/// Field: counter
/// The total number of messages received.
/// Field: type
/// The kind of SMPTE time using the SMPTE time type constants.
/// Field: flags
/// A set of flags that indicate the SMPTE state.
/// Field: hours
/// The number of hours in the full message.
/// Field: minutes
/// The number of minutes in the full message.
/// Field: seconds
/// The number of seconds in the full message.
/// Field: frames
/// The number of frames in the full message.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvsmptetime?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CVSMPTETime {
    pub subframes: i16,
    pub subframeDivisor: i16,
    pub counter: u32,
    pub r#type: u32,
    pub flags: u32,
    pub hours: i16,
    pub minutes: i16,
    pub seconds: i16,
    pub frames: i16,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CVSMPTETime {
    const ENCODING: Encoding = Encoding::Struct(
        "CVSMPTETime",
        &[
            <i16>::ENCODING,
            <i16>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <u32>::ENCODING,
            <i16>::ENCODING,
            <i16>::ENCODING,
            <i16>::ENCODING,
            <i16>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CVSMPTETime {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for CVSMPTETime {}

unsafe impl Sync for CVSMPTETime {}

/// Constants that describe the type of SMPTE time.
///
/// 24 Frame
///
/// 25 Frame
///
/// 30 Drop Frame
///
/// 30 Frame
///
/// 29.97 Frame
///
/// 29.97 Drop Frame
///
/// 60 Frame
///
/// 59.94 Frame
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvsmptetimetype?language=objc)
// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CVSMPTETimeType(pub u32);
impl CVSMPTETimeType {
    #[doc(alias = "kCVSMPTETimeType24")]
    pub const Type24: Self = Self(0);
    #[doc(alias = "kCVSMPTETimeType25")]
    pub const Type25: Self = Self(1);
    #[doc(alias = "kCVSMPTETimeType30Drop")]
    pub const Type30Drop: Self = Self(2);
    #[doc(alias = "kCVSMPTETimeType30")]
    pub const Type30: Self = Self(3);
    #[doc(alias = "kCVSMPTETimeType2997")]
    pub const Type2997: Self = Self(4);
    #[doc(alias = "kCVSMPTETimeType2997Drop")]
    pub const Type2997Drop: Self = Self(5);
    #[doc(alias = "kCVSMPTETimeType60")]
    pub const Type60: Self = Self(6);
    #[doc(alias = "kCVSMPTETimeType5994")]
    pub const Type5994: Self = Self(7);
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CVSMPTETimeType {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CVSMPTETimeType {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for CVSMPTETimeType {}

unsafe impl Sync for CVSMPTETimeType {}

/// Flags that describe the SMPTE time state.
///
/// The full time is valid.
///
/// Time is running.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvsmptetimeflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CVSMPTETimeFlags(pub u32);
bitflags::bitflags! {
    impl CVSMPTETimeFlags: u32 {
        #[doc(alias = "kCVSMPTETimeValid")]
        const Valid = 1<<0;
        #[doc(alias = "kCVSMPTETimeRunning")]
        const Running = 1<<1;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CVSMPTETimeFlags {
    const ENCODING: Encoding = u32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CVSMPTETimeFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for CVSMPTETimeFlags {}

unsafe impl Sync for CVSMPTETimeFlags {}

/// [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvtimeflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CVTimeFlags(pub i32);
bitflags::bitflags! {
    impl CVTimeFlags: i32 {
        #[doc(alias = "kCVTimeIsIndefinite")]
        const IsIndefinite = 1<<0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CVTimeFlags {
    const ENCODING: Encoding = i32::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CVTimeFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for CVTimeFlags {}

unsafe impl Sync for CVTimeFlags {}

/// [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvtime?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CVTime {
    pub timeValue: i64,
    pub timeScale: i32,
    pub flags: i32,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CVTime {
    const ENCODING: Encoding =
        Encoding::Struct("?", &[<i64>::ENCODING, <i32>::ENCODING, <i32>::ENCODING]);
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CVTime {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvzerotime?language=objc)
    pub static kCVZeroTime: CVTime;
}

extern "C" {
    /// [Apple's documentation](https://developer.apple.com/documentation/corevideo/kcvindefinitetime?language=objc)
    pub static kCVIndefiniteTime: CVTime;
}

/// CoreVideo uses a CVTimeStamp structure to store video display time stamps.
///
/// This structure is purposely very similar to AudioTimeStamp defined in the CoreAudio framework.
/// Most of the CVTimeStamp struct should be fairly self-explanatory. However, it is probably worth pointing out that unlike the audio time stamps, floats are not used to represent the video equivalent of sample times. This was done partly to avoid precision issues, and partly because QuickTime still uses integers for time values and time scales. In the actual implementation it has turned out to be very convenient to use integers, and we can represent framerates like NTSC (30000/1001 fps) exactly. The mHostTime structure field uses the same Mach absolute time base that is used in CoreAudio, so that clients of the CoreVideo API can synchronize between the two subsystems.
/// Field: version The current CVTimeStamp is version 0.
/// Field: videoTimeScale The scale (in units per second) of the videoTime and videoPeriod values
/// Field: videoTime This represents the start of a frame (or field for interlaced)
/// Field: hostTime Host root timebase time
/// Field: rateScalar This is the current rate of the device as measured by the timestamps, divided by the nominal rate
/// Field: videoRefreshPeriod This is the nominal update period of the current output device
/// Field: smpteTime SMPTE time representation of the time stamp.
/// Field: flags Possible values are:
/// kCVTimeStampVideoTimeValid
/// kCVTimeStampHostTimeValid
/// kCVTimeStampSMPTETimeValid
/// kCVTimeStampVideoPeriodValid
/// kCVTimeStampRateScalarValid
/// There are flags for each field to make it easier to detect interlaced vs progressive output
/// kCVTimeStampTopField
/// kCVTimeStampBottomField
/// Some commonly used combinations of timestamp flags
/// kCVTimeStampVideoHostTimeValid
/// kCVTimeStampIsInterlaced
/// Field: reserved Reserved. Do not use.
///
/// See also [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvtimestamp?language=objc)
#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct CVTimeStamp {
    pub version: u32,
    pub videoTimeScale: i32,
    pub videoTime: i64,
    pub hostTime: u64,
    pub rateScalar: c_double,
    pub videoRefreshPeriod: i64,
    pub smpteTime: CVSMPTETime,
    pub flags: u64,
    pub reserved: u64,
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CVTimeStamp {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <u32>::ENCODING,
            <i32>::ENCODING,
            <i64>::ENCODING,
            <u64>::ENCODING,
            <c_double>::ENCODING,
            <i64>::ENCODING,
            <CVSMPTETime>::ENCODING,
            <u64>::ENCODING,
            <u64>::ENCODING,
        ],
    );
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CVTimeStamp {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

/// [Apple's documentation](https://developer.apple.com/documentation/corevideo/cvtimestampflags?language=objc)
// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct CVTimeStampFlags(pub u64);
bitflags::bitflags! {
    impl CVTimeStampFlags: u64 {
        #[doc(alias = "kCVTimeStampVideoTimeValid")]
        const VideoTimeValid = 1<<0;
        #[doc(alias = "kCVTimeStampHostTimeValid")]
        const HostTimeValid = 1<<1;
        #[doc(alias = "kCVTimeStampSMPTETimeValid")]
        const SMPTETimeValid = 1<<2;
        #[doc(alias = "kCVTimeStampVideoRefreshPeriodValid")]
        const VideoRefreshPeriodValid = 1<<3;
        #[doc(alias = "kCVTimeStampRateScalarValid")]
        const RateScalarValid = 1<<4;
        #[doc(alias = "kCVTimeStampTopField")]
        const TopField = 1<<16;
        #[doc(alias = "kCVTimeStampBottomField")]
        const BottomField = 1<<17;
        #[doc(alias = "kCVTimeStampVideoHostTimeValid")]
        const VideoHostTimeValid = CVTimeStampFlags::VideoTimeValid.0|CVTimeStampFlags::HostTimeValid.0;
        #[doc(alias = "kCVTimeStampIsInterlaced")]
        const IsInterlaced = CVTimeStampFlags::TopField.0|CVTimeStampFlags::BottomField.0;
    }
}

#[cfg(feature = "objc2")]
unsafe impl Encode for CVTimeStampFlags {
    const ENCODING: Encoding = u64::ENCODING;
}

#[cfg(feature = "objc2")]
unsafe impl RefEncode for CVTimeStampFlags {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

unsafe impl Send for CVTimeStampFlags {}

unsafe impl Sync for CVTimeStampFlags {}
