var createMediapipeChromiumTestsSimd = (() => {
  var _scriptName = typeof document != 'undefined' ? document.currentScript?.src : undefined;
  
  return (
async function(moduleArg = {}) {
  var moduleRtn;

// include: shell.js
// The Module object: Our interface to the outside world. We import
// and export values on it. There are various ways Module can be used:
// 1. Not defined. We create it here
// 2. A function parameter, function(moduleArg) => Promise<Module>
// 3. pre-run appended it, var Module = {}; ..generated code..
// 4. External script tag defines var Module.
// We need to check if Module already exists (e.g. case 3 above).
// Substitution will be replaced with actual code on later stage of the build,
// this way Closure Compiler will not mangle it (e.g. case 4. above).
// Note that if you want to run closure, and also to use Module
// after the generated code, you will need to define   var Module = {};
// before the code. Then that object will be used in the code, and you
// can continue to use Module afterwards as well.
var Module=moduleArg;// Set up the promise that indicates the Module is initialized
var readyPromiseResolve,readyPromiseReject;var readyPromise=new Promise((resolve,reject)=>{readyPromiseResolve=resolve;readyPromiseReject=reject});// Determine the runtime environment we are in. You can customize this by
// setting the ENVIRONMENT setting at compile time (see settings.js).
// Attempt to auto-detect the environment
var ENVIRONMENT_IS_WEB=typeof window=="object";var ENVIRONMENT_IS_WORKER=typeof WorkerGlobalScope!="undefined";// N.b. Electron.js environment is simultaneously a NODE-environment, but
// also a web environment.
var ENVIRONMENT_IS_NODE=typeof process=="object"&&typeof process.versions=="object"&&typeof process.versions.node=="string"&&process.type!="renderer";// --pre-jses are emitted after the Module integration code, so that they can
// refer to Module (if they choose; they can also define Module)
// Sometimes an existing Module object exists with properties
// meant to overwrite the default module functionality. Here
// we collect those properties and reapply _after_ we configure
// the current environment's defaults to avoid having to be so
// defensive during initialization.
var moduleOverrides=Object.assign({},Module);var arguments_=[];var thisProgram="./this.program";var quit_=(status,toThrow)=>{throw toThrow};// `/` should be present at the end if `scriptDirectory` is not empty
var scriptDirectory="";function locateFile(path){if(Module["locateFile"]){return Module["locateFile"](path,scriptDirectory)}return scriptDirectory+path}// Hooks that are implemented differently in different runtime environments.
var readAsync,readBinary;// Note that this includes Node.js workers when relevant (pthreads is enabled).
// Node.js workers are detected as a combination of ENVIRONMENT_IS_WORKER and
// ENVIRONMENT_IS_NODE.
if(ENVIRONMENT_IS_WEB||ENVIRONMENT_IS_WORKER){if(ENVIRONMENT_IS_WORKER){// Check worker, not web, since window could be polyfilled
scriptDirectory=self.location.href}else if(typeof document!="undefined"&&document.currentScript){// web
scriptDirectory=document.currentScript.src}// When MODULARIZE, this JS may be executed later, after document.currentScript
// is gone, so we saved it, and we use it here instead of any other info.
if(_scriptName){scriptDirectory=_scriptName}// blob urls look like blob:http://site.com/etc/etc and we cannot infer anything from them.
// otherwise, slice off the final part of the url to find the script directory.
// if scriptDirectory does not contain a slash, lastIndexOf will return -1,
// and scriptDirectory will correctly be replaced with an empty string.
// If scriptDirectory contains a query (starting with ?) or a fragment (starting with #),
// they are removed because they could contain a slash.
if(scriptDirectory.startsWith("blob:")){scriptDirectory=""}else{scriptDirectory=scriptDirectory.slice(0,scriptDirectory.replace(/[?#].*/,"").lastIndexOf("/")+1)}{// include: web_or_worker_shell_read.js
if(ENVIRONMENT_IS_WORKER){readBinary=url=>{var xhr=new XMLHttpRequest;xhr.open("GET",url,false);xhr.responseType="arraybuffer";xhr.send(null);return new Uint8Array(/** @type{!ArrayBuffer} */(xhr.response))}}readAsync=async url=>{var response=await fetch(url,{credentials:"same-origin"});if(response.ok){return response.arrayBuffer()}throw new Error(response.status+" : "+response.url)}}}else{}var out=Module["print"]||console.log.bind(console);var err=Module["printErr"]||console.error.bind(console);// Merge back in the overrides
Object.assign(Module,moduleOverrides);// Free the object hierarchy contained in the overrides, this lets the GC
// reclaim data used.
moduleOverrides=null;// Emit code to handle expected values on the Module object. This applies Module.x
// to the proper local x. This has two benefits: first, we only emit it if it is
// expected to arrive, and second, by using a local everywhere else that can be
// minified.
if(Module["arguments"])arguments_=Module["arguments"];if(Module["thisProgram"])thisProgram=Module["thisProgram"];// perform assertions in shell.js after we set up out() and err(), as otherwise if an assertion fails it cannot print the message
// end include: shell.js
// include: preamble.js
// === Preamble library stuff ===
// Documentation for the public APIs defined in this file must be updated in:
//    site/source/docs/api_reference/preamble.js.rst
// A prebuilt local version of the documentation is available at:
//    site/build/text/docs/api_reference/preamble.js.txt
// You can also build docs locally as HTML or other formats in site/
// An online HTML version (which may be of a different version of Emscripten)
//    is up at http://kripken.github.io/emscripten-site/docs/api_reference/preamble.js.html
var wasmBinary=Module["wasmBinary"];// Wasm globals
var wasmMemory;//========================================
// Runtime essentials
//========================================
// whether we are quitting the application. no code should run after this.
// set in exit() and abort()
var ABORT=false;// set by exit() and abort().  Passed to 'onExit' handler.
// NOTE: This is also used as the process return code code in shell environments
// but only when noExitRuntime is false.
var EXITSTATUS;// In STRICT mode, we only define assert() when ASSERTIONS is set.  i.e. we
// don't define it at all in release modes.  This matches the behaviour of
// MINIMAL_RUNTIME.
// TODO(sbc): Make this the default even without STRICT enabled.
/** @type {function(*, string=)} */function assert(condition,text){if(!condition){// This build was created without ASSERTIONS defined.  `assert()` should not
// ever be called in this configuration but in case there are callers in
// the wild leave this simple abort() implementation here for now.
abort(text)}}// Memory management
var/** @type {!Int8Array} */HEAP8,/** @type {!Uint8Array} */HEAPU8,/** @type {!Int16Array} */HEAP16,/** @type {!Uint16Array} */HEAPU16,/** @type {!Int32Array} */HEAP32,/** @type {!Uint32Array} */HEAPU32,/** @type {!Float32Array} */HEAPF32,/** @type {!Float64Array} */HEAPF64;var runtimeInitialized=false;// include: runtime_shared.js
// include: runtime_stack_check.js
// end include: runtime_stack_check.js
// include: runtime_exceptions.js
// end include: runtime_exceptions.js
// include: runtime_debug.js
// end include: runtime_debug.js
// include: memoryprofiler.js
// end include: memoryprofiler.js
function updateMemoryViews(){var b=wasmMemory.buffer;Module["HEAP8"]=HEAP8=new Int8Array(b);Module["HEAP16"]=HEAP16=new Int16Array(b);Module["HEAPU8"]=HEAPU8=new Uint8Array(b);Module["HEAPU16"]=HEAPU16=new Uint16Array(b);Module["HEAP32"]=HEAP32=new Int32Array(b);Module["HEAPU32"]=HEAPU32=new Uint32Array(b);Module["HEAPF32"]=HEAPF32=new Float32Array(b);Module["HEAPF64"]=HEAPF64=new Float64Array(b)}// end include: runtime_shared.js
function preRun(){if(Module["preRun"]){if(typeof Module["preRun"]=="function")Module["preRun"]=[Module["preRun"]];while(Module["preRun"].length){addOnPreRun(Module["preRun"].shift())}}callRuntimeCallbacks(onPreRuns)}function initRuntime(){runtimeInitialized=true;if(!Module["noFSInit"]&&!FS.initialized)FS.init();TTY.init();wasmExports["Wf"]();FS.ignorePermissions=false}function postRun(){if(Module["postRun"]){if(typeof Module["postRun"]=="function")Module["postRun"]=[Module["postRun"]];while(Module["postRun"].length){addOnPostRun(Module["postRun"].shift())}}callRuntimeCallbacks(onPostRuns)}// A counter of dependencies for calling run(). If we need to
// do asynchronous work before running, increment this and
// decrement it. Incrementing must happen in a place like
// Module.preRun (used by emcc to add file preloading).
// Note that you can add dependencies in preRun, even though
// it happens right before run - run will be postponed until
// the dependencies are met.
var runDependencies=0;var dependenciesFulfilled=null;// overridden to take different actions when all run dependencies are fulfilled
function getUniqueRunDependency(id){return id}function addRunDependency(id){runDependencies++;Module["monitorRunDependencies"]?.(runDependencies)}function removeRunDependency(id){runDependencies--;Module["monitorRunDependencies"]?.(runDependencies);if(runDependencies==0){if(dependenciesFulfilled){var callback=dependenciesFulfilled;dependenciesFulfilled=null;callback()}}}/** @param {string|number=} what */function abort(what){Module["onAbort"]?.(what);what="Aborted("+what+")";// TODO(sbc): Should we remove printing and leave it up to whoever
// catches the exception?
err(what);ABORT=true;what+=". Build with -sASSERTIONS for more info.";// Use a wasm runtime error, because a JS error might be seen as a foreign
// exception, which means we'd run destructors on it. We need the error to
// simply make the program stop.
// FIXME This approach does not work in Wasm EH because it currently does not assume
// all RuntimeErrors are from traps; it decides whether a RuntimeError is from
// a trap or not based on a hidden field within the object. So at the moment
// we don't have a way of throwing a wasm trap from JS. TODO Make a JS API that
// allows this in the wasm spec.
// Suppress closure compiler warning here. Closure compiler's builtin extern
// definition for WebAssembly.RuntimeError claims it takes no arguments even
// though it can.
// TODO(https://github.com/google/closure-compiler/pull/3913): Remove if/when upstream closure gets fixed.
/** @suppress {checkTypes} */var e=new WebAssembly.RuntimeError(what);readyPromiseReject(e);// Throw the error whether or not MODULARIZE is set because abort is used
// in code paths apart from instantiation where an exception is expected
// to be thrown when abort is called.
throw e}var wasmBinaryFile;function findWasmBinary(){return locateFile("mediapipe_chromium_tests_simd.wasm")}function getBinarySync(file){if(file==wasmBinaryFile&&wasmBinary){return new Uint8Array(wasmBinary)}if(readBinary){return readBinary(file)}throw"both async and sync fetching of the wasm failed"}async function getWasmBinary(binaryFile){// If we don't have the binary yet, load it asynchronously using readAsync.
if(!wasmBinary){// Fetch the binary using readAsync
try{var response=await readAsync(binaryFile);return new Uint8Array(response)}catch{}}// Otherwise, getBinarySync should be able to get it synchronously
return getBinarySync(binaryFile)}async function instantiateArrayBuffer(binaryFile,imports){try{var binary=await getWasmBinary(binaryFile);var instance=await WebAssembly.instantiate(binary,imports);return instance}catch(reason){err(`failed to asynchronously prepare wasm: ${reason}`);abort(reason)}}async function instantiateAsync(binary,binaryFile,imports){if(!binary&&typeof WebAssembly.instantiateStreaming=="function"){try{var response=fetch(binaryFile,{credentials:"same-origin"});var instantiationResult=await WebAssembly.instantiateStreaming(response,imports);return instantiationResult}catch(reason){// We expect the most common failure cause to be a bad MIME type for the binary,
// in which case falling back to ArrayBuffer instantiation should work.
err(`wasm streaming compile failed: ${reason}`);err("falling back to ArrayBuffer instantiation")}}return instantiateArrayBuffer(binaryFile,imports)}function getWasmImports(){// prepare imports
return{"a":wasmImports}}// Create the wasm instance.
// Receives the wasm imports, returns the exports.
async function createWasm(){// Load the wasm module and create an instance of using native support in the JS engine.
// handle a generated wasm instance, receiving its exports and
// performing other necessary setup
/** @param {WebAssembly.Module=} module*/function receiveInstance(instance,module){wasmExports=instance.exports;wasmMemory=wasmExports["Vf"];updateMemoryViews();wasmTable=wasmExports["Xf"];removeRunDependency("wasm-instantiate");return wasmExports}// wait for the pthread pool (if any)
addRunDependency("wasm-instantiate");// Prefer streaming instantiation if available.
function receiveInstantiationResult(result){// 'result' is a ResultObject object which has both the module and instance.
// receiveInstance() will swap in the exports (to Module.asm) so they can be called
// TODO: Due to Closure regression https://github.com/google/closure-compiler/issues/3193, the above line no longer optimizes out down to the following line.
// When the regression is fixed, can restore the above PTHREADS-enabled path.
return receiveInstance(result["instance"])}var info=getWasmImports();// User shell pages can write their own Module.instantiateWasm = function(imports, successCallback) callback
// to manually instantiate the Wasm module themselves. This allows pages to
// run the instantiation parallel to any other async startup actions they are
// performing.
// Also pthreads and wasm workers initialize the wasm instance through this
// path.
if(Module["instantiateWasm"]){return new Promise((resolve,reject)=>{Module["instantiateWasm"](info,(mod,inst)=>{receiveInstance(mod,inst);resolve(mod.exports)})})}wasmBinaryFile??=findWasmBinary();try{var result=await instantiateAsync(wasmBinary,wasmBinaryFile,info);var exports=receiveInstantiationResult(result);return exports}catch(e){// If instantiation fails, reject the module ready promise.
readyPromiseReject(e);return Promise.reject(e)}}// Globals used by JS i64 conversions (see makeSetValue)
var tempDouble;var tempI64;// === Body ===
var ASM_CONSTS={2942708:($0,$1,$2)=>{throw new Error("CHECK FAIL AT "+UTF8ToString($0)+": "+$1+" "+UTF8ToString($2))},2942803:$0=>{const device=WebGPU.getJsObject($0);return device.features.has("subgroups")},2942887:$0=>{const canvas=Emval.toValue($0);const context=canvas.getContext("webgpu");return WebGPU.importJsTexture(context.getCurrentTexture())},2943030:($0,$1,$2,$3,$4)=>{const drawable=Emval.toValue($0);const device=WebGPU.getJsObject($1);const texture=WebGPU.getJsObject($2);const width=$3;const height=$4;device.queue.copyExternalImageToTexture({source:drawable},{texture},[width,height])},2943289:($0,$1,$2,$3)=>{const sourceExtTex=Emval.toValue($0);const device=WebGPU.getJsObject($1);const sampler=WebGPU.getJsObject($2);const bgLayout=WebGPU.getJsObject($3);const bindGroup=device.createBindGroup({layout:bgLayout,entries:[{binding:0,resource:sampler},{binding:1,resource:sourceExtTex}]});return WebGPU.importJsBindGroup(bindGroup)},2943659:()=>!!Module["preinitializedWebGPUDevice"],2943710:($0,$1)=>{const input=Emval.toValue($0);const output=Emval.toValue($1);const ctx=output.getContext("2d");ctx.drawImage(input,0,0,output.width,output.height)},2943875:($0,$1)=>{const inputArray=Emval.toValue($0);const output=Emval.toValue($1);const ctx=output.getContext("2d");const image_data=new ImageData(inputArray,output.width,output.height);ctx.putImageData(image_data,0,0)},2944099:($0,$1)=>{const input=Emval.toValue($0);const outputArray=Emval.toValue($1);const ctx=input.getContext("2d");const data=ctx.getImageData(0,0,input.width,input.height);outputArray.set(data.data)},2944303:()=>(typeof HTMLCanvasElement!=="undefined"),2944358:()=>{specialHTMLTargets["#canvas"]=Module.canvas},2944409:()=>(typeof wasmOffsetConverter!=="undefined")};function videopipe_export_webgpu_texture(texture_handle){const texture=WebGPU.getJsObject(texture_handle);return Emval.toHandle(texture)}function ExposeProfilingResults(calc_name,wgpu_buffer_ptr,num_repetitions){if(!Module.WEBGPU_SHADER_CALC_PROFILE){Module.WEBGPU_SHADER_CALC_PROFILE=async()=>{console.log("WebGpuShaderCalculator profiling results: ");for(const calc in Module.WEBGPU_SHADER_CALC_METRICS){const readBuffer=Module.WEBGPU_SHADER_CALC_METRICS[calc].buffer;await readBuffer.mapAsync(GPUMapMode.READ);const resultsBuffer=new BigInt64Array(readBuffer.getMappedRange());const timeDelta=resultsBuffer[1]-resultsBuffer[0];if(Number.MIN_SAFE_INTEGER<timeDelta&&timeDelta<Number.MAX_SAFE_INTEGER){const timeMs=Number(timeDelta)/1e6;const numRepetitions=Module.WEBGPU_SHADER_CALC_METRICS[calc].repetitions;console.log(`${calc} : ${timeMs/numRepetitions} ms`)}readBuffer.unmap()}console.log("Finished printing WebGpuShaderCalculator profiling.")}}const gpuReadBuffer=WebGPU.getJsObject(wgpu_buffer_ptr);Module.WEBGPU_SHADER_CALC_METRICS=Module.WEBGPU_SHADER_CALC_METRICS||{};Module.WEBGPU_SHADER_CALC_METRICS[UTF8ToString(calc_name)]={buffer:gpuReadBuffer,repetitions:num_repetitions}}function ExposeMetricsInfo(wgpu_buffer_ptr,total_inference_time_enabled,detailed_query_count,in_names){const gpuReadBuffer=WebGPU.getJsObject(wgpu_buffer_ptr);Module.MP_WEBGPU_METRICS=Module.MP_WEBGPU_METRICS||{};Module.MP_WEBGPU_METRICS.queryBuffer=gpuReadBuffer;Module.MP_WEBGPU_METRICS.totalInferenceTimeEnabled=total_inference_time_enabled;Module.MP_WEBGPU_METRICS.detailedQueryCount=detailed_query_count;Module.MP_WEBGPU_METRICS.operation_names=UTF8ToString(in_names).split("\n")}function JsGetDeviceMinSubgroupSize(deviceId){const device=WebGPU.getJsObject(deviceId);return device.adapterInfo.subgroupMinSize||device.limits.minSubgroupSize}function JsGetDeviceMaxSubgroupSize(deviceId){const device=WebGPU.getJsObject(deviceId);return device.adapterInfo.subgroupMaxSize||device.limits.maxSubgroupSize}function __asyncjs__ReadBufferDataJs(buffer_handle,data_ptr){return Asyncify.handleAsync(async()=>{const gpuReadBuffer=WebGPU.getJsObject(buffer_handle);await gpuReadBuffer.mapAsync(GPUMapMode.READ);const arrayBuffer=gpuReadBuffer.getMappedRange();const u8view=new Uint8Array(arrayBuffer);Module.HEAPU8.set(u8view,data_ptr>>>0);gpuReadBuffer.unmap()})}function hardware_concurrency(){var concurrency=1;try{concurrency=self.navigator.hardwareConcurrency}catch(e){}return concurrency}function mediapipe_import_external_texture(device_handle,source_handle){const device=WebGPU.getJsObject(device_handle);const source=Emval.toValue(source_handle);const externalTexture=device.importExternalTexture({source});return Emval.toHandle(externalTexture)}function GetAdapterArchitecture(){const device=Module["preinitializedWebGPUDevice"];const architecture=device.adapterInfo?device.adapterInfo.architecture:"Unknown";return stringToNewUTF8(architecture)}function GetAdapterDescription(){const device=Module["preinitializedWebGPUDevice"];const description=device.adapterInfo?device.adapterInfo.description:"Unknown";return stringToNewUTF8(description)}function GetAdapterDeviceName(){const device=Module["preinitializedWebGPUDevice"];const deviceName=device.adapterInfo?device.adapterInfo.device:"Unknown";return stringToNewUTF8(deviceName)}function GetAdapterVendor(){const device=Module["preinitializedWebGPUDevice"];const vendor=device.adapterInfo?device.adapterInfo.vendor:"Unknown";return stringToNewUTF8(vendor)}function __asyncjs__mediapipe_map_buffer_jspi(buffer_handle,data){return Asyncify.handleAsync(async()=>{const buffer=WebGPU.getJsObject(buffer_handle);await buffer.mapAsync(GPUMapMode.READ);const mapped=buffer.getMappedRange();HEAPU8.set(new Uint8Array(mapped),data);buffer.unmap()})}function mediapipe_create_utility_canvas2d(){let canvas;if(typeof HTMLCanvasElement!=="undefined"){canvas=document.createElement("canvas");canvas.style.display="none"}else{canvas=new OffscreenCanvas(0,0)}return Emval.toHandle(canvas)}function BeginGlQueryTiming(calc_name,num_repetitions){const gl=Module.canvas.getContext("webgl2");const query=gl.createQuery();Module.WEBGL_SHADER_CALC_METRICS=Module.WEBGL_SHADER_CALC_METRICS||{};Module.WEBGL_SHADER_CALC_METRICS[UTF8ToString(calc_name)]={query,repetitions:num_repetitions};Module.WEBGL_QUERY_TIMER_EXT=Module.WEBGL_QUERY_TIMER_EXT||gl.getExtension("EXT_disjoint_timer_query_webgl2");gl.beginQuery(Module.WEBGL_QUERY_TIMER_EXT.TIME_ELAPSED_EXT,query)}function EndGlQueryTiming(calc_name){const gl=Module.canvas.getContext("webgl2");gl.endQuery(Module.WEBGL_QUERY_TIMER_EXT.TIME_ELAPSED_EXT,Module.WEBGL_SHADER_CALC_METRICS[UTF8ToString(calc_name)].query)}function HaveOffsetConverter(){return typeof wasmOffsetConverter!=="undefined"}// end include: preamble.js
class ExitStatus{constructor(status){this.name="ExitStatus";this.message=`Program terminated with exit(${status})`;this.status=status}}var callRuntimeCallbacks=callbacks=>{while(callbacks.length>0){// Pass the module as the first argument.
callbacks.shift()(Module)}};var onPostRuns=[];var addOnPostRun=cb=>onPostRuns.unshift(cb);var onPreRuns=[];var addOnPreRun=cb=>onPreRuns.unshift(cb);var noExitRuntime=Module["noExitRuntime"]||true;var stackRestore=val=>__emscripten_stack_restore(val);var stackSave=()=>_emscripten_stack_get_current();class ExceptionInfo{// excPtr - Thrown object pointer to wrap. Metadata pointer is calculated from it.
constructor(excPtr){this.excPtr=excPtr;this.ptr=excPtr-24}set_type(type){HEAPU32[(((this.ptr)+(4))>>2)]=type}get_type(){return HEAPU32[(((this.ptr)+(4))>>2)]}set_destructor(destructor){HEAPU32[(((this.ptr)+(8))>>2)]=destructor}get_destructor(){return HEAPU32[(((this.ptr)+(8))>>2)]}set_caught(caught){caught=caught?1:0;HEAP8[(this.ptr)+(12)]=caught}get_caught(){return HEAP8[(this.ptr)+(12)]!=0}set_rethrown(rethrown){rethrown=rethrown?1:0;HEAP8[(this.ptr)+(13)]=rethrown}get_rethrown(){return HEAP8[(this.ptr)+(13)]!=0}// Initialize native structure fields. Should be called once after allocated.
init(type,destructor){this.set_adjusted_ptr(0);this.set_type(type);this.set_destructor(destructor)}set_adjusted_ptr(adjustedPtr){HEAPU32[(((this.ptr)+(16))>>2)]=adjustedPtr}get_adjusted_ptr(){return HEAPU32[(((this.ptr)+(16))>>2)]}}var exceptionLast=0;var uncaughtExceptionCount=0;var ___cxa_throw=(ptr,type,destructor)=>{var info=new ExceptionInfo(ptr);// Initialize ExceptionInfo content after it was allocated in __cxa_allocate_exception.
info.init(type,destructor);exceptionLast=ptr;uncaughtExceptionCount++;throw exceptionLast};var PATH={isAbs:path=>path.charAt(0)==="/",splitPath:filename=>{var splitPathRe=/^(\/?|)([\s\S]*?)((?:\.{1,2}|[^\/]+?|)(\.[^.\/]*|))(?:[\/]*)$/;return splitPathRe.exec(filename).slice(1)},normalizeArray:(parts,allowAboveRoot)=>{// if the path tries to go above the root, `up` ends up > 0
var up=0;for(var i=parts.length-1;i>=0;i--){var last=parts[i];if(last==="."){parts.splice(i,1)}else if(last===".."){parts.splice(i,1);up++}else if(up){parts.splice(i,1);up--}}// if the path is allowed to go above the root, restore leading ..s
if(allowAboveRoot){for(;up;up--){parts.unshift("..")}}return parts},normalize:path=>{var isAbsolute=PATH.isAbs(path),trailingSlash=path.slice(-1)==="/";// Normalize the path
path=PATH.normalizeArray(path.split("/").filter(p=>!!p),!isAbsolute).join("/");if(!path&&!isAbsolute){path="."}if(path&&trailingSlash){path+="/"}return(isAbsolute?"/":"")+path},dirname:path=>{var result=PATH.splitPath(path),root=result[0],dir=result[1];if(!root&&!dir){// No dirname whatsoever
return"."}if(dir){// It has a dirname, strip trailing slash
dir=dir.slice(0,-1)}return root+dir},basename:path=>path&&path.match(/([^\/]+|\/)\/*$/)[1],join:(...paths)=>PATH.normalize(paths.join("/")),join2:(l,r)=>PATH.normalize(l+"/"+r)};var initRandomFill=()=>view=>crypto.getRandomValues(view);var randomFill=view=>{// Lazily init on the first invocation.
(randomFill=initRandomFill())(view)};var PATH_FS={resolve:(...args)=>{var resolvedPath="",resolvedAbsolute=false;for(var i=args.length-1;i>=-1&&!resolvedAbsolute;i--){var path=(i>=0)?args[i]:FS.cwd();// Skip empty and invalid entries
if(typeof path!="string"){throw new TypeError("Arguments to path.resolve must be strings")}else if(!path){return""}resolvedPath=path+"/"+resolvedPath;resolvedAbsolute=PATH.isAbs(path)}// At this point the path should be resolved to a full absolute path, but
// handle relative paths to be safe (might happen when process.cwd() fails)
resolvedPath=PATH.normalizeArray(resolvedPath.split("/").filter(p=>!!p),!resolvedAbsolute).join("/");return((resolvedAbsolute?"/":"")+resolvedPath)||"."},relative:(from,to)=>{from=PATH_FS.resolve(from).slice(1);to=PATH_FS.resolve(to).slice(1);function trim(arr){var start=0;for(;start<arr.length;start++){if(arr[start]!=="")break}var end=arr.length-1;for(;end>=0;end--){if(arr[end]!=="")break}if(start>end)return[];return arr.slice(start,end-start+1)}var fromParts=trim(from.split("/"));var toParts=trim(to.split("/"));var length=Math.min(fromParts.length,toParts.length);var samePartsLength=length;for(var i=0;i<length;i++){if(fromParts[i]!==toParts[i]){samePartsLength=i;break}}var outputParts=[];for(var i=samePartsLength;i<fromParts.length;i++){outputParts.push("..")}outputParts=outputParts.concat(toParts.slice(samePartsLength));return outputParts.join("/")}};var UTF8Decoder=new TextDecoder;/**
     * Given a pointer 'idx' to a null-terminated UTF8-encoded string in the given
     * array that contains uint8 values, returns a copy of that string as a
     * Javascript String object.
     * heapOrArray is either a regular array, or a JavaScript typed array view.
     * @param {number=} idx
     * @param {number=} maxBytesToRead
     * @return {string}
     */var UTF8ArrayToString=(heapOrArray,idx=0,maxBytesToRead=NaN)=>{var endIdx=idx+maxBytesToRead;var endPtr=idx;// TextDecoder needs to know the byte length in advance, it doesn't stop on
// null terminator by itself.  Also, use the length info to avoid running tiny
// strings through TextDecoder, since .subarray() allocates garbage.
// (As a tiny code save trick, compare endPtr against endIdx using a negation,
// so that undefined/NaN means Infinity)
while(heapOrArray[endPtr]&&!(endPtr>=endIdx))++endPtr;return UTF8Decoder.decode(heapOrArray.buffer?heapOrArray.subarray(idx,endPtr):new Uint8Array(heapOrArray.slice(idx,endPtr)))};var FS_stdin_getChar_buffer=[];var lengthBytesUTF8=str=>{var len=0;for(var i=0;i<str.length;++i){// Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code
// unit, not a Unicode code point of the character! So decode
// UTF16->UTF32->UTF8.
// See http://unicode.org/faq/utf_bom.html#utf16-3
var c=str.charCodeAt(i);// possibly a lead surrogate
if(c<=127){len++}else if(c<=2047){len+=2}else if(c>=55296&&c<=57343){len+=4;++i}else{len+=3}}return len};var stringToUTF8Array=(str,heap,outIdx,maxBytesToWrite)=>{// Parameter maxBytesToWrite is not optional. Negative values, 0, null,
// undefined and false each don't write out any bytes.
if(!(maxBytesToWrite>0))return 0;var startIdx=outIdx;var endIdx=outIdx+maxBytesToWrite-1;// -1 for string null terminator.
for(var i=0;i<str.length;++i){// Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code
// unit, not a Unicode code point of the character! So decode
// UTF16->UTF32->UTF8.
// See http://unicode.org/faq/utf_bom.html#utf16-3
// For UTF8 byte structure, see http://en.wikipedia.org/wiki/UTF-8#Description
// and https://www.ietf.org/rfc/rfc2279.txt
// and https://tools.ietf.org/html/rfc3629
var u=str.charCodeAt(i);// possibly a lead surrogate
if(u>=55296&&u<=57343){var u1=str.charCodeAt(++i);u=65536+((u&1023)<<10)|(u1&1023)}if(u<=127){if(outIdx>=endIdx)break;heap[outIdx++]=u}else if(u<=2047){if(outIdx+1>=endIdx)break;heap[outIdx++]=192|(u>>6);heap[outIdx++]=128|(u&63)}else if(u<=65535){if(outIdx+2>=endIdx)break;heap[outIdx++]=224|(u>>12);heap[outIdx++]=128|((u>>6)&63);heap[outIdx++]=128|(u&63)}else{if(outIdx+3>=endIdx)break;heap[outIdx++]=240|(u>>18);heap[outIdx++]=128|((u>>12)&63);heap[outIdx++]=128|((u>>6)&63);heap[outIdx++]=128|(u&63)}}// Null-terminate the pointer to the buffer.
heap[outIdx]=0;return outIdx-startIdx};/** @type {function(string, boolean=, number=)} */var intArrayFromString=(stringy,dontAddNull,length)=>{var len=length>0?length:lengthBytesUTF8(stringy)+1;var u8array=new Array(len);var numBytesWritten=stringToUTF8Array(stringy,u8array,0,u8array.length);if(dontAddNull)u8array.length=numBytesWritten;return u8array};var FS_stdin_getChar=()=>{if(!FS_stdin_getChar_buffer.length){var result=null;if(typeof window!="undefined"&&typeof window.prompt=="function"){// Browser.
result=window.prompt("Input: ");// returns null on cancel
if(result!==null){result+="\n"}}else{}if(!result){return null}FS_stdin_getChar_buffer=intArrayFromString(result,true)}return FS_stdin_getChar_buffer.shift()};var TTY={ttys:[],init(){},shutdown(){},register(dev,ops){TTY.ttys[dev]={input:[],output:[],ops};FS.registerDevice(dev,TTY.stream_ops)},stream_ops:{open(stream){var tty=TTY.ttys[stream.node.rdev];if(!tty){throw new FS.ErrnoError(43)}stream.tty=tty;stream.seekable=false},close(stream){// flush any pending line data
stream.tty.ops.fsync(stream.tty)},fsync(stream){stream.tty.ops.fsync(stream.tty)},read(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.get_char){throw new FS.ErrnoError(60)}var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=stream.tty.ops.get_char(stream.tty)}catch(e){throw new FS.ErrnoError(29)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(6)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.atime=Date.now()}return bytesRead},write(stream,buffer,offset,length,pos){if(!stream.tty||!stream.tty.ops.put_char){throw new FS.ErrnoError(60)}try{for(var i=0;i<length;i++){stream.tty.ops.put_char(stream.tty,buffer[offset+i])}}catch(e){throw new FS.ErrnoError(29)}if(length){stream.node.mtime=stream.node.ctime=Date.now()}return i}},default_tty_ops:{get_char(tty){return FS_stdin_getChar()},put_char(tty,val){if(val===null||val===10){out(UTF8ArrayToString(tty.output));tty.output=[]}else{if(val!=0)tty.output.push(val)}},fsync(tty){if(tty.output?.length>0){out(UTF8ArrayToString(tty.output));tty.output=[]}},ioctl_tcgets(tty){// typical setting
return{c_iflag:25856,c_oflag:5,c_cflag:191,c_lflag:35387,c_cc:[3,28,127,21,4,0,1,0,17,19,26,0,18,15,23,22,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]}},ioctl_tcsets(tty,optional_actions,data){// currently just ignore
return 0},ioctl_tiocgwinsz(tty){return[24,80]}},default_tty1_ops:{put_char(tty,val){if(val===null||val===10){err(UTF8ArrayToString(tty.output));tty.output=[]}else{if(val!=0)tty.output.push(val)}},fsync(tty){if(tty.output?.length>0){err(UTF8ArrayToString(tty.output));tty.output=[]}}}};var zeroMemory=(address,size)=>{HEAPU8.fill(0,address,address+size)};var alignMemory=(size,alignment)=>Math.ceil(size/alignment)*alignment;var mmapAlloc=size=>{size=alignMemory(size,65536);var ptr=_emscripten_builtin_memalign(65536,size);if(ptr)zeroMemory(ptr,size);return ptr};var MEMFS={ops_table:null,mount(mount){return MEMFS.createNode(null,"/",16895,0)},createNode(parent,name,mode,dev){if(FS.isBlkdev(mode)||FS.isFIFO(mode)){// no supported
throw new FS.ErrnoError(63)}MEMFS.ops_table||={dir:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,lookup:MEMFS.node_ops.lookup,mknod:MEMFS.node_ops.mknod,rename:MEMFS.node_ops.rename,unlink:MEMFS.node_ops.unlink,rmdir:MEMFS.node_ops.rmdir,readdir:MEMFS.node_ops.readdir,symlink:MEMFS.node_ops.symlink},stream:{llseek:MEMFS.stream_ops.llseek}},file:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:{llseek:MEMFS.stream_ops.llseek,read:MEMFS.stream_ops.read,write:MEMFS.stream_ops.write,allocate:MEMFS.stream_ops.allocate,mmap:MEMFS.stream_ops.mmap,msync:MEMFS.stream_ops.msync}},link:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr,readlink:MEMFS.node_ops.readlink},stream:{}},chrdev:{node:{getattr:MEMFS.node_ops.getattr,setattr:MEMFS.node_ops.setattr},stream:FS.chrdev_stream_ops}};var node=FS.createNode(parent,name,mode,dev);if(FS.isDir(node.mode)){node.node_ops=MEMFS.ops_table.dir.node;node.stream_ops=MEMFS.ops_table.dir.stream;node.contents={}}else if(FS.isFile(node.mode)){node.node_ops=MEMFS.ops_table.file.node;node.stream_ops=MEMFS.ops_table.file.stream;node.usedBytes=0;// The actual number of bytes used in the typed array, as opposed to contents.length which gives the whole capacity.
// When the byte data of the file is populated, this will point to either a typed array, or a normal JS array. Typed arrays are preferred
// for performance, and used by default. However, typed arrays are not resizable like normal JS arrays are, so there is a small disk size
// penalty involved for appending file writes that continuously grow a file similar to std::vector capacity vs used -scheme.
node.contents=null}else if(FS.isLink(node.mode)){node.node_ops=MEMFS.ops_table.link.node;node.stream_ops=MEMFS.ops_table.link.stream}else if(FS.isChrdev(node.mode)){node.node_ops=MEMFS.ops_table.chrdev.node;node.stream_ops=MEMFS.ops_table.chrdev.stream}node.atime=node.mtime=node.ctime=Date.now();// add the new node to the parent
if(parent){parent.contents[name]=node;parent.atime=parent.mtime=parent.ctime=node.atime}return node},getFileDataAsTypedArray(node){if(!node.contents)return new Uint8Array(0);if(node.contents.subarray)return node.contents.subarray(0,node.usedBytes);// Make sure to not return excess unused bytes.
return new Uint8Array(node.contents)},expandFileStorage(node,newCapacity){var prevCapacity=node.contents?node.contents.length:0;if(prevCapacity>=newCapacity)return;// No need to expand, the storage was already large enough.
// Don't expand strictly to the given requested limit if it's only a very small increase, but instead geometrically grow capacity.
// For small filesizes (<1MB), perform size*2 geometric increase, but for large sizes, do a much more conservative size*1.125 increase to
// avoid overshooting the allocation cap by a very large margin.
var CAPACITY_DOUBLING_MAX=1024*1024;newCapacity=Math.max(newCapacity,(prevCapacity*(prevCapacity<CAPACITY_DOUBLING_MAX?2:1.125))>>>0);if(prevCapacity!=0)newCapacity=Math.max(newCapacity,256);// At minimum allocate 256b for each file when expanding.
var oldContents=node.contents;node.contents=new Uint8Array(newCapacity);// Allocate new storage.
if(node.usedBytes>0)node.contents.set(oldContents.subarray(0,node.usedBytes),0)},resizeFileStorage(node,newSize){if(node.usedBytes==newSize)return;if(newSize==0){node.contents=null;// Fully decommit when requesting a resize to zero.
node.usedBytes=0}else{var oldContents=node.contents;node.contents=new Uint8Array(newSize);// Allocate new storage.
if(oldContents){node.contents.set(oldContents.subarray(0,Math.min(newSize,node.usedBytes)))}node.usedBytes=newSize}},node_ops:{getattr(node){var attr={};// device numbers reuse inode numbers.
attr.dev=FS.isChrdev(node.mode)?node.id:1;attr.ino=node.id;attr.mode=node.mode;attr.nlink=1;attr.uid=0;attr.gid=0;attr.rdev=node.rdev;if(FS.isDir(node.mode)){attr.size=4096}else if(FS.isFile(node.mode)){attr.size=node.usedBytes}else if(FS.isLink(node.mode)){attr.size=node.link.length}else{attr.size=0}attr.atime=new Date(node.atime);attr.mtime=new Date(node.mtime);attr.ctime=new Date(node.ctime);// NOTE: In our implementation, st_blocks = Math.ceil(st_size/st_blksize),
//       but this is not required by the standard.
attr.blksize=4096;attr.blocks=Math.ceil(attr.size/attr.blksize);return attr},setattr(node,attr){for(const key of["mode","atime","mtime","ctime"]){if(attr[key]!=null){node[key]=attr[key]}}if(attr.size!==undefined){MEMFS.resizeFileStorage(node,attr.size)}},lookup(parent,name){throw MEMFS.doesNotExistError},mknod(parent,name,mode,dev){return MEMFS.createNode(parent,name,mode,dev)},rename(old_node,new_dir,new_name){var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}if(new_node){if(FS.isDir(old_node.mode)){// if we're overwriting a directory at new_name, make sure it's empty.
for(var i in new_node.contents){throw new FS.ErrnoError(55)}}FS.hashRemoveNode(new_node)}// do the internal rewiring
delete old_node.parent.contents[old_node.name];new_dir.contents[new_name]=old_node;old_node.name=new_name;new_dir.ctime=new_dir.mtime=old_node.parent.ctime=old_node.parent.mtime=Date.now()},unlink(parent,name){delete parent.contents[name];parent.ctime=parent.mtime=Date.now()},rmdir(parent,name){var node=FS.lookupNode(parent,name);for(var i in node.contents){throw new FS.ErrnoError(55)}delete parent.contents[name];parent.ctime=parent.mtime=Date.now()},readdir(node){return[".","..",...Object.keys(node.contents)]},symlink(parent,newname,oldpath){var node=MEMFS.createNode(parent,newname,511|40960,0);node.link=oldpath;return node},readlink(node){if(!FS.isLink(node.mode)){throw new FS.ErrnoError(28)}return node.link}},stream_ops:{read(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=stream.node.usedBytes)return 0;var size=Math.min(stream.node.usedBytes-position,length);if(size>8&&contents.subarray){// non-trivial, and typed array
buffer.set(contents.subarray(position,position+size),offset)}else{for(var i=0;i<size;i++)buffer[offset+i]=contents[position+i]}return size},write(stream,buffer,offset,length,position,canOwn){// If the buffer is located in main memory (HEAP), and if
// memory can grow, we can't hold on to references of the
// memory buffer, as they may get invalidated. That means we
// need to do copy its contents.
if(buffer.buffer===HEAP8.buffer){canOwn=false}if(!length)return 0;var node=stream.node;node.mtime=node.ctime=Date.now();if(buffer.subarray&&(!node.contents||node.contents.subarray)){// This write is from a typed array to a typed array?
if(canOwn){node.contents=buffer.subarray(offset,offset+length);node.usedBytes=length;return length}else if(node.usedBytes===0&&position===0){// If this is a simple first write to an empty file, do a fast set since we don't need to care about old data.
node.contents=buffer.slice(offset,offset+length);node.usedBytes=length;return length}else if(position+length<=node.usedBytes){// Writing to an already allocated and used subrange of the file?
node.contents.set(buffer.subarray(offset,offset+length),position);return length}}// Appending to an existing file and we need to reallocate, or source data did not come as a typed array.
MEMFS.expandFileStorage(node,position+length);if(node.contents.subarray&&buffer.subarray){// Use typed array write which is available.
node.contents.set(buffer.subarray(offset,offset+length),position)}else{for(var i=0;i<length;i++){node.contents[position+i]=buffer[offset+i]}}node.usedBytes=Math.max(node.usedBytes,position+length);return length},llseek(stream,offset,whence){var position=offset;if(whence===1){position+=stream.position}else if(whence===2){if(FS.isFile(stream.node.mode)){position+=stream.node.usedBytes}}if(position<0){throw new FS.ErrnoError(28)}return position},allocate(stream,offset,length){MEMFS.expandFileStorage(stream.node,offset+length);stream.node.usedBytes=Math.max(stream.node.usedBytes,offset+length)},mmap(stream,length,position,prot,flags){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(43)}var ptr;var allocated;var contents=stream.node.contents;// Only make a new copy when MAP_PRIVATE is specified.
if(!(flags&2)&&contents&&contents.buffer===HEAP8.buffer){// We can't emulate MAP_SHARED when the file is not backed by the
// buffer we're mapping to (e.g. the HEAP buffer).
allocated=false;ptr=contents.byteOffset}else{allocated=true;ptr=mmapAlloc(length);if(!ptr){throw new FS.ErrnoError(48)}if(contents){// Try to avoid unnecessary slices.
if(position>0||position+length<contents.length){if(contents.subarray){contents=contents.subarray(position,position+length)}else{contents=Array.prototype.slice.call(contents,position,position+length)}}HEAP8.set(contents,ptr)}}return{ptr,allocated}},msync(stream,buffer,offset,length,mmapFlags){MEMFS.stream_ops.write(stream,buffer,0,length,offset,false);// should we check if bytesWritten and length are the same?
return 0}}};var asyncLoad=async url=>{var arrayBuffer=await readAsync(url);return new Uint8Array(arrayBuffer)};var FS_createDataFile=(parent,name,fileData,canRead,canWrite,canOwn)=>{FS.createDataFile(parent,name,fileData,canRead,canWrite,canOwn)};var preloadPlugins=Module["preloadPlugins"]||[];var FS_handledByPreloadPlugin=(byteArray,fullname,finish,onerror)=>{// Ensure plugins are ready.
if(typeof Browser!="undefined")Browser.init();var handled=false;preloadPlugins.forEach(plugin=>{if(handled)return;if(plugin["canHandle"](fullname)){plugin["handle"](byteArray,fullname,finish,onerror);handled=true}});return handled};var FS_createPreloadedFile=(parent,name,url,canRead,canWrite,onload,onerror,dontCreateFile,canOwn,preFinish)=>{// TODO we should allow people to just pass in a complete filename instead
// of parent and name being that we just join them anyways
var fullname=name?PATH_FS.resolve(PATH.join2(parent,name)):parent;var dep=getUniqueRunDependency(`cp ${fullname}`);// might have several active requests for the same fullname
function processData(byteArray){function finish(byteArray){preFinish?.();if(!dontCreateFile){FS_createDataFile(parent,name,byteArray,canRead,canWrite,canOwn)}onload?.();removeRunDependency(dep)}if(FS_handledByPreloadPlugin(byteArray,fullname,finish,()=>{onerror?.();removeRunDependency(dep)})){return}finish(byteArray)}addRunDependency(dep);if(typeof url=="string"){asyncLoad(url).then(processData,onerror)}else{processData(url)}};var FS_modeStringToFlags=str=>{var flagModes={"r":0,"r+":2,"w":512|64|1,"w+":512|64|2,"a":1024|64|1,"a+":1024|64|2};var flags=flagModes[str];if(typeof flags=="undefined"){throw new Error(`Unknown file open mode: ${str}`)}return flags};var FS_getMode=(canRead,canWrite)=>{var mode=0;if(canRead)mode|=292|73;if(canWrite)mode|=146;return mode};var FS={root:null,mounts:[],devices:{},streams:[],nextInode:1,nameTable:null,currentPath:"/",initialized:false,ignorePermissions:true,filesystems:null,syncFSRequests:0,readFiles:{},ErrnoError:class{// We set the `name` property to be able to identify `FS.ErrnoError`
// - the `name` is a standard ECMA-262 property of error objects. Kind of good to have it anyway.
// - when using PROXYFS, an error can come from an underlying FS
// as different FS objects have their own FS.ErrnoError each,
// the test `err instanceof FS.ErrnoError` won't detect an error coming from another filesystem, causing bugs.
// we'll use the reliable test `err.name == "ErrnoError"` instead
constructor(errno){this.name="ErrnoError";this.errno=errno}},FSStream:class{constructor(){this.shared={};// Closure compiler requires us to declare all properties ahead of time
this.node=null}get object(){return this.node}set object(val){this.node=val}get isRead(){return(this.flags&2097155)!==1}get isWrite(){return(this.flags&2097155)!==0}get isAppend(){return(this.flags&1024)}get flags(){return this.shared.flags}set flags(val){this.shared.flags=val}get position(){return this.shared.position}set position(val){this.shared.position=val}},FSNode:class{constructor(parent,name,mode,rdev){this.node_ops={};this.stream_ops={};this.readMode=292|73;this.writeMode=146;this.mounted=null;if(!parent){parent=this}this.parent=parent;this.mount=parent.mount;this.id=FS.nextInode++;this.name=name;this.mode=mode;this.rdev=rdev;this.atime=this.mtime=this.ctime=Date.now()}get read(){return(this.mode&this.readMode)===this.readMode}set read(val){val?this.mode|=this.readMode:this.mode&=~this.readMode}get write(){return(this.mode&this.writeMode)===this.writeMode}set write(val){val?this.mode|=this.writeMode:this.mode&=~this.writeMode}get isFolder(){return FS.isDir(this.mode)}get isDevice(){return FS.isChrdev(this.mode)}},lookupPath(path,opts={}){if(!path){throw new FS.ErrnoError(44)}opts.follow_mount??=true;if(!PATH.isAbs(path)){path=FS.cwd()+"/"+path}// limit max consecutive symlinks to 40 (SYMLOOP_MAX).
linkloop:for(var nlinks=0;nlinks<40;nlinks++){// split the absolute path
var parts=path.split("/").filter(p=>!!p);// start at the root
var current=FS.root;var current_path="/";for(var i=0;i<parts.length;i++){var islast=(i===parts.length-1);if(islast&&opts.parent){// stop resolving
break}if(parts[i]==="."){continue}if(parts[i]===".."){current_path=PATH.dirname(current_path);current=current.parent;continue}current_path=PATH.join2(current_path,parts[i]);try{current=FS.lookupNode(current,parts[i])}catch(e){// if noent_okay is true, suppress a ENOENT in the last component
// and return an object with an undefined node. This is needed for
// resolving symlinks in the path when creating a file.
if((e?.errno===44)&&islast&&opts.noent_okay){return{path:current_path}}throw e}// jump to the mount's root node if this is a mountpoint
if(FS.isMountpoint(current)&&(!islast||opts.follow_mount)){current=current.mounted.root}// by default, lookupPath will not follow a symlink if it is the final path component.
// setting opts.follow = true will override this behavior.
if(FS.isLink(current.mode)&&(!islast||opts.follow)){if(!current.node_ops.readlink){throw new FS.ErrnoError(52)}var link=current.node_ops.readlink(current);if(!PATH.isAbs(link)){link=PATH.dirname(current_path)+"/"+link}path=link+"/"+parts.slice(i+1).join("/");continue linkloop}}return{path:current_path,node:current}}throw new FS.ErrnoError(32)},getPath(node){var path;while(true){if(FS.isRoot(node)){var mount=node.mount.mountpoint;if(!path)return mount;return mount[mount.length-1]!=="/"?`${mount}/${path}`:mount+path}path=path?`${node.name}/${path}`:node.name;node=node.parent}},hashName(parentid,name){var hash=0;for(var i=0;i<name.length;i++){hash=((hash<<5)-hash+name.charCodeAt(i))|0}return((parentid+hash)>>>0)%FS.nameTable.length},hashAddNode(node){var hash=FS.hashName(node.parent.id,node.name);node.name_next=FS.nameTable[hash];FS.nameTable[hash]=node},hashRemoveNode(node){var hash=FS.hashName(node.parent.id,node.name);if(FS.nameTable[hash]===node){FS.nameTable[hash]=node.name_next}else{var current=FS.nameTable[hash];while(current){if(current.name_next===node){current.name_next=node.name_next;break}current=current.name_next}}},lookupNode(parent,name){var errCode=FS.mayLookup(parent);if(errCode){throw new FS.ErrnoError(errCode)}var hash=FS.hashName(parent.id,name);for(var node=FS.nameTable[hash];node;node=node.name_next){var nodeName=node.name;if(node.parent.id===parent.id&&nodeName===name){return node}}// if we failed to find it in the cache, call into the VFS
return FS.lookup(parent,name)},createNode(parent,name,mode,rdev){var node=new FS.FSNode(parent,name,mode,rdev);FS.hashAddNode(node);return node},destroyNode(node){FS.hashRemoveNode(node)},isRoot(node){return node===node.parent},isMountpoint(node){return!!node.mounted},isFile(mode){return(mode&61440)===32768},isDir(mode){return(mode&61440)===16384},isLink(mode){return(mode&61440)===40960},isChrdev(mode){return(mode&61440)===8192},isBlkdev(mode){return(mode&61440)===24576},isFIFO(mode){return(mode&61440)===4096},isSocket(mode){return(mode&49152)===49152},flagsToPermissionString(flag){var perms=["r","w","rw"][flag&3];if((flag&512)){perms+="w"}return perms},nodePermissions(node,perms){if(FS.ignorePermissions){return 0}// return 0 if any user, group or owner bits are set.
if(perms.includes("r")&&!(node.mode&292)){return 2}else if(perms.includes("w")&&!(node.mode&146)){return 2}else if(perms.includes("x")&&!(node.mode&73)){return 2}return 0},mayLookup(dir){if(!FS.isDir(dir.mode))return 54;var errCode=FS.nodePermissions(dir,"x");if(errCode)return errCode;if(!dir.node_ops.lookup)return 2;return 0},mayCreate(dir,name){if(!FS.isDir(dir.mode)){return 54}try{var node=FS.lookupNode(dir,name);return 20}catch(e){}return FS.nodePermissions(dir,"wx")},mayDelete(dir,name,isdir){var node;try{node=FS.lookupNode(dir,name)}catch(e){return e.errno}var errCode=FS.nodePermissions(dir,"wx");if(errCode){return errCode}if(isdir){if(!FS.isDir(node.mode)){return 54}if(FS.isRoot(node)||FS.getPath(node)===FS.cwd()){return 10}}else{if(FS.isDir(node.mode)){return 31}}return 0},mayOpen(node,flags){if(!node){return 44}if(FS.isLink(node.mode)){return 32}else if(FS.isDir(node.mode)){if(FS.flagsToPermissionString(flags)!=="r"||(flags&(512|64))){// TODO: check for O_SEARCH? (== search for dir only)
return 31}}return FS.nodePermissions(node,FS.flagsToPermissionString(flags))},checkOpExists(op,err){if(!op){throw new FS.ErrnoError(err)}return op},MAX_OPEN_FDS:4096,nextfd(){for(var fd=0;fd<=FS.MAX_OPEN_FDS;fd++){if(!FS.streams[fd]){return fd}}throw new FS.ErrnoError(33)},getStreamChecked(fd){var stream=FS.getStream(fd);if(!stream){throw new FS.ErrnoError(8)}return stream},getStream:fd=>FS.streams[fd],createStream(stream,fd=-1){// clone it, so we can return an instance of FSStream
stream=Object.assign(new FS.FSStream,stream);if(fd==-1){fd=FS.nextfd()}stream.fd=fd;FS.streams[fd]=stream;return stream},closeStream(fd){FS.streams[fd]=null},dupStream(origStream,fd=-1){var stream=FS.createStream(origStream,fd);stream.stream_ops?.dup?.(stream);return stream},doSetAttr(stream,node,attr){var setattr=stream?.stream_ops.setattr;var arg=setattr?stream:node;setattr??=node.node_ops.setattr;FS.checkOpExists(setattr,63);setattr(arg,attr)},chrdev_stream_ops:{open(stream){var device=FS.getDevice(stream.node.rdev);// override node's stream ops with the device's
stream.stream_ops=device.stream_ops;// forward the open call
stream.stream_ops.open?.(stream)},llseek(){throw new FS.ErrnoError(70)}},major:dev=>((dev)>>8),minor:dev=>((dev)&255),makedev:(ma,mi)=>((ma)<<8|(mi)),registerDevice(dev,ops){FS.devices[dev]={stream_ops:ops}},getDevice:dev=>FS.devices[dev],getMounts(mount){var mounts=[];var check=[mount];while(check.length){var m=check.pop();mounts.push(m);check.push(...m.mounts)}return mounts},syncfs(populate,callback){if(typeof populate=="function"){callback=populate;populate=false}FS.syncFSRequests++;if(FS.syncFSRequests>1){err(`warning: ${FS.syncFSRequests} FS.syncfs operations in flight at once, probably just doing extra work`)}var mounts=FS.getMounts(FS.root.mount);var completed=0;function doCallback(errCode){FS.syncFSRequests--;return callback(errCode)}function done(errCode){if(errCode){if(!done.errored){done.errored=true;return doCallback(errCode)}return}if(++completed>=mounts.length){doCallback(null)}}// sync all mounts
mounts.forEach(mount=>{if(!mount.type.syncfs){return done(null)}mount.type.syncfs(mount,populate,done)})},mount(type,opts,mountpoint){var root=mountpoint==="/";var pseudo=!mountpoint;var node;if(root&&FS.root){throw new FS.ErrnoError(10)}else if(!root&&!pseudo){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});mountpoint=lookup.path;// use the absolute path
node=lookup.node;if(FS.isMountpoint(node)){throw new FS.ErrnoError(10)}if(!FS.isDir(node.mode)){throw new FS.ErrnoError(54)}}var mount={type,opts,mountpoint,mounts:[]};// create a root node for the fs
var mountRoot=type.mount(mount);mountRoot.mount=mount;mount.root=mountRoot;if(root){FS.root=mountRoot}else if(node){// set as a mountpoint
node.mounted=mount;// add the new mount to the current mount's children
if(node.mount){node.mount.mounts.push(mount)}}return mountRoot},unmount(mountpoint){var lookup=FS.lookupPath(mountpoint,{follow_mount:false});if(!FS.isMountpoint(lookup.node)){throw new FS.ErrnoError(28)}// destroy the nodes for this mount, and all its child mounts
var node=lookup.node;var mount=node.mounted;var mounts=FS.getMounts(mount);Object.keys(FS.nameTable).forEach(hash=>{var current=FS.nameTable[hash];while(current){var next=current.name_next;if(mounts.includes(current.mount)){FS.destroyNode(current)}current=next}});// no longer a mountpoint
node.mounted=null;// remove this mount from the child mounts
var idx=node.mount.mounts.indexOf(mount);node.mount.mounts.splice(idx,1)},lookup(parent,name){return parent.node_ops.lookup(parent,name)},mknod(path,mode,dev){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);if(!name){throw new FS.ErrnoError(28)}if(name==="."||name===".."){throw new FS.ErrnoError(20)}var errCode=FS.mayCreate(parent,name);if(errCode){throw new FS.ErrnoError(errCode)}if(!parent.node_ops.mknod){throw new FS.ErrnoError(63)}return parent.node_ops.mknod(parent,name,mode,dev)},statfs(path){return FS.statfsNode(FS.lookupPath(path,{follow:true}).node)},statfsStream(stream){// We keep a separate statfsStream function because noderawfs overrides
// it. In noderawfs, stream.node is sometimes null. Instead, we need to
// look at stream.path.
return FS.statfsNode(stream.node)},statfsNode(node){// NOTE: None of the defaults here are true. We're just returning safe and
//       sane values. Currently nodefs and rawfs replace these defaults,
//       other file systems leave them alone.
var rtn={bsize:4096,frsize:4096,blocks:1e6,bfree:5e5,bavail:5e5,files:FS.nextInode,ffree:FS.nextInode-1,fsid:42,flags:2,namelen:255};if(node.node_ops.statfs){Object.assign(rtn,node.node_ops.statfs(node.mount.opts.root))}return rtn},create(path,mode=438){mode&=4095;mode|=32768;return FS.mknod(path,mode,0)},mkdir(path,mode=511){mode&=511|512;mode|=16384;return FS.mknod(path,mode,0)},mkdirTree(path,mode){var dirs=path.split("/");var d="";for(var i=0;i<dirs.length;++i){if(!dirs[i])continue;d+="/"+dirs[i];try{FS.mkdir(d,mode)}catch(e){if(e.errno!=20)throw e}}},mkdev(path,mode,dev){if(typeof dev=="undefined"){dev=mode;mode=438}mode|=8192;return FS.mknod(path,mode,dev)},symlink(oldpath,newpath){if(!PATH_FS.resolve(oldpath)){throw new FS.ErrnoError(44)}var lookup=FS.lookupPath(newpath,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(44)}var newname=PATH.basename(newpath);var errCode=FS.mayCreate(parent,newname);if(errCode){throw new FS.ErrnoError(errCode)}if(!parent.node_ops.symlink){throw new FS.ErrnoError(63)}return parent.node_ops.symlink(parent,newname,oldpath)},rename(old_path,new_path){var old_dirname=PATH.dirname(old_path);var new_dirname=PATH.dirname(new_path);var old_name=PATH.basename(old_path);var new_name=PATH.basename(new_path);// parents must exist
var lookup,old_dir,new_dir;// let the errors from non existent directories percolate up
lookup=FS.lookupPath(old_path,{parent:true});old_dir=lookup.node;lookup=FS.lookupPath(new_path,{parent:true});new_dir=lookup.node;if(!old_dir||!new_dir)throw new FS.ErrnoError(44);// need to be part of the same mount
if(old_dir.mount!==new_dir.mount){throw new FS.ErrnoError(75)}// source must exist
var old_node=FS.lookupNode(old_dir,old_name);// old path should not be an ancestor of the new path
var relative=PATH_FS.relative(old_path,new_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(28)}// new path should not be an ancestor of the old path
relative=PATH_FS.relative(new_path,old_dirname);if(relative.charAt(0)!=="."){throw new FS.ErrnoError(55)}// see if the new path already exists
var new_node;try{new_node=FS.lookupNode(new_dir,new_name)}catch(e){}// early out if nothing needs to change
if(old_node===new_node){return}// we'll need to delete the old entry
var isdir=FS.isDir(old_node.mode);var errCode=FS.mayDelete(old_dir,old_name,isdir);if(errCode){throw new FS.ErrnoError(errCode)}// need delete permissions if we'll be overwriting.
// need create permissions if new doesn't already exist.
errCode=new_node?FS.mayDelete(new_dir,new_name,isdir):FS.mayCreate(new_dir,new_name);if(errCode){throw new FS.ErrnoError(errCode)}if(!old_dir.node_ops.rename){throw new FS.ErrnoError(63)}if(FS.isMountpoint(old_node)||(new_node&&FS.isMountpoint(new_node))){throw new FS.ErrnoError(10)}// if we are going to change the parent, check write permissions
if(new_dir!==old_dir){errCode=FS.nodePermissions(old_dir,"w");if(errCode){throw new FS.ErrnoError(errCode)}}// remove the node from the lookup hash
FS.hashRemoveNode(old_node);// do the underlying fs rename
try{old_dir.node_ops.rename(old_node,new_dir,new_name);// update old node (we do this here to avoid each backend
// needing to)
old_node.parent=new_dir}catch(e){throw e}finally{// add the node back to the hash (in case node_ops.rename
// changed its name)
FS.hashAddNode(old_node)}},rmdir(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var errCode=FS.mayDelete(parent,name,true);if(errCode){throw new FS.ErrnoError(errCode)}if(!parent.node_ops.rmdir){throw new FS.ErrnoError(63)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(10)}parent.node_ops.rmdir(parent,name);FS.destroyNode(node)},readdir(path){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;var readdir=FS.checkOpExists(node.node_ops.readdir,54);return readdir(node)},unlink(path){var lookup=FS.lookupPath(path,{parent:true});var parent=lookup.node;if(!parent){throw new FS.ErrnoError(44)}var name=PATH.basename(path);var node=FS.lookupNode(parent,name);var errCode=FS.mayDelete(parent,name,false);if(errCode){// According to POSIX, we should map EISDIR to EPERM, but
// we instead do what Linux does (and we must, as we use
// the musl linux libc).
throw new FS.ErrnoError(errCode)}if(!parent.node_ops.unlink){throw new FS.ErrnoError(63)}if(FS.isMountpoint(node)){throw new FS.ErrnoError(10)}parent.node_ops.unlink(parent,name);FS.destroyNode(node)},readlink(path){var lookup=FS.lookupPath(path);var link=lookup.node;if(!link){throw new FS.ErrnoError(44)}if(!link.node_ops.readlink){throw new FS.ErrnoError(28)}return link.node_ops.readlink(link)},stat(path,dontFollow){var lookup=FS.lookupPath(path,{follow:!dontFollow});var node=lookup.node;var getattr=FS.checkOpExists(node.node_ops.getattr,63);return getattr(node)},fstat(fd){var stream=FS.getStreamChecked(fd);var node=stream.node;var getattr=stream.stream_ops.getattr;var arg=getattr?stream:node;getattr??=node.node_ops.getattr;FS.checkOpExists(getattr,63);return getattr(arg)},lstat(path){return FS.stat(path,true)},doChmod(stream,node,mode,dontFollow){FS.doSetAttr(stream,node,{mode:(mode&4095)|(node.mode&~4095),ctime:Date.now(),dontFollow})},chmod(path,mode,dontFollow){var node;if(typeof path=="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}FS.doChmod(null,node,mode,dontFollow)},lchmod(path,mode){FS.chmod(path,mode,true)},fchmod(fd,mode){var stream=FS.getStreamChecked(fd);FS.doChmod(stream,stream.node,mode,false)},doChown(stream,node,dontFollow){FS.doSetAttr(stream,node,{timestamp:Date.now(),dontFollow})},chown(path,uid,gid,dontFollow){var node;if(typeof path=="string"){var lookup=FS.lookupPath(path,{follow:!dontFollow});node=lookup.node}else{node=path}FS.doChown(null,node,dontFollow)},lchown(path,uid,gid){FS.chown(path,uid,gid,true)},fchown(fd,uid,gid){var stream=FS.getStreamChecked(fd);FS.doChown(stream,stream.node,false)},doTruncate(stream,node,len){if(FS.isDir(node.mode)){throw new FS.ErrnoError(31)}if(!FS.isFile(node.mode)){throw new FS.ErrnoError(28)}var errCode=FS.nodePermissions(node,"w");if(errCode){throw new FS.ErrnoError(errCode)}FS.doSetAttr(stream,node,{size:len,timestamp:Date.now()})},truncate(path,len){if(len<0){throw new FS.ErrnoError(28)}var node;if(typeof path=="string"){var lookup=FS.lookupPath(path,{follow:true});node=lookup.node}else{node=path}FS.doTruncate(null,node,len)},ftruncate(fd,len){var stream=FS.getStreamChecked(fd);if(len<0||(stream.flags&2097155)===0){throw new FS.ErrnoError(28)}FS.doTruncate(stream,stream.node,len)},utime(path,atime,mtime){var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;var setattr=FS.checkOpExists(node.node_ops.setattr,63);setattr(node,{atime,mtime})},open(path,flags,mode=438){if(path===""){throw new FS.ErrnoError(44)}flags=typeof flags=="string"?FS_modeStringToFlags(flags):flags;if((flags&64)){mode=(mode&4095)|32768}else{mode=0}var node;var isDirPath;if(typeof path=="object"){node=path}else{isDirPath=path.endsWith("/");// noent_okay makes it so that if the final component of the path
// doesn't exist, lookupPath returns `node: undefined`. `path` will be
// updated to point to the target of all symlinks.
var lookup=FS.lookupPath(path,{follow:!(flags&131072),noent_okay:true});node=lookup.node;path=lookup.path}// perhaps we need to create the node
var created=false;if((flags&64)){if(node){// if O_CREAT and O_EXCL are set, error out if the node already exists
if((flags&128)){throw new FS.ErrnoError(20)}}else if(isDirPath){throw new FS.ErrnoError(31)}else{// node doesn't exist, try to create it
// Ignore the permission bits here to ensure we can `open` this new
// file below. We use chmod below the apply the permissions once the
// file is open.
node=FS.mknod(path,mode|511,0);created=true}}if(!node){throw new FS.ErrnoError(44)}// can't truncate a device
if(FS.isChrdev(node.mode)){flags&=~512}// if asked only for a directory, then this must be one
if((flags&65536)&&!FS.isDir(node.mode)){throw new FS.ErrnoError(54)}// check permissions, if this is not a file we just created now (it is ok to
// create and write to a file with read-only permissions; it is read-only
// for later use)
if(!created){var errCode=FS.mayOpen(node,flags);if(errCode){throw new FS.ErrnoError(errCode)}}// do truncation if necessary
if((flags&512)&&!created){FS.truncate(node,0)}// we've already handled these, don't pass down to the underlying vfs
flags&=~(128|512|131072);// register the stream with the filesystem
var stream=FS.createStream({node,path:FS.getPath(node),// we want the absolute path to the node
flags,seekable:true,position:0,stream_ops:node.stream_ops,// used by the file family libc calls (fopen, fwrite, ferror, etc.)
ungotten:[],error:false});// call the new stream's open function
if(stream.stream_ops.open){stream.stream_ops.open(stream)}if(created){FS.chmod(node,mode&511)}if(Module["logReadFiles"]&&!(flags&1)){if(!(path in FS.readFiles)){FS.readFiles[path]=1}}return stream},close(stream){if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if(stream.getdents)stream.getdents=null;// free readdir state
try{if(stream.stream_ops.close){stream.stream_ops.close(stream)}}catch(e){throw e}finally{FS.closeStream(stream.fd)}stream.fd=null},isClosed(stream){return stream.fd===null},llseek(stream,offset,whence){if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if(!stream.seekable||!stream.stream_ops.llseek){throw new FS.ErrnoError(70)}if(whence!=0&&whence!=1&&whence!=2){throw new FS.ErrnoError(28)}stream.position=stream.stream_ops.llseek(stream,offset,whence);stream.ungotten=[];return stream.position},read(stream,buffer,offset,length,position){if(length<0||position<0){throw new FS.ErrnoError(28)}if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(8)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(31)}if(!stream.stream_ops.read){throw new FS.ErrnoError(28)}var seeking=typeof position!="undefined";if(!seeking){position=stream.position}else if(!stream.seekable){throw new FS.ErrnoError(70)}var bytesRead=stream.stream_ops.read(stream,buffer,offset,length,position);if(!seeking)stream.position+=bytesRead;return bytesRead},write(stream,buffer,offset,length,position,canOwn){if(length<0||position<0){throw new FS.ErrnoError(28)}if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(8)}if(FS.isDir(stream.node.mode)){throw new FS.ErrnoError(31)}if(!stream.stream_ops.write){throw new FS.ErrnoError(28)}if(stream.seekable&&stream.flags&1024){// seek to the end before writing in append mode
FS.llseek(stream,0,2)}var seeking=typeof position!="undefined";if(!seeking){position=stream.position}else if(!stream.seekable){throw new FS.ErrnoError(70)}var bytesWritten=stream.stream_ops.write(stream,buffer,offset,length,position,canOwn);if(!seeking)stream.position+=bytesWritten;return bytesWritten},allocate(stream,offset,length){if(FS.isClosed(stream)){throw new FS.ErrnoError(8)}if(offset<0||length<=0){throw new FS.ErrnoError(28)}if((stream.flags&2097155)===0){throw new FS.ErrnoError(8)}if(!FS.isFile(stream.node.mode)&&!FS.isDir(stream.node.mode)){throw new FS.ErrnoError(43)}if(!stream.stream_ops.allocate){throw new FS.ErrnoError(138)}stream.stream_ops.allocate(stream,offset,length)},mmap(stream,length,position,prot,flags){// User requests writing to file (prot & PROT_WRITE != 0).
// Checking if we have permissions to write to the file unless
// MAP_PRIVATE flag is set. According to POSIX spec it is possible
// to write to file opened in read-only mode with MAP_PRIVATE flag,
// as all modifications will be visible only in the memory of
// the current process.
if((prot&2)!==0&&(flags&2)===0&&(stream.flags&2097155)!==2){throw new FS.ErrnoError(2)}if((stream.flags&2097155)===1){throw new FS.ErrnoError(2)}if(!stream.stream_ops.mmap){throw new FS.ErrnoError(43)}if(!length){throw new FS.ErrnoError(28)}return stream.stream_ops.mmap(stream,length,position,prot,flags)},msync(stream,buffer,offset,length,mmapFlags){if(!stream.stream_ops.msync){return 0}return stream.stream_ops.msync(stream,buffer,offset,length,mmapFlags)},ioctl(stream,cmd,arg){if(!stream.stream_ops.ioctl){throw new FS.ErrnoError(59)}return stream.stream_ops.ioctl(stream,cmd,arg)},readFile(path,opts={}){opts.flags=opts.flags||0;opts.encoding=opts.encoding||"binary";if(opts.encoding!=="utf8"&&opts.encoding!=="binary"){throw new Error(`Invalid encoding type "${opts.encoding}"`)}var ret;var stream=FS.open(path,opts.flags);var stat=FS.stat(path);var length=stat.size;var buf=new Uint8Array(length);FS.read(stream,buf,0,length,0);if(opts.encoding==="utf8"){ret=UTF8ArrayToString(buf)}else if(opts.encoding==="binary"){ret=buf}FS.close(stream);return ret},writeFile(path,data,opts={}){opts.flags=opts.flags||577;var stream=FS.open(path,opts.flags,opts.mode);if(typeof data=="string"){var buf=new Uint8Array(lengthBytesUTF8(data)+1);var actualNumBytes=stringToUTF8Array(data,buf,0,buf.length);FS.write(stream,buf,0,actualNumBytes,undefined,opts.canOwn)}else if(ArrayBuffer.isView(data)){FS.write(stream,data,0,data.byteLength,undefined,opts.canOwn)}else{throw new Error("Unsupported data type")}FS.close(stream)},cwd:()=>FS.currentPath,chdir(path){var lookup=FS.lookupPath(path,{follow:true});if(lookup.node===null){throw new FS.ErrnoError(44)}if(!FS.isDir(lookup.node.mode)){throw new FS.ErrnoError(54)}var errCode=FS.nodePermissions(lookup.node,"x");if(errCode){throw new FS.ErrnoError(errCode)}FS.currentPath=lookup.path},createDefaultDirectories(){FS.mkdir("/tmp");FS.mkdir("/home");FS.mkdir("/home/web_user")},createDefaultDevices(){// create /dev
FS.mkdir("/dev");// setup /dev/null
FS.registerDevice(FS.makedev(1,3),{read:()=>0,write:(stream,buffer,offset,length,pos)=>length,llseek:()=>0});FS.mkdev("/dev/null",FS.makedev(1,3));// setup /dev/tty and /dev/tty1
// stderr needs to print output using err() rather than out()
// so we register a second tty just for it.
TTY.register(FS.makedev(5,0),TTY.default_tty_ops);TTY.register(FS.makedev(6,0),TTY.default_tty1_ops);FS.mkdev("/dev/tty",FS.makedev(5,0));FS.mkdev("/dev/tty1",FS.makedev(6,0));// setup /dev/[u]random
// use a buffer to avoid overhead of individual crypto calls per byte
var randomBuffer=new Uint8Array(1024),randomLeft=0;var randomByte=()=>{if(randomLeft===0){randomFill(randomBuffer);randomLeft=randomBuffer.byteLength}return randomBuffer[--randomLeft]};FS.createDevice("/dev","random",randomByte);FS.createDevice("/dev","urandom",randomByte);// we're not going to emulate the actual shm device,
// just create the tmp dirs that reside in it commonly
FS.mkdir("/dev/shm");FS.mkdir("/dev/shm/tmp")},createSpecialDirectories(){// create /proc/self/fd which allows /proc/self/fd/6 => readlink gives the
// name of the stream for fd 6 (see test_unistd_ttyname)
FS.mkdir("/proc");var proc_self=FS.mkdir("/proc/self");FS.mkdir("/proc/self/fd");FS.mount({mount(){var node=FS.createNode(proc_self,"fd",16895,73);node.stream_ops={llseek:MEMFS.stream_ops.llseek};node.node_ops={lookup(parent,name){var fd=+name;var stream=FS.getStreamChecked(fd);var ret={parent:null,mount:{mountpoint:"fake"},node_ops:{readlink:()=>stream.path},id:fd+1};ret.parent=ret;// make it look like a simple root node
return ret},readdir(){return Array.from(FS.streams.entries()).filter(([k,v])=>v).map(([k,v])=>k.toString())}};return node}},{},"/proc/self/fd")},createStandardStreams(input,output,error){// TODO deprecate the old functionality of a single
// input / output callback and that utilizes FS.createDevice
// and instead require a unique set of stream ops
// by default, we symlink the standard streams to the
// default tty devices. however, if the standard streams
// have been overwritten we create a unique device for
// them instead.
if(input){FS.createDevice("/dev","stdin",input)}else{FS.symlink("/dev/tty","/dev/stdin")}if(output){FS.createDevice("/dev","stdout",null,output)}else{FS.symlink("/dev/tty","/dev/stdout")}if(error){FS.createDevice("/dev","stderr",null,error)}else{FS.symlink("/dev/tty1","/dev/stderr")}// open default streams for the stdin, stdout and stderr devices
var stdin=FS.open("/dev/stdin",0);var stdout=FS.open("/dev/stdout",1);var stderr=FS.open("/dev/stderr",1)},staticInit(){FS.nameTable=new Array(4096);FS.mount(MEMFS,{},"/");FS.createDefaultDirectories();FS.createDefaultDevices();FS.createSpecialDirectories();FS.filesystems={"MEMFS":MEMFS}},init(input,output,error){FS.initialized=true;// Allow Module.stdin etc. to provide defaults, if none explicitly passed to us here
input??=Module["stdin"];output??=Module["stdout"];error??=Module["stderr"];FS.createStandardStreams(input,output,error)},quit(){FS.initialized=false;// force-flush all streams, so we get musl std streams printed out
// close all of our streams
for(var i=0;i<FS.streams.length;i++){var stream=FS.streams[i];if(!stream){continue}FS.close(stream)}},findObject(path,dontResolveLastLink){var ret=FS.analyzePath(path,dontResolveLastLink);if(!ret.exists){return null}return ret.object},analyzePath(path,dontResolveLastLink){// operate from within the context of the symlink's target
try{var lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});path=lookup.path}catch(e){}var ret={isRoot:false,exists:false,error:0,name:null,path:null,object:null,parentExists:false,parentPath:null,parentObject:null};try{var lookup=FS.lookupPath(path,{parent:true});ret.parentExists=true;ret.parentPath=lookup.path;ret.parentObject=lookup.node;ret.name=PATH.basename(path);lookup=FS.lookupPath(path,{follow:!dontResolveLastLink});ret.exists=true;ret.path=lookup.path;ret.object=lookup.node;ret.name=lookup.node.name;ret.isRoot=lookup.path==="/"}catch(e){ret.error=e.errno}return ret},createPath(parent,path,canRead,canWrite){parent=typeof parent=="string"?parent:FS.getPath(parent);var parts=path.split("/").reverse();while(parts.length){var part=parts.pop();if(!part)continue;var current=PATH.join2(parent,part);try{FS.mkdir(current)}catch(e){if(e.errno!=20)throw e}parent=current}return current},createFile(parent,name,properties,canRead,canWrite){var path=PATH.join2(typeof parent=="string"?parent:FS.getPath(parent),name);var mode=FS_getMode(canRead,canWrite);return FS.create(path,mode)},createDataFile(parent,name,data,canRead,canWrite,canOwn){var path=name;if(parent){parent=typeof parent=="string"?parent:FS.getPath(parent);path=name?PATH.join2(parent,name):parent}var mode=FS_getMode(canRead,canWrite);var node=FS.create(path,mode);if(data){if(typeof data=="string"){var arr=new Array(data.length);for(var i=0,len=data.length;i<len;++i)arr[i]=data.charCodeAt(i);data=arr}// make sure we can write to the file
FS.chmod(node,mode|146);var stream=FS.open(node,577);FS.write(stream,data,0,data.length,0,canOwn);FS.close(stream);FS.chmod(node,mode)}},createDevice(parent,name,input,output){var path=PATH.join2(typeof parent=="string"?parent:FS.getPath(parent),name);var mode=FS_getMode(!!input,!!output);FS.createDevice.major??=64;var dev=FS.makedev(FS.createDevice.major++,0);// Create a fake device that a set of stream ops to emulate
// the old behavior.
FS.registerDevice(dev,{open(stream){stream.seekable=false},close(stream){// flush any pending line data
if(output?.buffer?.length){output(10)}},read(stream,buffer,offset,length,pos){var bytesRead=0;for(var i=0;i<length;i++){var result;try{result=input()}catch(e){throw new FS.ErrnoError(29)}if(result===undefined&&bytesRead===0){throw new FS.ErrnoError(6)}if(result===null||result===undefined)break;bytesRead++;buffer[offset+i]=result}if(bytesRead){stream.node.atime=Date.now()}return bytesRead},write(stream,buffer,offset,length,pos){for(var i=0;i<length;i++){try{output(buffer[offset+i])}catch(e){throw new FS.ErrnoError(29)}}if(length){stream.node.mtime=stream.node.ctime=Date.now()}return i}});return FS.mkdev(path,mode,dev)},forceLoadFile(obj){if(obj.isDevice||obj.isFolder||obj.link||obj.contents)return true;if(typeof XMLHttpRequest!="undefined"){throw new Error("Lazy loading should have been performed (contents set) in createLazyFile, but it was not. Lazy loading only works in web workers. Use --embed-file or --preload-file in emcc on the main thread.")}else{// Command-line.
try{obj.contents=readBinary(obj.url);obj.usedBytes=obj.contents.length}catch(e){throw new FS.ErrnoError(29)}}},createLazyFile(parent,name,url,canRead,canWrite){// Lazy chunked Uint8Array (implements get and length from Uint8Array).
// Actual getting is abstracted away for eventual reuse.
class LazyUint8Array{constructor(){this.lengthKnown=false;this.chunks=[];// Loaded chunks. Index is the chunk number
// Closure compiler requires us to declare all properties ahead of time.
this.getter=undefined;this._length=0;this._chunkSize=0}get(idx){if(idx>this.length-1||idx<0){return undefined}var chunkOffset=idx%this.chunkSize;var chunkNum=(idx/this.chunkSize)|0;return this.getter(chunkNum)[chunkOffset]}setDataGetter(getter){this.getter=getter}cacheLength(){// Find length
var xhr=new XMLHttpRequest;xhr.open("HEAD",url,false);xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);var datalength=Number(xhr.getResponseHeader("Content-length"));var header;var hasByteServing=(header=xhr.getResponseHeader("Accept-Ranges"))&&header==="bytes";var usesGzip=(header=xhr.getResponseHeader("Content-Encoding"))&&header==="gzip";var chunkSize=1024*1024;// Chunk size in bytes
if(!hasByteServing)chunkSize=datalength;// Function to get a range from the remote URL.
var doXHR=(from,to)=>{if(from>to)throw new Error("invalid range ("+from+", "+to+") or no bytes requested!");if(to>datalength-1)throw new Error("only "+datalength+" bytes available! programmer error!");// TODO: Use mozResponseArrayBuffer, responseStream, etc. if available.
var xhr=new XMLHttpRequest;xhr.open("GET",url,false);if(datalength!==chunkSize)xhr.setRequestHeader("Range","bytes="+from+"-"+to);// Some hints to the browser that we want binary data.
xhr.responseType="arraybuffer";if(xhr.overrideMimeType){xhr.overrideMimeType("text/plain; charset=x-user-defined")}xhr.send(null);if(!(xhr.status>=200&&xhr.status<300||xhr.status===304))throw new Error("Couldn't load "+url+". Status: "+xhr.status);if(xhr.response!==undefined){return new Uint8Array(/** @type{Array<number>} */(xhr.response||[]))}return intArrayFromString(xhr.responseText||"",true)};var lazyArray=this;lazyArray.setDataGetter(chunkNum=>{var start=chunkNum*chunkSize;var end=(chunkNum+1)*chunkSize-1;// including this byte
end=Math.min(end,datalength-1);// if datalength-1 is selected, this is the last block
if(typeof lazyArray.chunks[chunkNum]=="undefined"){lazyArray.chunks[chunkNum]=doXHR(start,end)}if(typeof lazyArray.chunks[chunkNum]=="undefined")throw new Error("doXHR failed!");return lazyArray.chunks[chunkNum]});if(usesGzip||!datalength){// if the server uses gzip or doesn't supply the length, we have to download the whole file to get the (uncompressed) length
chunkSize=datalength=1;// this will force getter(0)/doXHR do download the whole file
datalength=this.getter(0).length;chunkSize=datalength;out("LazyFiles on gzip forces download of the whole file when length is accessed")}this._length=datalength;this._chunkSize=chunkSize;this.lengthKnown=true}get length(){if(!this.lengthKnown){this.cacheLength()}return this._length}get chunkSize(){if(!this.lengthKnown){this.cacheLength()}return this._chunkSize}}if(typeof XMLHttpRequest!="undefined"){if(!ENVIRONMENT_IS_WORKER)throw"Cannot do synchronous binary XHRs outside webworkers in modern browsers. Use --embed-file or --preload-file in emcc";var lazyArray=new LazyUint8Array;var properties={isDevice:false,contents:lazyArray}}else{var properties={isDevice:false,url}}var node=FS.createFile(parent,name,properties,canRead,canWrite);// This is a total hack, but I want to get this lazy file code out of the
// core of MEMFS. If we want to keep this lazy file concept I feel it should
// be its own thin LAZYFS proxying calls to MEMFS.
if(properties.contents){node.contents=properties.contents}else if(properties.url){node.contents=null;node.url=properties.url}// Add a function that defers querying the file size until it is asked the first time.
Object.defineProperties(node,{usedBytes:{get:function(){return this.contents.length}}});// override each stream op with one that tries to force load the lazy file first
var stream_ops={};var keys=Object.keys(node.stream_ops);keys.forEach(key=>{var fn=node.stream_ops[key];stream_ops[key]=(...args)=>{FS.forceLoadFile(node);return fn(...args)}});function writeChunks(stream,buffer,offset,length,position){var contents=stream.node.contents;if(position>=contents.length)return 0;var size=Math.min(contents.length-position,length);if(contents.slice){// normal array
for(var i=0;i<size;i++){buffer[offset+i]=contents[position+i]}}else{for(var i=0;i<size;i++){// LazyUint8Array from sync binary XHR
buffer[offset+i]=contents.get(position+i)}}return size}// use a custom read function
stream_ops.read=(stream,buffer,offset,length,position)=>{FS.forceLoadFile(node);return writeChunks(stream,buffer,offset,length,position)};// use a custom mmap function
stream_ops.mmap=(stream,length,position,prot,flags)=>{FS.forceLoadFile(node);var ptr=mmapAlloc(length);if(!ptr){throw new FS.ErrnoError(48)}writeChunks(stream,HEAP8,ptr,length,position);return{ptr,allocated:true}};node.stream_ops=stream_ops;return node}};/**
     * Given a pointer 'ptr' to a null-terminated UTF8-encoded string in the
     * emscripten HEAP, returns a copy of that string as a Javascript String object.
     *
     * @param {number} ptr
     * @param {number=} maxBytesToRead - An optional length that specifies the
     *   maximum number of bytes to read. You can omit this parameter to scan the
     *   string until the first 0 byte. If maxBytesToRead is passed, and the string
     *   at [ptr, ptr+maxBytesToReadr[ contains a null byte in the middle, then the
     *   string will cut short at that byte index (i.e. maxBytesToRead will not
     *   produce a string of exact length [ptr, ptr+maxBytesToRead[) N.B. mixing
     *   frequent uses of UTF8ToString() with and without maxBytesToRead may throw
     *   JS JIT optimizations off, so it is worth to consider consistently using one
     * @return {string}
     */var UTF8ToString=(ptr,maxBytesToRead)=>{if(!ptr)return"";var maxPtr=ptr+maxBytesToRead;for(var end=ptr;!(end>=maxPtr)&&HEAPU8[end];)++end;return UTF8Decoder.decode(HEAPU8.subarray(ptr,end))};var SYSCALLS={DEFAULT_POLLMASK:5,calculateAt(dirfd,path,allowEmpty){if(PATH.isAbs(path)){return path}// relative path
var dir;if(dirfd===-100){dir=FS.cwd()}else{var dirstream=SYSCALLS.getStreamFromFD(dirfd);dir=dirstream.path}if(path.length==0){if(!allowEmpty){throw new FS.ErrnoError(44)}return dir}return dir+"/"+path},writeStat(buf,stat){HEAP32[((buf)>>2)]=stat.dev;HEAP32[(((buf)+(4))>>2)]=stat.mode;HEAPU32[(((buf)+(8))>>2)]=stat.nlink;HEAP32[(((buf)+(12))>>2)]=stat.uid;HEAP32[(((buf)+(16))>>2)]=stat.gid;HEAP32[(((buf)+(20))>>2)]=stat.rdev;(tempI64=[stat.size>>>0,(tempDouble=stat.size,(+(Math.abs(tempDouble)))>=1?(tempDouble>0?(+(Math.floor((tempDouble)/4294967296)))>>>0:(~~((+(Math.ceil((tempDouble-+(((~~(tempDouble)))>>>0))/4294967296)))))>>>0):0)],HEAP32[(((buf)+(24))>>2)]=tempI64[0],HEAP32[(((buf)+(28))>>2)]=tempI64[1]);HEAP32[(((buf)+(32))>>2)]=4096;HEAP32[(((buf)+(36))>>2)]=stat.blocks;var atime=stat.atime.getTime();var mtime=stat.mtime.getTime();var ctime=stat.ctime.getTime();(tempI64=[Math.floor(atime/1e3)>>>0,(tempDouble=Math.floor(atime/1e3),(+(Math.abs(tempDouble)))>=1?(tempDouble>0?(+(Math.floor((tempDouble)/4294967296)))>>>0:(~~((+(Math.ceil((tempDouble-+(((~~(tempDouble)))>>>0))/4294967296)))))>>>0):0)],HEAP32[(((buf)+(40))>>2)]=tempI64[0],HEAP32[(((buf)+(44))>>2)]=tempI64[1]);HEAPU32[(((buf)+(48))>>2)]=(atime%1e3)*1e3*1e3;(tempI64=[Math.floor(mtime/1e3)>>>0,(tempDouble=Math.floor(mtime/1e3),(+(Math.abs(tempDouble)))>=1?(tempDouble>0?(+(Math.floor((tempDouble)/4294967296)))>>>0:(~~((+(Math.ceil((tempDouble-+(((~~(tempDouble)))>>>0))/4294967296)))))>>>0):0)],HEAP32[(((buf)+(56))>>2)]=tempI64[0],HEAP32[(((buf)+(60))>>2)]=tempI64[1]);HEAPU32[(((buf)+(64))>>2)]=(mtime%1e3)*1e3*1e3;(tempI64=[Math.floor(ctime/1e3)>>>0,(tempDouble=Math.floor(ctime/1e3),(+(Math.abs(tempDouble)))>=1?(tempDouble>0?(+(Math.floor((tempDouble)/4294967296)))>>>0:(~~((+(Math.ceil((tempDouble-+(((~~(tempDouble)))>>>0))/4294967296)))))>>>0):0)],HEAP32[(((buf)+(72))>>2)]=tempI64[0],HEAP32[(((buf)+(76))>>2)]=tempI64[1]);HEAPU32[(((buf)+(80))>>2)]=(ctime%1e3)*1e3*1e3;(tempI64=[stat.ino>>>0,(tempDouble=stat.ino,(+(Math.abs(tempDouble)))>=1?(tempDouble>0?(+(Math.floor((tempDouble)/4294967296)))>>>0:(~~((+(Math.ceil((tempDouble-+(((~~(tempDouble)))>>>0))/4294967296)))))>>>0):0)],HEAP32[(((buf)+(88))>>2)]=tempI64[0],HEAP32[(((buf)+(92))>>2)]=tempI64[1]);return 0},writeStatFs(buf,stats){HEAP32[(((buf)+(4))>>2)]=stats.bsize;HEAP32[(((buf)+(40))>>2)]=stats.bsize;HEAP32[(((buf)+(8))>>2)]=stats.blocks;HEAP32[(((buf)+(12))>>2)]=stats.bfree;HEAP32[(((buf)+(16))>>2)]=stats.bavail;HEAP32[(((buf)+(20))>>2)]=stats.files;HEAP32[(((buf)+(24))>>2)]=stats.ffree;HEAP32[(((buf)+(28))>>2)]=stats.fsid;HEAP32[(((buf)+(44))>>2)]=stats.flags;// ST_NOSUID
HEAP32[(((buf)+(36))>>2)]=stats.namelen},doMsync(addr,stream,len,flags,offset){if(!FS.isFile(stream.node.mode)){throw new FS.ErrnoError(43)}if(flags&2){// MAP_PRIVATE calls need not to be synced back to underlying fs
return 0}var buffer=HEAPU8.slice(addr,addr+len);FS.msync(stream,buffer,offset,len,flags)},getStreamFromFD(fd){var stream=FS.getStreamChecked(fd);return stream},varargs:undefined,getStr(ptr){var ret=UTF8ToString(ptr);return ret}};function ___syscall_dup(fd){try{var old=SYSCALLS.getStreamFromFD(fd);return FS.dupStream(old).fd}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_faccessat(dirfd,path,amode,flags){try{path=SYSCALLS.getStr(path);path=SYSCALLS.calculateAt(dirfd,path);if(amode&~7){// need a valid mode
return-28}var lookup=FS.lookupPath(path,{follow:true});var node=lookup.node;if(!node){return-44}var perms="";if(amode&4)perms+="r";if(amode&2)perms+="w";if(amode&1)perms+="x";if(perms&&FS.nodePermissions(node,perms)){return-2}return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}/** @suppress {duplicate } */var syscallGetVarargI=()=>{// the `+` prepended here is necessary to convince the JSCompiler that varargs is indeed a number.
var ret=HEAP32[((+SYSCALLS.varargs)>>2)];SYSCALLS.varargs+=4;return ret};var syscallGetVarargP=syscallGetVarargI;function ___syscall_fcntl64(fd,cmd,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(fd);switch(cmd){case 0:{var arg=syscallGetVarargI();if(arg<0){return-28}while(FS.streams[arg]){arg++}var newStream;newStream=FS.dupStream(stream,arg);return newStream.fd}case 1:case 2:return 0;// FD_CLOEXEC makes no sense for a single process.
case 3:return stream.flags;case 4:{var arg=syscallGetVarargI();stream.flags|=arg;return 0}case 12:{var arg=syscallGetVarargP();var offset=0;// We're always unlocked.
HEAP16[(((arg)+(offset))>>1)]=2;return 0}case 13:case 14:// Pretend that the locking is successful. These are process-level locks,
// and Emscripten programs are a single process. If we supported linking a
// filesystem between programs, we'd need to do more here.
// See https://github.com/emscripten-core/emscripten/issues/23697
return 0}return-28}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_fstat64(fd,buf){try{return SYSCALLS.writeStat(buf,FS.fstat(fd))}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_ioctl(fd,op,varargs){SYSCALLS.varargs=varargs;try{var stream=SYSCALLS.getStreamFromFD(fd);switch(op){case 21509:{if(!stream.tty)return-59;return 0}case 21505:{if(!stream.tty)return-59;if(stream.tty.ops.ioctl_tcgets){var termios=stream.tty.ops.ioctl_tcgets(stream);var argp=syscallGetVarargP();HEAP32[((argp)>>2)]=termios.c_iflag||0;HEAP32[(((argp)+(4))>>2)]=termios.c_oflag||0;HEAP32[(((argp)+(8))>>2)]=termios.c_cflag||0;HEAP32[(((argp)+(12))>>2)]=termios.c_lflag||0;for(var i=0;i<32;i++){HEAP8[(argp+i)+(17)]=termios.c_cc[i]||0}return 0}return 0}case 21510:case 21511:case 21512:{if(!stream.tty)return-59;return 0}case 21506:case 21507:case 21508:{if(!stream.tty)return-59;if(stream.tty.ops.ioctl_tcsets){var argp=syscallGetVarargP();var c_iflag=HEAP32[((argp)>>2)];var c_oflag=HEAP32[(((argp)+(4))>>2)];var c_cflag=HEAP32[(((argp)+(8))>>2)];var c_lflag=HEAP32[(((argp)+(12))>>2)];var c_cc=[];for(var i=0;i<32;i++){c_cc.push(HEAP8[(argp+i)+(17)])}return stream.tty.ops.ioctl_tcsets(stream.tty,op,{c_iflag,c_oflag,c_cflag,c_lflag,c_cc})}return 0}case 21519:{if(!stream.tty)return-59;var argp=syscallGetVarargP();HEAP32[((argp)>>2)]=0;return 0}case 21520:{if(!stream.tty)return-59;return-28}case 21531:{var argp=syscallGetVarargP();return FS.ioctl(stream,op,argp)}case 21523:{// TODO: in theory we should write to the winsize struct that gets
// passed in, but for now musl doesn't read anything on it
if(!stream.tty)return-59;if(stream.tty.ops.ioctl_tiocgwinsz){var winsize=stream.tty.ops.ioctl_tiocgwinsz(stream.tty);var argp=syscallGetVarargP();HEAP16[((argp)>>1)]=winsize[0];HEAP16[(((argp)+(2))>>1)]=winsize[1]}return 0}case 21524:{// TODO: technically, this ioctl call should change the window size.
// but, since emscripten doesn't have any concept of a terminal window
// yet, we'll just silently throw it away as we do TIOCGWINSZ
if(!stream.tty)return-59;return 0}case 21515:{if(!stream.tty)return-59;return 0}default:return-28}}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_lstat64(path,buf){try{path=SYSCALLS.getStr(path);return SYSCALLS.writeStat(buf,FS.lstat(path))}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_newfstatat(dirfd,path,buf,flags){try{path=SYSCALLS.getStr(path);var nofollow=flags&256;var allowEmpty=flags&4096;flags=flags&(~6400);path=SYSCALLS.calculateAt(dirfd,path,allowEmpty);return SYSCALLS.writeStat(buf,nofollow?FS.lstat(path):FS.stat(path))}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_openat(dirfd,path,flags,varargs){SYSCALLS.varargs=varargs;try{path=SYSCALLS.getStr(path);path=SYSCALLS.calculateAt(dirfd,path);var mode=varargs?syscallGetVarargI():0;return FS.open(path,flags,mode).fd}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function ___syscall_stat64(path,buf){try{path=SYSCALLS.getStr(path);return SYSCALLS.writeStat(buf,FS.stat(path))}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}var __abort_js=()=>abort("");var structRegistrations={};var runDestructors=destructors=>{while(destructors.length){var ptr=destructors.pop();var del=destructors.pop();del(ptr)}};/** @suppress {globalThis} */function readPointer(pointer){return this["fromWireType"](HEAPU32[((pointer)>>2)])}var awaitingDependencies={};var registeredTypes={};var typeDependencies={};var InternalError;var throwInternalError=message=>{throw new InternalError(message)};var whenDependentTypesAreResolved=(myTypes,dependentTypes,getTypeConverters)=>{myTypes.forEach(type=>typeDependencies[type]=dependentTypes);function onComplete(typeConverters){var myTypeConverters=getTypeConverters(typeConverters);if(myTypeConverters.length!==myTypes.length){throwInternalError("Mismatched type converter count")}for(var i=0;i<myTypes.length;++i){registerType(myTypes[i],myTypeConverters[i])}}var typeConverters=new Array(dependentTypes.length);var unregisteredTypes=[];var registered=0;dependentTypes.forEach((dt,i)=>{if(registeredTypes.hasOwnProperty(dt)){typeConverters[i]=registeredTypes[dt]}else{unregisteredTypes.push(dt);if(!awaitingDependencies.hasOwnProperty(dt)){awaitingDependencies[dt]=[]}awaitingDependencies[dt].push(()=>{typeConverters[i]=registeredTypes[dt];++registered;if(registered===unregisteredTypes.length){onComplete(typeConverters)}})}});if(0===unregisteredTypes.length){onComplete(typeConverters)}};var __embind_finalize_value_object=structType=>{var reg=structRegistrations[structType];delete structRegistrations[structType];var rawConstructor=reg.rawConstructor;var rawDestructor=reg.rawDestructor;var fieldRecords=reg.fields;var fieldTypes=fieldRecords.map(field=>field.getterReturnType).concat(fieldRecords.map(field=>field.setterArgumentType));whenDependentTypesAreResolved([structType],fieldTypes,fieldTypes=>{var fields={};fieldRecords.forEach((field,i)=>{var fieldName=field.fieldName;var getterReturnType=fieldTypes[i];var getter=field.getter;var getterContext=field.getterContext;var setterArgumentType=fieldTypes[i+fieldRecords.length];var setter=field.setter;var setterContext=field.setterContext;fields[fieldName]={read:ptr=>getterReturnType["fromWireType"](getter(getterContext,ptr)),write:(ptr,o)=>{var destructors=[];setter(setterContext,ptr,setterArgumentType["toWireType"](destructors,o));runDestructors(destructors)}}});return[{name:reg.name,"fromWireType":ptr=>{var rv={};for(var i in fields){rv[i]=fields[i].read(ptr)}rawDestructor(ptr);return rv},"toWireType":(destructors,o)=>{// todo: Here we have an opportunity for -O3 level "unsafe" optimizations:
// assume all fields are present without checking.
for(var fieldName in fields){if(!(fieldName in o)){throw new TypeError(`Missing field: "${fieldName}"`)}}var ptr=rawConstructor();for(fieldName in fields){fields[fieldName].write(ptr,o[fieldName])}if(destructors!==null){destructors.push(rawDestructor,ptr)}return ptr},argPackAdvance:GenericWireTypeSize,"readValueFromPointer":readPointer,destructorFunction:rawDestructor}]})};var __embind_register_bigint=(primitiveType,name,size,minRange,maxRange)=>{};var embind_init_charCodes=()=>{var codes=new Array(256);for(var i=0;i<256;++i){codes[i]=String.fromCharCode(i)}embind_charCodes=codes};var embind_charCodes;var readLatin1String=ptr=>{var ret="";var c=ptr;while(HEAPU8[c]){ret+=embind_charCodes[HEAPU8[c++]]}return ret};var BindingError;var throwBindingError=message=>{throw new BindingError(message)};/** @param {Object=} options */function sharedRegisterType(rawType,registeredInstance,options={}){var name=registeredInstance.name;if(!rawType){throwBindingError(`type "${name}" must have a positive integer typeid pointer`)}if(registeredTypes.hasOwnProperty(rawType)){if(options.ignoreDuplicateRegistrations){return}else{throwBindingError(`Cannot register type '${name}' twice`)}}registeredTypes[rawType]=registeredInstance;delete typeDependencies[rawType];if(awaitingDependencies.hasOwnProperty(rawType)){var callbacks=awaitingDependencies[rawType];delete awaitingDependencies[rawType];callbacks.forEach(cb=>cb())}}/** @param {Object=} options */function registerType(rawType,registeredInstance,options={}){return sharedRegisterType(rawType,registeredInstance,options)}var GenericWireTypeSize=8;/** @suppress {globalThis} */var __embind_register_bool=(rawType,name,trueValue,falseValue)=>{name=readLatin1String(name);registerType(rawType,{name,"fromWireType":function(wt){// ambiguous emscripten ABI: sometimes return values are
// true or false, and sometimes integers (0 or 1)
return!!wt},"toWireType":function(destructors,o){return o?trueValue:falseValue},argPackAdvance:GenericWireTypeSize,"readValueFromPointer":function(pointer){return this["fromWireType"](HEAPU8[pointer])},destructorFunction:null})};var shallowCopyInternalPointer=o=>({count:o.count,deleteScheduled:o.deleteScheduled,preservePointerOnDelete:o.preservePointerOnDelete,ptr:o.ptr,ptrType:o.ptrType,smartPtr:o.smartPtr,smartPtrType:o.smartPtrType});var throwInstanceAlreadyDeleted=obj=>{function getInstanceTypeName(handle){return handle.$$.ptrType.registeredClass.name}throwBindingError(getInstanceTypeName(obj)+" instance already deleted")};var finalizationRegistry=false;var detachFinalizer=handle=>{};var runDestructor=$$=>{if($$.smartPtr){$$.smartPtrType.rawDestructor($$.smartPtr)}else{$$.ptrType.registeredClass.rawDestructor($$.ptr)}};var releaseClassHandle=$$=>{$$.count.value-=1;var toDelete=0===$$.count.value;if(toDelete){runDestructor($$)}};var downcastPointer=(ptr,ptrClass,desiredClass)=>{if(ptrClass===desiredClass){return ptr}if(undefined===desiredClass.baseClass){return null}var rv=downcastPointer(ptr,ptrClass,desiredClass.baseClass);if(rv===null){return null}return desiredClass.downcast(rv)};var registeredPointers={};var registeredInstances={};var getBasestPointer=(class_,ptr)=>{if(ptr===undefined){throwBindingError("ptr should not be undefined")}while(class_.baseClass){ptr=class_.upcast(ptr);class_=class_.baseClass}return ptr};var getInheritedInstance=(class_,ptr)=>{ptr=getBasestPointer(class_,ptr);return registeredInstances[ptr]};var makeClassHandle=(prototype,record)=>{if(!record.ptrType||!record.ptr){throwInternalError("makeClassHandle requires ptr and ptrType")}var hasSmartPtrType=!!record.smartPtrType;var hasSmartPtr=!!record.smartPtr;if(hasSmartPtrType!==hasSmartPtr){throwInternalError("Both smartPtrType and smartPtr must be specified")}record.count={value:1};return attachFinalizer(Object.create(prototype,{$$:{value:record,writable:true}}))};/** @suppress {globalThis} */function RegisteredPointer_fromWireType(ptr){// ptr is a raw pointer (or a raw smartpointer)
// rawPointer is a maybe-null raw pointer
var rawPointer=this.getPointee(ptr);if(!rawPointer){this.destructor(ptr);return null}var registeredInstance=getInheritedInstance(this.registeredClass,rawPointer);if(undefined!==registeredInstance){// JS object has been neutered, time to repopulate it
if(0===registeredInstance.$$.count.value){registeredInstance.$$.ptr=rawPointer;registeredInstance.$$.smartPtr=ptr;return registeredInstance["clone"]()}else{// else, just increment reference count on existing object
// it already has a reference to the smart pointer
var rv=registeredInstance["clone"]();this.destructor(ptr);return rv}}function makeDefaultHandle(){if(this.isSmartPointer){return makeClassHandle(this.registeredClass.instancePrototype,{ptrType:this.pointeeType,ptr:rawPointer,smartPtrType:this,smartPtr:ptr})}else{return makeClassHandle(this.registeredClass.instancePrototype,{ptrType:this,ptr})}}var actualType=this.registeredClass.getActualType(rawPointer);var registeredPointerRecord=registeredPointers[actualType];if(!registeredPointerRecord){return makeDefaultHandle.call(this)}var toType;if(this.isConst){toType=registeredPointerRecord.constPointerType}else{toType=registeredPointerRecord.pointerType}var dp=downcastPointer(rawPointer,this.registeredClass,toType.registeredClass);if(dp===null){return makeDefaultHandle.call(this)}if(this.isSmartPointer){return makeClassHandle(toType.registeredClass.instancePrototype,{ptrType:toType,ptr:dp,smartPtrType:this,smartPtr:ptr})}else{return makeClassHandle(toType.registeredClass.instancePrototype,{ptrType:toType,ptr:dp})}}var attachFinalizer=handle=>{if("undefined"===typeof FinalizationRegistry){attachFinalizer=handle=>handle;return handle}// If the running environment has a FinalizationRegistry (see
// https://github.com/tc39/proposal-weakrefs), then attach finalizers
// for class handles.  We check for the presence of FinalizationRegistry
// at run-time, not build-time.
finalizationRegistry=new FinalizationRegistry(info=>{releaseClassHandle(info.$$)});attachFinalizer=handle=>{var $$=handle.$$;var hasSmartPtr=!!$$.smartPtr;if(hasSmartPtr){// We should not call the destructor on raw pointers in case other code expects the pointee to live
var info={$$};finalizationRegistry.register(handle,info,handle)}return handle};detachFinalizer=handle=>finalizationRegistry.unregister(handle);return attachFinalizer(handle)};var deletionQueue=[];var flushPendingDeletes=()=>{while(deletionQueue.length){var obj=deletionQueue.pop();obj.$$.deleteScheduled=false;obj["delete"]()}};var delayFunction;var init_ClassHandle=()=>{Object.assign(ClassHandle.prototype,{"isAliasOf"(other){if(!(this instanceof ClassHandle)){return false}if(!(other instanceof ClassHandle)){return false}var leftClass=this.$$.ptrType.registeredClass;var left=this.$$.ptr;other.$$=/** @type {Object} */(other.$$);var rightClass=other.$$.ptrType.registeredClass;var right=other.$$.ptr;while(leftClass.baseClass){left=leftClass.upcast(left);leftClass=leftClass.baseClass}while(rightClass.baseClass){right=rightClass.upcast(right);rightClass=rightClass.baseClass}return leftClass===rightClass&&left===right},"clone"(){if(!this.$$.ptr){throwInstanceAlreadyDeleted(this)}if(this.$$.preservePointerOnDelete){this.$$.count.value+=1;return this}else{var clone=attachFinalizer(Object.create(Object.getPrototypeOf(this),{$$:{value:shallowCopyInternalPointer(this.$$)}}));clone.$$.count.value+=1;clone.$$.deleteScheduled=false;return clone}},"delete"(){if(!this.$$.ptr){throwInstanceAlreadyDeleted(this)}if(this.$$.deleteScheduled&&!this.$$.preservePointerOnDelete){throwBindingError("Object already scheduled for deletion")}detachFinalizer(this);releaseClassHandle(this.$$);if(!this.$$.preservePointerOnDelete){this.$$.smartPtr=undefined;this.$$.ptr=undefined}},"isDeleted"(){return!this.$$.ptr},"deleteLater"(){if(!this.$$.ptr){throwInstanceAlreadyDeleted(this)}if(this.$$.deleteScheduled&&!this.$$.preservePointerOnDelete){throwBindingError("Object already scheduled for deletion")}deletionQueue.push(this);if(deletionQueue.length===1&&delayFunction){delayFunction(flushPendingDeletes)}this.$$.deleteScheduled=true;return this}})};/** @constructor */function ClassHandle(){}var createNamedFunction=(name,func)=>Object.defineProperty(func,"name",{value:name});var ensureOverloadTable=(proto,methodName,humanName)=>{if(undefined===proto[methodName].overloadTable){var prevFunc=proto[methodName];// Inject an overload resolver function that routes to the appropriate overload based on the number of arguments.
proto[methodName]=function(...args){// TODO This check can be removed in -O3 level "unsafe" optimizations.
if(!proto[methodName].overloadTable.hasOwnProperty(args.length)){throwBindingError(`Function '${humanName}' called with an invalid number of arguments (${args.length}) - expects one of (${proto[methodName].overloadTable})!`)}return proto[methodName].overloadTable[args.length].apply(this,args)};// Move the previous function into the overload table.
proto[methodName].overloadTable=[];proto[methodName].overloadTable[prevFunc.argCount]=prevFunc}};/** @param {number=} numArguments */var exposePublicSymbol=(name,value,numArguments)=>{if(Module.hasOwnProperty(name)){if(undefined===numArguments||(undefined!==Module[name].overloadTable&&undefined!==Module[name].overloadTable[numArguments])){throwBindingError(`Cannot register public name '${name}' twice`)}// We are exposing a function with the same name as an existing function. Create an overload table and a function selector
// that routes between the two.
ensureOverloadTable(Module,name,name);if(Module[name].overloadTable.hasOwnProperty(numArguments)){throwBindingError(`Cannot register multiple overloads of a function with the same number of arguments (${numArguments})!`)}// Add the new function into the overload table.
Module[name].overloadTable[numArguments]=value}else{Module[name]=value;Module[name].argCount=numArguments}};var char_0=48;var char_9=57;var makeLegalFunctionName=name=>{name=name.replace(/[^a-zA-Z0-9_]/g,"$");var f=name.charCodeAt(0);if(f>=char_0&&f<=char_9){return`_${name}`}return name};/** @constructor */function RegisteredClass(name,constructor,instancePrototype,rawDestructor,baseClass,getActualType,upcast,downcast){this.name=name;this.constructor=constructor;this.instancePrototype=instancePrototype;this.rawDestructor=rawDestructor;this.baseClass=baseClass;this.getActualType=getActualType;this.upcast=upcast;this.downcast=downcast;this.pureVirtualFunctions=[]}var upcastPointer=(ptr,ptrClass,desiredClass)=>{while(ptrClass!==desiredClass){if(!ptrClass.upcast){throwBindingError(`Expected null or instance of ${desiredClass.name}, got an instance of ${ptrClass.name}`)}ptr=ptrClass.upcast(ptr);ptrClass=ptrClass.baseClass}return ptr};/** @suppress {globalThis} */function constNoSmartPtrRawPointerToWireType(destructors,handle){if(handle===null){if(this.isReference){throwBindingError(`null is not a valid ${this.name}`)}return 0}if(!handle.$$){throwBindingError(`Cannot pass "${embindRepr(handle)}" as a ${this.name}`)}if(!handle.$$.ptr){throwBindingError(`Cannot pass deleted object as a pointer of type ${this.name}`)}var handleClass=handle.$$.ptrType.registeredClass;var ptr=upcastPointer(handle.$$.ptr,handleClass,this.registeredClass);return ptr}/** @suppress {globalThis} */function genericPointerToWireType(destructors,handle){var ptr;if(handle===null){if(this.isReference){throwBindingError(`null is not a valid ${this.name}`)}if(this.isSmartPointer){ptr=this.rawConstructor();if(destructors!==null){destructors.push(this.rawDestructor,ptr)}return ptr}else{return 0}}if(!handle||!handle.$$){throwBindingError(`Cannot pass "${embindRepr(handle)}" as a ${this.name}`)}if(!handle.$$.ptr){throwBindingError(`Cannot pass deleted object as a pointer of type ${this.name}`)}if(!this.isConst&&handle.$$.ptrType.isConst){throwBindingError(`Cannot convert argument of type ${(handle.$$.smartPtrType?handle.$$.smartPtrType.name:handle.$$.ptrType.name)} to parameter type ${this.name}`)}var handleClass=handle.$$.ptrType.registeredClass;ptr=upcastPointer(handle.$$.ptr,handleClass,this.registeredClass);if(this.isSmartPointer){// TODO: this is not strictly true
// We could support BY_EMVAL conversions from raw pointers to smart pointers
// because the smart pointer can hold a reference to the handle
if(undefined===handle.$$.smartPtr){throwBindingError("Passing raw pointer to smart pointer is illegal")}switch(this.sharingPolicy){case 0:// NONE
// no upcasting
if(handle.$$.smartPtrType===this){ptr=handle.$$.smartPtr}else{throwBindingError(`Cannot convert argument of type ${(handle.$$.smartPtrType?handle.$$.smartPtrType.name:handle.$$.ptrType.name)} to parameter type ${this.name}`)}break;case 1:// INTRUSIVE
ptr=handle.$$.smartPtr;break;case 2:// BY_EMVAL
if(handle.$$.smartPtrType===this){ptr=handle.$$.smartPtr}else{var clonedHandle=handle["clone"]();ptr=this.rawShare(ptr,Emval.toHandle(()=>clonedHandle["delete"]()));if(destructors!==null){destructors.push(this.rawDestructor,ptr)}}break;default:throwBindingError("Unsupporting sharing policy")}}return ptr}/** @suppress {globalThis} */function nonConstNoSmartPtrRawPointerToWireType(destructors,handle){if(handle===null){if(this.isReference){throwBindingError(`null is not a valid ${this.name}`)}return 0}if(!handle.$$){throwBindingError(`Cannot pass "${embindRepr(handle)}" as a ${this.name}`)}if(!handle.$$.ptr){throwBindingError(`Cannot pass deleted object as a pointer of type ${this.name}`)}if(handle.$$.ptrType.isConst){throwBindingError(`Cannot convert argument of type ${handle.$$.ptrType.name} to parameter type ${this.name}`)}var handleClass=handle.$$.ptrType.registeredClass;var ptr=upcastPointer(handle.$$.ptr,handleClass,this.registeredClass);return ptr}var init_RegisteredPointer=()=>{Object.assign(RegisteredPointer.prototype,{getPointee(ptr){if(this.rawGetPointee){ptr=this.rawGetPointee(ptr)}return ptr},destructor(ptr){this.rawDestructor?.(ptr)},argPackAdvance:GenericWireTypeSize,"readValueFromPointer":readPointer,"fromWireType":RegisteredPointer_fromWireType})};/** @constructor
      @param {*=} pointeeType,
      @param {*=} sharingPolicy,
      @param {*=} rawGetPointee,
      @param {*=} rawConstructor,
      @param {*=} rawShare,
      @param {*=} rawDestructor,
       */function RegisteredPointer(name,registeredClass,isReference,isConst,// smart pointer properties
isSmartPointer,pointeeType,sharingPolicy,rawGetPointee,rawConstructor,rawShare,rawDestructor){this.name=name;this.registeredClass=registeredClass;this.isReference=isReference;this.isConst=isConst;// smart pointer properties
this.isSmartPointer=isSmartPointer;this.pointeeType=pointeeType;this.sharingPolicy=sharingPolicy;this.rawGetPointee=rawGetPointee;this.rawConstructor=rawConstructor;this.rawShare=rawShare;this.rawDestructor=rawDestructor;if(!isSmartPointer&&registeredClass.baseClass===undefined){if(isConst){this["toWireType"]=constNoSmartPtrRawPointerToWireType;this.destructorFunction=null}else{this["toWireType"]=nonConstNoSmartPtrRawPointerToWireType;this.destructorFunction=null}}else{this["toWireType"]=genericPointerToWireType}}/** @param {number=} numArguments */var replacePublicSymbol=(name,value,numArguments)=>{if(!Module.hasOwnProperty(name)){throwInternalError("Replacing nonexistent public symbol")}// If there's an overload table for this symbol, replace the symbol in the overload table instead.
if(undefined!==Module[name].overloadTable&&undefined!==numArguments){Module[name].overloadTable[numArguments]=value}else{Module[name]=value;Module[name].argCount=numArguments}};var dynCallLegacy=(sig,ptr,args)=>{sig=sig.replace(/p/g,"i");var f=Module["dynCall_"+sig];return f(ptr,...args)};var wasmTableMirror=[];/** @type {WebAssembly.Table} */var wasmTable;var getWasmTableEntry=funcPtr=>{var func=wasmTableMirror[funcPtr];if(!func){if(funcPtr>=wasmTableMirror.length)wasmTableMirror.length=funcPtr+1;/** @suppress {checkTypes} */wasmTableMirror[funcPtr]=func=wasmTable.get(funcPtr)}return func};var dynCall=(sig,ptr,args=[])=>{// Without WASM_BIGINT support we cannot directly call function with i64 as
// part of their signature, so we rely on the dynCall functions generated by
// wasm-emscripten-finalize
if(sig.includes("j")){return dynCallLegacy(sig,ptr,args)}var rtn=getWasmTableEntry(ptr)(...args);return rtn};var getDynCaller=(sig,ptr)=>(...args)=>dynCall(sig,ptr,args);var embind__requireFunction=(signature,rawFunction)=>{signature=readLatin1String(signature);function makeDynCaller(){if(signature.includes("j")){return getDynCaller(signature,rawFunction)}return getWasmTableEntry(rawFunction)}var fp=makeDynCaller();if(typeof fp!="function"){throwBindingError(`unknown function pointer with signature ${signature}: ${rawFunction}`)}return fp};var extendError=(baseErrorType,errorName)=>{var errorClass=createNamedFunction(errorName,function(message){this.name=errorName;this.message=message;var stack=(new Error(message)).stack;if(stack!==undefined){this.stack=this.toString()+"\n"+stack.replace(/^Error(:[^\n]*)?\n/,"")}});errorClass.prototype=Object.create(baseErrorType.prototype);errorClass.prototype.constructor=errorClass;errorClass.prototype.toString=function(){if(this.message===undefined){return this.name}else{return`${this.name}: ${this.message}`}};return errorClass};var UnboundTypeError;var getTypeName=type=>{var ptr=___getTypeName(type);var rv=readLatin1String(ptr);_free(ptr);return rv};var throwUnboundTypeError=(message,types)=>{var unboundTypes=[];var seen={};function visit(type){if(seen[type]){return}if(registeredTypes[type]){return}if(typeDependencies[type]){typeDependencies[type].forEach(visit);return}unboundTypes.push(type);seen[type]=true}types.forEach(visit);throw new UnboundTypeError(`${message}: `+unboundTypes.map(getTypeName).join([", "]))};var __embind_register_class=(rawType,rawPointerType,rawConstPointerType,baseClassRawType,getActualTypeSignature,getActualType,upcastSignature,upcast,downcastSignature,downcast,name,destructorSignature,rawDestructor)=>{name=readLatin1String(name);getActualType=embind__requireFunction(getActualTypeSignature,getActualType);upcast&&=embind__requireFunction(upcastSignature,upcast);downcast&&=embind__requireFunction(downcastSignature,downcast);rawDestructor=embind__requireFunction(destructorSignature,rawDestructor);var legalFunctionName=makeLegalFunctionName(name);exposePublicSymbol(legalFunctionName,function(){// this code cannot run if baseClassRawType is zero
throwUnboundTypeError(`Cannot construct ${name} due to unbound types`,[baseClassRawType])});whenDependentTypesAreResolved([rawType,rawPointerType,rawConstPointerType],baseClassRawType?[baseClassRawType]:[],base=>{base=base[0];var baseClass;var basePrototype;if(baseClassRawType){baseClass=base.registeredClass;basePrototype=baseClass.instancePrototype}else{basePrototype=ClassHandle.prototype}var constructor=createNamedFunction(name,function(...args){if(Object.getPrototypeOf(this)!==instancePrototype){throw new BindingError("Use 'new' to construct "+name)}if(undefined===registeredClass.constructor_body){throw new BindingError(name+" has no accessible constructor")}var body=registeredClass.constructor_body[args.length];if(undefined===body){throw new BindingError(`Tried to invoke ctor of ${name} with invalid number of parameters (${args.length}) - expected (${Object.keys(registeredClass.constructor_body).toString()}) parameters instead!`)}return body.apply(this,args)});var instancePrototype=Object.create(basePrototype,{constructor:{value:constructor}});constructor.prototype=instancePrototype;var registeredClass=new RegisteredClass(name,constructor,instancePrototype,rawDestructor,baseClass,getActualType,upcast,downcast);if(registeredClass.baseClass){// Keep track of class hierarchy. Used to allow sub-classes to inherit class functions.
registeredClass.baseClass.__derivedClasses??=[];registeredClass.baseClass.__derivedClasses.push(registeredClass)}var referenceConverter=new RegisteredPointer(name,registeredClass,true,false,false);var pointerConverter=new RegisteredPointer(name+"*",registeredClass,false,false,false);var constPointerConverter=new RegisteredPointer(name+" const*",registeredClass,false,true,false);registeredPointers[rawType]={pointerType:pointerConverter,constPointerType:constPointerConverter};replacePublicSymbol(legalFunctionName,constructor);return[referenceConverter,pointerConverter,constPointerConverter]})};function usesDestructorStack(argTypes){// Skip return value at index 0 - it's not deleted here.
for(var i=1;i<argTypes.length;++i){// The type does not define a destructor function - must use dynamic stack
if(argTypes[i]!==null&&argTypes[i].destructorFunction===undefined){return true}}return false}function craftInvokerFunction(humanName,argTypes,classType,cppInvokerFunc,cppTargetFunc,/** boolean= */isAsync){// humanName: a human-readable string name for the function to be generated.
// argTypes: An array that contains the embind type objects for all types in the function signature.
//    argTypes[0] is the type object for the function return value.
//    argTypes[1] is the type object for function this object/class type, or null if not crafting an invoker for a class method.
//    argTypes[2...] are the actual function parameters.
// classType: The embind type object for the class to be bound, or null if this is not a method of a class.
// cppInvokerFunc: JS Function object to the C++-side function that interops into C++ code.
// cppTargetFunc: Function pointer (an integer to FUNCTION_TABLE) to the target C++ function the cppInvokerFunc will end up calling.
// isAsync: Optional. If true, returns an async function. Async bindings are only supported with JSPI.
var argCount=argTypes.length;if(argCount<2){throwBindingError("argTypes array size mismatch! Must at least get return value and 'this' types!")}var isClassMethodFunc=(argTypes[1]!==null&&classType!==null);// Free functions with signature "void function()" do not need an invoker that marshalls between wire types.
// TODO: This omits argument count check - enable only at -O3 or similar.
//    if (ENABLE_UNSAFE_OPTS && argCount == 2 && argTypes[0].name == "void" && !isClassMethodFunc) {
//       return FUNCTION_TABLE[fn];
//    }
// Determine if we need to use a dynamic stack to store the destructors for the function parameters.
// TODO: Remove this completely once all function invokers are being dynamically generated.
var needsDestructorStack=usesDestructorStack(argTypes);var returns=(argTypes[0].name!=="void");var expectedArgCount=argCount-2;var argsWired=new Array(expectedArgCount);var invokerFuncArgs=[];var destructors=[];var invokerFn=function(...args){destructors.length=0;var thisWired;invokerFuncArgs.length=isClassMethodFunc?2:1;invokerFuncArgs[0]=cppTargetFunc;if(isClassMethodFunc){thisWired=argTypes[1]["toWireType"](destructors,this);invokerFuncArgs[1]=thisWired}for(var i=0;i<expectedArgCount;++i){argsWired[i]=argTypes[i+2]["toWireType"](destructors,args[i]);invokerFuncArgs.push(argsWired[i])}var rv=cppInvokerFunc(...invokerFuncArgs);function onDone(rv){if(needsDestructorStack){runDestructors(destructors)}else{for(var i=isClassMethodFunc?1:2;i<argTypes.length;i++){var param=i===1?thisWired:argsWired[i-2];if(argTypes[i].destructorFunction!==null){argTypes[i].destructorFunction(param)}}}if(returns){return argTypes[0]["fromWireType"](rv)}}return onDone(rv)};return createNamedFunction(humanName,invokerFn)}var heap32VectorToArray=(count,firstElement)=>{var array=[];for(var i=0;i<count;i++){// TODO(https://github.com/emscripten-core/emscripten/issues/17310):
// Find a way to hoist the `>> 2` or `>> 3` out of this loop.
array.push(HEAPU32[(((firstElement)+(i*4))>>2)])}return array};var getFunctionName=signature=>{signature=signature.trim();const argsIndex=signature.indexOf("(");if(argsIndex===-1)return signature;return signature.slice(0,argsIndex)};var __embind_register_class_function=(rawClassType,methodName,argCount,rawArgTypesAddr,// [ReturnType, ThisType, Args...]
invokerSignature,rawInvoker,context,isPureVirtual,isAsync,isNonnullReturn)=>{var rawArgTypes=heap32VectorToArray(argCount,rawArgTypesAddr);methodName=readLatin1String(methodName);methodName=getFunctionName(methodName);rawInvoker=embind__requireFunction(invokerSignature,rawInvoker);whenDependentTypesAreResolved([],[rawClassType],classType=>{classType=classType[0];var humanName=`${classType.name}.${methodName}`;if(methodName.startsWith("@@")){methodName=Symbol[methodName.substring(2)]}if(isPureVirtual){classType.registeredClass.pureVirtualFunctions.push(methodName)}function unboundTypesHandler(){throwUnboundTypeError(`Cannot call ${humanName} due to unbound types`,rawArgTypes)}var proto=classType.registeredClass.instancePrototype;var method=proto[methodName];if(undefined===method||(undefined===method.overloadTable&&method.className!==classType.name&&method.argCount===argCount-2)){// This is the first overload to be registered, OR we are replacing a
// function in the base class with a function in the derived class.
unboundTypesHandler.argCount=argCount-2;unboundTypesHandler.className=classType.name;proto[methodName]=unboundTypesHandler}else{// There was an existing function with the same name registered. Set up
// a function overload routing table.
ensureOverloadTable(proto,methodName,humanName);proto[methodName].overloadTable[argCount-2]=unboundTypesHandler}whenDependentTypesAreResolved([],rawArgTypes,argTypes=>{var memberFunction=craftInvokerFunction(humanName,argTypes,classType,rawInvoker,context,isAsync);// Replace the initial unbound-handler-stub function with the
// appropriate member function, now that all types are resolved. If
// multiple overloads are registered for this function, the function
// goes into an overload table.
if(undefined===proto[methodName].overloadTable){// Set argCount in case an overload is registered later
memberFunction.argCount=argCount-2;proto[methodName]=memberFunction}else{proto[methodName].overloadTable[argCount-2]=memberFunction}return[]});return[]})};var emval_freelist=[];var emval_handles=[];var __emval_decref=handle=>{if(handle>9&&0===--emval_handles[handle+1]){emval_handles[handle]=undefined;emval_freelist.push(handle)}};var count_emval_handles=()=>emval_handles.length/2-5-emval_freelist.length;var init_emval=()=>{// reserve 0 and some special values. These never get de-allocated.
emval_handles.push(0,1,undefined,1,null,1,true,1,false,1);Module["count_emval_handles"]=count_emval_handles};var Emval={toValue:handle=>{if(!handle){throwBindingError("Cannot use deleted val. handle = "+handle)}return emval_handles[handle]},toHandle:value=>{switch(value){case undefined:return 2;case null:return 4;case true:return 6;case false:return 8;default:{const handle=emval_freelist.pop()||emval_handles.length;emval_handles[handle]=value;emval_handles[handle+1]=1;return handle}}}};var EmValType={name:"emscripten::val","fromWireType":handle=>{var rv=Emval.toValue(handle);__emval_decref(handle);return rv},"toWireType":(destructors,value)=>Emval.toHandle(value),argPackAdvance:GenericWireTypeSize,"readValueFromPointer":readPointer,destructorFunction:null};var __embind_register_emval=rawType=>registerType(rawType,EmValType);var embindRepr=v=>{if(v===null){return"null"}var t=typeof v;if(t==="object"||t==="array"||t==="function"){return v.toString()}else{return""+v}};var floatReadValueFromPointer=(name,width)=>{switch(width){case 4:return function(pointer){return this["fromWireType"](HEAPF32[((pointer)>>2)])};case 8:return function(pointer){return this["fromWireType"](HEAPF64[((pointer)>>3)])};default:throw new TypeError(`invalid float width (${width}): ${name}`)}};var __embind_register_float=(rawType,name,size)=>{name=readLatin1String(name);registerType(rawType,{name,"fromWireType":value=>value,"toWireType":(destructors,value)=>value,argPackAdvance:GenericWireTypeSize,"readValueFromPointer":floatReadValueFromPointer(name,size),destructorFunction:null})};var __embind_register_function=(name,argCount,rawArgTypesAddr,signature,rawInvoker,fn,isAsync,isNonnullReturn)=>{var argTypes=heap32VectorToArray(argCount,rawArgTypesAddr);name=readLatin1String(name);name=getFunctionName(name);rawInvoker=embind__requireFunction(signature,rawInvoker);exposePublicSymbol(name,function(){throwUnboundTypeError(`Cannot call ${name} due to unbound types`,argTypes)},argCount-1);whenDependentTypesAreResolved([],argTypes,argTypes=>{var invokerArgsArray=[argTypes[0],null].concat(argTypes.slice(1));replacePublicSymbol(name,craftInvokerFunction(name,invokerArgsArray,null,rawInvoker,fn,isAsync),argCount-1);return[]})};var integerReadValueFromPointer=(name,width,signed)=>{// integers are quite common, so generate very specialized functions
switch(width){case 1:return signed?pointer=>HEAP8[pointer]:pointer=>HEAPU8[pointer];case 2:return signed?pointer=>HEAP16[((pointer)>>1)]:pointer=>HEAPU16[((pointer)>>1)];case 4:return signed?pointer=>HEAP32[((pointer)>>2)]:pointer=>HEAPU32[((pointer)>>2)];default:throw new TypeError(`invalid integer width (${width}): ${name}`)}};/** @suppress {globalThis} */var __embind_register_integer=(primitiveType,name,size,minRange,maxRange)=>{name=readLatin1String(name);// LLVM doesn't have signed and unsigned 32-bit types, so u32 literals come
// out as 'i32 -1'. Always treat those as max u32.
if(maxRange===-1){maxRange=4294967295}var fromWireType=value=>value;if(minRange===0){var bitshift=32-8*size;fromWireType=value=>(value<<bitshift)>>>bitshift}var isUnsignedType=(name.includes("unsigned"));var checkAssertions=(value,toTypeName)=>{};var toWireType;if(isUnsignedType){toWireType=function(destructors,value){checkAssertions(value,this.name);return value>>>0}}else{toWireType=function(destructors,value){checkAssertions(value,this.name);// The VM will perform JS to Wasm value conversion, according to the spec:
// https://www.w3.org/TR/wasm-js-api-1/#towebassemblyvalue
return value}}registerType(primitiveType,{name,"fromWireType":fromWireType,"toWireType":toWireType,argPackAdvance:GenericWireTypeSize,"readValueFromPointer":integerReadValueFromPointer(name,size,minRange!==0),destructorFunction:null})};var __embind_register_memory_view=(rawType,dataTypeIndex,name)=>{var typeMapping=[Int8Array,Uint8Array,Int16Array,Uint16Array,Int32Array,Uint32Array,Float32Array,Float64Array];var TA=typeMapping[dataTypeIndex];function decodeMemoryView(handle){var size=HEAPU32[((handle)>>2)];var data=HEAPU32[(((handle)+(4))>>2)];return new TA(HEAP8.buffer,data,size)}name=readLatin1String(name);registerType(rawType,{name,"fromWireType":decodeMemoryView,argPackAdvance:GenericWireTypeSize,"readValueFromPointer":decodeMemoryView},{ignoreDuplicateRegistrations:true})};var stringToUTF8=(str,outPtr,maxBytesToWrite)=>stringToUTF8Array(str,HEAPU8,outPtr,maxBytesToWrite);var __embind_register_std_string=(rawType,name)=>{name=readLatin1String(name);var stdStringIsUTF8=false;registerType(rawType,{name,// For some method names we use string keys here since they are part of
// the public/external API and/or used by the runtime-generated code.
"fromWireType"(value){var length=HEAPU32[((value)>>2)];var payload=value+4;var str;if(stdStringIsUTF8){var decodeStartPtr=payload;// Looping here to support possible embedded '0' bytes
for(var i=0;i<=length;++i){var currentBytePtr=payload+i;if(i==length||HEAPU8[currentBytePtr]==0){var maxRead=currentBytePtr-decodeStartPtr;var stringSegment=UTF8ToString(decodeStartPtr,maxRead);if(str===undefined){str=stringSegment}else{str+=String.fromCharCode(0);str+=stringSegment}decodeStartPtr=currentBytePtr+1}}}else{var a=new Array(length);for(var i=0;i<length;++i){a[i]=String.fromCharCode(HEAPU8[payload+i])}str=a.join("")}_free(value);return str},"toWireType"(destructors,value){if(value instanceof ArrayBuffer){value=new Uint8Array(value)}var length;var valueIsOfTypeString=(typeof value=="string");if(!(valueIsOfTypeString||value instanceof Uint8Array||value instanceof Uint8ClampedArray||value instanceof Int8Array)){throwBindingError("Cannot pass non-string to std::string")}if(stdStringIsUTF8&&valueIsOfTypeString){length=lengthBytesUTF8(value)}else{length=value.length}// assumes POINTER_SIZE alignment
var base=_malloc(4+length+1);var ptr=base+4;HEAPU32[((base)>>2)]=length;if(stdStringIsUTF8&&valueIsOfTypeString){stringToUTF8(value,ptr,length+1)}else{if(valueIsOfTypeString){for(var i=0;i<length;++i){var charCode=value.charCodeAt(i);if(charCode>255){_free(base);throwBindingError("String has UTF-16 code units that do not fit in 8 bits")}HEAPU8[ptr+i]=charCode}}else{for(var i=0;i<length;++i){HEAPU8[ptr+i]=value[i]}}}if(destructors!==null){destructors.push(_free,base)}return base},argPackAdvance:GenericWireTypeSize,"readValueFromPointer":readPointer,destructorFunction(ptr){_free(ptr)}})};var UTF16Decoder=new TextDecoder("utf-16le");var UTF16ToString=(ptr,maxBytesToRead)=>{var endPtr=ptr;// TextDecoder needs to know the byte length in advance, it doesn't stop on
// null terminator by itself.
// Also, use the length info to avoid running tiny strings through
// TextDecoder, since .subarray() allocates garbage.
var idx=endPtr>>1;var maxIdx=idx+maxBytesToRead/2;// If maxBytesToRead is not passed explicitly, it will be undefined, and this
// will always evaluate to true. This saves on code size.
while(!(idx>=maxIdx)&&HEAPU16[idx])++idx;endPtr=idx<<1;return UTF16Decoder.decode(HEAPU8.subarray(ptr,endPtr))};var stringToUTF16=(str,outPtr,maxBytesToWrite)=>{// Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
maxBytesToWrite??=2147483647;if(maxBytesToWrite<2)return 0;maxBytesToWrite-=2;// Null terminator.
var startPtr=outPtr;var numCharsToWrite=(maxBytesToWrite<str.length*2)?(maxBytesToWrite/2):str.length;for(var i=0;i<numCharsToWrite;++i){// charCodeAt returns a UTF-16 encoded code unit, so it can be directly written to the HEAP.
var codeUnit=str.charCodeAt(i);// possibly a lead surrogate
HEAP16[((outPtr)>>1)]=codeUnit;outPtr+=2}// Null-terminate the pointer to the HEAP.
HEAP16[((outPtr)>>1)]=0;return outPtr-startPtr};var lengthBytesUTF16=str=>str.length*2;var UTF32ToString=(ptr,maxBytesToRead)=>{var i=0;var str="";// If maxBytesToRead is not passed explicitly, it will be undefined, and this
// will always evaluate to true. This saves on code size.
while(!(i>=maxBytesToRead/4)){var utf32=HEAP32[(((ptr)+(i*4))>>2)];if(utf32==0)break;++i;// Gotcha: fromCharCode constructs a character from a UTF-16 encoded code (pair), not from a Unicode code point! So encode the code point to UTF-16 for constructing.
// See http://unicode.org/faq/utf_bom.html#utf16-3
if(utf32>=65536){var ch=utf32-65536;str+=String.fromCharCode(55296|(ch>>10),56320|(ch&1023))}else{str+=String.fromCharCode(utf32)}}return str};var stringToUTF32=(str,outPtr,maxBytesToWrite)=>{// Backwards compatibility: if max bytes is not specified, assume unsafe unbounded write is allowed.
maxBytesToWrite??=2147483647;if(maxBytesToWrite<4)return 0;var startPtr=outPtr;var endPtr=startPtr+maxBytesToWrite-4;for(var i=0;i<str.length;++i){// Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
// See http://unicode.org/faq/utf_bom.html#utf16-3
var codeUnit=str.charCodeAt(i);// possibly a lead surrogate
if(codeUnit>=55296&&codeUnit<=57343){var trailSurrogate=str.charCodeAt(++i);codeUnit=65536+((codeUnit&1023)<<10)|(trailSurrogate&1023)}HEAP32[((outPtr)>>2)]=codeUnit;outPtr+=4;if(outPtr+4>endPtr)break}// Null-terminate the pointer to the HEAP.
HEAP32[((outPtr)>>2)]=0;return outPtr-startPtr};var lengthBytesUTF32=str=>{var len=0;for(var i=0;i<str.length;++i){// Gotcha: charCodeAt returns a 16-bit word that is a UTF-16 encoded code unit, not a Unicode code point of the character! We must decode the string to UTF-32 to the heap.
// See http://unicode.org/faq/utf_bom.html#utf16-3
var codeUnit=str.charCodeAt(i);if(codeUnit>=55296&&codeUnit<=57343)++i;// possibly a lead surrogate, so skip over the tail surrogate.
len+=4}return len};var __embind_register_std_wstring=(rawType,charSize,name)=>{name=readLatin1String(name);var decodeString,encodeString,readCharAt,lengthBytesUTF;if(charSize===2){decodeString=UTF16ToString;encodeString=stringToUTF16;lengthBytesUTF=lengthBytesUTF16;readCharAt=pointer=>HEAPU16[((pointer)>>1)]}else if(charSize===4){decodeString=UTF32ToString;encodeString=stringToUTF32;lengthBytesUTF=lengthBytesUTF32;readCharAt=pointer=>HEAPU32[((pointer)>>2)]}registerType(rawType,{name,"fromWireType":value=>{// Code mostly taken from _embind_register_std_string fromWireType
var length=HEAPU32[((value)>>2)];var str;var decodeStartPtr=value+4;// Looping here to support possible embedded '0' bytes
for(var i=0;i<=length;++i){var currentBytePtr=value+4+i*charSize;if(i==length||readCharAt(currentBytePtr)==0){var maxReadBytes=currentBytePtr-decodeStartPtr;var stringSegment=decodeString(decodeStartPtr,maxReadBytes);if(str===undefined){str=stringSegment}else{str+=String.fromCharCode(0);str+=stringSegment}decodeStartPtr=currentBytePtr+charSize}}_free(value);return str},"toWireType":(destructors,value)=>{if(!(typeof value=="string")){throwBindingError(`Cannot pass non-string to C++ string type ${name}`)}// assumes POINTER_SIZE alignment
var length=lengthBytesUTF(value);var ptr=_malloc(4+length+charSize);HEAPU32[((ptr)>>2)]=length/charSize;encodeString(value,ptr+4,length+charSize);if(destructors!==null){destructors.push(_free,ptr)}return ptr},argPackAdvance:GenericWireTypeSize,"readValueFromPointer":readPointer,destructorFunction(ptr){_free(ptr)}})};var __embind_register_value_object=(rawType,name,constructorSignature,rawConstructor,destructorSignature,rawDestructor)=>{structRegistrations[rawType]={name:readLatin1String(name),rawConstructor:embind__requireFunction(constructorSignature,rawConstructor),rawDestructor:embind__requireFunction(destructorSignature,rawDestructor),fields:[]}};var __embind_register_value_object_field=(structType,fieldName,getterReturnType,getterSignature,getter,getterContext,setterArgumentType,setterSignature,setter,setterContext)=>{structRegistrations[structType].fields.push({fieldName:readLatin1String(fieldName),getterReturnType,getter:embind__requireFunction(getterSignature,getter),getterContext,setterArgumentType,setter:embind__requireFunction(setterSignature,setter),setterContext})};var __embind_register_void=(rawType,name)=>{name=readLatin1String(name);registerType(rawType,{isVoid:true,// void return values can be optimized out sometimes
name,argPackAdvance:0,"fromWireType":()=>undefined,// TODO: assert if anything else is given?
"toWireType":(destructors,o)=>undefined})};var requireRegisteredType=(rawType,humanName)=>{var impl=registeredTypes[rawType];if(undefined===impl){throwBindingError(`${humanName} has unknown type ${getTypeName(rawType)}`)}return impl};var emval_returnValue=(returnType,destructorsRef,handle)=>{var destructors=[];var result=returnType["toWireType"](destructors,handle);if(destructors.length){// void, primitives and any other types w/o destructors don't need to allocate a handle
HEAPU32[((destructorsRef)>>2)]=Emval.toHandle(destructors)}return result};var __emval_as=(handle,returnType,destructorsRef)=>{handle=Emval.toValue(handle);returnType=requireRegisteredType(returnType,"emval::as");return emval_returnValue(returnType,destructorsRef,handle)};var emval_methodCallers=[];var __emval_call=(caller,handle,destructorsRef,args)=>{caller=emval_methodCallers[caller];handle=Emval.toValue(handle);return caller(null,handle,destructorsRef,args)};var emval_symbols={};var getStringOrSymbol=address=>{var symbol=emval_symbols[address];if(symbol===undefined){return readLatin1String(address)}return symbol};var __emval_call_method=(caller,objHandle,methodName,destructorsRef,args)=>{caller=emval_methodCallers[caller];objHandle=Emval.toValue(objHandle);methodName=getStringOrSymbol(methodName);return caller(objHandle,objHandle[methodName],destructorsRef,args)};var emval_get_global=()=>{if(typeof globalThis=="object"){return globalThis}function testGlobal(obj){obj["$$$embind_global$$$"]=obj;var success=typeof $$$embind_global$$$=="object"&&obj["$$$embind_global$$$"]==obj;if(!success){delete obj["$$$embind_global$$$"]}return success}if(typeof $$$embind_global$$$=="object"){return $$$embind_global$$$}if(typeof global=="object"&&testGlobal(global)){$$$embind_global$$$=global}else if(typeof self=="object"&&testGlobal(self)){$$$embind_global$$$=self}if(typeof $$$embind_global$$$=="object"){return $$$embind_global$$$}throw Error("unable to get global object.")};var __emval_get_global=name=>{if(name===0){return Emval.toHandle(emval_get_global())}else{name=getStringOrSymbol(name);return Emval.toHandle(emval_get_global()[name])}};var emval_addMethodCaller=caller=>{var id=emval_methodCallers.length;emval_methodCallers.push(caller);return id};var emval_lookupTypes=(argCount,argTypes)=>{var a=new Array(argCount);for(var i=0;i<argCount;++i){a[i]=requireRegisteredType(HEAPU32[(((argTypes)+(i*4))>>2)],"parameter "+i)}return a};var reflectConstruct=Reflect.construct;var __emval_get_method_caller=(argCount,argTypes,kind)=>{var types=emval_lookupTypes(argCount,argTypes);var retType=types.shift();argCount--;// remove the shifted off return type
var argN=new Array(argCount);var invokerFunction=(obj,func,destructorsRef,args)=>{var offset=0;for(var i=0;i<argCount;++i){argN[i]=types[i]["readValueFromPointer"](args+offset);offset+=types[i].argPackAdvance}var rv=kind===/* CONSTRUCTOR */1?reflectConstruct(func,argN):func.apply(obj,argN);return emval_returnValue(retType,destructorsRef,rv)};var functionName=`methodCaller<(${types.map(t=>t.name).join(", ")}) => ${retType.name}>`;return emval_addMethodCaller(createNamedFunction(functionName,invokerFunction))};var __emval_get_property=(handle,key)=>{handle=Emval.toValue(handle);key=Emval.toValue(key);return Emval.toHandle(handle[key])};var __emval_incref=handle=>{if(handle>9){emval_handles[handle+1]+=1}};var __emval_instanceof=(object,constructor)=>{object=Emval.toValue(object);constructor=Emval.toValue(constructor);return object instanceof constructor};var __emval_new_cstring=v=>Emval.toHandle(getStringOrSymbol(v));var __emval_run_destructors=handle=>{var destructors=Emval.toValue(handle);runDestructors(destructors);__emval_decref(handle)};var __emval_set_property=(handle,key,value)=>{handle=Emval.toValue(handle);key=Emval.toValue(key);value=Emval.toValue(value);handle[key]=value};var __emval_take_value=(type,arg)=>{type=requireRegisteredType(type,"_emval_take_value");var v=type["readValueFromPointer"](arg);return Emval.toHandle(v)};var __emval_typeof=handle=>{handle=Emval.toValue(handle);return Emval.toHandle(typeof handle)};var convertI32PairToI53Checked=(lo,hi)=>((hi+2097152)>>>0<4194305-!!lo)?(lo>>>0)+hi*4294967296:NaN;function __gmtime_js(time_low,time_high,tmPtr){var time=convertI32PairToI53Checked(time_low,time_high);var date=new Date(time*1e3);HEAP32[((tmPtr)>>2)]=date.getUTCSeconds();HEAP32[(((tmPtr)+(4))>>2)]=date.getUTCMinutes();HEAP32[(((tmPtr)+(8))>>2)]=date.getUTCHours();HEAP32[(((tmPtr)+(12))>>2)]=date.getUTCDate();HEAP32[(((tmPtr)+(16))>>2)]=date.getUTCMonth();HEAP32[(((tmPtr)+(20))>>2)]=date.getUTCFullYear()-1900;HEAP32[(((tmPtr)+(24))>>2)]=date.getUTCDay();var start=Date.UTC(date.getUTCFullYear(),0,1,0,0,0,0);var yday=((date.getTime()-start)/(1e3*60*60*24))|0;HEAP32[(((tmPtr)+(28))>>2)]=yday}var isLeapYear=year=>year%4===0&&(year%100!==0||year%400===0);var MONTH_DAYS_LEAP_CUMULATIVE=[0,31,60,91,121,152,182,213,244,274,305,335];var MONTH_DAYS_REGULAR_CUMULATIVE=[0,31,59,90,120,151,181,212,243,273,304,334];var ydayFromDate=date=>{var leap=isLeapYear(date.getFullYear());var monthDaysCumulative=(leap?MONTH_DAYS_LEAP_CUMULATIVE:MONTH_DAYS_REGULAR_CUMULATIVE);var yday=monthDaysCumulative[date.getMonth()]+date.getDate()-1;// -1 since it's days since Jan 1
return yday};function __localtime_js(time_low,time_high,tmPtr){var time=convertI32PairToI53Checked(time_low,time_high);var date=new Date(time*1e3);HEAP32[((tmPtr)>>2)]=date.getSeconds();HEAP32[(((tmPtr)+(4))>>2)]=date.getMinutes();HEAP32[(((tmPtr)+(8))>>2)]=date.getHours();HEAP32[(((tmPtr)+(12))>>2)]=date.getDate();HEAP32[(((tmPtr)+(16))>>2)]=date.getMonth();HEAP32[(((tmPtr)+(20))>>2)]=date.getFullYear()-1900;HEAP32[(((tmPtr)+(24))>>2)]=date.getDay();var yday=ydayFromDate(date)|0;HEAP32[(((tmPtr)+(28))>>2)]=yday;HEAP32[(((tmPtr)+(36))>>2)]=-(date.getTimezoneOffset()*60);// Attention: DST is in December in South, and some regions don't have DST at all.
var start=new Date(date.getFullYear(),0,1);var summerOffset=new Date(date.getFullYear(),6,1).getTimezoneOffset();var winterOffset=start.getTimezoneOffset();var dst=(summerOffset!=winterOffset&&date.getTimezoneOffset()==Math.min(winterOffset,summerOffset))|0;HEAP32[(((tmPtr)+(32))>>2)]=dst}/** @suppress {duplicate } */var setTempRet0=val=>__emscripten_tempret_set(val);var __mktime_js=function(tmPtr){var ret=(()=>{var date=new Date(HEAP32[(((tmPtr)+(20))>>2)]+1900,HEAP32[(((tmPtr)+(16))>>2)],HEAP32[(((tmPtr)+(12))>>2)],HEAP32[(((tmPtr)+(8))>>2)],HEAP32[(((tmPtr)+(4))>>2)],HEAP32[((tmPtr)>>2)],0);// There's an ambiguous hour when the time goes back; the tm_isdst field is
// used to disambiguate it.  Date() basically guesses, so we fix it up if it
// guessed wrong, or fill in tm_isdst with the guess if it's -1.
var dst=HEAP32[(((tmPtr)+(32))>>2)];var guessedOffset=date.getTimezoneOffset();var start=new Date(date.getFullYear(),0,1);var summerOffset=new Date(date.getFullYear(),6,1).getTimezoneOffset();var winterOffset=start.getTimezoneOffset();var dstOffset=Math.min(winterOffset,summerOffset);// DST is in December in South
if(dst<0){// Attention: some regions don't have DST at all.
HEAP32[(((tmPtr)+(32))>>2)]=Number(summerOffset!=winterOffset&&dstOffset==guessedOffset)}else if((dst>0)!=(dstOffset==guessedOffset)){var nonDstOffset=Math.max(winterOffset,summerOffset);var trueOffset=dst>0?dstOffset:nonDstOffset;// Don't try setMinutes(date.getMinutes() + ...) -- it's messed up.
date.setTime(date.getTime()+(trueOffset-guessedOffset)*6e4)}HEAP32[(((tmPtr)+(24))>>2)]=date.getDay();var yday=ydayFromDate(date)|0;HEAP32[(((tmPtr)+(28))>>2)]=yday;// To match expected behavior, update fields from date
HEAP32[((tmPtr)>>2)]=date.getSeconds();HEAP32[(((tmPtr)+(4))>>2)]=date.getMinutes();HEAP32[(((tmPtr)+(8))>>2)]=date.getHours();HEAP32[(((tmPtr)+(12))>>2)]=date.getDate();HEAP32[(((tmPtr)+(16))>>2)]=date.getMonth();HEAP32[(((tmPtr)+(20))>>2)]=date.getYear();var timeMs=date.getTime();if(isNaN(timeMs)){return-1}// Return time in microseconds
return timeMs/1e3})();return(setTempRet0((tempDouble=ret,(+(Math.abs(tempDouble)))>=1?(tempDouble>0?(+(Math.floor((tempDouble)/4294967296)))>>>0:(~~((+(Math.ceil((tempDouble-+(((~~(tempDouble)))>>>0))/4294967296)))))>>>0):0)),ret>>>0)};function __mmap_js(len,prot,flags,fd,offset_low,offset_high,allocated,addr){var offset=convertI32PairToI53Checked(offset_low,offset_high);try{if(isNaN(offset))return 61;var stream=SYSCALLS.getStreamFromFD(fd);var res=FS.mmap(stream,len,offset,prot,flags);var ptr=res.ptr;HEAP32[((allocated)>>2)]=res.allocated;HEAPU32[((addr)>>2)]=ptr;return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}function __munmap_js(addr,len,prot,flags,fd,offset_low,offset_high){var offset=convertI32PairToI53Checked(offset_low,offset_high);try{var stream=SYSCALLS.getStreamFromFD(fd);if(prot&2){SYSCALLS.doMsync(addr,stream,len,flags,offset)}}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return-e.errno}}var __tzset_js=(timezone,daylight,std_name,dst_name)=>{// TODO: Use (malleable) environment variables instead of system settings.
var currentYear=(new Date).getFullYear();var winter=new Date(currentYear,0,1);var summer=new Date(currentYear,6,1);var winterOffset=winter.getTimezoneOffset();var summerOffset=summer.getTimezoneOffset();// Local standard timezone offset. Local standard time is not adjusted for
// daylight savings.  This code uses the fact that getTimezoneOffset returns
// a greater value during Standard Time versus Daylight Saving Time (DST).
// Thus it determines the expected output during Standard Time, and it
// compares whether the output of the given date the same (Standard) or less
// (DST).
var stdTimezoneOffset=Math.max(winterOffset,summerOffset);// timezone is specified as seconds west of UTC ("The external variable
// `timezone` shall be set to the difference, in seconds, between
// Coordinated Universal Time (UTC) and local standard time."), the same
// as returned by stdTimezoneOffset.
// See http://pubs.opengroup.org/onlinepubs/009695399/functions/tzset.html
HEAPU32[((timezone)>>2)]=stdTimezoneOffset*60;HEAP32[((daylight)>>2)]=Number(winterOffset!=summerOffset);var extractZone=timezoneOffset=>{// Why inverse sign?
// Read here https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Date/getTimezoneOffset
var sign=timezoneOffset>=0?"-":"+";var absOffset=Math.abs(timezoneOffset);var hours=String(Math.floor(absOffset/60)).padStart(2,"0");var minutes=String(absOffset%60).padStart(2,"0");return`UTC${sign}${hours}${minutes}`};var winterName=extractZone(winterOffset);var summerName=extractZone(summerOffset);if(summerOffset<winterOffset){// Northern hemisphere
stringToUTF8(winterName,std_name,17);stringToUTF8(summerName,dst_name,17)}else{stringToUTF8(winterName,dst_name,17);stringToUTF8(summerName,std_name,17)}};var _emscripten_get_now=()=>performance.now();var _emscripten_date_now=()=>Date.now();var nowIsMonotonic=1;var checkWasiClock=clock_id=>clock_id>=0&&clock_id<=3;function _clock_time_get(clk_id,ignored_precision_low,ignored_precision_high,ptime){var ignored_precision=convertI32PairToI53Checked(ignored_precision_low,ignored_precision_high);if(!checkWasiClock(clk_id)){return 28}var now;// all wasi clocks but realtime are monotonic
if(clk_id===0){now=_emscripten_date_now()}else if(nowIsMonotonic){now=_emscripten_get_now()}else{return 52}// "now" is in ms, and wasi times are in ns.
var nsec=Math.round(now*1e3*1e3);(tempI64=[nsec>>>0,(tempDouble=nsec,(+(Math.abs(tempDouble)))>=1?(tempDouble>0?(+(Math.floor((tempDouble)/4294967296)))>>>0:(~~((+(Math.ceil((tempDouble-+(((~~(tempDouble)))>>>0))/4294967296)))))>>>0):0)],HEAP32[((ptime)>>2)]=tempI64[0],HEAP32[(((ptime)+(4))>>2)]=tempI64[1]);return 0}var readEmAsmArgsArray=[];var readEmAsmArgs=(sigPtr,buf)=>{readEmAsmArgsArray.length=0;var ch;// Most arguments are i32s, so shift the buffer pointer so it is a plain
// index into HEAP32.
while(ch=HEAPU8[sigPtr++]){// Floats are always passed as doubles, so all types except for 'i'
// are 8 bytes and require alignment.
var wide=(ch!=105);wide&=(ch!=112);buf+=wide&&(buf%8)?4:0;readEmAsmArgsArray.push(// Special case for pointers under wasm64 or CAN_ADDRESS_2GB mode.
ch==112?HEAPU32[((buf)>>2)]:ch==105?HEAP32[((buf)>>2)]:HEAPF64[((buf)>>3)]);buf+=wide?8:4}return readEmAsmArgsArray};var runEmAsmFunction=(code,sigPtr,argbuf)=>{var args=readEmAsmArgs(sigPtr,argbuf);return ASM_CONSTS[code](...args)};var _emscripten_asm_const_int=(code,sigPtr,argbuf)=>runEmAsmFunction(code,sigPtr,argbuf);var _emscripten_asm_const_ptr=(code,sigPtr,argbuf)=>runEmAsmFunction(code,sigPtr,argbuf);var _emscripten_errn=(str,len)=>err(UTF8ToString(str,len));var getHeapMax=()=>// Stay one Wasm page short of 4GB: while e.g. Chrome is able to allocate
// full 4GB Wasm memories, the size will wrap back to 0 bytes in Wasm side
// for any code that deals with heap sizes, which would require special
// casing all heap size related code to treat 0 specially.
536870912;var _emscripten_get_heap_max=()=>getHeapMax();var _emscripten_has_asyncify=()=>0;var _emscripten_pc_get_function=pc=>{abort("Cannot use emscripten_pc_get_function without -sUSE_OFFSET_CONVERTER");return 0};var growMemory=size=>{var b=wasmMemory.buffer;var pages=((size-b.byteLength+65535)/65536)|0;try{// round size grow request up to wasm page size (fixed 64KB per spec)
wasmMemory.grow(pages);// .grow() takes a delta compared to the previous size
updateMemoryViews();return 1}catch(e){}};var _emscripten_resize_heap=requestedSize=>{var oldSize=HEAPU8.length;// With CAN_ADDRESS_2GB or MEMORY64, pointers are already unsigned.
requestedSize>>>=0;// With multithreaded builds, races can happen (another thread might increase the size
// in between), so return a failure, and let the caller retry.
// Memory resize rules:
// 1.  Always increase heap size to at least the requested size, rounded up
//     to next page multiple.
// 2a. If MEMORY_GROWTH_LINEAR_STEP == -1, excessively resize the heap
//     geometrically: increase the heap size according to
//     MEMORY_GROWTH_GEOMETRIC_STEP factor (default +20%), At most
//     overreserve by MEMORY_GROWTH_GEOMETRIC_CAP bytes (default 96MB).
// 2b. If MEMORY_GROWTH_LINEAR_STEP != -1, excessively resize the heap
//     linearly: increase the heap size by at least
//     MEMORY_GROWTH_LINEAR_STEP bytes.
// 3.  Max size for the heap is capped at 2048MB-WASM_PAGE_SIZE, or by
//     MAXIMUM_MEMORY, or by ASAN limit, depending on which is smallest
// 4.  If we were unable to allocate as much memory, it may be due to
//     over-eager decision to excessively reserve due to (3) above.
//     Hence if an allocation fails, cut down on the amount of excess
//     growth, in an attempt to succeed to perform a smaller allocation.
// A limit is set for how much we can grow. We should not exceed that
// (the wasm binary specifies it, so if we tried, we'd fail anyhow).
var maxHeapSize=getHeapMax();if(requestedSize>maxHeapSize){return false}// Loop through potential heap size increases. If we attempt a too eager
// reservation that fails, cut down on the attempted size and reserve a
// smaller bump instead. (max 3 times, chosen somewhat arbitrarily)
for(var cutDown=1;cutDown<=4;cutDown*=2){var overGrownHeapSize=oldSize+16777216/cutDown;// ensure linear growth
var newSize=Math.min(maxHeapSize,alignMemory(Math.max(requestedSize,overGrownHeapSize),65536));var replacement=growMemory(newSize);if(replacement){return true}}return false};/** @returns {number} */var convertFrameToPC=frame=>{abort("Cannot use convertFrameToPC (needed by __builtin_return_address) without -sUSE_OFFSET_CONVERTER");// return 0 if we can't find any
return 0};var UNWIND_CACHE={};var saveInUnwindCache=callstack=>{callstack.forEach(frame=>{var pc=convertFrameToPC(frame);if(pc){UNWIND_CACHE[pc]=frame}})};var jsStackTrace=()=>(new Error).stack.toString();var _emscripten_stack_snapshot=()=>{var callstack=jsStackTrace().split("\n");if(callstack[0]=="Error"){callstack.shift()}saveInUnwindCache(callstack);// Caches the stack snapshot so that emscripten_stack_unwind_buffer() can
// unwind from this spot.
UNWIND_CACHE.last_addr=convertFrameToPC(callstack[3]);UNWIND_CACHE.last_stack=callstack;return UNWIND_CACHE.last_addr};var _emscripten_stack_unwind_buffer=(addr,buffer,count)=>{var stack;if(UNWIND_CACHE.last_addr==addr){stack=UNWIND_CACHE.last_stack}else{stack=jsStackTrace().split("\n");if(stack[0]=="Error"){stack.shift()}saveInUnwindCache(stack)}var offset=3;while(stack[offset]&&convertFrameToPC(stack[offset])!=addr){++offset}for(var i=0;i<count&&stack[i+offset];++i){HEAP32[(((buffer)+(i*4))>>2)]=convertFrameToPC(stack[i+offset])}return i};var GLctx;var webgl_enable_ANGLE_instanced_arrays=ctx=>{// Extension available in WebGL 1 from Firefox 26 and Google Chrome 30 onwards. Core feature in WebGL 2.
var ext=ctx.getExtension("ANGLE_instanced_arrays");// Because this extension is a core function in WebGL 2, assign the extension entry points in place of
// where the core functions will reside in WebGL 2. This way the calling code can call these without
// having to dynamically branch depending if running against WebGL 1 or WebGL 2.
if(ext){ctx["vertexAttribDivisor"]=(index,divisor)=>ext["vertexAttribDivisorANGLE"](index,divisor);ctx["drawArraysInstanced"]=(mode,first,count,primcount)=>ext["drawArraysInstancedANGLE"](mode,first,count,primcount);ctx["drawElementsInstanced"]=(mode,count,type,indices,primcount)=>ext["drawElementsInstancedANGLE"](mode,count,type,indices,primcount);return 1}};var webgl_enable_OES_vertex_array_object=ctx=>{// Extension available in WebGL 1 from Firefox 25 and WebKit 536.28/desktop Safari 6.0.3 onwards. Core feature in WebGL 2.
var ext=ctx.getExtension("OES_vertex_array_object");if(ext){ctx["createVertexArray"]=()=>ext["createVertexArrayOES"]();ctx["deleteVertexArray"]=vao=>ext["deleteVertexArrayOES"](vao);ctx["bindVertexArray"]=vao=>ext["bindVertexArrayOES"](vao);ctx["isVertexArray"]=vao=>ext["isVertexArrayOES"](vao);return 1}};var webgl_enable_WEBGL_draw_buffers=ctx=>{// Extension available in WebGL 1 from Firefox 28 onwards. Core feature in WebGL 2.
var ext=ctx.getExtension("WEBGL_draw_buffers");if(ext){ctx["drawBuffers"]=(n,bufs)=>ext["drawBuffersWEBGL"](n,bufs);return 1}};var webgl_enable_WEBGL_draw_instanced_base_vertex_base_instance=ctx=>// Closure is expected to be allowed to minify the '.dibvbi' property, so not accessing it quoted.
!!(ctx.dibvbi=ctx.getExtension("WEBGL_draw_instanced_base_vertex_base_instance"));var webgl_enable_WEBGL_multi_draw_instanced_base_vertex_base_instance=ctx=>!!(ctx.mdibvbi=ctx.getExtension("WEBGL_multi_draw_instanced_base_vertex_base_instance"));var webgl_enable_EXT_polygon_offset_clamp=ctx=>!!(ctx.extPolygonOffsetClamp=ctx.getExtension("EXT_polygon_offset_clamp"));var webgl_enable_EXT_clip_control=ctx=>!!(ctx.extClipControl=ctx.getExtension("EXT_clip_control"));var webgl_enable_WEBGL_polygon_mode=ctx=>!!(ctx.webglPolygonMode=ctx.getExtension("WEBGL_polygon_mode"));var webgl_enable_WEBGL_multi_draw=ctx=>// Closure is expected to be allowed to minify the '.multiDrawWebgl' property, so not accessing it quoted.
!!(ctx.multiDrawWebgl=ctx.getExtension("WEBGL_multi_draw"));var getEmscriptenSupportedExtensions=ctx=>{// Restrict the list of advertised extensions to those that we actually
// support.
var supportedExtensions=[// WebGL 1 extensions
"ANGLE_instanced_arrays","EXT_blend_minmax","EXT_disjoint_timer_query","EXT_frag_depth","EXT_shader_texture_lod","EXT_sRGB","OES_element_index_uint","OES_fbo_render_mipmap","OES_standard_derivatives","OES_texture_float","OES_texture_half_float","OES_texture_half_float_linear","OES_vertex_array_object","WEBGL_color_buffer_float","WEBGL_depth_texture","WEBGL_draw_buffers",// WebGL 2 extensions
"EXT_color_buffer_float","EXT_conservative_depth","EXT_disjoint_timer_query_webgl2","EXT_texture_norm16","NV_shader_noperspective_interpolation","WEBGL_clip_cull_distance",// WebGL 1 and WebGL 2 extensions
"EXT_clip_control","EXT_color_buffer_half_float","EXT_depth_clamp","EXT_float_blend","EXT_polygon_offset_clamp","EXT_texture_compression_bptc","EXT_texture_compression_rgtc","EXT_texture_filter_anisotropic","KHR_parallel_shader_compile","OES_texture_float_linear","WEBGL_blend_func_extended","WEBGL_compressed_texture_astc","WEBGL_compressed_texture_etc","WEBGL_compressed_texture_etc1","WEBGL_compressed_texture_s3tc","WEBGL_compressed_texture_s3tc_srgb","WEBGL_debug_renderer_info","WEBGL_debug_shaders","WEBGL_lose_context","WEBGL_multi_draw","WEBGL_polygon_mode"];// .getSupportedExtensions() can return null if context is lost, so coerce to empty array.
return(ctx.getSupportedExtensions()||[]).filter(ext=>supportedExtensions.includes(ext))};var registerPreMainLoop=f=>{// Does nothing unless $MainLoop is included/used.
typeof MainLoop!="undefined"&&MainLoop.preMainLoop.push(f)};var GL={counter:1,buffers:[],mappedBuffers:{},programs:[],framebuffers:[],renderbuffers:[],textures:[],shaders:[],vaos:[],contexts:[],offscreenCanvases:{},queries:[],samplers:[],transformFeedbacks:[],syncs:[],byteSizeByTypeRoot:5120,byteSizeByType:[1,1,2,2,4,4,4,2,3,4,8],stringCache:{},stringiCache:{},unpackAlignment:4,unpackRowLength:0,recordError:errorCode=>{if(!GL.lastError){GL.lastError=errorCode}},getNewId:table=>{var ret=GL.counter++;for(var i=table.length;i<ret;i++){table[i]=null}// Skip over any non-null elements that might have been created by
// glBindBuffer.
while(table[ret]){ret=GL.counter++}return ret},genObject:(n,buffers,createFunction,objectTable)=>{for(var i=0;i<n;i++){var buffer=GLctx[createFunction]();var id=buffer&&GL.getNewId(objectTable);if(buffer){buffer.name=id;objectTable[id]=buffer}else{GL.recordError(1282)}HEAP32[(((buffers)+(i*4))>>2)]=id}},MAX_TEMP_BUFFER_SIZE:2097152,numTempVertexBuffersPerSize:64,log2ceilLookup:i=>32-Math.clz32(i===0?0:i-1),generateTempBuffers:(quads,context)=>{var largestIndex=GL.log2ceilLookup(GL.MAX_TEMP_BUFFER_SIZE);context.tempVertexBufferCounters1=[];context.tempVertexBufferCounters2=[];context.tempVertexBufferCounters1.length=context.tempVertexBufferCounters2.length=largestIndex+1;context.tempVertexBuffers1=[];context.tempVertexBuffers2=[];context.tempVertexBuffers1.length=context.tempVertexBuffers2.length=largestIndex+1;context.tempIndexBuffers=[];context.tempIndexBuffers.length=largestIndex+1;for(var i=0;i<=largestIndex;++i){context.tempIndexBuffers[i]=null;// Created on-demand
context.tempVertexBufferCounters1[i]=context.tempVertexBufferCounters2[i]=0;var ringbufferLength=GL.numTempVertexBuffersPerSize;context.tempVertexBuffers1[i]=[];context.tempVertexBuffers2[i]=[];var ringbuffer1=context.tempVertexBuffers1[i];var ringbuffer2=context.tempVertexBuffers2[i];ringbuffer1.length=ringbuffer2.length=ringbufferLength;for(var j=0;j<ringbufferLength;++j){ringbuffer1[j]=ringbuffer2[j]=null}}if(quads){// GL_QUAD indexes can be precalculated
context.tempQuadIndexBuffer=GLctx.createBuffer();context.GLctx.bindBuffer(34963,context.tempQuadIndexBuffer);var numIndexes=GL.MAX_TEMP_BUFFER_SIZE>>1;var quadIndexes=new Uint16Array(numIndexes);var i=0,v=0;while(1){quadIndexes[i++]=v;if(i>=numIndexes)break;quadIndexes[i++]=v+1;if(i>=numIndexes)break;quadIndexes[i++]=v+2;if(i>=numIndexes)break;quadIndexes[i++]=v;if(i>=numIndexes)break;quadIndexes[i++]=v+2;if(i>=numIndexes)break;quadIndexes[i++]=v+3;if(i>=numIndexes)break;v+=4}context.GLctx.bufferData(34963,quadIndexes,35044);context.GLctx.bindBuffer(34963,null)}},getTempVertexBuffer:sizeBytes=>{var idx=GL.log2ceilLookup(sizeBytes);var ringbuffer=GL.currentContext.tempVertexBuffers1[idx];var nextFreeBufferIndex=GL.currentContext.tempVertexBufferCounters1[idx];GL.currentContext.tempVertexBufferCounters1[idx]=(GL.currentContext.tempVertexBufferCounters1[idx]+1)&(GL.numTempVertexBuffersPerSize-1);var vbo=ringbuffer[nextFreeBufferIndex];if(vbo){return vbo}var prevVBO=GLctx.getParameter(34964);ringbuffer[nextFreeBufferIndex]=GLctx.createBuffer();GLctx.bindBuffer(34962,ringbuffer[nextFreeBufferIndex]);GLctx.bufferData(34962,1<<idx,35048);GLctx.bindBuffer(34962,prevVBO);return ringbuffer[nextFreeBufferIndex]},getTempIndexBuffer:sizeBytes=>{var idx=GL.log2ceilLookup(sizeBytes);var ibo=GL.currentContext.tempIndexBuffers[idx];if(ibo){return ibo}var prevIBO=GLctx.getParameter(34965);GL.currentContext.tempIndexBuffers[idx]=GLctx.createBuffer();GLctx.bindBuffer(34963,GL.currentContext.tempIndexBuffers[idx]);GLctx.bufferData(34963,1<<idx,35048);GLctx.bindBuffer(34963,prevIBO);return GL.currentContext.tempIndexBuffers[idx]},newRenderingFrameStarted:()=>{if(!GL.currentContext){return}var vb=GL.currentContext.tempVertexBuffers1;GL.currentContext.tempVertexBuffers1=GL.currentContext.tempVertexBuffers2;GL.currentContext.tempVertexBuffers2=vb;vb=GL.currentContext.tempVertexBufferCounters1;GL.currentContext.tempVertexBufferCounters1=GL.currentContext.tempVertexBufferCounters2;GL.currentContext.tempVertexBufferCounters2=vb;var largestIndex=GL.log2ceilLookup(GL.MAX_TEMP_BUFFER_SIZE);for(var i=0;i<=largestIndex;++i){GL.currentContext.tempVertexBufferCounters1[i]=0}},getSource:(shader,count,string,length)=>{var source="";for(var i=0;i<count;++i){var len=length?HEAPU32[(((length)+(i*4))>>2)]:undefined;source+=UTF8ToString(HEAPU32[(((string)+(i*4))>>2)],len)}return source},calcBufLength:(size,type,stride,count)=>{if(stride>0){return count*stride}var typeSize=GL.byteSizeByType[type-GL.byteSizeByTypeRoot];return size*typeSize*count},usedTempBuffers:[],preDrawHandleClientVertexAttribBindings:count=>{GL.resetBufferBinding=false;// TODO: initial pass to detect ranges we need to upload, might not need
// an upload per attrib
for(var i=0;i<GL.currentContext.maxVertexAttribs;++i){var cb=GL.currentContext.clientBuffers[i];if(!cb.clientside||!cb.enabled)continue;GL.resetBufferBinding=true;var size=GL.calcBufLength(cb.size,cb.type,cb.stride,count);var buf=GL.getTempVertexBuffer(size);GLctx.bindBuffer(34962,buf);GLctx.bufferSubData(34962,0,HEAPU8.subarray(cb.ptr,cb.ptr+size));cb.vertexAttribPointerAdaptor.call(GLctx,i,cb.size,cb.type,cb.normalized,cb.stride,0)}},postDrawHandleClientVertexAttribBindings:()=>{if(GL.resetBufferBinding){GLctx.bindBuffer(34962,GL.buffers[GLctx.currentArrayBufferBinding])}},createContext:(/** @type {HTMLCanvasElement} */canvas,webGLContextAttributes)=>{// If WebGL context has already been preinitialized for the page on the JS
// side, reuse that context instead. This is useful for example when the
// main page precompiles shaders for the application, in which case the
// WebGL context is created already before any Emscripten compiled code
// has been downloaded.
if(Module["preinitializedWebGLContext"]){var ctx=Module["preinitializedWebGLContext"];// The ctx object may not be of a known class (e.g. it may be a debug
// wrapper), so we ask it for its version rather than use instanceof.
webGLContextAttributes.majorVersion=Number(ctx.getParameter(ctx.VERSION).match(/^WebGL (\d+).\d+/)[1])}else{// BUG: Workaround Safari WebGL issue: After successfully acquiring WebGL
// context on a canvas, calling .getContext() will always return that
// context independent of which 'webgl' or 'webgl2'
// context version was passed. See:
//   https://bugs.webkit.org/show_bug.cgi?id=222758
// and:
//   https://github.com/emscripten-core/emscripten/issues/13295.
// TODO: Once the bug is fixed and shipped in Safari, adjust the Safari
// version field in above check.
if(!canvas.getContextSafariWebGL2Fixed){canvas.getContextSafariWebGL2Fixed=canvas.getContext;/** @type {function(this:HTMLCanvasElement, string, (Object|null)=): (Object|null)} */function fixedGetContext(ver,attrs){var gl=canvas.getContextSafariWebGL2Fixed(ver,attrs);return((ver=="webgl")==(gl instanceof WebGLRenderingContext))?gl:null}canvas.getContext=fixedGetContext}var ctx=(webGLContextAttributes.majorVersion>1)?canvas.getContext("webgl2",webGLContextAttributes):canvas.getContext("webgl",webGLContextAttributes)}if(!ctx)return 0;var handle=GL.registerContext(ctx,webGLContextAttributes);return handle},registerContext:(ctx,webGLContextAttributes)=>{// without pthreads a context is just an integer ID
var handle=GL.getNewId(GL.contexts);var context={handle,attributes:webGLContextAttributes,version:webGLContextAttributes.majorVersion,GLctx:ctx};// Store the created context object so that we can access the context
// given a canvas without having to pass the parameters again.
if(ctx.canvas)ctx.canvas.GLctxObject=context;GL.contexts[handle]=context;if(typeof webGLContextAttributes.enableExtensionsByDefault=="undefined"||webGLContextAttributes.enableExtensionsByDefault){GL.initExtensions(context)}context.maxVertexAttribs=context.GLctx.getParameter(34921);context.clientBuffers=[];for(var i=0;i<context.maxVertexAttribs;i++){context.clientBuffers[i]={enabled:false,clientside:false,size:0,type:0,normalized:0,stride:0,ptr:0,vertexAttribPointerAdaptor:null}}GL.generateTempBuffers(false,context);return handle},makeContextCurrent:contextHandle=>{// Active Emscripten GL layer context object.
GL.currentContext=GL.contexts[contextHandle];// Active WebGL context object.
Module["ctx"]=GLctx=GL.currentContext?.GLctx;return!(contextHandle&&!GLctx)},getContext:contextHandle=>GL.contexts[contextHandle],deleteContext:contextHandle=>{if(GL.currentContext===GL.contexts[contextHandle]){GL.currentContext=null}if(typeof JSEvents=="object"){// Release all JS event handlers on the DOM element that the GL context is
// associated with since the context is now deleted.
JSEvents.removeAllHandlersOnTarget(GL.contexts[contextHandle].GLctx.canvas)}// Make sure the canvas object no longer refers to the context object so
// there are no GC surprises.
if(GL.contexts[contextHandle]?.GLctx.canvas){GL.contexts[contextHandle].GLctx.canvas.GLctxObject=undefined}GL.contexts[contextHandle]=null},initExtensions:context=>{// If this function is called without a specific context object, init the
// extensions of the currently active context.
context||=GL.currentContext;if(context.initExtensionsDone)return;context.initExtensionsDone=true;var GLctx=context.GLctx;// Detect the presence of a few extensions manually, ction GL interop
// layer itself will need to know if they exist.
// Extensions that are available in both WebGL 1 and WebGL 2
webgl_enable_WEBGL_multi_draw(GLctx);webgl_enable_EXT_polygon_offset_clamp(GLctx);webgl_enable_EXT_clip_control(GLctx);webgl_enable_WEBGL_polygon_mode(GLctx);// Extensions that are only available in WebGL 1 (the calls will be no-ops
// if called on a WebGL 2 context active)
webgl_enable_ANGLE_instanced_arrays(GLctx);webgl_enable_OES_vertex_array_object(GLctx);webgl_enable_WEBGL_draw_buffers(GLctx);// Extensions that are available from WebGL >= 2 (no-op if called on a WebGL 1 context active)
webgl_enable_WEBGL_draw_instanced_base_vertex_base_instance(GLctx);webgl_enable_WEBGL_multi_draw_instanced_base_vertex_base_instance(GLctx);// On WebGL 2, EXT_disjoint_timer_query is replaced with an alternative
// that's based on core APIs, and exposes only the queryCounterEXT()
// entrypoint.
if(context.version>=2){GLctx.disjointTimerQueryExt=GLctx.getExtension("EXT_disjoint_timer_query_webgl2")}// However, Firefox exposes the WebGL 1 version on WebGL 2 as well and
// thus we look for the WebGL 1 version again if the WebGL 2 version
// isn't present. https://bugzilla.mozilla.org/show_bug.cgi?id=1328882
if(context.version<2||!GLctx.disjointTimerQueryExt){GLctx.disjointTimerQueryExt=GLctx.getExtension("EXT_disjoint_timer_query")}getEmscriptenSupportedExtensions(GLctx).forEach(ext=>{// WEBGL_lose_context, WEBGL_debug_renderer_info and WEBGL_debug_shaders
// are not enabled by default.
if(!ext.includes("lose_context")&&!ext.includes("debug")){// Call .getExtension() to enable that extension permanently.
GLctx.getExtension(ext)}})}};var JSEvents={batteryEvent:0,gamepadEvent:0,keyEvent:0,mouseEvent:0,wheelEvent:0,uiEvent:0,focusEvent:0,deviceOrientationEvent:0,orientationChangeEvent:0,deviceMotionEvent:0,fullscreenChangeEvent:0,pointerlockChangeEvent:0,visibilityChangeEvent:0,touchEvent:0,memcpy(target,src,size){HEAP8.set(HEAP8.subarray(src,src+size),target)},removeAllEventListeners(){while(JSEvents.eventHandlers.length){JSEvents._removeHandler(JSEvents.eventHandlers.length-1)}JSEvents.deferredCalls=[]},inEventHandler:0,deferredCalls:[],deferCall(targetFunction,precedence,argsList){function arraysHaveEqualContent(arrA,arrB){if(arrA.length!=arrB.length)return false;for(var i in arrA){if(arrA[i]!=arrB[i])return false}return true}// Test if the given call was already queued, and if so, don't add it again.
for(var call of JSEvents.deferredCalls){if(call.targetFunction==targetFunction&&arraysHaveEqualContent(call.argsList,argsList)){return}}JSEvents.deferredCalls.push({targetFunction,precedence,argsList});JSEvents.deferredCalls.sort((x,y)=>x.precedence<y.precedence)},removeDeferredCalls(targetFunction){JSEvents.deferredCalls=JSEvents.deferredCalls.filter(call=>call.targetFunction!=targetFunction)},canPerformEventHandlerRequests(){if(navigator.userActivation){// Verify against transient activation status from UserActivation API
// whether it is possible to perform a request here without needing to defer. See
// https://developer.mozilla.org/en-US/docs/Web/Security/User_activation#transient_activation
// and https://caniuse.com/mdn-api_useractivation
// At the time of writing, Firefox does not support this API: https://bugzilla.mozilla.org/show_bug.cgi?id=1791079
return navigator.userActivation.isActive}return JSEvents.inEventHandler&&JSEvents.currentEventHandler.allowsDeferredCalls},runDeferredCalls(){if(!JSEvents.canPerformEventHandlerRequests()){return}var deferredCalls=JSEvents.deferredCalls;JSEvents.deferredCalls=[];for(var call of deferredCalls){call.targetFunction(...call.argsList)}},eventHandlers:[],removeAllHandlersOnTarget:(target,eventTypeString)=>{for(var i=0;i<JSEvents.eventHandlers.length;++i){if(JSEvents.eventHandlers[i].target==target&&(!eventTypeString||eventTypeString==JSEvents.eventHandlers[i].eventTypeString)){JSEvents._removeHandler(i--)}}},_removeHandler(i){var h=JSEvents.eventHandlers[i];h.target.removeEventListener(h.eventTypeString,h.eventListenerFunc,h.useCapture);JSEvents.eventHandlers.splice(i,1)},registerOrRemoveHandler(eventHandler){if(!eventHandler.target){return-4}if(eventHandler.callbackfunc){eventHandler.eventListenerFunc=function(event){// Increment nesting count for the event handler.
++JSEvents.inEventHandler;JSEvents.currentEventHandler=eventHandler;// Process any old deferred calls the user has placed.
JSEvents.runDeferredCalls();// Process the actual event, calls back to user C code handler.
eventHandler.handlerFunc(event);// Process any new deferred calls that were placed right now from this event handler.
JSEvents.runDeferredCalls();// Out of event handler - restore nesting count.
--JSEvents.inEventHandler};eventHandler.target.addEventListener(eventHandler.eventTypeString,eventHandler.eventListenerFunc,eventHandler.useCapture);JSEvents.eventHandlers.push(eventHandler)}else{for(var i=0;i<JSEvents.eventHandlers.length;++i){if(JSEvents.eventHandlers[i].target==eventHandler.target&&JSEvents.eventHandlers[i].eventTypeString==eventHandler.eventTypeString){JSEvents._removeHandler(i--)}}}return 0},getNodeNameForTarget(target){if(!target)return"";if(target==window)return"#window";if(target==screen)return"#screen";return target?.nodeName||""},fullscreenEnabled(){return document.fullscreenEnabled||document.webkitFullscreenEnabled}};var webglPowerPreferences=["default","low-power","high-performance"];/** @type {Object} */var specialHTMLTargets=[0,typeof document!="undefined"?document:0,typeof window!="undefined"?window:0];var findEventTarget=target=>{// The sensible "default" target varies between events, but use window as the default
// since DOM events mostly can default to that. Specific callback registrations
// override their own defaults.
if(!target)return window;if(typeof target=="number")target=specialHTMLTargets[target]||UTF8ToString(target);if(target==="#window")return window;else if(target==="#document")return document;else if(target==="#screen")return screen;else if(target==="#canvas")return Module["canvas"];else if(typeof target=="string")return(typeof document!="undefined")?document.getElementById(target):null;return target};var findCanvasEventTarget=target=>{if(typeof target=="number")target=UTF8ToString(target);if(!target||target==="#canvas"){if(typeof GL!="undefined"&&GL.offscreenCanvases["canvas"])return GL.offscreenCanvases["canvas"];// TODO: Remove this line, target '#canvas' should refer only to Module['canvas'], not to GL.offscreenCanvases['canvas'] - but need stricter tests to be able to remove this line.
return Module["canvas"]}if(typeof GL!="undefined"&&GL.offscreenCanvases[target])return GL.offscreenCanvases[target];return findEventTarget(target)};/** @suppress {duplicate } */var _emscripten_webgl_do_create_context=(target,attributes)=>{var attr32=((attributes)>>2);var powerPreference=HEAP32[attr32+(8>>2)];var contextAttributes={"alpha":!!HEAP8[attributes+0],"depth":!!HEAP8[attributes+1],"stencil":!!HEAP8[attributes+2],"antialias":!!HEAP8[attributes+3],"premultipliedAlpha":!!HEAP8[attributes+4],"preserveDrawingBuffer":!!HEAP8[attributes+5],"powerPreference":webglPowerPreferences[powerPreference],"failIfMajorPerformanceCaveat":!!HEAP8[attributes+12],// The following are not predefined WebGL context attributes in the WebGL specification, so the property names can be minified by Closure.
majorVersion:HEAP32[attr32+(16>>2)],minorVersion:HEAP32[attr32+(20>>2)],enableExtensionsByDefault:HEAP8[attributes+24],explicitSwapControl:HEAP8[attributes+25],proxyContextToMainThread:HEAP32[attr32+(28>>2)],renderViaOffscreenBackBuffer:HEAP8[attributes+32]};var canvas=findCanvasEventTarget(target);if(!canvas){return 0}if(contextAttributes.explicitSwapControl){return 0}var contextHandle=GL.createContext(canvas,contextAttributes);return contextHandle};var _emscripten_webgl_create_context=_emscripten_webgl_do_create_context;var _emscripten_webgl_destroy_context=contextHandle=>{if(GL.currentContext==contextHandle)GL.currentContext=0;GL.deleteContext(contextHandle)};var _emscripten_webgl_get_context_attributes=(c,a)=>{if(!a)return-5;c=GL.contexts[c];if(!c)return-3;var t=c.GLctx;if(!t)return-3;t=t.getContextAttributes();HEAP8[a]=t.alpha;HEAP8[(a)+(1)]=t.depth;HEAP8[(a)+(2)]=t.stencil;HEAP8[(a)+(3)]=t.antialias;HEAP8[(a)+(4)]=t.premultipliedAlpha;HEAP8[(a)+(5)]=t.preserveDrawingBuffer;var power=t["powerPreference"]&&webglPowerPreferences.indexOf(t["powerPreference"]);HEAP32[(((a)+(8))>>2)]=power;HEAP8[(a)+(12)]=t.failIfMajorPerformanceCaveat;HEAP32[(((a)+(16))>>2)]=c.version;HEAP32[(((a)+(20))>>2)]=0;HEAP8[(a)+(24)]=c.attributes.enableExtensionsByDefault;return 0};/** @suppress {duplicate } */var _emscripten_webgl_do_get_current_context=()=>GL.currentContext?GL.currentContext.handle:0;var _emscripten_webgl_get_current_context=_emscripten_webgl_do_get_current_context;var _emscripten_webgl_make_context_current=contextHandle=>{var success=GL.makeContextCurrent(contextHandle);return success?0:-5};var stackAlloc=sz=>__emscripten_stack_alloc(sz);var stringToUTF8OnStack=str=>{var size=lengthBytesUTF8(str)+1;var ret=stackAlloc(size);stringToUTF8(str,ret,size);return ret};var stringToNewUTF8=str=>{var size=lengthBytesUTF8(str)+1;var ret=_malloc(size);if(ret)stringToUTF8(str,ret,size);return ret};var WebGPU={Internals:{jsObjects:[],jsObjectInsert:(ptr,jsObject)=>{// TODO(crbug.com/422847728): If the bindings aren't built with the same
// linkopts as dependencies, i.e. in google3, the pointers can be signed
// ints and results in crashes, so force the pointers to be unsigned.
WebGPU.Internals.jsObjects[(ptr>>>=0)]=jsObject},bufferOnUnmaps:[],futures:[],futureInsert:(futureId,promise)=>{}},getJsObject:ptr=>{if(!ptr)return undefined;// TODO(crbug.com/422847728): If the bindings aren't built with the same
// linkopts as dependencies, i.e. in google3, the pointers can be signed
// ints and results in crashes, so force the pointers to be unsigned.
var key=(ptr>>>=0);return WebGPU.Internals.jsObjects[key]},importJsAdapter:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateAdapter(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsBindGroup:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateBindGroup(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsBindGroupLayout:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateBindGroupLayout(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsBuffer:(buffer,parentPtr=0)=>{// At the moment, we do not allow importing pending buffers.
assert(buffer.mapState!="pending");var mapState=buffer.mapState=="mapped"?3:1;var bufferPtr=_emwgpuCreateBuffer(parentPtr,mapState);WebGPU.Internals.jsObjectInsert(bufferPtr,buffer);if(buffer.mapState=="mapped"){WebGPU.Internals.bufferOnUnmaps[bufferPtr]=[]}return bufferPtr},importJsCommandBuffer:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateCommandBuffer(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsCommandEncoder:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateCommandEncoder(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsComputePassEncoder:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateComputePassEncoder(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsComputePipeline:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateComputePipeline(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsDevice:(device,parentPtr=0)=>{var queuePtr=_emwgpuCreateQueue(parentPtr);var devicePtr=_emwgpuCreateDevice(parentPtr,queuePtr);WebGPU.Internals.jsObjectInsert(queuePtr,device.queue);WebGPU.Internals.jsObjectInsert(devicePtr,device);return devicePtr},importJsPipelineLayout:(obj,parentPtr=0)=>{var ptr=_emwgpuCreatePipelineLayout(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsQuerySet:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateQuerySet(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsQueue:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateQueue(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsRenderBundle:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateRenderBundle(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsRenderBundleEncoder:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateRenderBundleEncoder(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsRenderPassEncoder:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateRenderPassEncoder(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsRenderPipeline:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateRenderPipeline(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsSampler:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateSampler(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsShaderModule:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateShaderModule(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsSurface:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateSurface(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsTexture:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateTexture(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},importJsTextureView:(obj,parentPtr=0)=>{var ptr=_emwgpuCreateTextureView(parentPtr);WebGPU.Internals.jsObjects[ptr]=obj;return ptr},errorCallback:(callback,type,message,userdata)=>{var sp=stackSave();var messagePtr=stringToUTF8OnStack(message);getWasmTableEntry(callback)(type,messagePtr,userdata);stackRestore(sp)},setStringView:(ptr,data,length)=>{HEAPU32[((ptr)>>2)]=data;HEAPU32[(((ptr)+(4))>>2)]=length},makeStringFromStringView:stringViewPtr=>{var ptr=HEAPU32[((stringViewPtr)>>2)];var length=HEAPU32[(((stringViewPtr)+(4))>>2)];// UTF8ToString stops at the first null terminator character in the
// string regardless of the length.
return UTF8ToString(ptr,length)},makeStringFromOptionalStringView:stringViewPtr=>{var ptr=HEAPU32[((stringViewPtr)>>2)];var length=HEAPU32[(((stringViewPtr)+(4))>>2)];// If we don't have a valid string pointer, just return undefined when
// optional.
if(!ptr){if(length===0){return""}return undefined}// UTF8ToString stops at the first null terminator character in the
// string regardless of the length.
return UTF8ToString(ptr,length)},makeColor:ptr=>({"r":HEAPF64[((ptr)>>3)],"g":HEAPF64[(((ptr)+(8))>>3)],"b":HEAPF64[(((ptr)+(16))>>3)],"a":HEAPF64[(((ptr)+(24))>>3)]}),makeExtent3D:ptr=>({"width":HEAPU32[((ptr)>>2)],"height":HEAPU32[(((ptr)+(4))>>2)],"depthOrArrayLayers":HEAPU32[(((ptr)+(8))>>2)]}),makeOrigin3D:ptr=>({"x":HEAPU32[((ptr)>>2)],"y":HEAPU32[(((ptr)+(4))>>2)],"z":HEAPU32[(((ptr)+(8))>>2)]}),makeTexelCopyTextureInfo:ptr=>({"texture":WebGPU.getJsObject(HEAPU32[((ptr)>>2)]),"mipLevel":HEAPU32[(((ptr)+(4))>>2)],"origin":WebGPU.makeOrigin3D(ptr+8),"aspect":WebGPU.TextureAspect[HEAPU32[(((ptr)+(20))>>2)]]}),makeTexelCopyBufferLayout:ptr=>{var bytesPerRow=HEAPU32[(((ptr)+(8))>>2)];var rowsPerImage=HEAPU32[(((ptr)+(12))>>2)];return{"offset":(HEAPU32[(((ptr+4))>>2)]*4294967296+HEAPU32[((ptr)>>2)]),"bytesPerRow":bytesPerRow===4294967295?undefined:bytesPerRow,"rowsPerImage":rowsPerImage===4294967295?undefined:rowsPerImage}},makeTexelCopyBufferInfo:ptr=>{var layoutPtr=ptr+0;var bufferCopyView=WebGPU.makeTexelCopyBufferLayout(layoutPtr);bufferCopyView["buffer"]=WebGPU.getJsObject(HEAPU32[(((ptr)+(16))>>2)]);return bufferCopyView},makePassTimestampWrites:ptr=>{if(ptr===0)return undefined;return{"querySet":WebGPU.getJsObject(HEAPU32[(((ptr)+(4))>>2)]),"beginningOfPassWriteIndex":HEAPU32[(((ptr)+(8))>>2)],"endOfPassWriteIndex":HEAPU32[(((ptr)+(12))>>2)]}},makePipelineConstants:(constantCount,constantsPtr)=>{if(!constantCount)return;var constants={};for(var i=0;i<constantCount;++i){var entryPtr=constantsPtr+24*i;var key=WebGPU.makeStringFromStringView(entryPtr+4);constants[key]=HEAPF64[(((entryPtr)+(16))>>3)]}return constants},makePipelineLayout:layoutPtr=>{if(!layoutPtr)return"auto";return WebGPU.getJsObject(layoutPtr)},makeComputeState:ptr=>{if(!ptr)return undefined;var desc={"module":WebGPU.getJsObject(HEAPU32[(((ptr)+(4))>>2)]),"constants":WebGPU.makePipelineConstants(HEAPU32[(((ptr)+(16))>>2)],HEAPU32[(((ptr)+(20))>>2)]),"entryPoint":WebGPU.makeStringFromOptionalStringView(ptr+8)};return desc},makeComputePipelineDesc:descriptor=>{var desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"layout":WebGPU.makePipelineLayout(HEAPU32[(((descriptor)+(12))>>2)]),"compute":WebGPU.makeComputeState(descriptor+16)};return desc},makeRenderPipelineDesc:descriptor=>{function makePrimitiveState(psPtr){if(!psPtr)return undefined;return{"topology":WebGPU.PrimitiveTopology[HEAPU32[(((psPtr)+(4))>>2)]],"stripIndexFormat":WebGPU.IndexFormat[HEAPU32[(((psPtr)+(8))>>2)]],"frontFace":WebGPU.FrontFace[HEAPU32[(((psPtr)+(12))>>2)]],"cullMode":WebGPU.CullMode[HEAPU32[(((psPtr)+(16))>>2)]],"unclippedDepth":!!(HEAPU32[(((psPtr)+(20))>>2)])}}function makeBlendComponent(bdPtr){if(!bdPtr)return undefined;return{"operation":WebGPU.BlendOperation[HEAPU32[((bdPtr)>>2)]],"srcFactor":WebGPU.BlendFactor[HEAPU32[(((bdPtr)+(4))>>2)]],"dstFactor":WebGPU.BlendFactor[HEAPU32[(((bdPtr)+(8))>>2)]]}}function makeBlendState(bsPtr){if(!bsPtr)return undefined;return{"alpha":makeBlendComponent(bsPtr+12),"color":makeBlendComponent(bsPtr+0)}}function makeColorState(csPtr){var formatInt=HEAPU32[(((csPtr)+(4))>>2)];return formatInt===0?undefined:{"format":WebGPU.TextureFormat[formatInt],"blend":makeBlendState(HEAPU32[(((csPtr)+(8))>>2)]),"writeMask":HEAPU32[(((csPtr)+(16))>>2)]}}function makeColorStates(count,csArrayPtr){var states=[];for(var i=0;i<count;++i){states.push(makeColorState(csArrayPtr+24*i))}return states}function makeStencilStateFace(ssfPtr){return{"compare":WebGPU.CompareFunction[HEAPU32[((ssfPtr)>>2)]],"failOp":WebGPU.StencilOperation[HEAPU32[(((ssfPtr)+(4))>>2)]],"depthFailOp":WebGPU.StencilOperation[HEAPU32[(((ssfPtr)+(8))>>2)]],"passOp":WebGPU.StencilOperation[HEAPU32[(((ssfPtr)+(12))>>2)]]}}function makeDepthStencilState(dssPtr){if(!dssPtr)return undefined;return{"format":WebGPU.TextureFormat[HEAPU32[(((dssPtr)+(4))>>2)]],"depthWriteEnabled":!!(HEAPU32[(((dssPtr)+(8))>>2)]),"depthCompare":WebGPU.CompareFunction[HEAPU32[(((dssPtr)+(12))>>2)]],"stencilFront":makeStencilStateFace(dssPtr+16),"stencilBack":makeStencilStateFace(dssPtr+32),"stencilReadMask":HEAPU32[(((dssPtr)+(48))>>2)],"stencilWriteMask":HEAPU32[(((dssPtr)+(52))>>2)],"depthBias":HEAP32[(((dssPtr)+(56))>>2)],"depthBiasSlopeScale":HEAPF32[(((dssPtr)+(60))>>2)],"depthBiasClamp":HEAPF32[(((dssPtr)+(64))>>2)]}}function makeVertexAttribute(vaPtr){return{"format":WebGPU.VertexFormat[HEAPU32[(((vaPtr)+(4))>>2)]],"offset":(HEAPU32[((((vaPtr+4))+(8))>>2)]*4294967296+HEAPU32[(((vaPtr)+(8))>>2)]),"shaderLocation":HEAPU32[(((vaPtr)+(16))>>2)]}}function makeVertexAttributes(count,vaArrayPtr){var vas=[];for(var i=0;i<count;++i){vas.push(makeVertexAttribute(vaArrayPtr+i*24))}return vas}function makeVertexBuffer(vbPtr){if(!vbPtr)return undefined;var stepModeInt=HEAPU32[(((vbPtr)+(4))>>2)];var attributeCountInt=HEAPU32[(((vbPtr)+(16))>>2)];if(stepModeInt===0&&attributeCountInt===0){return null}return{"arrayStride":(HEAPU32[((((vbPtr+4))+(8))>>2)]*4294967296+HEAPU32[(((vbPtr)+(8))>>2)]),"stepMode":WebGPU.VertexStepMode[stepModeInt],"attributes":makeVertexAttributes(attributeCountInt,HEAPU32[(((vbPtr)+(20))>>2)])}}function makeVertexBuffers(count,vbArrayPtr){if(!count)return undefined;var vbs=[];for(var i=0;i<count;++i){vbs.push(makeVertexBuffer(vbArrayPtr+i*24))}return vbs}function makeVertexState(viPtr){if(!viPtr)return undefined;var desc={"module":WebGPU.getJsObject(HEAPU32[(((viPtr)+(4))>>2)]),"constants":WebGPU.makePipelineConstants(HEAPU32[(((viPtr)+(16))>>2)],HEAPU32[(((viPtr)+(20))>>2)]),"buffers":makeVertexBuffers(HEAPU32[(((viPtr)+(24))>>2)],HEAPU32[(((viPtr)+(28))>>2)]),"entryPoint":WebGPU.makeStringFromOptionalStringView(viPtr+8)};return desc}function makeMultisampleState(msPtr){if(!msPtr)return undefined;return{"count":HEAPU32[(((msPtr)+(4))>>2)],"mask":HEAPU32[(((msPtr)+(8))>>2)],"alphaToCoverageEnabled":!!(HEAPU32[(((msPtr)+(12))>>2)])}}function makeFragmentState(fsPtr){if(!fsPtr)return undefined;var desc={"module":WebGPU.getJsObject(HEAPU32[(((fsPtr)+(4))>>2)]),"constants":WebGPU.makePipelineConstants(HEAPU32[(((fsPtr)+(16))>>2)],HEAPU32[(((fsPtr)+(20))>>2)]),"targets":makeColorStates(HEAPU32[(((fsPtr)+(24))>>2)],HEAPU32[(((fsPtr)+(28))>>2)]),"entryPoint":WebGPU.makeStringFromOptionalStringView(fsPtr+8)};return desc}var desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"layout":WebGPU.makePipelineLayout(HEAPU32[(((descriptor)+(12))>>2)]),"vertex":makeVertexState(descriptor+16),"primitive":makePrimitiveState(descriptor+48),"depthStencil":makeDepthStencilState(HEAPU32[(((descriptor)+(72))>>2)]),"multisample":makeMultisampleState(descriptor+76),"fragment":makeFragmentState(HEAPU32[(((descriptor)+(92))>>2)])};return desc},fillLimitStruct:(limits,limitsOutPtr)=>{function setLimitValueU32(name,limitOffset){var limitValue=limits[name];HEAP32[(((limitsOutPtr)+(limitOffset))>>2)]=limitValue}function setLimitValueU64(name,limitOffset){var limitValue=limits[name];(tempI64=[limitValue>>>0,(tempDouble=limitValue,(+(Math.abs(tempDouble)))>=1?(tempDouble>0?(+(Math.floor((tempDouble)/4294967296)))>>>0:(~~((+(Math.ceil((tempDouble-+(((~~(tempDouble)))>>>0))/4294967296)))))>>>0):0)],HEAP32[(((limitsOutPtr)+(limitOffset))>>2)]=tempI64[0],HEAP32[(((limitsOutPtr)+((limitOffset)+(4)))>>2)]=tempI64[1])}setLimitValueU32("maxTextureDimension1D",4);setLimitValueU32("maxTextureDimension2D",8);setLimitValueU32("maxTextureDimension3D",12);setLimitValueU32("maxTextureArrayLayers",16);setLimitValueU32("maxBindGroups",20);setLimitValueU32("maxBindGroupsPlusVertexBuffers",24);setLimitValueU32("maxBindingsPerBindGroup",28);setLimitValueU32("maxDynamicUniformBuffersPerPipelineLayout",32);setLimitValueU32("maxDynamicStorageBuffersPerPipelineLayout",36);setLimitValueU32("maxSampledTexturesPerShaderStage",40);setLimitValueU32("maxSamplersPerShaderStage",44);setLimitValueU32("maxStorageBuffersPerShaderStage",48);setLimitValueU32("maxStorageTexturesPerShaderStage",52);setLimitValueU32("maxUniformBuffersPerShaderStage",56);setLimitValueU32("minUniformBufferOffsetAlignment",80);setLimitValueU32("minStorageBufferOffsetAlignment",84);setLimitValueU64("maxUniformBufferBindingSize",64);setLimitValueU64("maxStorageBufferBindingSize",72);setLimitValueU32("maxVertexBuffers",88);setLimitValueU64("maxBufferSize",96);setLimitValueU32("maxVertexAttributes",104);setLimitValueU32("maxVertexBufferArrayStride",108);setLimitValueU32("maxInterStageShaderVariables",112);setLimitValueU32("maxColorAttachments",116);setLimitValueU32("maxColorAttachmentBytesPerSample",120);setLimitValueU32("maxComputeWorkgroupStorageSize",124);setLimitValueU32("maxComputeInvocationsPerWorkgroup",128);setLimitValueU32("maxComputeWorkgroupSizeX",132);setLimitValueU32("maxComputeWorkgroupSizeY",136);setLimitValueU32("maxComputeWorkgroupSizeZ",140);setLimitValueU32("maxComputeWorkgroupsPerDimension",144);// Non-standard. If this is undefined, it will correctly just cast to 0.
if(limits.maxImmediateSize!==undefined){setLimitValueU32("maxImmediateSize",148)}},fillAdapterInfoStruct:(info,infoStruct)=>{// Populate subgroup limits.
HEAP32[(((infoStruct)+(52))>>2)]=info.subgroupMinSize;HEAP32[(((infoStruct)+(56))>>2)]=info.subgroupMaxSize;// Append all the strings together to condense into a single malloc.
var strs=info.vendor+info.architecture+info.device+info.description;var strPtr=stringToNewUTF8(strs);var vendorLen=lengthBytesUTF8(info.vendor);WebGPU.setStringView(infoStruct+4,strPtr,vendorLen);strPtr+=vendorLen;var architectureLen=lengthBytesUTF8(info.architecture);WebGPU.setStringView(infoStruct+12,strPtr,architectureLen);strPtr+=architectureLen;var deviceLen=lengthBytesUTF8(info.device);WebGPU.setStringView(infoStruct+20,strPtr,deviceLen);strPtr+=deviceLen;var descriptionLen=lengthBytesUTF8(info.description);WebGPU.setStringView(infoStruct+28,strPtr,descriptionLen);strPtr+=descriptionLen;HEAP32[(((infoStruct)+(36))>>2)]=2;var adapterType=info.isFallbackAdapter?3:4;HEAP32[(((infoStruct)+(40))>>2)]=adapterType;HEAP32[(((infoStruct)+(44))>>2)]=0;HEAP32[(((infoStruct)+(48))>>2)]=0},AddressMode:[,"clamp-to-edge","repeat","mirror-repeat"],BlendFactor:[,"zero","one","src","one-minus-src","src-alpha","one-minus-src-alpha","dst","one-minus-dst","dst-alpha","one-minus-dst-alpha","src-alpha-saturated","constant","one-minus-constant","src1","one-minus-src1","src1alpha","one-minus-src1alpha"],BlendOperation:[,"add","subtract","reverse-subtract","min","max"],BufferBindingType:["binding-not-used",,"uniform","storage","read-only-storage"],BufferMapState:[,"unmapped","pending","mapped"],CompareFunction:[,"never","less","equal","less-equal","greater","not-equal","greater-equal","always"],CompilationInfoRequestStatus:[,"success","callback-cancelled"],CompositeAlphaMode:[,"opaque","premultiplied","unpremultiplied","inherit"],CullMode:[,"none","front","back"],ErrorFilter:[,"validation","out-of-memory","internal"],FeatureLevel:[,"compatibility","core"],FeatureName:{1:"core-features-and-limits",2:"depth-clip-control",3:"depth32float-stencil8",4:"texture-compression-bc",5:"texture-compression-bc-sliced-3d",6:"texture-compression-etc2",7:"texture-compression-astc",8:"texture-compression-astc-sliced-3d",9:"timestamp-query",10:"indirect-first-instance",11:"shader-f16",12:"rg11b10ufloat-renderable",13:"bgra8unorm-storage",14:"float32-filterable",15:"float32-blendable",16:"clip-distances",17:"dual-source-blending",18:"subgroups",19:"texture-formats-tier1",20:"texture-formats-tier2",327692:"chromium-experimental-unorm16-texture-formats",327693:"chromium-experimental-snorm16-texture-formats",327732:"chromium-experimental-multi-draw-indirect"},FilterMode:[,"nearest","linear"],FrontFace:[,"ccw","cw"],IndexFormat:[,"uint16","uint32"],InstanceFeatureName:[,"timed-wait-any","shader-source-spirv","multiple-devices-per-adapter"],LoadOp:[,"load","clear"],MipmapFilterMode:[,"nearest","linear"],OptionalBool:["false","true"],PowerPreference:[,"low-power","high-performance"],PredefinedColorSpace:[,"srgb","display-p3"],PrimitiveTopology:[,"point-list","line-list","line-strip","triangle-list","triangle-strip"],QueryType:[,"occlusion","timestamp"],SamplerBindingType:["binding-not-used",,"filtering","non-filtering","comparison"],Status:[,"success","error"],StencilOperation:[,"keep","zero","replace","invert","increment-clamp","decrement-clamp","increment-wrap","decrement-wrap"],StorageTextureAccess:["binding-not-used",,"write-only","read-only","read-write"],StoreOp:[,"store","discard"],SurfaceGetCurrentTextureStatus:[,"success-optimal","success-suboptimal","timeout","outdated","lost","error"],TextureAspect:[,"all","stencil-only","depth-only"],TextureDimension:[,"1d","2d","3d"],TextureFormat:[,"r8unorm","r8snorm","r8uint","r8sint","r16unorm","r16snorm","r16uint","r16sint","r16float","rg8unorm","rg8snorm","rg8uint","rg8sint","r32float","r32uint","r32sint","rg16unorm","rg16snorm","rg16uint","rg16sint","rg16float","rgba8unorm","rgba8unorm-srgb","rgba8snorm","rgba8uint","rgba8sint","bgra8unorm","bgra8unorm-srgb","rgb10a2uint","rgb10a2unorm","rg11b10ufloat","rgb9e5ufloat","rg32float","rg32uint","rg32sint","rgba16unorm","rgba16snorm","rgba16uint","rgba16sint","rgba16float","rgba32float","rgba32uint","rgba32sint","stencil8","depth16unorm","depth24plus","depth24plus-stencil8","depth32float","depth32float-stencil8","bc1-rgba-unorm","bc1-rgba-unorm-srgb","bc2-rgba-unorm","bc2-rgba-unorm-srgb","bc3-rgba-unorm","bc3-rgba-unorm-srgb","bc4-r-unorm","bc4-r-snorm","bc5-rg-unorm","bc5-rg-snorm","bc6h-rgb-ufloat","bc6h-rgb-float","bc7-rgba-unorm","bc7-rgba-unorm-srgb","etc2-rgb8unorm","etc2-rgb8unorm-srgb","etc2-rgb8a1unorm","etc2-rgb8a1unorm-srgb","etc2-rgba8unorm","etc2-rgba8unorm-srgb","eac-r11unorm","eac-r11snorm","eac-rg11unorm","eac-rg11snorm","astc-4x4-unorm","astc-4x4-unorm-srgb","astc-5x4-unorm","astc-5x4-unorm-srgb","astc-5x5-unorm","astc-5x5-unorm-srgb","astc-6x5-unorm","astc-6x5-unorm-srgb","astc-6x6-unorm","astc-6x6-unorm-srgb","astc-8x5-unorm","astc-8x5-unorm-srgb","astc-8x6-unorm","astc-8x6-unorm-srgb","astc-8x8-unorm","astc-8x8-unorm-srgb","astc-10x5-unorm","astc-10x5-unorm-srgb","astc-10x6-unorm","astc-10x6-unorm-srgb","astc-10x8-unorm","astc-10x8-unorm-srgb","astc-10x10-unorm","astc-10x10-unorm-srgb","astc-12x10-unorm","astc-12x10-unorm-srgb","astc-12x12-unorm","astc-12x12-unorm-srgb"],TextureSampleType:["binding-not-used",,"float","unfilterable-float","depth","sint","uint"],TextureViewDimension:[,"1d","2d","2d-array","cube","cube-array","3d"],ToneMappingMode:[,"standard","extended"],VertexFormat:[,"uint8","uint8x2","uint8x4","sint8","sint8x2","sint8x4","unorm8","unorm8x2","unorm8x4","snorm8","snorm8x2","snorm8x4","uint16","uint16x2","uint16x4","sint16","sint16x2","sint16x4","unorm16","unorm16x2","unorm16x4","snorm16","snorm16x2","snorm16x4","float16","float16x2","float16x4","float32","float32x2","float32x3","float32x4","uint32","uint32x2","uint32x3","uint32x4","sint32","sint32x2","sint32x3","sint32x4","unorm10-10-10-2","unorm8x4-bgra"],VertexStepMode:[,"vertex","instance"],WGSLLanguageFeatureName:[,"readonly_and_readwrite_storage_textures","packed_4x8_integer_dot_product","unrestricted_pointer_parameters","pointer_composite_access"]};var _emscripten_webgpu_get_device=()=>{if(WebGPU.preinitializedDeviceId===undefined){WebGPU.preinitializedDeviceId=WebGPU.importJsDevice(Module["preinitializedWebGPUDevice"]);// Some users depend on this keeping the device alive, so we add an
// additional reference when we first initialize it.
_wgpuDeviceAddRef(WebGPU.preinitializedDeviceId)}_wgpuDeviceAddRef(WebGPU.preinitializedDeviceId);return WebGPU.preinitializedDeviceId};var _emwgpuBufferDestroy=bufferPtr=>{var buffer=WebGPU.getJsObject(bufferPtr);var onUnmap=WebGPU.Internals.bufferOnUnmaps[bufferPtr];if(onUnmap){for(var i=0;i<onUnmap.length;++i){onUnmap[i]()}delete WebGPU.Internals.bufferOnUnmaps[bufferPtr]}buffer.destroy()};var warnOnce=text=>{warnOnce.shown||={};if(!warnOnce.shown[text]){warnOnce.shown[text]=1;err(text)}};var _emwgpuBufferGetMappedRange=(bufferPtr,offset,size)=>{var buffer=WebGPU.getJsObject(bufferPtr);if(size===0)warnOnce("getMappedRange size=0 no longer means WGPU_WHOLE_MAP_SIZE");if(size==-1)size=undefined;var mapped;try{mapped=buffer.getMappedRange(offset,size)}catch(ex){return 0}var data=_memalign(16,mapped.byteLength);HEAPU8.fill(0,data,mapped.byteLength);WebGPU.Internals.bufferOnUnmaps[bufferPtr].push(()=>{new Uint8Array(mapped).set(HEAPU8.subarray(data,data+mapped.byteLength));_free(data)});return data};var _emwgpuBufferUnmap=bufferPtr=>{var buffer=WebGPU.getJsObject(bufferPtr);var onUnmap=WebGPU.Internals.bufferOnUnmaps[bufferPtr];if(!onUnmap){// Already unmapped
return}for(var i=0;i<onUnmap.length;++i){onUnmap[i]()}delete WebGPU.Internals.bufferOnUnmaps[bufferPtr];buffer.unmap()};var _emwgpuDelete=ptr=>{delete WebGPU.Internals.jsObjects[ptr]};var _emwgpuDeviceCreateBuffer=(devicePtr,descriptor,bufferPtr)=>{var mappedAtCreation=!!(HEAPU32[(((descriptor)+(32))>>2)]);var desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"usage":HEAPU32[(((descriptor)+(16))>>2)],"size":(HEAPU32[((((descriptor+4))+(24))>>2)]*4294967296+HEAPU32[(((descriptor)+(24))>>2)]),"mappedAtCreation":mappedAtCreation};var device=WebGPU.getJsObject(devicePtr);var buffer;try{buffer=device.createBuffer(desc)}catch(ex){// The only exception should be RangeError if mapping at creation ran out of memory.
return false}WebGPU.Internals.jsObjectInsert(bufferPtr,buffer);if(mappedAtCreation){WebGPU.Internals.bufferOnUnmaps[bufferPtr]=[]}return true};var _emwgpuDeviceCreateComputePipelineAsync=function(devicePtr,futureId_low,futureId_high,descriptor,pipelinePtr){var futureId=convertI32PairToI53Checked(futureId_low,futureId_high);var desc=WebGPU.makeComputePipelineDesc(descriptor);var device=WebGPU.getJsObject(devicePtr);WebGPU.Internals.futureInsert(futureId,device.createComputePipelineAsync(desc).then(pipeline=>{WebGPU.Internals.jsObjectInsert(pipelinePtr,pipeline);_emwgpuOnCreateComputePipelineCompleted(futureId,1,pipelinePtr,0)},pipelineError=>{var sp=stackSave();var messagePtr=stringToUTF8OnStack(pipelineError.message);var status=pipelineError.reason==="validation"?3:pipelineError.reason==="internal"?4:0;_emwgpuOnCreateComputePipelineCompleted(futureId,status,pipelinePtr,messagePtr);stackRestore(sp)}))};var _emwgpuDeviceCreateRenderPipelineAsync=function(devicePtr,futureId_low,futureId_high,descriptor,pipelinePtr){var futureId=convertI32PairToI53Checked(futureId_low,futureId_high);var desc=WebGPU.makeRenderPipelineDesc(descriptor);var device=WebGPU.getJsObject(devicePtr);WebGPU.Internals.futureInsert(futureId,device.createRenderPipelineAsync(desc).then(pipeline=>{WebGPU.Internals.jsObjectInsert(pipelinePtr,pipeline);_emwgpuOnCreateRenderPipelineCompleted(futureId,1,pipelinePtr,0)},pipelineError=>{var sp=stackSave();var messagePtr=stringToUTF8OnStack(pipelineError.message);var status=pipelineError.reason==="validation"?3:pipelineError.reason==="internal"?4:0;_emwgpuOnCreateRenderPipelineCompleted(futureId,status,pipelinePtr,messagePtr);stackRestore(sp)}))};var _emwgpuDeviceCreateShaderModule=(devicePtr,descriptor,shaderModulePtr)=>{var nextInChainPtr=HEAPU32[((descriptor)>>2)];var sType=HEAPU32[(((nextInChainPtr)+(4))>>2)];var desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"code":""};switch(sType){case 2:{desc["code"]=WebGPU.makeStringFromStringView(nextInChainPtr+8);break}}var device=WebGPU.getJsObject(devicePtr);WebGPU.Internals.jsObjectInsert(shaderModulePtr,device.createShaderModule(desc))};var _emwgpuDeviceDestroy=devicePtr=>{const device=WebGPU.getJsObject(devicePtr);// Remove the onuncapturederror handler which holds a pointer to the WGPUDevice.
device.onuncapturederror=null;device.destroy()};var _emwgpuDevicePopErrorScope=function(devicePtr,futureId_low,futureId_high){var futureId=convertI32PairToI53Checked(futureId_low,futureId_high);var device=WebGPU.getJsObject(devicePtr);WebGPU.Internals.futureInsert(futureId,device.popErrorScope().then(gpuError=>{var type=5;if(!gpuError)type=1;else if(gpuError instanceof GPUValidationError)type=2;else if(gpuError instanceof GPUOutOfMemoryError)type=3;else if(gpuError instanceof GPUInternalError)type=4;var sp=stackSave();var messagePtr=gpuError?stringToUTF8OnStack(gpuError.message):0;_emwgpuOnPopErrorScopeCompleted(futureId,1,type,messagePtr);stackRestore(sp)},ex=>{var sp=stackSave();var messagePtr=stringToUTF8OnStack(ex.message);_emwgpuOnPopErrorScopeCompleted(futureId,1,5,messagePtr);stackRestore(sp)}))};var _emwgpuQueueOnSubmittedWorkDone=function(queuePtr,futureId_low,futureId_high){var futureId=convertI32PairToI53Checked(futureId_low,futureId_high);var queue=WebGPU.getJsObject(queuePtr);WebGPU.Internals.futureInsert(futureId,queue.onSubmittedWorkDone().then(()=>{_emwgpuOnWorkDoneCompleted(futureId,1)},()=>{// We could translate this into a status+message, but it's not supposed to ever happen.
abort("Unexpected failure in GPUQueue.onSubmittedWorkDone().")}))};var _emwgpuWaitAny=()=>{abort("TODO: Implement asyncify-free WaitAny for timeout=0")};var ENV={};var getExecutableName=()=>thisProgram||"./this.program";var getEnvStrings=()=>{if(!getEnvStrings.strings){// Default values.
// Browser language detection #8751
var lang=((typeof navigator=="object"&&navigator.languages&&navigator.languages[0])||"C").replace("-","_")+".UTF-8";var env={"USER":"web_user","LOGNAME":"web_user","PATH":"/","PWD":"/","HOME":"/home/web_user","LANG":lang,"_":getExecutableName()};// Apply the user-provided values, if any.
for(var x in ENV){// x is a key in ENV; if ENV[x] is undefined, that means it was
// explicitly set to be so. We allow user code to do that to
// force variables with default values to remain unset.
if(ENV[x]===undefined)delete env[x];else env[x]=ENV[x]}var strings=[];for(var x in env){strings.push(`${x}=${env[x]}`)}getEnvStrings.strings=strings}return getEnvStrings.strings};var stringToAscii=(str,buffer)=>{for(var i=0;i<str.length;++i){HEAP8[buffer++]=str.charCodeAt(i)}// Null-terminate the string
HEAP8[buffer]=0};var _environ_get=(__environ,environ_buf)=>{var bufSize=0;getEnvStrings().forEach((string,i)=>{var ptr=environ_buf+bufSize;HEAPU32[(((__environ)+(i*4))>>2)]=ptr;stringToAscii(string,ptr);bufSize+=string.length+1});return 0};var _environ_sizes_get=(penviron_count,penviron_buf_size)=>{var strings=getEnvStrings();HEAPU32[((penviron_count)>>2)]=strings.length;var bufSize=0;strings.forEach(string=>bufSize+=string.length+1);HEAPU32[((penviron_buf_size)>>2)]=bufSize;return 0};var runtimeKeepaliveCounter=0;var keepRuntimeAlive=()=>noExitRuntime||runtimeKeepaliveCounter>0;var _proc_exit=code=>{EXITSTATUS=code;if(!keepRuntimeAlive()){Module["onExit"]?.(code);ABORT=true}quit_(code,new ExitStatus(code))};/** @suppress {duplicate } */ /** @param {boolean|number=} implicit */var exitJS=(status,implicit)=>{EXITSTATUS=status;_proc_exit(status)};var _exit=exitJS;function _fd_close(fd){try{var stream=SYSCALLS.getStreamFromFD(fd);FS.close(stream);return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return e.errno}}/** @param {number=} offset */var doReadv=(stream,iov,iovcnt,offset)=>{var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAPU32[((iov)>>2)];var len=HEAPU32[(((iov)+(4))>>2)];iov+=8;var curr=FS.read(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len)break;// nothing more to read
if(typeof offset!="undefined"){offset+=curr}}return ret};function _fd_read(fd,iov,iovcnt,pnum){try{var stream=SYSCALLS.getStreamFromFD(fd);var num=doReadv(stream,iov,iovcnt);HEAPU32[((pnum)>>2)]=num;return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return e.errno}}function _fd_seek(fd,offset_low,offset_high,whence,newOffset){var offset=convertI32PairToI53Checked(offset_low,offset_high);try{if(isNaN(offset))return 61;var stream=SYSCALLS.getStreamFromFD(fd);FS.llseek(stream,offset,whence);(tempI64=[stream.position>>>0,(tempDouble=stream.position,(+(Math.abs(tempDouble)))>=1?(tempDouble>0?(+(Math.floor((tempDouble)/4294967296)))>>>0:(~~((+(Math.ceil((tempDouble-+(((~~(tempDouble)))>>>0))/4294967296)))))>>>0):0)],HEAP32[((newOffset)>>2)]=tempI64[0],HEAP32[(((newOffset)+(4))>>2)]=tempI64[1]);if(stream.getdents&&offset===0&&whence===0)stream.getdents=null;// reset readdir state
return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return e.errno}}/** @param {number=} offset */var doWritev=(stream,iov,iovcnt,offset)=>{var ret=0;for(var i=0;i<iovcnt;i++){var ptr=HEAPU32[((iov)>>2)];var len=HEAPU32[(((iov)+(4))>>2)];iov+=8;var curr=FS.write(stream,HEAP8,ptr,len,offset);if(curr<0)return-1;ret+=curr;if(curr<len){// No more space to write.
break}if(typeof offset!="undefined"){offset+=curr}}return ret};function _fd_write(fd,iov,iovcnt,pnum){try{var stream=SYSCALLS.getStreamFromFD(fd);var num=doWritev(stream,iov,iovcnt);HEAPU32[((pnum)>>2)]=num;return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return e.errno}}var _glActiveTexture=x0=>GLctx.activeTexture(x0);var _glAttachShader=(program,shader)=>{GLctx.attachShader(GL.programs[program],GL.shaders[shader])};var _glBeginQuery=(target,id)=>{GLctx.beginQuery(target,GL.queries[id])};var _glBeginTransformFeedback=x0=>GLctx.beginTransformFeedback(x0);var _glBindAttribLocation=(program,index,name)=>{GLctx.bindAttribLocation(GL.programs[program],index,UTF8ToString(name))};var _glBindBuffer=(target,buffer)=>{// Calling glBindBuffer with an unknown buffer will implicitly create a
// new one.  Here we bypass `GL.counter` and directly using the ID passed
// in.
if(buffer&&!GL.buffers[buffer]){var b=GLctx.createBuffer();b.name=buffer;GL.buffers[buffer]=b}if(target==34962){GLctx.currentArrayBufferBinding=buffer}else if(target==34963){GLctx.currentElementArrayBufferBinding=buffer}if(target==35051){// In WebGL 2 glReadPixels entry point, we need to use a different WebGL 2
// API function call when a buffer is bound to
// GL_PIXEL_PACK_BUFFER_BINDING point, so must keep track whether that
// binding point is non-null to know what is the proper API function to
// call.
GLctx.currentPixelPackBufferBinding=buffer}else if(target==35052){// In WebGL 2 gl(Compressed)Tex(Sub)Image[23]D entry points, we need to
// use a different WebGL 2 API function call when a buffer is bound to
// GL_PIXEL_UNPACK_BUFFER_BINDING point, so must keep track whether that
// binding point is non-null to know what is the proper API function to
// call.
GLctx.currentPixelUnpackBufferBinding=buffer}GLctx.bindBuffer(target,GL.buffers[buffer])};var _glBindBufferBase=(target,index,buffer)=>{GLctx.bindBufferBase(target,index,GL.buffers[buffer])};var _glBindBufferRange=(target,index,buffer,offset,ptrsize)=>{GLctx.bindBufferRange(target,index,GL.buffers[buffer],offset,ptrsize)};var _glBindFramebuffer=(target,framebuffer)=>{GLctx.bindFramebuffer(target,GL.framebuffers[framebuffer])};var _glBindRenderbuffer=(target,renderbuffer)=>{GLctx.bindRenderbuffer(target,GL.renderbuffers[renderbuffer])};var _glBindSampler=(unit,sampler)=>{GLctx.bindSampler(unit,GL.samplers[sampler])};var _glBindTexture=(target,texture)=>{GLctx.bindTexture(target,GL.textures[texture])};var _glBindTransformFeedback=(target,id)=>{GLctx.bindTransformFeedback(target,GL.transformFeedbacks[id])};var _glBindVertexArray=vao=>{GLctx.bindVertexArray(GL.vaos[vao]);var ibo=GLctx.getParameter(34965);GLctx.currentElementArrayBufferBinding=ibo?(ibo.name|0):0};var _glBlendColor=(x0,x1,x2,x3)=>GLctx.blendColor(x0,x1,x2,x3);var _glBlendEquation=x0=>GLctx.blendEquation(x0);var _glBlendEquationSeparate=(x0,x1)=>GLctx.blendEquationSeparate(x0,x1);var _glBlendFunc=(x0,x1)=>GLctx.blendFunc(x0,x1);var _glBlendFuncSeparate=(x0,x1,x2,x3)=>GLctx.blendFuncSeparate(x0,x1,x2,x3);var _glBlitFramebuffer=(x0,x1,x2,x3,x4,x5,x6,x7,x8,x9)=>GLctx.blitFramebuffer(x0,x1,x2,x3,x4,x5,x6,x7,x8,x9);var _glBufferData=(target,size,data,usage)=>{if(GL.currentContext.version>=2){// If size is zero, WebGL would interpret uploading the whole input
// arraybuffer (starting from given offset), which would not make sense in
// WebAssembly, so avoid uploading if size is zero. However we must still
// call bufferData to establish a backing storage of zero bytes.
if(data&&size){GLctx.bufferData(target,HEAPU8,usage,data,size)}else{GLctx.bufferData(target,size,usage)}return}// N.b. here first form specifies a heap subarray, second form an integer
// size, so the ?: code here is polymorphic. It is advised to avoid
// randomly mixing both uses in calling code, to avoid any potential JS
// engine JIT issues.
GLctx.bufferData(target,data?HEAPU8.subarray(data,data+size):size,usage)};var _glBufferSubData=(target,offset,size,data)=>{if(GL.currentContext.version>=2){size&&GLctx.bufferSubData(target,offset,HEAPU8,data,size);return}GLctx.bufferSubData(target,offset,HEAPU8.subarray(data,data+size))};var _glCheckFramebufferStatus=x0=>GLctx.checkFramebufferStatus(x0);var _glClear=x0=>GLctx.clear(x0);var _glClearBufferfi=(x0,x1,x2,x3)=>GLctx.clearBufferfi(x0,x1,x2,x3);var _glClearBufferfv=(buffer,drawbuffer,value)=>{GLctx.clearBufferfv(buffer,drawbuffer,HEAPF32,((value)>>2))};var _glClearBufferiv=(buffer,drawbuffer,value)=>{GLctx.clearBufferiv(buffer,drawbuffer,HEAP32,((value)>>2))};var _glClearBufferuiv=(buffer,drawbuffer,value)=>{GLctx.clearBufferuiv(buffer,drawbuffer,HEAPU32,((value)>>2))};var _glClearColor=(x0,x1,x2,x3)=>GLctx.clearColor(x0,x1,x2,x3);var _glClearDepthf=x0=>GLctx.clearDepth(x0);var _glClearStencil=x0=>GLctx.clearStencil(x0);var convertI32PairToI53=(lo,hi)=>(lo>>>0)+hi*4294967296;var _glClientWaitSync=(sync,flags,timeout_low,timeout_high)=>{// WebGL2 vs GLES3 differences: in GLES3, the timeout parameter is a uint64, where 0xFFFFFFFFFFFFFFFFULL means GL_TIMEOUT_IGNORED.
// In JS, there's no 64-bit value types, so instead timeout is taken to be signed, and GL_TIMEOUT_IGNORED is given value -1.
// Inherently the value accepted in the timeout is lossy, and can't take in arbitrary u64 bit pattern (but most likely doesn't matter)
// See https://www.khronos.org/registry/webgl/specs/latest/2.0/#5.15
var timeout=convertI32PairToI53(timeout_low,timeout_high);return GLctx.clientWaitSync(GL.syncs[sync],flags,timeout)};var _glColorMask=(red,green,blue,alpha)=>{GLctx.colorMask(!!red,!!green,!!blue,!!alpha)};var _glCompileShader=shader=>{GLctx.compileShader(GL.shaders[shader])};var _glCompressedTexImage2D=(target,level,internalFormat,width,height,border,imageSize,data)=>{// `data` may be null here, which means "allocate uniniitalized space but
// don't upload" in GLES parlance, but `compressedTexImage2D` requires the
// final data parameter, so we simply pass a heap view starting at zero
// effectively uploading whatever happens to be near address zero.  See
// https://github.com/emscripten-core/emscripten/issues/19300.
if(GL.currentContext.version>=2){if(GLctx.currentPixelUnpackBufferBinding||!imageSize){GLctx.compressedTexImage2D(target,level,internalFormat,width,height,border,imageSize,data);return}GLctx.compressedTexImage2D(target,level,internalFormat,width,height,border,HEAPU8,data,imageSize);return}GLctx.compressedTexImage2D(target,level,internalFormat,width,height,border,HEAPU8.subarray((data),data+imageSize))};var _glCompressedTexImage3D=(target,level,internalFormat,width,height,depth,border,imageSize,data)=>{if(GLctx.currentPixelUnpackBufferBinding){GLctx.compressedTexImage3D(target,level,internalFormat,width,height,depth,border,imageSize,data)}else{GLctx.compressedTexImage3D(target,level,internalFormat,width,height,depth,border,HEAPU8,data,imageSize)}};var _glCompressedTexSubImage2D=(target,level,xoffset,yoffset,width,height,format,imageSize,data)=>{if(GL.currentContext.version>=2){if(GLctx.currentPixelUnpackBufferBinding||!imageSize){GLctx.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,imageSize,data);return}GLctx.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,HEAPU8,data,imageSize);return}GLctx.compressedTexSubImage2D(target,level,xoffset,yoffset,width,height,format,HEAPU8.subarray((data),data+imageSize))};var _glCompressedTexSubImage3D=(target,level,xoffset,yoffset,zoffset,width,height,depth,format,imageSize,data)=>{if(GLctx.currentPixelUnpackBufferBinding){GLctx.compressedTexSubImage3D(target,level,xoffset,yoffset,zoffset,width,height,depth,format,imageSize,data)}else{GLctx.compressedTexSubImage3D(target,level,xoffset,yoffset,zoffset,width,height,depth,format,HEAPU8,data,imageSize)}};var _glCopyBufferSubData=(x0,x1,x2,x3,x4)=>GLctx.copyBufferSubData(x0,x1,x2,x3,x4);var _glCopyTexImage2D=(x0,x1,x2,x3,x4,x5,x6,x7)=>GLctx.copyTexImage2D(x0,x1,x2,x3,x4,x5,x6,x7);var _glCopyTexSubImage2D=(x0,x1,x2,x3,x4,x5,x6,x7)=>GLctx.copyTexSubImage2D(x0,x1,x2,x3,x4,x5,x6,x7);var _glCopyTexSubImage3D=(x0,x1,x2,x3,x4,x5,x6,x7,x8)=>GLctx.copyTexSubImage3D(x0,x1,x2,x3,x4,x5,x6,x7,x8);var _glCreateProgram=()=>{var id=GL.getNewId(GL.programs);var program=GLctx.createProgram();// Store additional information needed for each shader program:
program.name=id;// Lazy cache results of
// glGetProgramiv(GL_ACTIVE_UNIFORM_MAX_LENGTH/GL_ACTIVE_ATTRIBUTE_MAX_LENGTH/GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH)
program.maxUniformLength=program.maxAttributeLength=program.maxUniformBlockNameLength=0;program.uniformIdCounter=1;GL.programs[id]=program;return id};var _glCreateShader=shaderType=>{var id=GL.getNewId(GL.shaders);GL.shaders[id]=GLctx.createShader(shaderType);return id};var _glCullFace=x0=>GLctx.cullFace(x0);var _glDeleteBuffers=(n,buffers)=>{for(var i=0;i<n;i++){var id=HEAP32[(((buffers)+(i*4))>>2)];var buffer=GL.buffers[id];// From spec: "glDeleteBuffers silently ignores 0's and names that do not
// correspond to existing buffer objects."
if(!buffer)continue;GLctx.deleteBuffer(buffer);buffer.name=0;GL.buffers[id]=null;if(id==GLctx.currentArrayBufferBinding)GLctx.currentArrayBufferBinding=0;if(id==GLctx.currentElementArrayBufferBinding)GLctx.currentElementArrayBufferBinding=0;if(id==GLctx.currentPixelPackBufferBinding)GLctx.currentPixelPackBufferBinding=0;if(id==GLctx.currentPixelUnpackBufferBinding)GLctx.currentPixelUnpackBufferBinding=0}};var _glDeleteFramebuffers=(n,framebuffers)=>{for(var i=0;i<n;++i){var id=HEAP32[(((framebuffers)+(i*4))>>2)];var framebuffer=GL.framebuffers[id];if(!framebuffer)continue;// GL spec: "glDeleteFramebuffers silently ignores 0s and names that do not correspond to existing framebuffer objects".
GLctx.deleteFramebuffer(framebuffer);framebuffer.name=0;GL.framebuffers[id]=null}};var _glDeleteProgram=id=>{if(!id)return;var program=GL.programs[id];if(!program){// glDeleteProgram actually signals an error when deleting a nonexisting
// object, unlike some other GL delete functions.
GL.recordError(1281);return}GLctx.deleteProgram(program);program.name=0;GL.programs[id]=null};var _glDeleteQueries=(n,ids)=>{for(var i=0;i<n;i++){var id=HEAP32[(((ids)+(i*4))>>2)];var query=GL.queries[id];if(!query)continue;// GL spec: "unused names in ids are ignored, as is the name zero."
GLctx.deleteQuery(query);GL.queries[id]=null}};var _glDeleteRenderbuffers=(n,renderbuffers)=>{for(var i=0;i<n;i++){var id=HEAP32[(((renderbuffers)+(i*4))>>2)];var renderbuffer=GL.renderbuffers[id];if(!renderbuffer)continue;// GL spec: "glDeleteRenderbuffers silently ignores 0s and names that do not correspond to existing renderbuffer objects".
GLctx.deleteRenderbuffer(renderbuffer);renderbuffer.name=0;GL.renderbuffers[id]=null}};var _glDeleteSamplers=(n,samplers)=>{for(var i=0;i<n;i++){var id=HEAP32[(((samplers)+(i*4))>>2)];var sampler=GL.samplers[id];if(!sampler)continue;GLctx.deleteSampler(sampler);sampler.name=0;GL.samplers[id]=null}};var _glDeleteShader=id=>{if(!id)return;var shader=GL.shaders[id];if(!shader){// glDeleteShader actually signals an error when deleting a nonexisting
// object, unlike some other GL delete functions.
GL.recordError(1281);return}GLctx.deleteShader(shader);GL.shaders[id]=null};var _glDeleteSync=id=>{if(!id)return;var sync=GL.syncs[id];if(!sync){// glDeleteSync signals an error when deleting a nonexisting object, unlike some other GL delete functions.
GL.recordError(1281);return}GLctx.deleteSync(sync);sync.name=0;GL.syncs[id]=null};var _glDeleteTextures=(n,textures)=>{for(var i=0;i<n;i++){var id=HEAP32[(((textures)+(i*4))>>2)];var texture=GL.textures[id];// GL spec: "glDeleteTextures silently ignores 0s and names that do not
// correspond to existing textures".
if(!texture)continue;GLctx.deleteTexture(texture);texture.name=0;GL.textures[id]=null}};var _glDeleteTransformFeedbacks=(n,ids)=>{for(var i=0;i<n;i++){var id=HEAP32[(((ids)+(i*4))>>2)];var transformFeedback=GL.transformFeedbacks[id];if(!transformFeedback)continue;// GL spec: "unused names in ids are ignored, as is the name zero."
GLctx.deleteTransformFeedback(transformFeedback);transformFeedback.name=0;GL.transformFeedbacks[id]=null}};var _glDeleteVertexArrays=(n,vaos)=>{for(var i=0;i<n;i++){var id=HEAP32[(((vaos)+(i*4))>>2)];GLctx.deleteVertexArray(GL.vaos[id]);GL.vaos[id]=null}};var _glDepthFunc=x0=>GLctx.depthFunc(x0);var _glDepthMask=flag=>{GLctx.depthMask(!!flag)};var _glDepthRangef=(x0,x1)=>GLctx.depthRange(x0,x1);var _glDetachShader=(program,shader)=>{GLctx.detachShader(GL.programs[program],GL.shaders[shader])};var _glDisable=x0=>GLctx.disable(x0);var _glDisableVertexAttribArray=index=>{var cb=GL.currentContext.clientBuffers[index];cb.enabled=false;GLctx.disableVertexAttribArray(index)};var _glDrawArrays=(mode,first,count)=>{// bind any client-side buffers
GL.preDrawHandleClientVertexAttribBindings(first+count);GLctx.drawArrays(mode,first,count);GL.postDrawHandleClientVertexAttribBindings()};var _glDrawArraysInstanced=(mode,first,count,primcount)=>{GLctx.drawArraysInstanced(mode,first,count,primcount)};var tempFixedLengthArray=[];var _glDrawBuffers=(n,bufs)=>{var bufArray=tempFixedLengthArray[n];for(var i=0;i<n;i++){bufArray[i]=HEAP32[(((bufs)+(i*4))>>2)]}GLctx.drawBuffers(bufArray)};var _glDrawElements=(mode,count,type,indices)=>{var buf;var vertexes=0;if(!GLctx.currentElementArrayBufferBinding){var size=GL.calcBufLength(1,type,0,count);buf=GL.getTempIndexBuffer(size);GLctx.bindBuffer(34963,buf);GLctx.bufferSubData(34963,0,HEAPU8.subarray(indices,indices+size));// Calculating vertex count if shader's attribute data is on client side
if(count>0){for(var i=0;i<GL.currentContext.maxVertexAttribs;++i){var cb=GL.currentContext.clientBuffers[i];if(cb.clientside&&cb.enabled){let arrayClass;switch(type){case 5121:arrayClass=Uint8Array;break;case 5123:arrayClass=Uint16Array;break;case 5125:arrayClass=Uint32Array;break;default:GL.recordError(1282);return}vertexes=new arrayClass(HEAPU8.buffer,indices,count).reduce((max,current)=>Math.max(max,current))+1;break}}}// the index is now 0
indices=0}// bind any client-side buffers
GL.preDrawHandleClientVertexAttribBindings(vertexes);GLctx.drawElements(mode,count,type,indices);GL.postDrawHandleClientVertexAttribBindings(count);if(!GLctx.currentElementArrayBufferBinding){GLctx.bindBuffer(34963,null)}};var _glDrawElementsInstanced=(mode,count,type,indices,primcount)=>{GLctx.drawElementsInstanced(mode,count,type,indices,primcount)};var _glDrawRangeElements=(mode,start,end,count,type,indices)=>{// TODO: This should be a trivial pass-though function registered at the bottom of this page as
// glFuncs[6][1] += ' drawRangeElements';
// but due to https://bugzilla.mozilla.org/show_bug.cgi?id=1202427,
// we work around by ignoring the range.
_glDrawElements(mode,count,type,indices)};var _glEnable=x0=>GLctx.enable(x0);var _glEnableVertexAttribArray=index=>{var cb=GL.currentContext.clientBuffers[index];cb.enabled=true;GLctx.enableVertexAttribArray(index)};var _glEndQuery=x0=>GLctx.endQuery(x0);var _glEndTransformFeedback=()=>GLctx.endTransformFeedback();var _glFenceSync=(condition,flags)=>{var sync=GLctx.fenceSync(condition,flags);if(sync){var id=GL.getNewId(GL.syncs);sync.name=id;GL.syncs[id]=sync;return id}return 0};var _glFinish=()=>GLctx.finish();var _glFlush=()=>GLctx.flush();var _glFramebufferRenderbuffer=(target,attachment,renderbuffertarget,renderbuffer)=>{GLctx.framebufferRenderbuffer(target,attachment,renderbuffertarget,GL.renderbuffers[renderbuffer])};var _glFramebufferTexture2D=(target,attachment,textarget,texture,level)=>{GLctx.framebufferTexture2D(target,attachment,textarget,GL.textures[texture],level)};var _glFramebufferTextureLayer=(target,attachment,texture,level,layer)=>{GLctx.framebufferTextureLayer(target,attachment,GL.textures[texture],level,layer)};var _glFrontFace=x0=>GLctx.frontFace(x0);var _glGenBuffers=(n,buffers)=>{GL.genObject(n,buffers,"createBuffer",GL.buffers)};var _glGenFramebuffers=(n,ids)=>{GL.genObject(n,ids,"createFramebuffer",GL.framebuffers)};var _glGenQueries=(n,ids)=>{GL.genObject(n,ids,"createQuery",GL.queries)};var _glGenRenderbuffers=(n,renderbuffers)=>{GL.genObject(n,renderbuffers,"createRenderbuffer",GL.renderbuffers)};var _glGenSamplers=(n,samplers)=>{GL.genObject(n,samplers,"createSampler",GL.samplers)};var _glGenTextures=(n,textures)=>{GL.genObject(n,textures,"createTexture",GL.textures)};var _glGenTransformFeedbacks=(n,ids)=>{GL.genObject(n,ids,"createTransformFeedback",GL.transformFeedbacks)};var _glGenVertexArrays=(n,arrays)=>{GL.genObject(n,arrays,"createVertexArray",GL.vaos)};var _glGenerateMipmap=x0=>GLctx.generateMipmap(x0);var __glGetActiveAttribOrUniform=(funcName,program,index,bufSize,length,size,type,name)=>{program=GL.programs[program];var info=GLctx[funcName](program,index);if(info){// If an error occurs, nothing will be written to length, size and type and name.
var numBytesWrittenExclNull=name&&stringToUTF8(info.name,name,bufSize);if(length)HEAP32[((length)>>2)]=numBytesWrittenExclNull;if(size)HEAP32[((size)>>2)]=info.size;if(type)HEAP32[((type)>>2)]=info.type}};var _glGetActiveAttrib=(program,index,bufSize,length,size,type,name)=>__glGetActiveAttribOrUniform("getActiveAttrib",program,index,bufSize,length,size,type,name);var _glGetActiveUniform=(program,index,bufSize,length,size,type,name)=>__glGetActiveAttribOrUniform("getActiveUniform",program,index,bufSize,length,size,type,name);var _glGetActiveUniformBlockName=(program,uniformBlockIndex,bufSize,length,uniformBlockName)=>{program=GL.programs[program];var result=GLctx.getActiveUniformBlockName(program,uniformBlockIndex);if(!result)return;// If an error occurs, nothing will be written to uniformBlockName or length.
if(uniformBlockName&&bufSize>0){var numBytesWrittenExclNull=stringToUTF8(result,uniformBlockName,bufSize);if(length)HEAP32[((length)>>2)]=numBytesWrittenExclNull}else{if(length)HEAP32[((length)>>2)]=0}};var _glGetActiveUniformBlockiv=(program,uniformBlockIndex,pname,params)=>{if(!params){// GLES2 specification does not specify how to behave if params is a null pointer. Since calling this function does not make sense
// if params == null, issue a GL error to notify user about it.
GL.recordError(1281);return}program=GL.programs[program];if(pname==35393){var name=GLctx.getActiveUniformBlockName(program,uniformBlockIndex);HEAP32[((params)>>2)]=name.length+1;return}var result=GLctx.getActiveUniformBlockParameter(program,uniformBlockIndex,pname);if(result===null)return;// If an error occurs, nothing should be written to params.
if(pname==35395){for(var i=0;i<result.length;i++){HEAP32[(((params)+(i*4))>>2)]=result[i]}}else{HEAP32[((params)>>2)]=result}};var _glGetActiveUniformsiv=(program,uniformCount,uniformIndices,pname,params)=>{if(!params){// GLES2 specification does not specify how to behave if params is a null pointer. Since calling this function does not make sense
// if params == null, issue a GL error to notify user about it.
GL.recordError(1281);return}if(uniformCount>0&&uniformIndices==0){GL.recordError(1281);return}program=GL.programs[program];var ids=[];for(var i=0;i<uniformCount;i++){ids.push(HEAP32[(((uniformIndices)+(i*4))>>2)])}var result=GLctx.getActiveUniforms(program,ids,pname);if(!result)return;// GL spec: If an error is generated, nothing is written out to params.
var len=result.length;for(var i=0;i<len;i++){HEAP32[(((params)+(i*4))>>2)]=result[i]}};var _glGetAttachedShaders=(program,maxCount,count,shaders)=>{var result=GLctx.getAttachedShaders(GL.programs[program]);var len=result.length;if(len>maxCount){len=maxCount}HEAP32[((count)>>2)]=len;for(var i=0;i<len;++i){var id=GL.shaders.indexOf(result[i]);HEAP32[(((shaders)+(i*4))>>2)]=id}};var _glGetAttribLocation=(program,name)=>GLctx.getAttribLocation(GL.programs[program],UTF8ToString(name));var writeI53ToI64=(ptr,num)=>{HEAPU32[((ptr)>>2)]=num;var lower=HEAPU32[((ptr)>>2)];HEAPU32[(((ptr)+(4))>>2)]=(num-lower)/4294967296};var webglGetExtensions=()=>{var exts=getEmscriptenSupportedExtensions(GLctx);exts=exts.concat(exts.map(e=>"GL_"+e));return exts};var emscriptenWebGLGet=(name_,p,type)=>{// Guard against user passing a null pointer.
// Note that GLES2 spec does not say anything about how passing a null
// pointer should be treated.  Testing on desktop core GL 3, the application
// crashes on glGetIntegerv to a null pointer, but better to report an error
// instead of doing anything random.
if(!p){GL.recordError(1281);return}var ret=undefined;switch(name_){// Handle a few trivial GLES values
case 36346:// GL_SHADER_COMPILER
ret=1;break;case 36344:// GL_SHADER_BINARY_FORMATS
if(type!=0&&type!=1){GL.recordError(1280)}// Do not write anything to the out pointer, since no binary formats are
// supported.
return;case 34814:// GL_NUM_PROGRAM_BINARY_FORMATS
case 36345:// GL_NUM_SHADER_BINARY_FORMATS
ret=0;break;case 34466:// GL_NUM_COMPRESSED_TEXTURE_FORMATS
// WebGL doesn't have GL_NUM_COMPRESSED_TEXTURE_FORMATS (it's obsolete
// since GL_COMPRESSED_TEXTURE_FORMATS returns a JS array that can be
// queried for length), so implement it ourselves to allow C++ GLES2
// code get the length.
var formats=GLctx.getParameter(34467);ret=formats?formats.length:0;break;case 33309:// GL_NUM_EXTENSIONS
if(GL.currentContext.version<2){// Calling GLES3/WebGL2 function with a GLES2/WebGL1 context
GL.recordError(1282);return}ret=webglGetExtensions().length;break;case 33307:// GL_MAJOR_VERSION
case 33308:// GL_MINOR_VERSION
if(GL.currentContext.version<2){GL.recordError(1280);// GL_INVALID_ENUM
return}ret=name_==33307?3:0;// return version 3.0
break}if(ret===undefined){var result=GLctx.getParameter(name_);switch(typeof result){case"number":ret=result;break;case"boolean":ret=result?1:0;break;case"string":GL.recordError(1280);// GL_INVALID_ENUM
return;case"object":if(result===null){// null is a valid result for some (e.g., which buffer is bound -
// perhaps nothing is bound), but otherwise can mean an invalid
// name_, which we need to report as an error
switch(name_){case 34964:// ARRAY_BUFFER_BINDING
case 35725:// CURRENT_PROGRAM
case 34965:// ELEMENT_ARRAY_BUFFER_BINDING
case 36006:// FRAMEBUFFER_BINDING or DRAW_FRAMEBUFFER_BINDING
case 36007:// RENDERBUFFER_BINDING
case 32873:// TEXTURE_BINDING_2D
case 34229:// WebGL 2 GL_VERTEX_ARRAY_BINDING, or WebGL 1 extension OES_vertex_array_object GL_VERTEX_ARRAY_BINDING_OES
case 36662:// COPY_READ_BUFFER_BINDING or COPY_READ_BUFFER
case 36663:// COPY_WRITE_BUFFER_BINDING or COPY_WRITE_BUFFER
case 35053:// PIXEL_PACK_BUFFER_BINDING
case 35055:// PIXEL_UNPACK_BUFFER_BINDING
case 36010:// READ_FRAMEBUFFER_BINDING
case 35097:// SAMPLER_BINDING
case 35869:// TEXTURE_BINDING_2D_ARRAY
case 32874:// TEXTURE_BINDING_3D
case 36389:// TRANSFORM_FEEDBACK_BINDING
case 35983:// TRANSFORM_FEEDBACK_BUFFER_BINDING
case 35368:// UNIFORM_BUFFER_BINDING
case 34068:{// TEXTURE_BINDING_CUBE_MAP
ret=0;break}default:{GL.recordError(1280);// GL_INVALID_ENUM
return}}}else if(result instanceof Float32Array||result instanceof Uint32Array||result instanceof Int32Array||result instanceof Array){for(var i=0;i<result.length;++i){switch(type){case 0:HEAP32[(((p)+(i*4))>>2)]=result[i];break;case 2:HEAPF32[(((p)+(i*4))>>2)]=result[i];break;case 4:HEAP8[(p)+(i)]=result[i]?1:0;break}}return}else{try{ret=result.name|0}catch(e){GL.recordError(1280);// GL_INVALID_ENUM
err(`GL_INVALID_ENUM in glGet${type}v: Unknown object returned from WebGL getParameter(${name_})! (error: ${e})`);return}}break;default:GL.recordError(1280);// GL_INVALID_ENUM
err(`GL_INVALID_ENUM in glGet${type}v: Native code calling glGet${type}v(${name_}) and it returns ${result} of type ${typeof(result)}!`);return}}switch(type){case 1:writeI53ToI64(p,ret);break;case 0:HEAP32[((p)>>2)]=ret;break;case 2:HEAPF32[((p)>>2)]=ret;break;case 4:HEAP8[p]=ret?1:0;break}};var _glGetBooleanv=(name_,p)=>emscriptenWebGLGet(name_,p,4);var _glGetBufferParameteriv=(target,value,data)=>{if(!data){// GLES2 specification does not specify how to behave if data is a null
// pointer. Since calling this function does not make sense if data ==
// null, issue a GL error to notify user about it.
GL.recordError(1281);return}HEAP32[((data)>>2)]=GLctx.getBufferParameter(target,value)};var _glGetError=()=>{var error=GLctx.getError()||GL.lastError;GL.lastError=0;return error};var _glGetFloatv=(name_,p)=>emscriptenWebGLGet(name_,p,2);var _glGetFragDataLocation=(program,name)=>GLctx.getFragDataLocation(GL.programs[program],UTF8ToString(name));var _glGetFramebufferAttachmentParameteriv=(target,attachment,pname,params)=>{var result=GLctx.getFramebufferAttachmentParameter(target,attachment,pname);if(result instanceof WebGLRenderbuffer||result instanceof WebGLTexture){result=result.name|0}HEAP32[((params)>>2)]=result};var emscriptenWebGLGetIndexed=(target,index,data,type)=>{if(!data){// GLES2 specification does not specify how to behave if data is a null pointer. Since calling this function does not make sense
// if data == null, issue a GL error to notify user about it.
GL.recordError(1281);return}var result=GLctx.getIndexedParameter(target,index);var ret;switch(typeof result){case"boolean":ret=result?1:0;break;case"number":ret=result;break;case"object":if(result===null){switch(target){case 35983:// TRANSFORM_FEEDBACK_BUFFER_BINDING
case 35368:// UNIFORM_BUFFER_BINDING
ret=0;break;default:{GL.recordError(1280);// GL_INVALID_ENUM
return}}}else if(result instanceof WebGLBuffer){ret=result.name|0}else{GL.recordError(1280);// GL_INVALID_ENUM
return}break;default:GL.recordError(1280);// GL_INVALID_ENUM
return}switch(type){case 1:writeI53ToI64(data,ret);break;case 0:HEAP32[((data)>>2)]=ret;break;case 2:HEAPF32[((data)>>2)]=ret;break;case 4:HEAP8[data]=ret?1:0;break;default:throw"internal emscriptenWebGLGetIndexed() error, bad type: "+type}};var _glGetInteger64i_v=(target,index,data)=>emscriptenWebGLGetIndexed(target,index,data,1);var _glGetInteger64v=(name_,p)=>{emscriptenWebGLGet(name_,p,1)};var _glGetIntegeri_v=(target,index,data)=>emscriptenWebGLGetIndexed(target,index,data,0);var _glGetIntegerv=(name_,p)=>emscriptenWebGLGet(name_,p,0);var _glGetInternalformativ=(target,internalformat,pname,bufSize,params)=>{if(bufSize<0){GL.recordError(1281);return}if(!params){// GLES3 specification does not specify how to behave if values is a null pointer. Since calling this function does not make sense
// if values == null, issue a GL error to notify user about it.
GL.recordError(1281);return}var ret=GLctx.getInternalformatParameter(target,internalformat,pname);if(ret===null)return;for(var i=0;i<ret.length&&i<bufSize;++i){HEAP32[(((params)+(i*4))>>2)]=ret[i]}};var _glGetProgramInfoLog=(program,maxLength,length,infoLog)=>{var log=GLctx.getProgramInfoLog(GL.programs[program]);if(log===null)log="(unknown error)";var numBytesWrittenExclNull=(maxLength>0&&infoLog)?stringToUTF8(log,infoLog,maxLength):0;if(length)HEAP32[((length)>>2)]=numBytesWrittenExclNull};var _glGetProgramiv=(program,pname,p)=>{if(!p){// GLES2 specification does not specify how to behave if p is a null
// pointer. Since calling this function does not make sense if p == null,
// issue a GL error to notify user about it.
GL.recordError(1281);return}if(program>=GL.counter){GL.recordError(1281);return}program=GL.programs[program];if(pname==35716){// GL_INFO_LOG_LENGTH
var log=GLctx.getProgramInfoLog(program);if(log===null)log="(unknown error)";HEAP32[((p)>>2)]=log.length+1}else if(pname==35719){if(!program.maxUniformLength){var numActiveUniforms=GLctx.getProgramParameter(program,35718);for(var i=0;i<numActiveUniforms;++i){program.maxUniformLength=Math.max(program.maxUniformLength,GLctx.getActiveUniform(program,i).name.length+1)}}HEAP32[((p)>>2)]=program.maxUniformLength}else if(pname==35722){if(!program.maxAttributeLength){var numActiveAttributes=GLctx.getProgramParameter(program,35721);for(var i=0;i<numActiveAttributes;++i){program.maxAttributeLength=Math.max(program.maxAttributeLength,GLctx.getActiveAttrib(program,i).name.length+1)}}HEAP32[((p)>>2)]=program.maxAttributeLength}else if(pname==35381){if(!program.maxUniformBlockNameLength){var numActiveUniformBlocks=GLctx.getProgramParameter(program,35382);for(var i=0;i<numActiveUniformBlocks;++i){program.maxUniformBlockNameLength=Math.max(program.maxUniformBlockNameLength,GLctx.getActiveUniformBlockName(program,i).length+1)}}HEAP32[((p)>>2)]=program.maxUniformBlockNameLength}else{HEAP32[((p)>>2)]=GLctx.getProgramParameter(program,pname)}};var _glGetQueryObjectuiv=(id,pname,params)=>{if(!params){// GLES2 specification does not specify how to behave if params is a null pointer. Since calling this function does not make sense
// if p == null, issue a GL error to notify user about it.
GL.recordError(1281);return}var query=GL.queries[id];var param=GLctx.getQueryParameter(query,pname);var ret;if(typeof param=="boolean"){ret=param?1:0}else{ret=param}HEAP32[((params)>>2)]=ret};var _glGetQueryiv=(target,pname,params)=>{if(!params){// GLES2 specification does not specify how to behave if params is a null pointer. Since calling this function does not make sense
// if p == null, issue a GL error to notify user about it.
GL.recordError(1281);return}HEAP32[((params)>>2)]=GLctx.getQuery(target,pname)};var _glGetRenderbufferParameteriv=(target,pname,params)=>{if(!params){// GLES2 specification does not specify how to behave if params is a null pointer. Since calling this function does not make sense
// if params == null, issue a GL error to notify user about it.
GL.recordError(1281);return}HEAP32[((params)>>2)]=GLctx.getRenderbufferParameter(target,pname)};var _glGetSamplerParameterfv=(sampler,pname,params)=>{if(!params){// GLES3 specification does not specify how to behave if params is a null pointer. Since calling this function does not make sense
// if p == null, issue a GL error to notify user about it.
GL.recordError(1281);return}HEAPF32[((params)>>2)]=GLctx.getSamplerParameter(GL.samplers[sampler],pname)};var _glGetSamplerParameteriv=(sampler,pname,params)=>{if(!params){// GLES3 specification does not specify how to behave if params is a null pointer. Since calling this function does not make sense
// if p == null, issue a GL error to notify user about it.
GL.recordError(1281);return}HEAP32[((params)>>2)]=GLctx.getSamplerParameter(GL.samplers[sampler],pname)};var _glGetShaderInfoLog=(shader,maxLength,length,infoLog)=>{var log=GLctx.getShaderInfoLog(GL.shaders[shader]);if(log===null)log="(unknown error)";var numBytesWrittenExclNull=(maxLength>0&&infoLog)?stringToUTF8(log,infoLog,maxLength):0;if(length)HEAP32[((length)>>2)]=numBytesWrittenExclNull};var _glGetShaderPrecisionFormat=(shaderType,precisionType,range,precision)=>{var result=GLctx.getShaderPrecisionFormat(shaderType,precisionType);HEAP32[((range)>>2)]=result.rangeMin;HEAP32[(((range)+(4))>>2)]=result.rangeMax;HEAP32[((precision)>>2)]=result.precision};var _glGetShaderSource=(shader,bufSize,length,source)=>{var result=GLctx.getShaderSource(GL.shaders[shader]);if(!result)return;// If an error occurs, nothing will be written to length or source.
var numBytesWrittenExclNull=(bufSize>0&&source)?stringToUTF8(result,source,bufSize):0;if(length)HEAP32[((length)>>2)]=numBytesWrittenExclNull};var _glGetShaderiv=(shader,pname,p)=>{if(!p){// GLES2 specification does not specify how to behave if p is a null
// pointer. Since calling this function does not make sense if p == null,
// issue a GL error to notify user about it.
GL.recordError(1281);return}if(pname==35716){// GL_INFO_LOG_LENGTH
var log=GLctx.getShaderInfoLog(GL.shaders[shader]);if(log===null)log="(unknown error)";// The GLES2 specification says that if the shader has an empty info log,
// a value of 0 is returned. Otherwise the log has a null char appended.
// (An empty string is falsey, so we can just check that instead of
// looking at log.length.)
var logLength=log?log.length+1:0;HEAP32[((p)>>2)]=logLength}else if(pname==35720){// GL_SHADER_SOURCE_LENGTH
var source=GLctx.getShaderSource(GL.shaders[shader]);// source may be a null, or the empty string, both of which are falsey
// values that we report a 0 length for.
var sourceLength=source?source.length+1:0;HEAP32[((p)>>2)]=sourceLength}else{HEAP32[((p)>>2)]=GLctx.getShaderParameter(GL.shaders[shader],pname)}};var _glGetString=name_=>{var ret=GL.stringCache[name_];if(!ret){switch(name_){case 7939:ret=stringToNewUTF8(webglGetExtensions().join(" "));break;case 7936:case 7937:case 37445:case 37446:var s=GLctx.getParameter(name_);if(!s){GL.recordError(1280)}ret=s?stringToNewUTF8(s):0;break;case 7938:var webGLVersion=GLctx.getParameter(7938);// return GLES version string corresponding to the version of the WebGL context
var glVersion=`OpenGL ES 2.0 (${webGLVersion})`;if(GL.currentContext.version>=2)glVersion=`OpenGL ES 3.0 (${webGLVersion})`;ret=stringToNewUTF8(glVersion);break;case 35724:var glslVersion=GLctx.getParameter(35724);// extract the version number 'N.M' from the string 'WebGL GLSL ES N.M ...'
var ver_re=/^WebGL GLSL ES ([0-9]\.[0-9][0-9]?)(?:$| .*)/;var ver_num=glslVersion.match(ver_re);if(ver_num!==null){if(ver_num[1].length==3)ver_num[1]=ver_num[1]+"0";// ensure minor version has 2 digits
glslVersion=`OpenGL ES GLSL ES ${ver_num[1]} (${glslVersion})`}ret=stringToNewUTF8(glslVersion);break;default:GL.recordError(1280)}GL.stringCache[name_]=ret}return ret};var _glGetSynciv=(sync,pname,bufSize,length,values)=>{if(bufSize<0){// GLES3 specification does not specify how to behave if bufSize < 0, however in the spec wording for glGetInternalformativ, it does say that GL_INVALID_VALUE should be raised,
// so raise GL_INVALID_VALUE here as well.
GL.recordError(1281);return}if(!values){// GLES3 specification does not specify how to behave if values is a null pointer. Since calling this function does not make sense
// if values == null, issue a GL error to notify user about it.
GL.recordError(1281);return}var ret=GLctx.getSyncParameter(GL.syncs[sync],pname);if(ret!==null){HEAP32[((values)>>2)]=ret;if(length)HEAP32[((length)>>2)]=1}};var _glGetTexParameterfv=(target,pname,params)=>{if(!params){// GLES2 specification does not specify how to behave if params is a null
// pointer. Since calling this function does not make sense if p == null,
// issue a GL error to notify user about it.
GL.recordError(1281);return}HEAPF32[((params)>>2)]=GLctx.getTexParameter(target,pname)};var _glGetTexParameteriv=(target,pname,params)=>{if(!params){// GLES2 specification does not specify how to behave if params is a null
// pointer. Since calling this function does not make sense if p == null,
// issue a GL error to notify user about it.
GL.recordError(1281);return}HEAP32[((params)>>2)]=GLctx.getTexParameter(target,pname)};var _glGetTransformFeedbackVarying=(program,index,bufSize,length,size,type,name)=>{program=GL.programs[program];var info=GLctx.getTransformFeedbackVarying(program,index);if(!info)return;// If an error occurred, the return parameters length, size, type and name will be unmodified.
if(name&&bufSize>0){var numBytesWrittenExclNull=stringToUTF8(info.name,name,bufSize);if(length)HEAP32[((length)>>2)]=numBytesWrittenExclNull}else{if(length)HEAP32[((length)>>2)]=0}if(size)HEAP32[((size)>>2)]=info.size;if(type)HEAP32[((type)>>2)]=info.type};var _glGetUniformBlockIndex=(program,uniformBlockName)=>GLctx.getUniformBlockIndex(GL.programs[program],UTF8ToString(uniformBlockName));var _glGetUniformIndices=(program,uniformCount,uniformNames,uniformIndices)=>{if(!uniformIndices){// GLES2 specification does not specify how to behave if uniformIndices is a null pointer. Since calling this function does not make sense
// if uniformIndices == null, issue a GL error to notify user about it.
GL.recordError(1281);return}if(uniformCount>0&&(uniformNames==0||uniformIndices==0)){GL.recordError(1281);return}program=GL.programs[program];var names=[];for(var i=0;i<uniformCount;i++)names.push(UTF8ToString(HEAP32[(((uniformNames)+(i*4))>>2)]));var result=GLctx.getUniformIndices(program,names);if(!result)return;// GL spec: If an error is generated, nothing is written out to uniformIndices.
var len=result.length;for(var i=0;i<len;i++){HEAP32[(((uniformIndices)+(i*4))>>2)]=result[i]}};/** @suppress {checkTypes} */var jstoi_q=str=>parseInt(str);/** @noinline */var webglGetLeftBracePos=name=>name.slice(-1)=="]"&&name.lastIndexOf("[");var webglPrepareUniformLocationsBeforeFirstUse=program=>{var uniformLocsById=program.uniformLocsById,// Maps GLuint -> WebGLUniformLocation
uniformSizeAndIdsByName=program.uniformSizeAndIdsByName,// Maps name -> [uniform array length, GLuint]
i,j;// On the first time invocation of glGetUniformLocation on this shader program:
// initialize cache data structures and discover which uniforms are arrays.
if(!uniformLocsById){// maps GLint integer locations to WebGLUniformLocations
program.uniformLocsById=uniformLocsById={};// maps integer locations back to uniform name strings, so that we can lazily fetch uniform array locations
program.uniformArrayNamesById={};var numActiveUniforms=GLctx.getProgramParameter(program,35718);for(i=0;i<numActiveUniforms;++i){var u=GLctx.getActiveUniform(program,i);var nm=u.name;var sz=u.size;var lb=webglGetLeftBracePos(nm);var arrayName=lb>0?nm.slice(0,lb):nm;// Assign a new location.
var id=program.uniformIdCounter;program.uniformIdCounter+=sz;// Eagerly get the location of the uniformArray[0] base element.
// The remaining indices >0 will be left for lazy evaluation to
// improve performance. Those may never be needed to fetch, if the
// application fills arrays always in full starting from the first
// element of the array.
uniformSizeAndIdsByName[arrayName]=[sz,id];// Store placeholder integers in place that highlight that these
// >0 index locations are array indices pending population.
for(j=0;j<sz;++j){uniformLocsById[id]=j;program.uniformArrayNamesById[id++]=arrayName}}}};var _glGetUniformLocation=(program,name)=>{name=UTF8ToString(name);if(program=GL.programs[program]){webglPrepareUniformLocationsBeforeFirstUse(program);var uniformLocsById=program.uniformLocsById;// Maps GLuint -> WebGLUniformLocation
var arrayIndex=0;var uniformBaseName=name;// Invariant: when populating integer IDs for uniform locations, we must
// maintain the precondition that arrays reside in contiguous addresses,
// i.e. for a 'vec4 colors[10];', colors[4] must be at location
// colors[0]+4.  However, user might call glGetUniformLocation(program,
// "colors") for an array, so we cannot discover based on the user input
// arguments whether the uniform we are dealing with is an array. The only
// way to discover which uniforms are arrays is to enumerate over all the
// active uniforms in the program.
var leftBrace=webglGetLeftBracePos(name);// If user passed an array accessor "[index]", parse the array index off the accessor.
if(leftBrace>0){arrayIndex=jstoi_q(name.slice(leftBrace+1))>>>0;// "index]", coerce parseInt(']') with >>>0 to treat "foo[]" as "foo[0]" and foo[-1] as unsigned out-of-bounds.
uniformBaseName=name.slice(0,leftBrace)}// Have we cached the location of this uniform before?
// A pair [array length, GLint of the uniform location]
var sizeAndId=program.uniformSizeAndIdsByName[uniformBaseName];// If an uniform with this name exists, and if its index is within the
// array limits (if it's even an array), query the WebGLlocation, or
// return an existing cached location.
if(sizeAndId&&arrayIndex<sizeAndId[0]){arrayIndex+=sizeAndId[1];// Add the base location of the uniform to the array index offset.
if((uniformLocsById[arrayIndex]=uniformLocsById[arrayIndex]||GLctx.getUniformLocation(program,name))){return arrayIndex}}}else{// N.b. we are currently unable to distinguish between GL program IDs that
// never existed vs GL program IDs that have been deleted, so report
// GL_INVALID_VALUE in both cases.
GL.recordError(1281)}return-1};var _glGetVertexAttribPointerv=(index,pname,pointer)=>{if(!pointer){// GLES2 specification does not specify how to behave if pointer is a null
// pointer. Since calling this function does not make sense if pointer ==
// null, issue a GL error to notify user about it.
GL.recordError(1281);return}if(GL.currentContext.clientBuffers[index].enabled){err("glGetVertexAttribPointer on client-side array: not supported, bad data returned")}HEAP32[((pointer)>>2)]=GLctx.getVertexAttribOffset(index,pname)};/** @suppress{checkTypes} */var emscriptenWebGLGetVertexAttrib=(index,pname,params,type)=>{if(!params){// GLES2 specification does not specify how to behave if params is a null
// pointer. Since calling this function does not make sense if params ==
// null, issue a GL error to notify user about it.
GL.recordError(1281);return}if(GL.currentContext.clientBuffers[index].enabled){err("glGetVertexAttrib*v on client-side array: not supported, bad data returned")}var data=GLctx.getVertexAttrib(index,pname);if(pname==34975){HEAP32[((params)>>2)]=data&&data["name"]}else if(typeof data=="number"||typeof data=="boolean"){switch(type){case 0:HEAP32[((params)>>2)]=data;break;case 2:HEAPF32[((params)>>2)]=data;break;case 5:HEAP32[((params)>>2)]=Math.fround(data);break}}else{for(var i=0;i<data.length;i++){switch(type){case 0:HEAP32[(((params)+(i*4))>>2)]=data[i];break;case 2:HEAPF32[(((params)+(i*4))>>2)]=data[i];break;case 5:HEAP32[(((params)+(i*4))>>2)]=Math.fround(data[i]);break}}}};var _glGetVertexAttribfv=(index,pname,params)=>{// N.B. This function may only be called if the vertex attribute was
// specified using the function glVertexAttrib*f(), otherwise the results
// are undefined. (GLES3 spec 6.1.12)
emscriptenWebGLGetVertexAttrib(index,pname,params,2)};var _glGetVertexAttribiv=(index,pname,params)=>{// N.B. This function may only be called if the vertex attribute was
// specified using the function glVertexAttrib*f(), otherwise the results
// are undefined. (GLES3 spec 6.1.12)
emscriptenWebGLGetVertexAttrib(index,pname,params,5)};var _glHint=(x0,x1)=>GLctx.hint(x0,x1);var _glInvalidateFramebuffer=(target,numAttachments,attachments)=>{var list=tempFixedLengthArray[numAttachments];for(var i=0;i<numAttachments;i++){list[i]=HEAP32[(((attachments)+(i*4))>>2)]}GLctx.invalidateFramebuffer(target,list)};var _glInvalidateSubFramebuffer=(target,numAttachments,attachments,x,y,width,height)=>{var list=tempFixedLengthArray[numAttachments];for(var i=0;i<numAttachments;i++){list[i]=HEAP32[(((attachments)+(i*4))>>2)]}GLctx.invalidateSubFramebuffer(target,list,x,y,width,height)};var _glIsBuffer=buffer=>{var b=GL.buffers[buffer];if(!b)return 0;return GLctx.isBuffer(b)};var _glIsEnabled=x0=>GLctx.isEnabled(x0);var _glIsFramebuffer=framebuffer=>{var fb=GL.framebuffers[framebuffer];if(!fb)return 0;return GLctx.isFramebuffer(fb)};var _glIsProgram=program=>{program=GL.programs[program];if(!program)return 0;return GLctx.isProgram(program)};var _glIsQuery=id=>{var query=GL.queries[id];if(!query)return 0;return GLctx.isQuery(query)};var _glIsRenderbuffer=renderbuffer=>{var rb=GL.renderbuffers[renderbuffer];if(!rb)return 0;return GLctx.isRenderbuffer(rb)};var _glIsSampler=id=>{var sampler=GL.samplers[id];if(!sampler)return 0;return GLctx.isSampler(sampler)};var _glIsShader=shader=>{var s=GL.shaders[shader];if(!s)return 0;return GLctx.isShader(s)};var _glIsSync=sync=>GLctx.isSync(GL.syncs[sync]);var _glIsTexture=id=>{var texture=GL.textures[id];if(!texture)return 0;return GLctx.isTexture(texture)};var _glIsTransformFeedback=id=>GLctx.isTransformFeedback(GL.transformFeedbacks[id]);var _glIsVertexArray=array=>{var vao=GL.vaos[array];if(!vao)return 0;return GLctx.isVertexArray(vao)};var _glLineWidth=x0=>GLctx.lineWidth(x0);var _glLinkProgram=program=>{program=GL.programs[program];GLctx.linkProgram(program);// Invalidate earlier computed uniform->ID mappings, those have now become stale
program.uniformLocsById=0;// Mark as null-like so that glGetUniformLocation() knows to populate this again.
program.uniformSizeAndIdsByName={}};var _glPauseTransformFeedback=()=>GLctx.pauseTransformFeedback();var _glPixelStorei=(pname,param)=>{if(pname==3317){GL.unpackAlignment=param}else if(pname==3314){GL.unpackRowLength=param}GLctx.pixelStorei(pname,param)};var _glPolygonOffset=(x0,x1)=>GLctx.polygonOffset(x0,x1);var _glReadBuffer=x0=>GLctx.readBuffer(x0);var computeUnpackAlignedImageSize=(width,height,sizePerPixel)=>{function roundedToNextMultipleOf(x,y){return(x+y-1)&-y}var plainRowSize=(GL.unpackRowLength||width)*sizePerPixel;var alignedRowSize=roundedToNextMultipleOf(plainRowSize,GL.unpackAlignment);return height*alignedRowSize};var colorChannelsInGlTextureFormat=format=>{// Micro-optimizations for size: map format to size by subtracting smallest
// enum value (0x1902) from all values first.  Also omit the most common
// size value (1) from the list, which is assumed by formats not on the
// list.
var colorChannels={// 0x1902 /* GL_DEPTH_COMPONENT */ - 0x1902: 1,
// 0x1906 /* GL_ALPHA */ - 0x1902: 1,
5:3,6:4,// 0x1909 /* GL_LUMINANCE */ - 0x1902: 1,
8:2,29502:3,29504:4,// 0x1903 /* GL_RED */ - 0x1902: 1,
26917:2,26918:2,// 0x8D94 /* GL_RED_INTEGER */ - 0x1902: 1,
29846:3,29847:4};return colorChannels[format-6402]||1};var heapObjectForWebGLType=type=>{// Micro-optimization for size: Subtract lowest GL enum number (0x1400/* GL_BYTE */) from type to compare
// smaller values for the heap, for shorter generated code size.
// Also the type HEAPU16 is not tested for explicitly, but any unrecognized type will return out HEAPU16.
// (since most types are HEAPU16)
type-=5120;if(type==0)return HEAP8;if(type==1)return HEAPU8;if(type==2)return HEAP16;if(type==4)return HEAP32;if(type==6)return HEAPF32;if(type==5||type==28922||type==28520||type==30779||type==30782)return HEAPU32;return HEAPU16};var toTypedArrayIndex=(pointer,heap)=>pointer>>>(31-Math.clz32(heap.BYTES_PER_ELEMENT));var emscriptenWebGLGetTexPixelData=(type,format,width,height,pixels,internalFormat)=>{var heap=heapObjectForWebGLType(type);var sizePerPixel=colorChannelsInGlTextureFormat(format)*heap.BYTES_PER_ELEMENT;var bytes=computeUnpackAlignedImageSize(width,height,sizePerPixel);return heap.subarray(toTypedArrayIndex(pixels,heap),toTypedArrayIndex(pixels+bytes,heap))};var _glReadPixels=(x,y,width,height,format,type,pixels)=>{if(GL.currentContext.version>=2){if(GLctx.currentPixelPackBufferBinding){GLctx.readPixels(x,y,width,height,format,type,pixels);return}var heap=heapObjectForWebGLType(type);var target=toTypedArrayIndex(pixels,heap);GLctx.readPixels(x,y,width,height,format,type,heap,target);return}var pixelData=emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,format);if(!pixelData){GL.recordError(1280);return}GLctx.readPixels(x,y,width,height,format,type,pixelData)};var _glRenderbufferStorage=(x0,x1,x2,x3)=>GLctx.renderbufferStorage(x0,x1,x2,x3);var _glRenderbufferStorageMultisample=(x0,x1,x2,x3,x4)=>GLctx.renderbufferStorageMultisample(x0,x1,x2,x3,x4);var _glResumeTransformFeedback=()=>GLctx.resumeTransformFeedback();var _glSampleCoverage=(value,invert)=>{GLctx.sampleCoverage(value,!!invert)};var _glSamplerParameterf=(sampler,pname,param)=>{GLctx.samplerParameterf(GL.samplers[sampler],pname,param)};var _glSamplerParameteri=(sampler,pname,param)=>{GLctx.samplerParameteri(GL.samplers[sampler],pname,param)};var _glScissor=(x0,x1,x2,x3)=>GLctx.scissor(x0,x1,x2,x3);var _glShaderSource=(shader,count,string,length)=>{var source=GL.getSource(shader,count,string,length);GLctx.shaderSource(GL.shaders[shader],source)};var _glStencilFunc=(x0,x1,x2)=>GLctx.stencilFunc(x0,x1,x2);var _glStencilFuncSeparate=(x0,x1,x2,x3)=>GLctx.stencilFuncSeparate(x0,x1,x2,x3);var _glStencilMask=x0=>GLctx.stencilMask(x0);var _glStencilMaskSeparate=(x0,x1)=>GLctx.stencilMaskSeparate(x0,x1);var _glStencilOp=(x0,x1,x2)=>GLctx.stencilOp(x0,x1,x2);var _glStencilOpSeparate=(x0,x1,x2,x3)=>GLctx.stencilOpSeparate(x0,x1,x2,x3);var _glTexImage2D=(target,level,internalFormat,width,height,border,format,type,pixels)=>{if(GL.currentContext.version>=2){if(GLctx.currentPixelUnpackBufferBinding){GLctx.texImage2D(target,level,internalFormat,width,height,border,format,type,pixels);return}if(pixels){var heap=heapObjectForWebGLType(type);var index=toTypedArrayIndex(pixels,heap);GLctx.texImage2D(target,level,internalFormat,width,height,border,format,type,heap,index);return}}var pixelData=pixels?emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,internalFormat):null;GLctx.texImage2D(target,level,internalFormat,width,height,border,format,type,pixelData)};var _glTexImage3D=(target,level,internalFormat,width,height,depth,border,format,type,pixels)=>{if(GLctx.currentPixelUnpackBufferBinding){GLctx.texImage3D(target,level,internalFormat,width,height,depth,border,format,type,pixels)}else if(pixels){var heap=heapObjectForWebGLType(type);GLctx.texImage3D(target,level,internalFormat,width,height,depth,border,format,type,heap,toTypedArrayIndex(pixels,heap))}else{GLctx.texImage3D(target,level,internalFormat,width,height,depth,border,format,type,null)}};var _glTexParameterf=(x0,x1,x2)=>GLctx.texParameterf(x0,x1,x2);var _glTexParameterfv=(target,pname,params)=>{var param=HEAPF32[((params)>>2)];GLctx.texParameterf(target,pname,param)};var _glTexParameteri=(x0,x1,x2)=>GLctx.texParameteri(x0,x1,x2);var _glTexStorage2D=(x0,x1,x2,x3,x4)=>GLctx.texStorage2D(x0,x1,x2,x3,x4);var _glTexStorage3D=(x0,x1,x2,x3,x4,x5)=>GLctx.texStorage3D(x0,x1,x2,x3,x4,x5);var _glTexSubImage2D=(target,level,xoffset,yoffset,width,height,format,type,pixels)=>{if(GL.currentContext.version>=2){if(GLctx.currentPixelUnpackBufferBinding){GLctx.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,pixels);return}if(pixels){var heap=heapObjectForWebGLType(type);GLctx.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,heap,toTypedArrayIndex(pixels,heap));return}}var pixelData=pixels?emscriptenWebGLGetTexPixelData(type,format,width,height,pixels,0):null;GLctx.texSubImage2D(target,level,xoffset,yoffset,width,height,format,type,pixelData)};var _glTexSubImage3D=(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,pixels)=>{if(GLctx.currentPixelUnpackBufferBinding){GLctx.texSubImage3D(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,pixels)}else if(pixels){var heap=heapObjectForWebGLType(type);GLctx.texSubImage3D(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,heap,toTypedArrayIndex(pixels,heap))}else{GLctx.texSubImage3D(target,level,xoffset,yoffset,zoffset,width,height,depth,format,type,null)}};var _glTransformFeedbackVaryings=(program,count,varyings,bufferMode)=>{program=GL.programs[program];var vars=[];for(var i=0;i<count;i++)vars.push(UTF8ToString(HEAP32[(((varyings)+(i*4))>>2)]));GLctx.transformFeedbackVaryings(program,vars,bufferMode)};var webglGetUniformLocation=location=>{var p=GLctx.currentProgram;if(p){var webglLoc=p.uniformLocsById[location];// p.uniformLocsById[location] stores either an integer, or a
// WebGLUniformLocation.
// If an integer, we have not yet bound the location, so do it now. The
// integer value specifies the array index we should bind to.
if(typeof webglLoc=="number"){p.uniformLocsById[location]=webglLoc=GLctx.getUniformLocation(p,p.uniformArrayNamesById[location]+(webglLoc>0?`[${webglLoc}]`:""))}// Else an already cached WebGLUniformLocation, return it.
return webglLoc}else{GL.recordError(1282)}};var _glUniform1f=(location,v0)=>{GLctx.uniform1f(webglGetUniformLocation(location),v0)};var miniTempWebGLFloatBuffers=[];var _glUniform1fv=(location,count,value)=>{if(GL.currentContext.version>=2){count&&GLctx.uniform1fv(webglGetUniformLocation(location),HEAPF32,((value)>>2),count);return}if(count<=288){// avoid allocation when uploading few enough uniforms
var view=miniTempWebGLFloatBuffers[count];for(var i=0;i<count;++i){view[i]=HEAPF32[(((value)+(4*i))>>2)]}}else{var view=HEAPF32.subarray((((value)>>2)),((value+count*4)>>2))}GLctx.uniform1fv(webglGetUniformLocation(location),view)};var _glUniform1i=(location,v0)=>{GLctx.uniform1i(webglGetUniformLocation(location),v0)};var miniTempWebGLIntBuffers=[];var _glUniform1iv=(location,count,value)=>{if(GL.currentContext.version>=2){count&&GLctx.uniform1iv(webglGetUniformLocation(location),HEAP32,((value)>>2),count);return}if(count<=288){// avoid allocation when uploading few enough uniforms
var view=miniTempWebGLIntBuffers[count];for(var i=0;i<count;++i){view[i]=HEAP32[(((value)+(4*i))>>2)]}}else{var view=HEAP32.subarray((((value)>>2)),((value+count*4)>>2))}GLctx.uniform1iv(webglGetUniformLocation(location),view)};var _glUniform1ui=(location,v0)=>{GLctx.uniform1ui(webglGetUniformLocation(location),v0)};var _glUniform1uiv=(location,count,value)=>{count&&GLctx.uniform1uiv(webglGetUniformLocation(location),HEAPU32,((value)>>2),count)};var _glUniform2f=(location,v0,v1)=>{GLctx.uniform2f(webglGetUniformLocation(location),v0,v1)};var _glUniform2fv=(location,count,value)=>{if(GL.currentContext.version>=2){count&&GLctx.uniform2fv(webglGetUniformLocation(location),HEAPF32,((value)>>2),count*2);return}if(count<=144){// avoid allocation when uploading few enough uniforms
count*=2;var view=miniTempWebGLFloatBuffers[count];for(var i=0;i<count;i+=2){view[i]=HEAPF32[(((value)+(4*i))>>2)];view[i+1]=HEAPF32[(((value)+(4*i+4))>>2)]}}else{var view=HEAPF32.subarray((((value)>>2)),((value+count*8)>>2))}GLctx.uniform2fv(webglGetUniformLocation(location),view)};var _glUniform2i=(location,v0,v1)=>{GLctx.uniform2i(webglGetUniformLocation(location),v0,v1)};var _glUniform2iv=(location,count,value)=>{if(GL.currentContext.version>=2){count&&GLctx.uniform2iv(webglGetUniformLocation(location),HEAP32,((value)>>2),count*2);return}if(count<=144){// avoid allocation when uploading few enough uniforms
count*=2;var view=miniTempWebGLIntBuffers[count];for(var i=0;i<count;i+=2){view[i]=HEAP32[(((value)+(4*i))>>2)];view[i+1]=HEAP32[(((value)+(4*i+4))>>2)]}}else{var view=HEAP32.subarray((((value)>>2)),((value+count*8)>>2))}GLctx.uniform2iv(webglGetUniformLocation(location),view)};var _glUniform2ui=(location,v0,v1)=>{GLctx.uniform2ui(webglGetUniformLocation(location),v0,v1)};var _glUniform2uiv=(location,count,value)=>{count&&GLctx.uniform2uiv(webglGetUniformLocation(location),HEAPU32,((value)>>2),count*2)};var _glUniform3f=(location,v0,v1,v2)=>{GLctx.uniform3f(webglGetUniformLocation(location),v0,v1,v2)};var _glUniform3fv=(location,count,value)=>{if(GL.currentContext.version>=2){count&&GLctx.uniform3fv(webglGetUniformLocation(location),HEAPF32,((value)>>2),count*3);return}if(count<=96){// avoid allocation when uploading few enough uniforms
count*=3;var view=miniTempWebGLFloatBuffers[count];for(var i=0;i<count;i+=3){view[i]=HEAPF32[(((value)+(4*i))>>2)];view[i+1]=HEAPF32[(((value)+(4*i+4))>>2)];view[i+2]=HEAPF32[(((value)+(4*i+8))>>2)]}}else{var view=HEAPF32.subarray((((value)>>2)),((value+count*12)>>2))}GLctx.uniform3fv(webglGetUniformLocation(location),view)};var _glUniform3i=(location,v0,v1,v2)=>{GLctx.uniform3i(webglGetUniformLocation(location),v0,v1,v2)};var _glUniform3iv=(location,count,value)=>{if(GL.currentContext.version>=2){count&&GLctx.uniform3iv(webglGetUniformLocation(location),HEAP32,((value)>>2),count*3);return}if(count<=96){// avoid allocation when uploading few enough uniforms
count*=3;var view=miniTempWebGLIntBuffers[count];for(var i=0;i<count;i+=3){view[i]=HEAP32[(((value)+(4*i))>>2)];view[i+1]=HEAP32[(((value)+(4*i+4))>>2)];view[i+2]=HEAP32[(((value)+(4*i+8))>>2)]}}else{var view=HEAP32.subarray((((value)>>2)),((value+count*12)>>2))}GLctx.uniform3iv(webglGetUniformLocation(location),view)};var _glUniform3ui=(location,v0,v1,v2)=>{GLctx.uniform3ui(webglGetUniformLocation(location),v0,v1,v2)};var _glUniform3uiv=(location,count,value)=>{count&&GLctx.uniform3uiv(webglGetUniformLocation(location),HEAPU32,((value)>>2),count*3)};var _glUniform4f=(location,v0,v1,v2,v3)=>{GLctx.uniform4f(webglGetUniformLocation(location),v0,v1,v2,v3)};var _glUniform4fv=(location,count,value)=>{if(GL.currentContext.version>=2){count&&GLctx.uniform4fv(webglGetUniformLocation(location),HEAPF32,((value)>>2),count*4);return}if(count<=72){// avoid allocation when uploading few enough uniforms
var view=miniTempWebGLFloatBuffers[4*count];// hoist the heap out of the loop for size and for pthreads+growth.
var heap=HEAPF32;value=((value)>>2);count*=4;for(var i=0;i<count;i+=4){var dst=value+i;view[i]=heap[dst];view[i+1]=heap[dst+1];view[i+2]=heap[dst+2];view[i+3]=heap[dst+3]}}else{var view=HEAPF32.subarray((((value)>>2)),((value+count*16)>>2))}GLctx.uniform4fv(webglGetUniformLocation(location),view)};var _glUniform4i=(location,v0,v1,v2,v3)=>{GLctx.uniform4i(webglGetUniformLocation(location),v0,v1,v2,v3)};var _glUniform4iv=(location,count,value)=>{if(GL.currentContext.version>=2){count&&GLctx.uniform4iv(webglGetUniformLocation(location),HEAP32,((value)>>2),count*4);return}if(count<=72){// avoid allocation when uploading few enough uniforms
count*=4;var view=miniTempWebGLIntBuffers[count];for(var i=0;i<count;i+=4){view[i]=HEAP32[(((value)+(4*i))>>2)];view[i+1]=HEAP32[(((value)+(4*i+4))>>2)];view[i+2]=HEAP32[(((value)+(4*i+8))>>2)];view[i+3]=HEAP32[(((value)+(4*i+12))>>2)]}}else{var view=HEAP32.subarray((((value)>>2)),((value+count*16)>>2))}GLctx.uniform4iv(webglGetUniformLocation(location),view)};var _glUniform4ui=(location,v0,v1,v2,v3)=>{GLctx.uniform4ui(webglGetUniformLocation(location),v0,v1,v2,v3)};var _glUniform4uiv=(location,count,value)=>{count&&GLctx.uniform4uiv(webglGetUniformLocation(location),HEAPU32,((value)>>2),count*4)};var _glUniformBlockBinding=(program,uniformBlockIndex,uniformBlockBinding)=>{program=GL.programs[program];GLctx.uniformBlockBinding(program,uniformBlockIndex,uniformBlockBinding)};var _glUniformMatrix2fv=(location,count,transpose,value)=>{if(GL.currentContext.version>=2){count&&GLctx.uniformMatrix2fv(webglGetUniformLocation(location),!!transpose,HEAPF32,((value)>>2),count*4);return}if(count<=72){// avoid allocation when uploading few enough uniforms
count*=4;var view=miniTempWebGLFloatBuffers[count];for(var i=0;i<count;i+=4){view[i]=HEAPF32[(((value)+(4*i))>>2)];view[i+1]=HEAPF32[(((value)+(4*i+4))>>2)];view[i+2]=HEAPF32[(((value)+(4*i+8))>>2)];view[i+3]=HEAPF32[(((value)+(4*i+12))>>2)]}}else{var view=HEAPF32.subarray((((value)>>2)),((value+count*16)>>2))}GLctx.uniformMatrix2fv(webglGetUniformLocation(location),!!transpose,view)};var _glUniformMatrix2x3fv=(location,count,transpose,value)=>{count&&GLctx.uniformMatrix2x3fv(webglGetUniformLocation(location),!!transpose,HEAPF32,((value)>>2),count*6)};var _glUniformMatrix2x4fv=(location,count,transpose,value)=>{count&&GLctx.uniformMatrix2x4fv(webglGetUniformLocation(location),!!transpose,HEAPF32,((value)>>2),count*8)};var _glUniformMatrix3fv=(location,count,transpose,value)=>{if(GL.currentContext.version>=2){count&&GLctx.uniformMatrix3fv(webglGetUniformLocation(location),!!transpose,HEAPF32,((value)>>2),count*9);return}if(count<=32){// avoid allocation when uploading few enough uniforms
count*=9;var view=miniTempWebGLFloatBuffers[count];for(var i=0;i<count;i+=9){view[i]=HEAPF32[(((value)+(4*i))>>2)];view[i+1]=HEAPF32[(((value)+(4*i+4))>>2)];view[i+2]=HEAPF32[(((value)+(4*i+8))>>2)];view[i+3]=HEAPF32[(((value)+(4*i+12))>>2)];view[i+4]=HEAPF32[(((value)+(4*i+16))>>2)];view[i+5]=HEAPF32[(((value)+(4*i+20))>>2)];view[i+6]=HEAPF32[(((value)+(4*i+24))>>2)];view[i+7]=HEAPF32[(((value)+(4*i+28))>>2)];view[i+8]=HEAPF32[(((value)+(4*i+32))>>2)]}}else{var view=HEAPF32.subarray((((value)>>2)),((value+count*36)>>2))}GLctx.uniformMatrix3fv(webglGetUniformLocation(location),!!transpose,view)};var _glUniformMatrix3x2fv=(location,count,transpose,value)=>{count&&GLctx.uniformMatrix3x2fv(webglGetUniformLocation(location),!!transpose,HEAPF32,((value)>>2),count*6)};var _glUniformMatrix3x4fv=(location,count,transpose,value)=>{count&&GLctx.uniformMatrix3x4fv(webglGetUniformLocation(location),!!transpose,HEAPF32,((value)>>2),count*12)};var _glUniformMatrix4fv=(location,count,transpose,value)=>{if(GL.currentContext.version>=2){count&&GLctx.uniformMatrix4fv(webglGetUniformLocation(location),!!transpose,HEAPF32,((value)>>2),count*16);return}if(count<=18){// avoid allocation when uploading few enough uniforms
var view=miniTempWebGLFloatBuffers[16*count];// hoist the heap out of the loop for size and for pthreads+growth.
var heap=HEAPF32;value=((value)>>2);count*=16;for(var i=0;i<count;i+=16){var dst=value+i;view[i]=heap[dst];view[i+1]=heap[dst+1];view[i+2]=heap[dst+2];view[i+3]=heap[dst+3];view[i+4]=heap[dst+4];view[i+5]=heap[dst+5];view[i+6]=heap[dst+6];view[i+7]=heap[dst+7];view[i+8]=heap[dst+8];view[i+9]=heap[dst+9];view[i+10]=heap[dst+10];view[i+11]=heap[dst+11];view[i+12]=heap[dst+12];view[i+13]=heap[dst+13];view[i+14]=heap[dst+14];view[i+15]=heap[dst+15]}}else{var view=HEAPF32.subarray((((value)>>2)),((value+count*64)>>2))}GLctx.uniformMatrix4fv(webglGetUniformLocation(location),!!transpose,view)};var _glUniformMatrix4x2fv=(location,count,transpose,value)=>{count&&GLctx.uniformMatrix4x2fv(webglGetUniformLocation(location),!!transpose,HEAPF32,((value)>>2),count*8)};var _glUniformMatrix4x3fv=(location,count,transpose,value)=>{count&&GLctx.uniformMatrix4x3fv(webglGetUniformLocation(location),!!transpose,HEAPF32,((value)>>2),count*12)};var _glUseProgram=program=>{program=GL.programs[program];GLctx.useProgram(program);// Record the currently active program so that we can access the uniform
// mapping table of that program.
GLctx.currentProgram=program};var _glValidateProgram=program=>{GLctx.validateProgram(GL.programs[program])};var _glVertexAttrib1f=(x0,x1)=>GLctx.vertexAttrib1f(x0,x1);var _glVertexAttrib1fv=(index,v)=>{GLctx.vertexAttrib1f(index,HEAPF32[v>>2])};var _glVertexAttrib2f=(x0,x1,x2)=>GLctx.vertexAttrib2f(x0,x1,x2);var _glVertexAttrib2fv=(index,v)=>{GLctx.vertexAttrib2f(index,HEAPF32[v>>2],HEAPF32[v+4>>2])};var _glVertexAttrib3f=(x0,x1,x2,x3)=>GLctx.vertexAttrib3f(x0,x1,x2,x3);var _glVertexAttrib3fv=(index,v)=>{GLctx.vertexAttrib3f(index,HEAPF32[v>>2],HEAPF32[v+4>>2],HEAPF32[v+8>>2])};var _glVertexAttrib4f=(x0,x1,x2,x3,x4)=>GLctx.vertexAttrib4f(x0,x1,x2,x3,x4);var _glVertexAttrib4fv=(index,v)=>{GLctx.vertexAttrib4f(index,HEAPF32[v>>2],HEAPF32[v+4>>2],HEAPF32[v+8>>2],HEAPF32[v+12>>2])};var _glVertexAttribDivisor=(index,divisor)=>{GLctx.vertexAttribDivisor(index,divisor)};var _glVertexAttribI4i=(x0,x1,x2,x3,x4)=>GLctx.vertexAttribI4i(x0,x1,x2,x3,x4);var _glVertexAttribI4iv=(index,v)=>{GLctx.vertexAttribI4i(index,HEAP32[v>>2],HEAP32[v+4>>2],HEAP32[v+8>>2],HEAP32[v+12>>2])};var _glVertexAttribI4ui=(x0,x1,x2,x3,x4)=>GLctx.vertexAttribI4ui(x0,x1,x2,x3,x4);var _glVertexAttribI4uiv=(index,v)=>{GLctx.vertexAttribI4ui(index,HEAPU32[v>>2],HEAPU32[v+4>>2],HEAPU32[v+8>>2],HEAPU32[v+12>>2])};var _glVertexAttribIPointer=(index,size,type,stride,ptr)=>{var cb=GL.currentContext.clientBuffers[index];if(!GLctx.currentArrayBufferBinding){cb.size=size;cb.type=type;cb.normalized=false;cb.stride=stride;cb.ptr=ptr;cb.clientside=true;cb.vertexAttribPointerAdaptor=function(index,size,type,normalized,stride,ptr){this.vertexAttribIPointer(index,size,type,stride,ptr)};return}cb.clientside=false;GLctx.vertexAttribIPointer(index,size,type,stride,ptr)};var _glVertexAttribPointer=(index,size,type,normalized,stride,ptr)=>{var cb=GL.currentContext.clientBuffers[index];if(!GLctx.currentArrayBufferBinding){cb.size=size;cb.type=type;cb.normalized=normalized;cb.stride=stride;cb.ptr=ptr;cb.clientside=true;cb.vertexAttribPointerAdaptor=function(index,size,type,normalized,stride,ptr){this.vertexAttribPointer(index,size,type,normalized,stride,ptr)};return}cb.clientside=false;GLctx.vertexAttribPointer(index,size,type,!!normalized,stride,ptr)};var _glViewport=(x0,x1,x2,x3)=>GLctx.viewport(x0,x1,x2,x3);var _glWaitSync=(sync,flags,timeout_low,timeout_high)=>{// See WebGL2 vs GLES3 difference on GL_TIMEOUT_IGNORED above (https://www.khronos.org/registry/webgl/specs/latest/2.0/#5.15)
var timeout=convertI32PairToI53(timeout_low,timeout_high);GLctx.waitSync(GL.syncs[sync],flags,timeout)};function _mediapipe_find_canvas_event_target(canvasSelector){let target=findCanvasEventTarget(canvasSelector);// WebGPU-on-worker uses this function to try to grab the canvas, but
// doesn't have a DOM element to find. So as a quick patch, if the default
// behavior is unsuccessful here then we try a webgpu canvas property
// which is set by the user directly on the Module, much like how our old
// pipeline used the Module.canvas property. See b/265271517 for details.
if(Module&&!target){target=Module.canvasWebGpu}return Emval.toHandle(target)}function _mediapipe_webgl_get_current_ctx_canvas(){return Emval.toHandle(GLctx.canvas)}function _mediapipe_webgl_tex_image_drawable(drawableHandle){const drawable=Emval.toValue(drawableHandle);GLctx.texImage2D(GLctx.TEXTURE_2D,0,GLctx.RGBA,GLctx.RGBA,GLctx.UNSIGNED_BYTE,drawable)}function _random_get(buffer,size){try{randomFill(HEAPU8.subarray(buffer,buffer+size));return 0}catch(e){if(typeof FS=="undefined"||!(e.name==="ErrnoError"))throw e;return e.errno}}var _wgpuBufferGetSize=function(bufferPtr){var ret=(()=>{var buffer=WebGPU.getJsObject(bufferPtr);// 64-bit
return buffer.size})();return(setTempRet0((tempDouble=ret,(+(Math.abs(tempDouble)))>=1?(tempDouble>0?(+(Math.floor((tempDouble)/4294967296)))>>>0:(~~((+(Math.ceil((tempDouble-+(((~~(tempDouble)))>>>0))/4294967296)))))>>>0):0)),ret>>>0)};var _wgpuBufferGetUsage=function(bufferPtr){var ret=(()=>{var buffer=WebGPU.getJsObject(bufferPtr);return buffer.usage})();return(setTempRet0((tempDouble=ret,(+(Math.abs(tempDouble)))>=1?(tempDouble>0?(+(Math.floor((tempDouble)/4294967296)))>>>0:(~~((+(Math.ceil((tempDouble-+(((~~(tempDouble)))>>>0))/4294967296)))))>>>0):0)),ret>>>0)};var _wgpuCommandEncoderBeginComputePass=(encoderPtr,descriptor)=>{var desc;if(descriptor){desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"timestampWrites":WebGPU.makePassTimestampWrites(HEAPU32[(((descriptor)+(12))>>2)])}}var commandEncoder=WebGPU.getJsObject(encoderPtr);var ptr=_emwgpuCreateComputePassEncoder(0);WebGPU.Internals.jsObjectInsert(ptr,commandEncoder.beginComputePass(desc));return ptr};var _wgpuCommandEncoderBeginRenderPass=(encoderPtr,descriptor)=>{function makeColorAttachment(caPtr){var viewPtr=HEAPU32[(((caPtr)+(4))>>2)];if(viewPtr===0){// view could be undefined.
return undefined}var depthSlice=HEAP32[(((caPtr)+(8))>>2)];if(depthSlice==-1)depthSlice=undefined;var loadOpInt=HEAPU32[(((caPtr)+(16))>>2)];var storeOpInt=HEAPU32[(((caPtr)+(20))>>2)];var clearValue=WebGPU.makeColor(caPtr+24);return{"view":WebGPU.getJsObject(viewPtr),"depthSlice":depthSlice,"resolveTarget":WebGPU.getJsObject(HEAPU32[(((caPtr)+(12))>>2)]),"clearValue":clearValue,"loadOp":WebGPU.LoadOp[loadOpInt],"storeOp":WebGPU.StoreOp[storeOpInt]}}function makeColorAttachments(count,caPtr){var attachments=[];for(var i=0;i<count;++i){attachments.push(makeColorAttachment(caPtr+56*i))}return attachments}function makeDepthStencilAttachment(dsaPtr){if(dsaPtr===0)return undefined;return{"view":WebGPU.getJsObject(HEAPU32[(((dsaPtr)+(4))>>2)]),"depthClearValue":HEAPF32[(((dsaPtr)+(16))>>2)],"depthLoadOp":WebGPU.LoadOp[HEAPU32[(((dsaPtr)+(8))>>2)]],"depthStoreOp":WebGPU.StoreOp[HEAPU32[(((dsaPtr)+(12))>>2)]],"depthReadOnly":!!(HEAPU32[(((dsaPtr)+(20))>>2)]),"stencilClearValue":HEAPU32[(((dsaPtr)+(32))>>2)],"stencilLoadOp":WebGPU.LoadOp[HEAPU32[(((dsaPtr)+(24))>>2)]],"stencilStoreOp":WebGPU.StoreOp[HEAPU32[(((dsaPtr)+(28))>>2)]],"stencilReadOnly":!!(HEAPU32[(((dsaPtr)+(36))>>2)])}}function makeRenderPassDescriptor(descriptor){var nextInChainPtr=HEAPU32[((descriptor)>>2)];var maxDrawCount=undefined;if(nextInChainPtr!==0){var sType=HEAPU32[(((nextInChainPtr)+(4))>>2)];var renderPassMaxDrawCount=nextInChainPtr;maxDrawCount=(HEAPU32[((((renderPassMaxDrawCount+4))+(8))>>2)]*4294967296+HEAPU32[(((renderPassMaxDrawCount)+(8))>>2)])}var desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"colorAttachments":makeColorAttachments(HEAPU32[(((descriptor)+(12))>>2)],HEAPU32[(((descriptor)+(16))>>2)]),"depthStencilAttachment":makeDepthStencilAttachment(HEAPU32[(((descriptor)+(20))>>2)]),"occlusionQuerySet":WebGPU.getJsObject(HEAPU32[(((descriptor)+(24))>>2)]),"timestampWrites":WebGPU.makePassTimestampWrites(HEAPU32[(((descriptor)+(28))>>2)]),"maxDrawCount":maxDrawCount};return desc}var desc=makeRenderPassDescriptor(descriptor);var commandEncoder=WebGPU.getJsObject(encoderPtr);var ptr=_emwgpuCreateRenderPassEncoder(0);WebGPU.Internals.jsObjectInsert(ptr,commandEncoder.beginRenderPass(desc));return ptr};function _wgpuCommandEncoderCopyBufferToBuffer(encoderPtr,srcPtr,srcOffset_low,srcOffset_high,dstPtr,dstOffset_low,dstOffset_high,size_low,size_high){var srcOffset=convertI32PairToI53Checked(srcOffset_low,srcOffset_high);var dstOffset=convertI32PairToI53Checked(dstOffset_low,dstOffset_high);var size=convertI32PairToI53Checked(size_low,size_high);var commandEncoder=WebGPU.getJsObject(encoderPtr);var src=WebGPU.getJsObject(srcPtr);var dst=WebGPU.getJsObject(dstPtr);commandEncoder.copyBufferToBuffer(src,srcOffset,dst,dstOffset,size)}var _wgpuCommandEncoderCopyBufferToTexture=(encoderPtr,srcPtr,dstPtr,copySizePtr)=>{var commandEncoder=WebGPU.getJsObject(encoderPtr);var copySize=WebGPU.makeExtent3D(copySizePtr);commandEncoder.copyBufferToTexture(WebGPU.makeTexelCopyBufferInfo(srcPtr),WebGPU.makeTexelCopyTextureInfo(dstPtr),copySize)};var _wgpuCommandEncoderCopyTextureToBuffer=(encoderPtr,srcPtr,dstPtr,copySizePtr)=>{var commandEncoder=WebGPU.getJsObject(encoderPtr);var copySize=WebGPU.makeExtent3D(copySizePtr);commandEncoder.copyTextureToBuffer(WebGPU.makeTexelCopyTextureInfo(srcPtr),WebGPU.makeTexelCopyBufferInfo(dstPtr),copySize)};var _wgpuCommandEncoderCopyTextureToTexture=(encoderPtr,srcPtr,dstPtr,copySizePtr)=>{var commandEncoder=WebGPU.getJsObject(encoderPtr);var copySize=WebGPU.makeExtent3D(copySizePtr);commandEncoder.copyTextureToTexture(WebGPU.makeTexelCopyTextureInfo(srcPtr),WebGPU.makeTexelCopyTextureInfo(dstPtr),copySize)};var _wgpuCommandEncoderFinish=(encoderPtr,descriptor)=>{// TODO: Use the descriptor.
var commandEncoder=WebGPU.getJsObject(encoderPtr);var ptr=_emwgpuCreateCommandBuffer(0);WebGPU.Internals.jsObjectInsert(ptr,commandEncoder.finish());return ptr};function _wgpuCommandEncoderResolveQuerySet(encoderPtr,querySetPtr,firstQuery,queryCount,destinationPtr,destinationOffset_low,destinationOffset_high){var destinationOffset=convertI32PairToI53Checked(destinationOffset_low,destinationOffset_high);var commandEncoder=WebGPU.getJsObject(encoderPtr);var querySet=WebGPU.getJsObject(querySetPtr);var destination=WebGPU.getJsObject(destinationPtr);commandEncoder.resolveQuerySet(querySet,firstQuery,queryCount,destination,destinationOffset)}var _wgpuComputePassEncoderDispatchWorkgroups=(passPtr,x,y,z)=>{var pass=WebGPU.getJsObject(passPtr);pass.dispatchWorkgroups(x,y,z)};var _wgpuComputePassEncoderEnd=passPtr=>{var pass=WebGPU.getJsObject(passPtr);pass.end()};var _wgpuComputePassEncoderSetBindGroup=(passPtr,groupIndex,groupPtr,dynamicOffsetCount,dynamicOffsetsPtr)=>{var pass=WebGPU.getJsObject(passPtr);var group=WebGPU.getJsObject(groupPtr);if(dynamicOffsetCount==0){pass.setBindGroup(groupIndex,group)}else{pass.setBindGroup(groupIndex,group,HEAPU32,((dynamicOffsetsPtr)>>2),dynamicOffsetCount)}};var _wgpuComputePassEncoderSetPipeline=(passPtr,pipelinePtr)=>{var pass=WebGPU.getJsObject(passPtr);var pipeline=WebGPU.getJsObject(pipelinePtr);pass.setPipeline(pipeline)};var _wgpuComputePipelineGetBindGroupLayout=(pipelinePtr,groupIndex)=>{var pipeline=WebGPU.getJsObject(pipelinePtr);var ptr=_emwgpuCreateBindGroupLayout(0);WebGPU.Internals.jsObjectInsert(ptr,pipeline.getBindGroupLayout(groupIndex));return ptr};var readI53FromI64=ptr=>HEAPU32[((ptr)>>2)]+HEAP32[(((ptr)+(4))>>2)]*4294967296;var _wgpuDeviceCreateBindGroup=(devicePtr,descriptor)=>{function makeEntry(entryPtr){var bufferPtr=HEAPU32[(((entryPtr)+(8))>>2)];var samplerPtr=HEAPU32[(((entryPtr)+(32))>>2)];var textureViewPtr=HEAPU32[(((entryPtr)+(36))>>2)];var binding=HEAPU32[(((entryPtr)+(4))>>2)];if(bufferPtr){var size=readI53FromI64((entryPtr)+(24));if(size==-1)size=undefined;return{"binding":binding,"resource":{"buffer":WebGPU.getJsObject(bufferPtr),"offset":(HEAPU32[((((entryPtr+4))+(16))>>2)]*4294967296+HEAPU32[(((entryPtr)+(16))>>2)]),"size":size}}}else if(samplerPtr){return{"binding":binding,"resource":WebGPU.getJsObject(samplerPtr)}}else{return{"binding":binding,"resource":WebGPU.getJsObject(textureViewPtr)}}}function makeEntries(count,entriesPtrs){var entries=[];for(var i=0;i<count;++i){entries.push(makeEntry(entriesPtrs+40*i))}return entries}var desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"layout":WebGPU.getJsObject(HEAPU32[(((descriptor)+(12))>>2)]),"entries":makeEntries(HEAPU32[(((descriptor)+(16))>>2)],HEAPU32[(((descriptor)+(20))>>2)])};var device=WebGPU.getJsObject(devicePtr);var ptr=_emwgpuCreateBindGroup(0);WebGPU.Internals.jsObjectInsert(ptr,device.createBindGroup(desc));return ptr};var _wgpuDeviceCreateBindGroupLayout=(devicePtr,descriptor)=>{function makeBufferEntry(entryPtr){var typeInt=HEAPU32[(((entryPtr)+(4))>>2)];if(!typeInt)return undefined;return{"type":WebGPU.BufferBindingType[typeInt],"hasDynamicOffset":!!(HEAPU32[(((entryPtr)+(8))>>2)]),"minBindingSize":(HEAPU32[((((entryPtr+4))+(16))>>2)]*4294967296+HEAPU32[(((entryPtr)+(16))>>2)])}}function makeSamplerEntry(entryPtr){var typeInt=HEAPU32[(((entryPtr)+(4))>>2)];if(!typeInt)return undefined;return{"type":WebGPU.SamplerBindingType[typeInt]}}function makeTextureEntry(entryPtr){var sampleTypeInt=HEAPU32[(((entryPtr)+(4))>>2)];if(!sampleTypeInt)return undefined;return{"sampleType":WebGPU.TextureSampleType[sampleTypeInt],"viewDimension":WebGPU.TextureViewDimension[HEAPU32[(((entryPtr)+(8))>>2)]],"multisampled":!!(HEAPU32[(((entryPtr)+(12))>>2)])}}function makeStorageTextureEntry(entryPtr){var accessInt=HEAPU32[(((entryPtr)+(4))>>2)];if(!accessInt)return undefined;return{"access":WebGPU.StorageTextureAccess[accessInt],"format":WebGPU.TextureFormat[HEAPU32[(((entryPtr)+(8))>>2)]],"viewDimension":WebGPU.TextureViewDimension[HEAPU32[(((entryPtr)+(12))>>2)]]}}function makeEntry(entryPtr){return{"binding":HEAPU32[(((entryPtr)+(4))>>2)],"visibility":HEAPU32[(((entryPtr)+(8))>>2)],"buffer":makeBufferEntry(entryPtr+24),"sampler":makeSamplerEntry(entryPtr+48),"texture":makeTextureEntry(entryPtr+56),"storageTexture":makeStorageTextureEntry(entryPtr+72)}}function makeEntries(count,entriesPtrs){var entries=[];for(var i=0;i<count;++i){entries.push(makeEntry(entriesPtrs+88*i))}return entries}var desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"entries":makeEntries(HEAPU32[(((descriptor)+(12))>>2)],HEAPU32[(((descriptor)+(16))>>2)])};var device=WebGPU.getJsObject(devicePtr);var ptr=_emwgpuCreateBindGroupLayout(0);WebGPU.Internals.jsObjectInsert(ptr,device.createBindGroupLayout(desc));return ptr};var _wgpuDeviceCreateCommandEncoder=(devicePtr,descriptor)=>{var desc;if(descriptor){desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4)}}var device=WebGPU.getJsObject(devicePtr);var ptr=_emwgpuCreateCommandEncoder(0);WebGPU.Internals.jsObjectInsert(ptr,device.createCommandEncoder(desc));return ptr};var _wgpuDeviceCreateComputePipeline=(devicePtr,descriptor)=>{var desc=WebGPU.makeComputePipelineDesc(descriptor);var device=WebGPU.getJsObject(devicePtr);var ptr=_emwgpuCreateComputePipeline(0);WebGPU.Internals.jsObjectInsert(ptr,device.createComputePipeline(desc));return ptr};var _wgpuDeviceCreatePipelineLayout=(devicePtr,descriptor)=>{var bglCount=HEAPU32[(((descriptor)+(12))>>2)];var bglPtr=HEAPU32[(((descriptor)+(16))>>2)];var bgls=[];for(var i=0;i<bglCount;++i){bgls.push(WebGPU.getJsObject(HEAPU32[(((bglPtr)+(4*i))>>2)]))}var desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"bindGroupLayouts":bgls};var device=WebGPU.getJsObject(devicePtr);var ptr=_emwgpuCreatePipelineLayout(0);WebGPU.Internals.jsObjectInsert(ptr,device.createPipelineLayout(desc));return ptr};var _wgpuDeviceCreateQuerySet=(devicePtr,descriptor)=>{var desc={"type":WebGPU.QueryType[HEAPU32[(((descriptor)+(12))>>2)]],"count":HEAPU32[(((descriptor)+(16))>>2)]};var device=WebGPU.getJsObject(devicePtr);var ptr=_emwgpuCreateQuerySet(0);WebGPU.Internals.jsObjectInsert(ptr,device.createQuerySet(desc));return ptr};var _wgpuDeviceCreateRenderPipeline=(devicePtr,descriptor)=>{var desc=WebGPU.makeRenderPipelineDesc(descriptor);var device=WebGPU.getJsObject(devicePtr);var ptr=_emwgpuCreateRenderPipeline(0);WebGPU.Internals.jsObjectInsert(ptr,device.createRenderPipeline(desc));return ptr};var _wgpuDeviceCreateSampler=(devicePtr,descriptor)=>{var desc;if(descriptor){desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"addressModeU":WebGPU.AddressMode[HEAPU32[(((descriptor)+(12))>>2)]],"addressModeV":WebGPU.AddressMode[HEAPU32[(((descriptor)+(16))>>2)]],"addressModeW":WebGPU.AddressMode[HEAPU32[(((descriptor)+(20))>>2)]],"magFilter":WebGPU.FilterMode[HEAPU32[(((descriptor)+(24))>>2)]],"minFilter":WebGPU.FilterMode[HEAPU32[(((descriptor)+(28))>>2)]],"mipmapFilter":WebGPU.MipmapFilterMode[HEAPU32[(((descriptor)+(32))>>2)]],"lodMinClamp":HEAPF32[(((descriptor)+(36))>>2)],"lodMaxClamp":HEAPF32[(((descriptor)+(40))>>2)],"compare":WebGPU.CompareFunction[HEAPU32[(((descriptor)+(44))>>2)]],"maxAnisotropy":HEAPU16[(((descriptor)+(48))>>1)]}}var device=WebGPU.getJsObject(devicePtr);var ptr=_emwgpuCreateSampler(0);WebGPU.Internals.jsObjectInsert(ptr,device.createSampler(desc));return ptr};var _wgpuDeviceCreateTexture=(devicePtr,descriptor)=>{var desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"size":WebGPU.makeExtent3D(descriptor+28),"mipLevelCount":HEAPU32[(((descriptor)+(44))>>2)],"sampleCount":HEAPU32[(((descriptor)+(48))>>2)],"dimension":WebGPU.TextureDimension[HEAPU32[(((descriptor)+(24))>>2)]],"format":WebGPU.TextureFormat[HEAPU32[(((descriptor)+(40))>>2)]],"usage":HEAPU32[(((descriptor)+(16))>>2)]};var viewFormatCount=HEAPU32[(((descriptor)+(52))>>2)];if(viewFormatCount){var viewFormatsPtr=HEAPU32[(((descriptor)+(56))>>2)];// viewFormatsPtr pointer to an array of TextureFormat which is an enum of size uint32_t
desc["viewFormats"]=Array.from(HEAP32.subarray((((viewFormatsPtr)>>2)),((viewFormatsPtr+viewFormatCount*4)>>2)),format=>WebGPU.TextureFormat[format])}var device=WebGPU.getJsObject(devicePtr);var ptr=_emwgpuCreateTexture(0);WebGPU.Internals.jsObjectInsert(ptr,device.createTexture(desc));return ptr};var _wgpuDeviceGetLimits=(devicePtr,limitsOutPtr)=>{var device=WebGPU.getJsObject(devicePtr);WebGPU.fillLimitStruct(device.limits,limitsOutPtr);return 1};var _wgpuDeviceHasFeature=(devicePtr,featureEnumValue)=>{var device=WebGPU.getJsObject(devicePtr);return device.features.has(WebGPU.FeatureName[featureEnumValue])};var _wgpuDevicePushErrorScope=(devicePtr,filter)=>{var device=WebGPU.getJsObject(devicePtr);device.pushErrorScope(WebGPU.ErrorFilter[filter])};var _wgpuQueueSubmit=(queuePtr,commandCount,commands)=>{var queue=WebGPU.getJsObject(queuePtr);var cmds=Array.from(HEAP32.subarray((((commands)>>2)),((commands+commandCount*4)>>2)),id=>WebGPU.getJsObject(id));queue.submit(cmds)};function _wgpuQueueWriteBuffer(queuePtr,bufferPtr,bufferOffset_low,bufferOffset_high,data,size){var bufferOffset=convertI32PairToI53Checked(bufferOffset_low,bufferOffset_high);var queue=WebGPU.getJsObject(queuePtr);var buffer=WebGPU.getJsObject(bufferPtr);// There is a size limitation for ArrayBufferView. Work around by passing in a subarray
// instead of the whole heap. crbug.com/1201109
var subarray=HEAPU8.subarray(data,data+size);queue.writeBuffer(buffer,bufferOffset,subarray,0,size)}var _wgpuQueueWriteTexture=(queuePtr,destinationPtr,data,dataSize,dataLayoutPtr,writeSizePtr)=>{var queue=WebGPU.getJsObject(queuePtr);var destination=WebGPU.makeTexelCopyTextureInfo(destinationPtr);var dataLayout=WebGPU.makeTexelCopyBufferLayout(dataLayoutPtr);var writeSize=WebGPU.makeExtent3D(writeSizePtr);// This subarray isn't strictly necessary, but helps work around an issue
// where Chromium makes a copy of the entire heap. crbug.com/1134457
var subarray=HEAPU8.subarray(data,data+dataSize);queue.writeTexture(destination,subarray,dataLayout,writeSize)};var _wgpuRenderPassEncoderDraw=(passPtr,vertexCount,instanceCount,firstVertex,firstInstance)=>{firstVertex>>>=0;firstInstance>>>=0;var pass=WebGPU.getJsObject(passPtr);pass.draw(vertexCount,instanceCount,firstVertex,firstInstance)};var _wgpuRenderPassEncoderEnd=encoderPtr=>{var encoder=WebGPU.getJsObject(encoderPtr);encoder.end()};var _wgpuRenderPassEncoderSetBindGroup=(passPtr,groupIndex,groupPtr,dynamicOffsetCount,dynamicOffsetsPtr)=>{var pass=WebGPU.getJsObject(passPtr);var group=WebGPU.getJsObject(groupPtr);if(dynamicOffsetCount==0){pass.setBindGroup(groupIndex,group)}else{pass.setBindGroup(groupIndex,group,HEAPU32,((dynamicOffsetsPtr)>>2),dynamicOffsetCount)}};var _wgpuRenderPassEncoderSetPipeline=(passPtr,pipelinePtr)=>{var pass=WebGPU.getJsObject(passPtr);var pipeline=WebGPU.getJsObject(pipelinePtr);pass.setPipeline(pipeline)};var _wgpuRenderPipelineGetBindGroupLayout=(pipelinePtr,groupIndex)=>{var pipeline=WebGPU.getJsObject(pipelinePtr);var ptr=_emwgpuCreateBindGroupLayout(0);WebGPU.Internals.jsObjectInsert(ptr,pipeline.getBindGroupLayout(groupIndex));return ptr};var _wgpuTextureCreateView=(texturePtr,descriptor)=>{var desc;if(descriptor){var mipLevelCount=HEAPU32[(((descriptor)+(24))>>2)];var arrayLayerCount=HEAPU32[(((descriptor)+(32))>>2)];desc={"label":WebGPU.makeStringFromOptionalStringView(descriptor+4),"format":WebGPU.TextureFormat[HEAPU32[(((descriptor)+(12))>>2)]],"dimension":WebGPU.TextureViewDimension[HEAPU32[(((descriptor)+(16))>>2)]],"baseMipLevel":HEAPU32[(((descriptor)+(20))>>2)],"mipLevelCount":mipLevelCount===4294967295?undefined:mipLevelCount,"baseArrayLayer":HEAPU32[(((descriptor)+(28))>>2)],"arrayLayerCount":arrayLayerCount===4294967295?undefined:arrayLayerCount,"aspect":WebGPU.TextureAspect[HEAPU32[(((descriptor)+(36))>>2)]]}}var texture=WebGPU.getJsObject(texturePtr);var ptr=_emwgpuCreateTextureView(0);WebGPU.Internals.jsObjectInsert(ptr,texture.createView(desc));return ptr};var _wgpuTextureDestroy=texturePtr=>{WebGPU.getJsObject(texturePtr).destroy()};var _wgpuTextureGetFormat=texturePtr=>{var texture=WebGPU.getJsObject(texturePtr);// Should return the enum integer instead of string.
return WebGPU.TextureFormat.indexOf(texture.format)};var FS_createPath=FS.createPath;var FS_unlink=path=>FS.unlink(path);var FS_createLazyFile=FS.createLazyFile;var FS_createDevice=FS.createDevice;FS.createPreloadedFile=FS_createPreloadedFile;FS.staticInit();// Set module methods based on EXPORTED_RUNTIME_METHODS
Module["FS_createPath"]=FS.createPath;Module["FS_createDataFile"]=FS.createDataFile;Module["FS_createPreloadedFile"]=FS.createPreloadedFile;Module["FS_unlink"]=FS.unlink;Module["FS_createLazyFile"]=FS.createLazyFile;Module["FS_createDevice"]=FS.createDevice;// This error may happen quite a bit. To avoid overhead we reuse it (and
// suffer a lack of stack info).
MEMFS.doesNotExistError=new FS.ErrnoError(44);/** @suppress {checkTypes} */MEMFS.doesNotExistError.stack="<generic error, no stack>";InternalError=Module["InternalError"]=class InternalError extends Error{constructor(message){super(message);this.name="InternalError"}};embind_init_charCodes();BindingError=Module["BindingError"]=class BindingError extends Error{constructor(message){super(message);this.name="BindingError"}};init_ClassHandle();init_RegisteredPointer();UnboundTypeError=Module["UnboundTypeError"]=extendError(Error,"UnboundTypeError");init_emval();// Signal GL rendering layer that processing of a new frame is about to
// start. This helps it optimize VBO double-buffering and reduce GPU stalls.
registerPreMainLoop(()=>GL.newRenderingFrameStarted());for(var i=0;i<32;++i)tempFixedLengthArray.push(new Array(i));var miniTempWebGLFloatBuffersStorage=new Float32Array(288);// Create GL_POOL_TEMP_BUFFERS_SIZE+1 temporary buffers, for uploads of size 0 through GL_POOL_TEMP_BUFFERS_SIZE inclusive
for(/**@suppress{duplicate}*/var i=0;i<=288;++i){miniTempWebGLFloatBuffers[i]=miniTempWebGLFloatBuffersStorage.subarray(0,i)}var miniTempWebGLIntBuffersStorage=new Int32Array(288);// Create GL_POOL_TEMP_BUFFERS_SIZE+1 temporary buffers, for uploads of size 0 through GL_POOL_TEMP_BUFFERS_SIZE inclusive
for(/**@suppress{duplicate}*/var i=0;i<=288;++i){miniTempWebGLIntBuffers[i]=miniTempWebGLIntBuffersStorage.subarray(0,i)}var wasmImports={/** @export */Uf:BeginGlQueryTiming,/** @export */Tf:EndGlQueryTiming,/** @export */Sf:ExposeMetricsInfo,/** @export */Rf:ExposeProfilingResults,/** @export */Qf:GetAdapterArchitecture,/** @export */Pf:GetAdapterDescription,/** @export */Of:GetAdapterDeviceName,/** @export */Nf:GetAdapterVendor,/** @export */Mf:HaveOffsetConverter,/** @export */Lf:JsGetDeviceMaxSubgroupSize,/** @export */Kf:JsGetDeviceMinSubgroupSize,/** @export */xb:__asyncjs__ReadBufferDataJs,/** @export */qc:__asyncjs__mediapipe_map_buffer_jspi,/** @export */A:___cxa_throw,/** @export */Jf:___syscall_dup,/** @export */If:___syscall_faccessat,/** @export */ic:___syscall_fcntl64,/** @export */Hf:___syscall_fstat64,/** @export */Gf:___syscall_ioctl,/** @export */Ff:___syscall_lstat64,/** @export */Ef:___syscall_newfstatat,/** @export */hc:___syscall_openat,/** @export */Df:___syscall_stat64,/** @export */yf:__abort_js,/** @export */fc:__embind_finalize_value_object,/** @export */Ic:__embind_register_bigint,/** @export */xf:__embind_register_bool,/** @export */wf:__embind_register_class,/** @export */x:__embind_register_class_function,/** @export */vf:__embind_register_emval,/** @export */ec:__embind_register_float,/** @export */$:__embind_register_function,/** @export */ga:__embind_register_integer,/** @export */C:__embind_register_memory_view,/** @export */uf:__embind_register_std_string,/** @export */ub:__embind_register_std_wstring,/** @export */dc:__embind_register_value_object,/** @export */pa:__embind_register_value_object_field,/** @export */tf:__embind_register_void,/** @export */ta:__emval_as,/** @export */cc:__emval_call,/** @export */tb:__emval_call_method,/** @export */p:__emval_decref,/** @export */Ha:__emval_get_global,/** @export */Ga:__emval_get_method_caller,/** @export */xa:__emval_get_property,/** @export */_:__emval_incref,/** @export */sb:__emval_instanceof,/** @export */Z:__emval_new_cstring,/** @export */O:__emval_run_destructors,/** @export */Za:__emval_set_property,/** @export */fa:__emval_take_value,/** @export */sf:__emval_typeof,/** @export */Hc:__gmtime_js,/** @export */Gc:__localtime_js,/** @export */Fc:__mktime_js,/** @export */Ec:__mmap_js,/** @export */Dc:__munmap_js,/** @export */rf:__tzset_js,/** @export */Kc:_clock_time_get,/** @export */Y:_emscripten_asm_const_int,/** @export */bc:_emscripten_asm_const_ptr,/** @export */qf:_emscripten_date_now,/** @export */rb:_emscripten_errn,/** @export */pf:_emscripten_get_heap_max,/** @export */K:_emscripten_get_now,/** @export */sa:_emscripten_has_asyncify,/** @export */of:_emscripten_pc_get_function,/** @export */nf:_emscripten_resize_heap,/** @export */mf:_emscripten_stack_snapshot,/** @export */lf:_emscripten_stack_unwind_buffer,/** @export */kf:_emscripten_webgl_create_context,/** @export */jf:_emscripten_webgl_destroy_context,/** @export */hf:_emscripten_webgl_get_context_attributes,/** @export */ac:_emscripten_webgl_get_current_context,/** @export */gf:_emscripten_webgl_make_context_current,/** @export */V:_emscripten_webgpu_get_device,/** @export */ff:_emwgpuBufferDestroy,/** @export */ef:_emwgpuBufferGetMappedRange,/** @export */df:_emwgpuBufferUnmap,/** @export */I:_emwgpuDelete,/** @export */cf:_emwgpuDeviceCreateBuffer,/** @export */Cc:_emwgpuDeviceCreateComputePipelineAsync,/** @export */Bc:_emwgpuDeviceCreateRenderPipelineAsync,/** @export */bf:_emwgpuDeviceCreateShaderModule,/** @export */af:_emwgpuDeviceDestroy,/** @export */Ac:_emwgpuDevicePopErrorScope,/** @export */zc:_emwgpuQueueOnSubmittedWorkDone,/** @export */$e:_emwgpuWaitAny,/** @export */Cf:_environ_get,/** @export */Bf:_environ_sizes_get,/** @export */Ya:_exit,/** @export */wb:_fd_close,/** @export */gc:_fd_read,/** @export */Jc:_fd_seek,/** @export */vb:_fd_write,/** @export */c:_glActiveTexture,/** @export */ra:_glAttachShader,/** @export */_e:_glBeginQuery,/** @export */Ze:_glBeginTransformFeedback,/** @export */qb:_glBindAttribLocation,/** @export */d:_glBindBuffer,/** @export */pb:_glBindBufferBase,/** @export */Ye:_glBindBufferRange,/** @export */B:_glBindFramebuffer,/** @export */Fa:_glBindRenderbuffer,/** @export */Xe:_glBindSampler,/** @export */a:_glBindTexture,/** @export */We:_glBindTransformFeedback,/** @export */g:_glBindVertexArray,/** @export */Ve:_glBlendColor,/** @export */Ue:_glBlendEquation,/** @export */Te:_glBlendEquationSeparate,/** @export */Se:_glBlendFunc,/** @export */Re:_glBlendFuncSeparate,/** @export */$b:_glBlitFramebuffer,/** @export */l:_glBufferData,/** @export */Qe:_glBufferSubData,/** @export */Pe:_glCheckFramebufferStatus,/** @export */ea:_glClear,/** @export */Oe:_glClearBufferfi,/** @export */Ne:_glClearBufferfv,/** @export */Me:_glClearBufferiv,/** @export */Le:_glClearBufferuiv,/** @export */Xa:_glClearColor,/** @export */Ke:_glClearDepthf,/** @export */Je:_glClearStencil,/** @export */yc:_glClientWaitSync,/** @export */Ie:_glColorMask,/** @export */Wa:_glCompileShader,/** @export */_b:_glCompressedTexImage2D,/** @export */Zb:_glCompressedTexImage3D,/** @export */Yb:_glCompressedTexSubImage2D,/** @export */Xb:_glCompressedTexSubImage3D,/** @export */He:_glCopyBufferSubData,/** @export */qa:_glCopyTexImage2D,/** @export */Ge:_glCopyTexSubImage2D,/** @export */Fe:_glCopyTexSubImage3D,/** @export */Va:_glCreateProgram,/** @export */Ua:_glCreateShader,/** @export */Ee:_glCullFace,/** @export */q:_glDeleteBuffers,/** @export */U:_glDeleteFramebuffers,/** @export */k:_glDeleteProgram,/** @export */ob:_glDeleteQueries,/** @export */Ta:_glDeleteRenderbuffers,/** @export */nb:_glDeleteSamplers,/** @export */oa:_glDeleteShader,/** @export */wa:_glDeleteSync,/** @export */G:_glDeleteTextures,/** @export */mb:_glDeleteTransformFeedbacks,/** @export */v:_glDeleteVertexArrays,/** @export */lb:_glDepthFunc,/** @export */De:_glDepthMask,/** @export */Ce:_glDepthRangef,/** @export */kb:_glDetachShader,/** @export */H:_glDisable,/** @export */u:_glDisableVertexAttribArray,/** @export */n:_glDrawArrays,/** @export */Be:_glDrawArraysInstanced,/** @export */Ea:_glDrawBuffers,/** @export */Ae:_glDrawElements,/** @export */ze:_glDrawElementsInstanced,/** @export */ye:_glDrawRangeElements,/** @export */xe:_glEnable,/** @export */j:_glEnableVertexAttribArray,/** @export */we:_glEndQuery,/** @export */ve:_glEndTransformFeedback,/** @export */Wb:_glFenceSync,/** @export */Da:_glFinish,/** @export */o:_glFlush,/** @export */Vb:_glFramebufferRenderbuffer,/** @export */N:_glFramebufferTexture2D,/** @export */jb:_glFramebufferTextureLayer,/** @export */ue:_glFrontFace,/** @export */s:_glGenBuffers,/** @export */na:_glGenFramebuffers,/** @export */te:_glGenQueries,/** @export */Ub:_glGenRenderbuffers,/** @export */se:_glGenSamplers,/** @export */T:_glGenTextures,/** @export */re:_glGenTransformFeedbacks,/** @export */z:_glGenVertexArrays,/** @export */ib:_glGenerateMipmap,/** @export */qe:_glGetActiveAttrib,/** @export */pe:_glGetActiveUniform,/** @export */oe:_glGetActiveUniformBlockName,/** @export */hb:_glGetActiveUniformBlockiv,/** @export */ne:_glGetActiveUniformsiv,/** @export */me:_glGetAttachedShaders,/** @export */gb:_glGetAttribLocation,/** @export */Tb:_glGetBooleanv,/** @export */Sb:_glGetBufferParameteriv,/** @export */ma:_glGetError,/** @export */Rb:_glGetFloatv,/** @export */le:_glGetFragDataLocation,/** @export */fb:_glGetFramebufferAttachmentParameteriv,/** @export */ke:_glGetInteger64i_v,/** @export */je:_glGetInteger64v,/** @export */ie:_glGetIntegeri_v,/** @export */t:_glGetIntegerv,/** @export */Qb:_glGetInternalformativ,/** @export */Pb:_glGetProgramInfoLog,/** @export */Sa:_glGetProgramiv,/** @export */he:_glGetQueryObjectuiv,/** @export */ge:_glGetQueryiv,/** @export */fe:_glGetRenderbufferParameteriv,/** @export */ee:_glGetSamplerParameterfv,/** @export */de:_glGetSamplerParameteriv,/** @export */eb:_glGetShaderInfoLog,/** @export */ce:_glGetShaderPrecisionFormat,/** @export */be:_glGetShaderSource,/** @export */Ra:_glGetShaderiv,/** @export */S:_glGetString,/** @export */ae:_glGetSynciv,/** @export */$d:_glGetTexParameterfv,/** @export */Ob:_glGetTexParameteriv,/** @export */_d:_glGetTransformFeedbackVarying,/** @export */Nb:_glGetUniformBlockIndex,/** @export */Zd:_glGetUniformIndices,/** @export */b:_glGetUniformLocation,/** @export */Yd:_glGetVertexAttribPointerv,/** @export */Xd:_glGetVertexAttribfv,/** @export */Mb:_glGetVertexAttribiv,/** @export */Wd:_glHint,/** @export */Vd:_glInvalidateFramebuffer,/** @export */Ud:_glInvalidateSubFramebuffer,/** @export */Td:_glIsBuffer,/** @export */Sd:_glIsEnabled,/** @export */Rd:_glIsFramebuffer,/** @export */Qd:_glIsProgram,/** @export */Pd:_glIsQuery,/** @export */Od:_glIsRenderbuffer,/** @export */Nd:_glIsSampler,/** @export */Md:_glIsShader,/** @export */Ld:_glIsSync,/** @export */Kd:_glIsTexture,/** @export */Jd:_glIsTransformFeedback,/** @export */Id:_glIsVertexArray,/** @export */Hd:_glLineWidth,/** @export */Qa:_glLinkProgram,/** @export */Gd:_glPauseTransformFeedback,/** @export */Ca:_glPixelStorei,/** @export */Fd:_glPolygonOffset,/** @export */Ed:_glReadBuffer,/** @export */va:_glReadPixels,/** @export */Lb:_glRenderbufferStorage,/** @export */Kb:_glRenderbufferStorageMultisample,/** @export */Dd:_glResumeTransformFeedback,/** @export */Cd:_glSampleCoverage,/** @export */Bd:_glSamplerParameterf,/** @export */Ad:_glSamplerParameteri,/** @export */zd:_glScissor,/** @export */Pa:_glShaderSource,/** @export */yd:_glStencilFunc,/** @export */xd:_glStencilFuncSeparate,/** @export */wd:_glStencilMask,/** @export */vd:_glStencilMaskSeparate,/** @export */ud:_glStencilOp,/** @export */td:_glStencilOpSeparate,/** @export */y:_glTexImage2D,/** @export */Oa:_glTexImage3D,/** @export */Ba:_glTexParameterf,/** @export */Jb:_glTexParameterfv,/** @export */h:_glTexParameteri,/** @export */Aa:_glTexStorage2D,/** @export */Ib:_glTexStorage3D,/** @export */J:_glTexSubImage2D,/** @export */za:_glTexSubImage3D,/** @export */sd:_glTransformFeedbackVaryings,/** @export */m:_glUniform1f,/** @export */da:_glUniform1fv,/** @export */e:_glUniform1i,/** @export */rd:_glUniform1iv,/** @export */qd:_glUniform1ui,/** @export */pd:_glUniform1uiv,/** @export */w:_glUniform2f,/** @export */Hb:_glUniform2fv,/** @export */od:_glUniform2i,/** @export */nd:_glUniform2iv,/** @export */md:_glUniform2ui,/** @export */ld:_glUniform2uiv,/** @export */la:_glUniform3f,/** @export */Gb:_glUniform3fv,/** @export */kd:_glUniform3i,/** @export */jd:_glUniform3iv,/** @export */id:_glUniform3ui,/** @export */hd:_glUniform3uiv,/** @export */ka:_glUniform4f,/** @export */R:_glUniform4fv,/** @export */gd:_glUniform4i,/** @export */Fb:_glUniform4iv,/** @export */fd:_glUniform4ui,/** @export */ed:_glUniform4uiv,/** @export */Eb:_glUniformBlockBinding,/** @export */db:_glUniformMatrix2fv,/** @export */dd:_glUniformMatrix2x3fv,/** @export */cd:_glUniformMatrix2x4fv,/** @export */cb:_glUniformMatrix3fv,/** @export */bd:_glUniformMatrix3x2fv,/** @export */ad:_glUniformMatrix3x4fv,/** @export */ja:_glUniformMatrix4fv,/** @export */$c:_glUniformMatrix4x2fv,/** @export */_c:_glUniformMatrix4x3fv,/** @export */f:_glUseProgram,/** @export */Zc:_glValidateProgram,/** @export */Yc:_glVertexAttrib1f,/** @export */Xc:_glVertexAttrib1fv,/** @export */Wc:_glVertexAttrib2f,/** @export */Vc:_glVertexAttrib2fv,/** @export */Uc:_glVertexAttrib3f,/** @export */Tc:_glVertexAttrib3fv,/** @export */Sc:_glVertexAttrib4f,/** @export */Rc:_glVertexAttrib4fv,/** @export */Qc:_glVertexAttribDivisor,/** @export */Pc:_glVertexAttribI4i,/** @export */Oc:_glVertexAttribI4iv,/** @export */Nc:_glVertexAttribI4ui,/** @export */Mc:_glVertexAttribI4uiv,/** @export */Lc:_glVertexAttribIPointer,/** @export */i:_glVertexAttribPointer,/** @export */ca:_glViewport,/** @export */xc:_glWaitSync,/** @export */bb:hardware_concurrency,/** @export */sc:mediapipe_create_utility_canvas2d,/** @export */Db:_mediapipe_find_canvas_event_target,/** @export */rc:mediapipe_import_external_texture,/** @export */pc:_mediapipe_webgl_get_current_ctx_canvas,/** @export */oc:_mediapipe_webgl_tex_image_drawable,/** @export */Af:_proc_exit,/** @export */zf:_random_get,/** @export */nc:videopipe_export_webgpu_texture,/** @export */wc:_wgpuBufferGetSize,/** @export */vc:_wgpuBufferGetUsage,/** @export */Q:_wgpuCommandEncoderBeginComputePass,/** @export */Ma:_wgpuCommandEncoderBeginRenderPass,/** @export */uc:_wgpuCommandEncoderCopyBufferToBuffer,/** @export */mc:_wgpuCommandEncoderCopyBufferToTexture,/** @export */Cb:_wgpuCommandEncoderCopyTextureToBuffer,/** @export */lc:_wgpuCommandEncoderCopyTextureToTexture,/** @export */F:_wgpuCommandEncoderFinish,/** @export */Na:_wgpuCommandEncoderResolveQuerySet,/** @export */X:_wgpuComputePassEncoderDispatchWorkgroups,/** @export */P:_wgpuComputePassEncoderEnd,/** @export */ba:_wgpuComputePassEncoderSetBindGroup,/** @export */W:_wgpuComputePassEncoderSetPipeline,/** @export */ia:_wgpuComputePipelineGetBindGroupLayout,/** @export */M:_wgpuDeviceCreateBindGroup,/** @export */Bb:_wgpuDeviceCreateBindGroupLayout,/** @export */E:_wgpuDeviceCreateCommandEncoder,/** @export */Ab:_wgpuDeviceCreateComputePipeline,/** @export */zb:_wgpuDeviceCreatePipelineLayout,/** @export */ab:_wgpuDeviceCreateQuerySet,/** @export */yb:_wgpuDeviceCreateRenderPipeline,/** @export */L:_wgpuDeviceCreateSampler,/** @export */aa:_wgpuDeviceCreateTexture,/** @export */kc:_wgpuDeviceGetLimits,/** @export */jc:_wgpuDeviceHasFeature,/** @export */ua:_wgpuDevicePushErrorScope,/** @export */D:_wgpuQueueSubmit,/** @export */tc:_wgpuQueueWriteBuffer,/** @export */$a:_wgpuQueueWriteTexture,/** @export */La:_wgpuRenderPassEncoderDraw,/** @export */Ka:_wgpuRenderPassEncoderEnd,/** @export */Ja:_wgpuRenderPassEncoderSetBindGroup,/** @export */Ia:_wgpuRenderPassEncoderSetPipeline,/** @export */_a:_wgpuRenderPipelineGetBindGroupLayout,/** @export */r:_wgpuTextureCreateView,/** @export */ha:_wgpuTextureDestroy,/** @export */ya:_wgpuTextureGetFormat};var wasmExports;createWasm();var ___wasm_call_ctors=()=>(___wasm_call_ctors=wasmExports["Wf"])();var _malloc=a0=>(_malloc=wasmExports["Yf"])(a0);var _free=a0=>(_free=wasmExports["Zf"])(a0);var _wgpuDeviceAddRef=a0=>(_wgpuDeviceAddRef=wasmExports["_f"])(a0);var _emwgpuCreateBindGroup=a0=>(_emwgpuCreateBindGroup=wasmExports["$f"])(a0);var _emwgpuCreateBindGroupLayout=a0=>(_emwgpuCreateBindGroupLayout=wasmExports["ag"])(a0);var _emwgpuCreateCommandBuffer=a0=>(_emwgpuCreateCommandBuffer=wasmExports["bg"])(a0);var _emwgpuCreateCommandEncoder=a0=>(_emwgpuCreateCommandEncoder=wasmExports["cg"])(a0);var _emwgpuCreateComputePassEncoder=a0=>(_emwgpuCreateComputePassEncoder=wasmExports["dg"])(a0);var _emwgpuCreateComputePipeline=a0=>(_emwgpuCreateComputePipeline=wasmExports["eg"])(a0);var _emwgpuCreatePipelineLayout=a0=>(_emwgpuCreatePipelineLayout=wasmExports["fg"])(a0);var _emwgpuCreateQuerySet=a0=>(_emwgpuCreateQuerySet=wasmExports["gg"])(a0);var _emwgpuCreateRenderBundle=a0=>(_emwgpuCreateRenderBundle=wasmExports["hg"])(a0);var _emwgpuCreateRenderBundleEncoder=a0=>(_emwgpuCreateRenderBundleEncoder=wasmExports["ig"])(a0);var _emwgpuCreateRenderPassEncoder=a0=>(_emwgpuCreateRenderPassEncoder=wasmExports["jg"])(a0);var _emwgpuCreateRenderPipeline=a0=>(_emwgpuCreateRenderPipeline=wasmExports["kg"])(a0);var _emwgpuCreateSampler=a0=>(_emwgpuCreateSampler=wasmExports["lg"])(a0);var _emwgpuCreateSurface=a0=>(_emwgpuCreateSurface=wasmExports["mg"])(a0);var _emwgpuCreateTexture=a0=>(_emwgpuCreateTexture=wasmExports["ng"])(a0);var _emwgpuCreateTextureView=a0=>(_emwgpuCreateTextureView=wasmExports["og"])(a0);var _emwgpuCreateAdapter=a0=>(_emwgpuCreateAdapter=wasmExports["pg"])(a0);var _emwgpuCreateBuffer=(a0,a1)=>(_emwgpuCreateBuffer=wasmExports["qg"])(a0,a1);var _emwgpuCreateDevice=(a0,a1)=>(_emwgpuCreateDevice=wasmExports["rg"])(a0,a1);var _emwgpuCreateQueue=a0=>(_emwgpuCreateQueue=wasmExports["sg"])(a0);var _emwgpuCreateShaderModule=a0=>(_emwgpuCreateShaderModule=wasmExports["tg"])(a0);var _emwgpuOnCreateComputePipelineCompleted=(a0,a1,a2,a3)=>(_emwgpuOnCreateComputePipelineCompleted=wasmExports["ug"])(a0,a1,a2,a3);var _emwgpuOnCreateRenderPipelineCompleted=(a0,a1,a2,a3)=>(_emwgpuOnCreateRenderPipelineCompleted=wasmExports["vg"])(a0,a1,a2,a3);var _emwgpuOnPopErrorScopeCompleted=(a0,a1,a2,a3)=>(_emwgpuOnPopErrorScopeCompleted=wasmExports["wg"])(a0,a1,a2,a3);var _emwgpuOnWorkDoneCompleted=(a0,a1)=>(_emwgpuOnWorkDoneCompleted=wasmExports["xg"])(a0,a1);var ___getTypeName=a0=>(___getTypeName=wasmExports["yg"])(a0);var _emscripten_builtin_memalign=(a0,a1)=>(_emscripten_builtin_memalign=wasmExports["zg"])(a0,a1);var _memalign=(a0,a1)=>(_memalign=wasmExports["Ag"])(a0,a1);var __emscripten_tempret_set=a0=>(__emscripten_tempret_set=wasmExports["Bg"])(a0);var __emscripten_stack_restore=a0=>(__emscripten_stack_restore=wasmExports["Cg"])(a0);var __emscripten_stack_alloc=a0=>(__emscripten_stack_alloc=wasmExports["Dg"])(a0);var _emscripten_stack_get_current=()=>(_emscripten_stack_get_current=wasmExports["Eg"])();var dynCall_ji=Module["dynCall_ji"]=(a0,a1)=>(dynCall_ji=Module["dynCall_ji"]=wasmExports["Fg"])(a0,a1);var dynCall_iiiijij=Module["dynCall_iiiijij"]=(a0,a1,a2,a3,a4,a5,a6,a7,a8)=>(dynCall_iiiijij=Module["dynCall_iiiijij"]=wasmExports["Gg"])(a0,a1,a2,a3,a4,a5,a6,a7,a8);var dynCall_jii=Module["dynCall_jii"]=(a0,a1,a2)=>(dynCall_jii=Module["dynCall_jii"]=wasmExports["Hg"])(a0,a1,a2);var dynCall_iiij=Module["dynCall_iiij"]=(a0,a1,a2,a3,a4)=>(dynCall_iiij=Module["dynCall_iiij"]=wasmExports["Ig"])(a0,a1,a2,a3,a4);var dynCall_iiiji=Module["dynCall_iiiji"]=(a0,a1,a2,a3,a4,a5)=>(dynCall_iiiji=Module["dynCall_iiiji"]=wasmExports["Jg"])(a0,a1,a2,a3,a4,a5);var dynCall_viiji=Module["dynCall_viiji"]=(a0,a1,a2,a3,a4,a5)=>(dynCall_viiji=Module["dynCall_viiji"]=wasmExports["Kg"])(a0,a1,a2,a3,a4,a5);var dynCall_jiii=Module["dynCall_jiii"]=(a0,a1,a2,a3)=>(dynCall_jiii=Module["dynCall_jiii"]=wasmExports["Lg"])(a0,a1,a2,a3);var dynCall_vij=Module["dynCall_vij"]=(a0,a1,a2,a3)=>(dynCall_vij=Module["dynCall_vij"]=wasmExports["Mg"])(a0,a1,a2,a3);var dynCall_jij=Module["dynCall_jij"]=(a0,a1,a2,a3)=>(dynCall_jij=Module["dynCall_jij"]=wasmExports["Ng"])(a0,a1,a2,a3);var dynCall_jijj=Module["dynCall_jijj"]=(a0,a1,a2,a3,a4,a5)=>(dynCall_jijj=Module["dynCall_jijj"]=wasmExports["Og"])(a0,a1,a2,a3,a4,a5);var dynCall_jijii=Module["dynCall_jijii"]=(a0,a1,a2,a3,a4,a5)=>(dynCall_jijii=Module["dynCall_jijii"]=wasmExports["Pg"])(a0,a1,a2,a3,a4,a5);var dynCall_viji=Module["dynCall_viji"]=(a0,a1,a2,a3,a4)=>(dynCall_viji=Module["dynCall_viji"]=wasmExports["Qg"])(a0,a1,a2,a3,a4);var dynCall_jijiii=Module["dynCall_jijiii"]=(a0,a1,a2,a3,a4,a5,a6)=>(dynCall_jijiii=Module["dynCall_jijiii"]=wasmExports["Rg"])(a0,a1,a2,a3,a4,a5,a6);var dynCall_jijji=Module["dynCall_jijji"]=(a0,a1,a2,a3,a4,a5,a6)=>(dynCall_jijji=Module["dynCall_jijji"]=wasmExports["Sg"])(a0,a1,a2,a3,a4,a5,a6);var dynCall_jiji=Module["dynCall_jiji"]=(a0,a1,a2,a3,a4)=>(dynCall_jiji=Module["dynCall_jiji"]=wasmExports["Tg"])(a0,a1,a2,a3,a4);var dynCall_viij=Module["dynCall_viij"]=(a0,a1,a2,a3,a4)=>(dynCall_viij=Module["dynCall_viij"]=wasmExports["Ug"])(a0,a1,a2,a3,a4);var dynCall_vijjii=Module["dynCall_vijjii"]=(a0,a1,a2,a3,a4,a5,a6,a7)=>(dynCall_vijjii=Module["dynCall_vijjii"]=wasmExports["Vg"])(a0,a1,a2,a3,a4,a5,a6,a7);var dynCall_jiij=Module["dynCall_jiij"]=(a0,a1,a2,a3,a4)=>(dynCall_jiij=Module["dynCall_jiij"]=wasmExports["Wg"])(a0,a1,a2,a3,a4);var dynCall_iiiijj=Module["dynCall_iiiijj"]=(a0,a1,a2,a3,a4,a5,a6,a7)=>(dynCall_iiiijj=Module["dynCall_iiiijj"]=wasmExports["Xg"])(a0,a1,a2,a3,a4,a5,a6,a7);var dynCall_iiiij=Module["dynCall_iiiij"]=(a0,a1,a2,a3,a4,a5)=>(dynCall_iiiij=Module["dynCall_iiiij"]=wasmExports["Yg"])(a0,a1,a2,a3,a4,a5);var dynCall_jiiiii=Module["dynCall_jiiiii"]=(a0,a1,a2,a3,a4,a5)=>(dynCall_jiiiii=Module["dynCall_jiiiii"]=wasmExports["Zg"])(a0,a1,a2,a3,a4,a5);var dynCall_jijjiii=Module["dynCall_jijjiii"]=(a0,a1,a2,a3,a4,a5,a6,a7,a8)=>(dynCall_jijjiii=Module["dynCall_jijjiii"]=wasmExports["_g"])(a0,a1,a2,a3,a4,a5,a6,a7,a8);var dynCall_jijiiii=Module["dynCall_jijiiii"]=(a0,a1,a2,a3,a4,a5,a6,a7)=>(dynCall_jijiiii=Module["dynCall_jijiiii"]=wasmExports["$g"])(a0,a1,a2,a3,a4,a5,a6,a7);var dynCall_jijiiiii=Module["dynCall_jijiiiii"]=(a0,a1,a2,a3,a4,a5,a6,a7,a8)=>(dynCall_jijiiiii=Module["dynCall_jijiiiii"]=wasmExports["ah"])(a0,a1,a2,a3,a4,a5,a6,a7,a8);var dynCall_iiijj=Module["dynCall_iiijj"]=(a0,a1,a2,a3,a4,a5,a6)=>(dynCall_iiijj=Module["dynCall_iiijj"]=wasmExports["bh"])(a0,a1,a2,a3,a4,a5,a6);var dynCall_iijijjji=Module["dynCall_iijijjji"]=(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11)=>(dynCall_iijijjji=Module["dynCall_iijijjji"]=wasmExports["ch"])(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9,a10,a11);var dynCall_iiji=Module["dynCall_iiji"]=(a0,a1,a2,a3,a4)=>(dynCall_iiji=Module["dynCall_iiji"]=wasmExports["dh"])(a0,a1,a2,a3,a4);var dynCall_jijij=Module["dynCall_jijij"]=(a0,a1,a2,a3,a4,a5,a6)=>(dynCall_jijij=Module["dynCall_jijij"]=wasmExports["eh"])(a0,a1,a2,a3,a4,a5,a6);var dynCall_iijijji=Module["dynCall_iijijji"]=(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9)=>(dynCall_iijijji=Module["dynCall_iijijji"]=wasmExports["fh"])(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);var dynCall_jiiii=Module["dynCall_jiiii"]=(a0,a1,a2,a3,a4)=>(dynCall_jiiii=Module["dynCall_jiiii"]=wasmExports["gh"])(a0,a1,a2,a3,a4);var dynCall_jjj=Module["dynCall_jjj"]=(a0,a1,a2,a3,a4)=>(dynCall_jjj=Module["dynCall_jjj"]=wasmExports["hh"])(a0,a1,a2,a3,a4);var dynCall_viijj=Module["dynCall_viijj"]=(a0,a1,a2,a3,a4,a5,a6)=>(dynCall_viijj=Module["dynCall_viijj"]=wasmExports["ih"])(a0,a1,a2,a3,a4,a5,a6);var dynCall_viiijjj=Module["dynCall_viiijjj"]=(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9)=>(dynCall_viiijjj=Module["dynCall_viiijjj"]=wasmExports["jh"])(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);var dynCall_vji=Module["dynCall_vji"]=(a0,a1,a2,a3)=>(dynCall_vji=Module["dynCall_vji"]=wasmExports["kh"])(a0,a1,a2,a3);var dynCall_viijii=Module["dynCall_viijii"]=(a0,a1,a2,a3,a4,a5,a6)=>(dynCall_viijii=Module["dynCall_viijii"]=wasmExports["lh"])(a0,a1,a2,a3,a4,a5,a6);var dynCall_viiiji=Module["dynCall_viiiji"]=(a0,a1,a2,a3,a4,a5,a6)=>(dynCall_viiiji=Module["dynCall_viiiji"]=wasmExports["mh"])(a0,a1,a2,a3,a4,a5,a6);var dynCall_vijjj=Module["dynCall_vijjj"]=(a0,a1,a2,a3,a4,a5,a6,a7)=>(dynCall_vijjj=Module["dynCall_vijjj"]=wasmExports["nh"])(a0,a1,a2,a3,a4,a5,a6,a7);var dynCall_vj=Module["dynCall_vj"]=(a0,a1,a2)=>(dynCall_vj=Module["dynCall_vj"]=wasmExports["oh"])(a0,a1,a2);var dynCall_iijjiiii=Module["dynCall_iijjiiii"]=(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9)=>(dynCall_iijjiiii=Module["dynCall_iijjiiii"]=wasmExports["ph"])(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);var dynCall_iiiiij=Module["dynCall_iiiiij"]=(a0,a1,a2,a3,a4,a5,a6)=>(dynCall_iiiiij=Module["dynCall_iiiiij"]=wasmExports["qh"])(a0,a1,a2,a3,a4,a5,a6);var dynCall_iiiiijj=Module["dynCall_iiiiijj"]=(a0,a1,a2,a3,a4,a5,a6,a7,a8)=>(dynCall_iiiiijj=Module["dynCall_iiiiijj"]=wasmExports["rh"])(a0,a1,a2,a3,a4,a5,a6,a7,a8);var dynCall_iiiiiijj=Module["dynCall_iiiiiijj"]=(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9)=>(dynCall_iiiiiijj=Module["dynCall_iiiiiijj"]=wasmExports["sh"])(a0,a1,a2,a3,a4,a5,a6,a7,a8,a9);var _kVersionStampBuildChangelistStr=Module["_kVersionStampBuildChangelistStr"]=920016;var _kVersionStampCitcSnapshotStr=Module["_kVersionStampCitcSnapshotStr"]=920048;var _kVersionStampCitcWorkspaceIdStr=Module["_kVersionStampCitcWorkspaceIdStr"]=920080;var _kVersionStampSourceUriStr=Module["_kVersionStampSourceUriStr"]=920592;var _kVersionStampBuildClientStr=Module["_kVersionStampBuildClientStr"]=921104;var _kVersionStampBuildClientMintStatusStr=Module["_kVersionStampBuildClientMintStatusStr"]=921616;var _kVersionStampBuildCompilerStr=Module["_kVersionStampBuildCompilerStr"]=921648;var _kVersionStampBuildDateTimePstStr=Module["_kVersionStampBuildDateTimePstStr"]=922160;var _kVersionStampBuildDepotPathStr=Module["_kVersionStampBuildDepotPathStr"]=922192;var _kVersionStampBuildIdStr=Module["_kVersionStampBuildIdStr"]=922704;var _kVersionStampBuildInfoStr=Module["_kVersionStampBuildInfoStr"]=923216;var _kVersionStampBuildLabelStr=Module["_kVersionStampBuildLabelStr"]=923728;var _kVersionStampBuildTargetStr=Module["_kVersionStampBuildTargetStr"]=924240;var _kVersionStampBuildTimestampStr=Module["_kVersionStampBuildTimestampStr"]=924752;var _kVersionStampBuildToolStr=Module["_kVersionStampBuildToolStr"]=924784;var _kVersionStampG3BuildTargetStr=Module["_kVersionStampG3BuildTargetStr"]=925296;var _kVersionStampVerifiableStr=Module["_kVersionStampVerifiableStr"]=925808;var _kVersionStampBuildFdoTypeStr=Module["_kVersionStampBuildFdoTypeStr"]=925840;var _kVersionStampBuildBaselineChangelistStr=Module["_kVersionStampBuildBaselineChangelistStr"]=925872;var _kVersionStampBuildLtoTypeStr=Module["_kVersionStampBuildLtoTypeStr"]=925904;var _kVersionStampBuildPropellerTypeStr=Module["_kVersionStampBuildPropellerTypeStr"]=925936;var _kVersionStampBuildPghoTypeStr=Module["_kVersionStampBuildPghoTypeStr"]=925968;var _kVersionStampBuildUsernameStr=Module["_kVersionStampBuildUsernameStr"]=926e3;var _kVersionStampBuildHostnameStr=Module["_kVersionStampBuildHostnameStr"]=926512;var _kVersionStampBuildDirectoryStr=Module["_kVersionStampBuildDirectoryStr"]=927024;var _kVersionStampBuildChangelistInt=Module["_kVersionStampBuildChangelistInt"]=927536;var _kVersionStampCitcSnapshotInt=Module["_kVersionStampCitcSnapshotInt"]=927544;var _kVersionStampBuildClientMintStatusInt=Module["_kVersionStampBuildClientMintStatusInt"]=927548;var _kVersionStampBuildTimestampInt=Module["_kVersionStampBuildTimestampInt"]=927552;var _kVersionStampVerifiableInt=Module["_kVersionStampVerifiableInt"]=927560;var _kVersionStampBuildCoverageEnabledInt=Module["_kVersionStampBuildCoverageEnabledInt"]=927564;var _kVersionStampBuildBaselineChangelistInt=Module["_kVersionStampBuildBaselineChangelistInt"]=927568;var _kVersionStampPrecookedTimestampStr=Module["_kVersionStampPrecookedTimestampStr"]=927584;var _kVersionStampPrecookedClientInfoStr=Module["_kVersionStampPrecookedClientInfoStr"]=928096;// include: postamble.js
// === Auto-generated postamble setup entry stuff ===
Module["addRunDependency"]=addRunDependency;Module["removeRunDependency"]=removeRunDependency;Module["abort"]=abort;Module["FS_createPreloadedFile"]=FS_createPreloadedFile;Module["FS_unlink"]=FS_unlink;Module["FS_createPath"]=FS_createPath;Module["FS_createDevice"]=FS_createDevice;Module["FS"]=FS;Module["FS_createDataFile"]=FS_createDataFile;Module["FS_createLazyFile"]=FS_createLazyFile;function run(){if(runDependencies>0){dependenciesFulfilled=run;return}preRun();// a preRun added a dependency, run will be called later
if(runDependencies>0){dependenciesFulfilled=run;return}function doRun(){// run may have just been called through dependencies being fulfilled just in this very frame,
// or while the async setStatus time below was happening
Module["calledRun"]=true;if(ABORT)return;initRuntime();readyPromiseResolve(Module);Module["onRuntimeInitialized"]?.();postRun()}if(Module["setStatus"]){Module["setStatus"]("Running...");setTimeout(()=>{setTimeout(()=>Module["setStatus"](""),1);doRun()},1)}else{doRun()}}if(Module["preInit"]){if(typeof Module["preInit"]=="function")Module["preInit"]=[Module["preInit"]];while(Module["preInit"].length>0){Module["preInit"].pop()()}}run();// end include: postamble.js
// include: postamble_modularize.js
// In MODULARIZE mode we wrap the generated code in a factory function
// and return either the Module itself, or a promise of the module.
// We assign to the `moduleRtn` global here and configure closure to see
// this as and extern so it won't get minified.
moduleRtn=readyPromise;


  return moduleRtn;
}
);
})();
if (typeof exports === 'object' && typeof module === 'object') {
  module.exports = createMediapipeChromiumTestsSimd;
  // This default export looks redundant, but it allows TS to import this
  // commonjs style module.
  module.exports.default = createMediapipeChromiumTestsSimd;
} else if (typeof define === 'function' && define['amd'])
  define([], () => createMediapipeChromiumTestsSimd);
