﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent-runtime/model/ListInvocationsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::BedrockAgentRuntime::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListInvocationsResult::ListInvocationsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListInvocationsResult& ListInvocationsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("invocationSummaries")) {
    Aws::Utils::Array<JsonView> invocationSummariesJsonList = jsonValue.GetArray("invocationSummaries");
    for (unsigned invocationSummariesIndex = 0; invocationSummariesIndex < invocationSummariesJsonList.GetLength();
         ++invocationSummariesIndex) {
      m_invocationSummaries.push_back(invocationSummariesJsonList[invocationSummariesIndex].AsObject());
    }
    m_invocationSummariesHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
