﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codeartifact/model/CreateDomainRequest.h>
#include <aws/core/http/URI.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CodeArtifact::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws::Http;

Aws::String CreateDomainRequest::SerializePayload() const {
  JsonValue payload;

  if (m_encryptionKeyHasBeenSet) {
    payload.WithString("encryptionKey", m_encryptionKey);
  }

  if (m_tagsHasBeenSet) {
    Aws::Utils::Array<JsonValue> tagsJsonList(m_tags.size());
    for (unsigned tagsIndex = 0; tagsIndex < tagsJsonList.GetLength(); ++tagsIndex) {
      tagsJsonList[tagsIndex].AsObject(m_tags[tagsIndex].Jsonize());
    }
    payload.WithArray("tags", std::move(tagsJsonList));
  }

  return payload.View().WriteReadable();
}

void CreateDomainRequest::AddQueryStringParameters(URI& uri) const {
  Aws::StringStream ss;
  if (m_domainHasBeenSet) {
    ss << m_domain;
    uri.AddQueryStringParameter("domain", ss.str());
    ss.str("");
  }
}
