﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/codeguru-security/model/ListFindingsMetricsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::CodeGuruSecurity::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

ListFindingsMetricsResult::ListFindingsMetricsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) { *this = result; }

ListFindingsMetricsResult& ListFindingsMetricsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("findingsMetrics")) {
    Aws::Utils::Array<JsonView> findingsMetricsJsonList = jsonValue.GetArray("findingsMetrics");
    for (unsigned findingsMetricsIndex = 0; findingsMetricsIndex < findingsMetricsJsonList.GetLength(); ++findingsMetricsIndex) {
      m_findingsMetrics.push_back(findingsMetricsJsonList[findingsMetricsIndex].AsObject());
    }
    m_findingsMetricsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("nextToken")) {
    m_nextToken = jsonValue.GetString("nextToken");
    m_nextTokenHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
