/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.editors.text;

import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.editors.text.TextEditorMessages;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.RetargetTextEditorAction;

public class TextEditorActionContributor
extends BasicTextEditorActionContributor {
    private final RetargetTextEditorAction fChangeEncodingAction = new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ChangeEncodingAction.");
    private final RetargetTextEditorAction fQuickAssistAction = new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.QuickAssist.");
    private final IContributionItem fQuickAssistMenuEntry;
    private final RetargetTextEditorAction fRetargetShowInformationAction;

    public TextEditorActionContributor() {
        this.fQuickAssistAction.setActionDefinitionId("org.eclipse.jdt.ui.edit.text.java.correction.assist.proposals");
        this.fQuickAssistMenuEntry = new ActionContributionItem((IAction)this.fQuickAssistAction);
        this.fRetargetShowInformationAction = new RetargetTextEditorAction(TextEditorMessages.getBundleForConstructedKeys(), "Editor.ShowInformation.");
        this.fRetargetShowInformationAction.setActionDefinitionId("org.eclipse.ui.edit.text.showInformation");
    }

    private void doSetActiveEditor(IEditorPart part) {
        ITextEditor textEditor = null;
        if (part instanceof ITextEditor) {
            textEditor = (ITextEditor)part;
        }
        IActionBars actionBars = this.getActionBars();
        actionBars.setGlobalActionHandler(IDEActionFactory.ADD_TASK.getId(), this.getAction(textEditor, IDEActionFactory.ADD_TASK.getId()));
        actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(textEditor, IDEActionFactory.BOOKMARK.getId()));
        IAction action = this.getAction(textEditor, ITextEditorActionConstants.NEXT);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, action);
        action = this.getAction(textEditor, ITextEditorActionConstants.PREVIOUS);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, action);
        action = this.getAction(textEditor, ITextEditorActionConstants.REFRESH);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.REFRESH, action);
        this.fChangeEncodingAction.setAction(this.getAction(textEditor, "ChangeEncoding"));
        IAction quickAssistAction = this.getAction(textEditor, "QuickAssist");
        this.fQuickAssistAction.setAction(quickAssistAction);
        if (textEditor == null) {
            return;
        }
        IMenuManager menuMgr = textEditor.getEditorSite().getActionBars().getMenuManager();
        IMenuManager editMenu = menuMgr.findMenuUsingPath("edit");
        if (editMenu != null) {
            boolean isEnabled = quickAssistAction != null && quickAssistAction.isEnabled();
            this.fQuickAssistMenuEntry.setVisible(isEnabled);
            editMenu.update(true);
        }
        this.fRetargetShowInformationAction.setAction(this.getAction(textEditor, "ShowInformation"));
    }

    public void contributeToMenu(IMenuManager menu) {
        super.contributeToMenu(menu);
        IMenuManager editMenu = menu.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.appendToGroup("group.assist", this.fQuickAssistMenuEntry);
            this.fQuickAssistMenuEntry.setVisible(false);
            editMenu.appendToGroup("group.information", (IAction)this.fRetargetShowInformationAction);
        }
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.doSetActiveEditor(part);
    }

    public void dispose() {
        this.doSetActiveEditor(null);
        super.dispose();
    }

    public void init(IActionBars bars) {
        super.init(bars);
        IMenuManager menuManager = bars.getMenuManager();
        IMenuManager editMenu = menuManager.findMenuUsingPath("edit");
        if (editMenu != null) {
            editMenu.add((IAction)this.fChangeEncodingAction);
        }
    }
}

