// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct CountTokensOutput {
    /// <p>The number of tokens in the provided input according to the specified model's tokenization rules. This count represents the number of input tokens that would be processed if the same input were sent to the model in an inference request. Use this value to estimate costs and ensure your inputs stay within model token limits.</p>
    pub input_tokens: i32,
    _request_id: Option<String>,
}
impl CountTokensOutput {
    /// <p>The number of tokens in the provided input according to the specified model's tokenization rules. This count represents the number of input tokens that would be processed if the same input were sent to the model in an inference request. Use this value to estimate costs and ensure your inputs stay within model token limits.</p>
    pub fn input_tokens(&self) -> i32 {
        self.input_tokens
    }
}
impl ::aws_types::request_id::RequestId for CountTokensOutput {
    fn request_id(&self) -> Option<&str> {
        self._request_id.as_deref()
    }
}
impl CountTokensOutput {
    /// Creates a new builder-style object to manufacture [`CountTokensOutput`](crate::operation::count_tokens::CountTokensOutput).
    pub fn builder() -> crate::operation::count_tokens::builders::CountTokensOutputBuilder {
        crate::operation::count_tokens::builders::CountTokensOutputBuilder::default()
    }
}

/// A builder for [`CountTokensOutput`](crate::operation::count_tokens::CountTokensOutput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct CountTokensOutputBuilder {
    pub(crate) input_tokens: ::std::option::Option<i32>,
    _request_id: Option<String>,
}
impl CountTokensOutputBuilder {
    /// <p>The number of tokens in the provided input according to the specified model's tokenization rules. This count represents the number of input tokens that would be processed if the same input were sent to the model in an inference request. Use this value to estimate costs and ensure your inputs stay within model token limits.</p>
    /// This field is required.
    pub fn input_tokens(mut self, input: i32) -> Self {
        self.input_tokens = ::std::option::Option::Some(input);
        self
    }
    /// <p>The number of tokens in the provided input according to the specified model's tokenization rules. This count represents the number of input tokens that would be processed if the same input were sent to the model in an inference request. Use this value to estimate costs and ensure your inputs stay within model token limits.</p>
    pub fn set_input_tokens(mut self, input: ::std::option::Option<i32>) -> Self {
        self.input_tokens = input;
        self
    }
    /// <p>The number of tokens in the provided input according to the specified model's tokenization rules. This count represents the number of input tokens that would be processed if the same input were sent to the model in an inference request. Use this value to estimate costs and ensure your inputs stay within model token limits.</p>
    pub fn get_input_tokens(&self) -> &::std::option::Option<i32> {
        &self.input_tokens
    }
    pub(crate) fn _request_id(mut self, request_id: impl Into<String>) -> Self {
        self._request_id = Some(request_id.into());
        self
    }

    pub(crate) fn _set_request_id(&mut self, request_id: Option<String>) -> &mut Self {
        self._request_id = request_id;
        self
    }
    /// Consumes the builder and constructs a [`CountTokensOutput`](crate::operation::count_tokens::CountTokensOutput).
    /// This method will fail if any of the following fields are not set:
    /// - [`input_tokens`](crate::operation::count_tokens::builders::CountTokensOutputBuilder::input_tokens)
    pub fn build(self) -> ::std::result::Result<crate::operation::count_tokens::CountTokensOutput, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::operation::count_tokens::CountTokensOutput {
            input_tokens: self.input_tokens.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "input_tokens",
                    "input_tokens was not specified but it is required when building CountTokensOutput",
                )
            })?,
            _request_id: self._request_id,
        })
    }
}
