/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_xnr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TR = "तुर्की";
        final String metaValue_ar = "अरबी";
        final String metaValue_hy = "आर्मेनियाई";
        final String metaValue_bn = "बंगाली";
        final String metaValue_bug = "बगिनीस";
        final String metaValue_ccp = "चकमा";
        final String metaValue_chr = "चेरोकी";
        final String metaValue_el = "यूनानी";
        final String metaValue_gu = "गुजराती";
        final String metaValue_he = "हिब्रू";
        final String metaValue_ja = "जापानी";
        final String metaValue_km = "खमेर";
        final String metaValue_kn = "कन्नड़";
        final String metaValue_ko = "कोरियाई";
        final String metaValue_lo = "लाओ";
        final String metaValue_la = "लैटिन";
        final String metaValue_ml = "मलयालम";
        final String metaValue_mn = "मंगोलियाई";
        final String metaValue_or = "उड़िया";
        final String metaValue_si = "सिंहली";
        final String metaValue_ta = "तमिल";
        final String metaValue_te = "तेलुगू";
        final String metaValue_th = "थाई";
        final String metaValue_bo = "तिब्बती";
        final String metaValue_vai = "वाई";
        final Object[][] data = new Object[][] {
            { "001", "दुनिया" },
            { "002", "अफ़्रीका" },
            { "003", "उत्तर अमरिका" },
            { "005", "दखण अमरिका" },
            { "009", "ओशिआनिया" },
            { "011", "पश्चिमी अफ़्रीका" },
            { "013", "बिचला अमरिका" },
            { "014", "पूर्वी अफ़्रीका" },
            { "015", "उत्तरी अफ़्रीका" },
            { "017", "बिचला अफ़्रीका" },
            { "018", "दखणे बखें अफ़्रीका" },
            { "019", "अमरिका दा" },
            { "021", "उत्तरी अमरिका" },
            { "029", "कैरिबियन" },
            { "030", "पूर्वी एशिया" },
            { "034", "दखणे बखें एशिया" },
            { "035", "दखण-पूर्व एशिया" },
            { "039", "दखणे बखें यूरोप" },
            { "053", "ऑस्ट्रेलेशिया" },
            { "054", "मेलानेशिया" },
            { "057", "माइक्रोनेशियाई लाका" },
            { "061", "पोलिनेशिया" },
            { "142", "एशिया" },
            { "143", "बिचला एशिया" },
            { "145", "पश्चिमी एशिया" },
            { "150", "यूरोप" },
            { "151", "पूर्वी यूरोप" },
            { "154", "उत्तरी यूरोप" },
            { "155", "पश्चिमी यूरोप" },
            { "202", "उप-सहारा अफ़्रीका" },
            { "419", "लैटिन अमरिका" },
            { "AC", "असेंशन द्वीप" },
            { "AD", "एंडोरा" },
            { "AE", "संयुक्त अरब अमीरात" },
            { "AF", "अफ़गानिस्तान" },
            { "AG", "एंटिगुआ कने बरबुडा" },
            { "AI", "एंग्विला" },
            { "AL", "अल्बानिया" },
            { "AM", "आर्मेनिया" },
            { "AO", "अंगोला" },
            { "AQ", "अंटार्कटिका" },
            { "AR", "अर्जेंटीना" },
            { "AS", "अमरिकी समोआ" },
            { "AT", "ऑस्ट्रिया" },
            { "AU", "ऑस्ट्रेलिया" },
            { "AW", "अरूबा" },
            { "AX", "एलैंड द्वीपां दा झुंड" },
            { "AZ", "अज़रबैजान" },
            { "BA", "बोस्निया कने हर्ज़ेगोविना" },
            { "BB", "बारबाडोस" },
            { "BD", "बांग्लादेश" },
            { "BE", "बेल्जियम" },
            { "BF", "बुर्किना फ़ासो" },
            { "BG", "बुल्गारिया" },
            { "BH", "बहरीन" },
            { "BI", "बुरुंडी" },
            { "BJ", "बेनिन" },
            { "BL", "सेंट बार्थेलेमी" },
            { "BM", "बरमूडा" },
            { "BN", "ब्रूनेई" },
            { "BO", "बोलीविया" },
            { "BQ", "कैरिबियन नीदरलैंड" },
            { "BR", "ब्राज़ील" },
            { "BS", "बहामास" },
            { "BT", "भूटान" },
            { "BV", "बोवेत द्वीप" },
            { "BW", "बोत्स्वाना" },
            { "BY", "बेलारूस" },
            { "BZ", "बेलीज़" },
            { "CA", "कनेडा" },
            { "CC", "कोकोस (कीलिंग) द्वीपां दा झुंड" },
            { "CD", "कांगो - किंशासा" },
            { "CF", "बिचला अफ़्रीकी गणराज्य" },
            { "CG", "कांगो – ब्राज़ाविल" },
            { "CH", "स्विट्ज़रलैंड" },
            { "CI", "कोट डी आइवर" },
            { "CK", "कुक द्वीपां दा झुंड" },
            { "CL", "चिली" },
            { "CM", "कैमरून" },
            { "CN", "चीन" },
            { "CO", "कोलंबिया" },
            { "CP", "क्लिपर्टन द्वीप" },
            { "CR", "कोस्टारिका" },
            { "CU", "क्यूबा" },
            { "CV", "केप वर्ड" },
            { "CW", "क्यूरासाओ" },
            { "CX", "क्रिसमस द्वीप" },
            { "CY", "साइप्रस" },
            { "CZ", "चेकिया" },
            { "DE", "जर्मनी" },
            { "DG", "डिएगो गार्सिया" },
            { "DJ", "जिबूती" },
            { "DK", "डेनमार्क" },
            { "DM", "डोमिनिका" },
            { "DO", "डोमिनिकन गणराज्य" },
            { "DZ", "अल्जीरिया" },
            { "EA", "सेउटा कने मेलिला" },
            { "EC", "इक्वाडोर" },
            { "EE", "एस्टोनिया" },
            { "EG", "मिस्र" },
            { "EH", "पश्चिमी सहारा" },
            { "ER", "इरिट्रिया" },
            { "ES", "स्पेन" },
            { "ET", "इथियोपिया" },
            { "EU", "यूरोपीय संघ" },
            { "EZ", "यूरोज़ोन" },
            { "FI", "फ़िनलैंड" },
            { "FJ", "फ़िजी" },
            { "FK", "फ़ॉकलैंड द्वीपां दा झुंड" },
            { "FM", "माइक्रोनेशिया" },
            { "FO", "फ़ेरो द्वीपां दा झुंड" },
            { "FR", "फ़्रांस" },
            { "GA", "गैबॉन" },
            { "GB", "यूनाइटेड किंगडम" },
            { "GD", "ग्रेनेडा" },
            { "GE", "जॉर्जिया" },
            { "GF", "फ़्रेंच गुयाना" },
            { "GG", "गर्नसी" },
            { "GH", "घाना" },
            { "GI", "जिब्राल्टर" },
            { "GL", "ग्रीनलैंड" },
            { "GM", "गाम्बिया" },
            { "GN", "गिनी" },
            { "GP", "ग्वाडेलूप" },
            { "GQ", "इक्वेटोरियल गिनी" },
            { "GR", "यूनान" },
            { "GS", "दखण जॉर्जिया कने दखण सैंडविच द्वीपां दा झुंड" },
            { "GT", "ग्वाटेमाला" },
            { "GU", "गुआम" },
            { "GW", "गिनी-बिसाउ" },
            { "GY", "गुयाना" },
            { "HK", "हाँग काँग (चीन खास प्रशासनिक लाका)" },
            { "HM", "हर्ड द्वीप कने मैकडोनॉल्ड द्वीपां दा झुंड" },
            { "HN", "होंडूरास" },
            { "HR", "क्रोएशिया" },
            { "HT", "हैती" },
            { "HU", "हंगरी" },
            { "IC", "कैनेरी द्वीपां दा झुंड" },
            { "ID", "इंडोनेशिया" },
            { "IE", "आयरलैंड" },
            { "IL", "इज़राइल" },
            { "IM", "आइल ऑफ़ मैन" },
            { "IN", "भारत" },
            { "IO", "ब्रिटिश हिंद महासागरीय लाका" },
            { "IQ", "इराक" },
            { "IR", "ईरान" },
            { "IS", "आइसलैंड" },
            { "IT", "इटली" },
            { "JE", "जर्सी" },
            { "JM", "जमैका" },
            { "JO", "जॉर्डन" },
            { "JP", "जापान" },
            { "KE", "केन्या" },
            { "KG", "किर्गिज़स्तान" },
            { "KH", "कंबोडिया" },
            { "KI", "किरिबाती" },
            { "KM", "कोमोरोस" },
            { "KN", "सेंट किट्स कने नेविस" },
            { "KP", "उत्तर कोरिया" },
            { "KR", "दखण कोरिया" },
            { "KW", "कुवैत" },
            { "KY", "कैमेन द्वीपसमूह" },
            { "KZ", "कज़ाखस्तान" },
            { "LA", "लाओस" },
            { "LB", "लेबनान" },
            { "LC", "सेंट लूसिया" },
            { "LI", "लिचेंस्टीन" },
            { "LK", "श्रीलंका" },
            { "LR", "लाइबेरिया" },
            { "LS", "लेसोथो" },
            { "LT", "लिथुआनिया" },
            { "LU", "लग्ज़मबर्ग" },
            { "LV", "लातविया" },
            { "LY", "लीबिया" },
            { "MA", "मोरक्को" },
            { "MC", "मोनाको" },
            { "MD", "मॉल्डोवा" },
            { "ME", "मोंटेनेग्रो" },
            { "MF", "सेंट मार्टिन" },
            { "MG", "मेडागास्कर" },
            { "MH", "मार्शल द्वीपां दा झुंड" },
            { "MK", "उत्तरी मकदूनिया" },
            { "ML", "माली" },
            { "MM", "म्यांमार (बर्मा)" },
            { "MN", "मंगोलिया" },
            { "MO", "मकाऊ (खास प्रशासनिक लाका चीन)" },
            { "MP", "उत्तरी मारियाना द्वीपां दा झुंड" },
            { "MQ", "मार्टीनिक" },
            { "MR", "मॉरिटानिया" },
            { "MS", "मोंटसेरात" },
            { "MT", "माल्टा" },
            { "MU", "मॉरीशस" },
            { "MV", "मालदीव" },
            { "MW", "मलावी" },
            { "MX", "मैक्सिको" },
            { "MY", "मलेशिया" },
            { "MZ", "मोज़ांबिक" },
            { "NA", "नामीबिया" },
            { "NC", "न्यू कैलेडोनिया" },
            { "NE", "नाइजर" },
            { "NF", "नॉरफ़ॉक द्वीप" },
            { "NG", "नाइजीरिया" },
            { "NI", "निकारागुआ" },
            { "NL", "नीदरलैंड" },
            { "NO", "नॉर्वे" },
            { "NP", "नेपाल" },
            { "NR", "नाउरु" },
            { "NU", "नीयू" },
            { "NZ", "न्यूज़ीलैंड" },
            { "OM", "ओमान" },
            { "PA", "पनामा" },
            { "PE", "पेरू" },
            { "PF", "फ़्रेंच पोलिनेशिया" },
            { "PG", "पापुआ न्यू गिनी" },
            { "PH", "फ़िलिपींस" },
            { "PK", "पाकिस्तान" },
            { "PL", "पोलैंड" },
            { "PM", "सेंट पिएरे कने मिक्वेलान" },
            { "PN", "पिटकैर्न द्वीपसमूह" },
            { "PR", "पोर्टो रिको" },
            { "PS", "फ़िलिस्तीनी लाका" },
            { "PT", "पुर्तगाल" },
            { "PW", "पलाऊ" },
            { "PY", "पराग्वे" },
            { "QA", "क़तर" },
            { "QO", "आउटलाइंग ओशिनिया" },
            { "RE", "रियूनियन" },
            { "RO", "रोमानिया" },
            { "RS", "सर्बिया" },
            { "RU", "रूस" },
            { "RW", "रवांडा" },
            { "SA", "सऊदी अरब" },
            { "SB", "सोलोमन द्वीपसमूह" },
            { "SC", "सेशेल्स" },
            { "SD", "सूडान" },
            { "SE", "स्वीडन" },
            { "SG", "सिंगापुर" },
            { "SH", "सेंट हेलेना" },
            { "SI", "स्लोवेनिया" },
            { "SJ", "स्वालबार्ड कने जान मायेन" },
            { "SK", "स्लोवाकिया" },
            { "SL", "सिएरा लियोन" },
            { "SM", "सैन मेरीनो" },
            { "SN", "सेनेगल" },
            { "SO", "सोमालिया" },
            { "SR", "सूरीनाम" },
            { "SS", "दखण सूडान" },
            { "ST", "साओ टोम कने प्रिंसिपे" },
            { "SV", "अल सल्वाडोर" },
            { "SX", "सिंट मार्टिन" },
            { "SY", "सीरिया" },
            { "SZ", "एस्वाटिनी" },
            { "TA", "ट्रिस्टन दा कुना" },
            { "TC", "तुर्क कने कैकोज़ द्वीपां दा झुंड" },
            { "TD", "चाड" },
            { "TF", "फ़्रांसीसी दखणे बखें लाका" },
            { "TG", "टोगो" },
            { "TH", "थाईलैंड" },
            { "TJ", "ताज़िकिस्तान" },
            { "TK", "तोकेलाउ" },
            { "TL", "तिमोर-लेस्त" },
            { "TM", "तुर्कमेनिस्तान" },
            { "TN", "ट्यूनीशिया" },
            { "TO", "टोंगा" },
            { "TR", metaValue_TR },
            { "TT", "त्रिनिदाद कने टोबैगो" },
            { "TV", "तुवालू" },
            { "TW", "ताइवान" },
            { "TZ", "तंज़ानिया" },
            { "UA", "यूक्रेन" },
            { "UG", "युगांडा" },
            { "UM", "यू॰एस॰ आउटलाइंग द्वीपां दा झुंड" },
            { "UN", "संयुक्त रास्टर" },
            { "US", "संयुक्त राज्य" },
            { "UY", "उरूग्वे" },
            { "UZ", "उज़्बेकिस्तान" },
            { "VA", "वेटिकन सिटी" },
            { "VC", "सेंट विंसेंट कने ग्रेनाडाइंस" },
            { "VE", "वेनेज़ुएला" },
            { "VG", "ब्रिटिश वर्जिन द्वीपां दा झुंड" },
            { "VI", "यू॰एस॰ वर्जिन द्वीपां दा झुंड" },
            { "VN", "वियतनाम" },
            { "VU", "वनुआतू" },
            { "WF", "वालिस कने फ़्यूचूना" },
            { "WS", "समोआ" },
            { "XA", "सूडो-एक्सेंट" },
            { "XB", "सूडो-बायडायरेक्शनल" },
            { "XK", "कोसोवो" },
            { "YE", "यमन" },
            { "YT", "मायोते" },
            { "ZA", "दखण अफ़्रीका" },
            { "ZM", "ज़ाम्बिया" },
            { "ZW", "ज़िम्बाब्वे" },
            { "ZZ", "अणजाण लाका" },
            { "aa", "अफ़ार" },
            { "ab", "अब्ख़ाज़ियन" },
            { "af", "अफ़्रीकी" },
            { "ak", "अकन" },
            { "am", "अम्हेरी" },
            { "an", "अर्गोनी" },
            { "ar", metaValue_ar },
            { "as", "असमी" },
            { "av", "अवेरिक" },
            { "ay", "आयमारा" },
            { "az", "अज़रबैजानी" },
            { "ba", "बशख़िर" },
            { "be", "बेलारूसी" },
            { "bg", "बुल्गारियाई" },
            { "bi", "बिस्लामा" },
            { "bm", "बाम्बारा" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "ब्रेटन" },
            { "bs", "बोस्नियाई" },
            { "ca", "कातालान" },
            { "ce", "चेचन" },
            { "ch", "कमोरो" },
            { "co", "कोर्सीकन" },
            { "cs", "चेक" },
            { "cu", "चर्च साल्विक" },
            { "cv", "चूवाश" },
            { "cy", "वेल्श" },
            { "da", "डेनिश" },
            { "de", "जर्मन" },
            { "dv", "दिवेही" },
            { "dz", "ज़ोन्गखा" },
            { "ee", "ईवे" },
            { "el", metaValue_el },
            { "en", "अंग्रेज़ी" },
            { "eo", "एस्पेरेंतो" },
            { "es", "स्पेनी" },
            { "et", "एस्टोनिये आली" },
            { "eu", "बास्क" },
            { "fa", "फ़ारसी" },
            { "ff", "फुलाह" },
            { "fi", "फ़िनिश" },
            { "fj", "फिजियन" },
            { "fo", "फ़ैरोइज़" },
            { "fr", "फ़्रांसीसी" },
            { "fy", "पश्चिमी फ़्रिसियाई" },
            { "ga", "आयरिश" },
            { "gd", "स्कॉटिश गाएलिक" },
            { "gl", "गैलिशियन" },
            { "gn", "गुआरानी" },
            { "gu", metaValue_gu },
            { "gv", "मैंक्स" },
            { "ha", "हौसा" },
            { "he", metaValue_he },
            { "hi", "हिन्दी" },
            { "hr", "क्रोएशियाई" },
            { "ht", "हैतियाई" },
            { "hu", "हंगेरियाई" },
            { "hy", metaValue_hy },
            { "hz", "हरैरो" },
            { "ia", "इंटरलिंगुआ" },
            { "id", "इंडोनेशियाई" },
            { "ie", "ईन्टरलिंगुइ" },
            { "ig", "ईग्बो" },
            { "ii", "सिचुआन यी" },
            { "io", "इडौ" },
            { "is", "आइसलैंडिक" },
            { "it", "इतालवी" },
            { "iu", "इनूकीटूत्" },
            { "ja", metaValue_ja },
            { "jv", "जावानीज़" },
            { "ka", "जॉर्जियाई" },
            { "ki", "किकुयू" },
            { "kj", "क्वान्यामा" },
            { "kk", "कज़ाख़" },
            { "kl", "कलालीसुत" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "कनुरी" },
            { "ks", "कश्मीरी" },
            { "ku", "कुर्दिश" },
            { "kv", "कोमी" },
            { "kw", "कोर्निश" },
            { "ky", "किर्गीज़" },
            { "la", metaValue_la },
            { "lb", "लग्ज़मबर्गी" },
            { "lg", "गांडा" },
            { "li", "लिंबर्गिश" },
            { "ln", "लिंगाला" },
            { "lo", metaValue_lo },
            { "lt", "लिथुआनियाई" },
            { "lu", "ल्यूबा-कटांगा" },
            { "lv", "लातवियाई" },
            { "mg", "मालागासी" },
            { "mh", "मार्शलीज़" },
            { "mi", "माओरी" },
            { "mk", "मकदूनियाई" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "मराठी" },
            { "ms", "मलय" },
            { "mt", "माल्टीज़" },
            { "my", "बर्मीज़" },
            { "na", "नाउरू" },
            { "nb", "नॉर्वेजियाई बोकमाल" },
            { "nd", "उत्तरी देबेल" },
            { "ne", "नेपाली" },
            { "ng", "डोन्गा" },
            { "nl", "डच" },
            { "nn", "नॉर्वेजियाई नॉयनॉर्स्क" },
            { "no", "नॉर्वेजियाई" },
            { "nr", "दखण देबेल" },
            { "nv", "नावाजो" },
            { "ny", "न्यानजा" },
            { "oc", "ओसीटान" },
            { "om", "ओरोमो" },
            { "or", metaValue_or },
            { "os", "ओस्सेटिक" },
            { "pa", "पंजाबी" },
            { "pl", "पोलिश" },
            { "ps", "पश्तो" },
            { "pt", "पुर्तगाली" },
            { "qu", "क्वेचुआ" },
            { "rm", "रोमान्श" },
            { "rn", "रुन्दी" },
            { "ro", "रोमानियाई" },
            { "ru", "रूसी" },
            { "rw", "किन्यारवांडा" },
            { "sa", "संस्कृत" },
            { "sc", "सार्दिनियन" },
            { "sd", "सिंधी" },
            { "se", "उतरी सामी" },
            { "sg", "सांगो" },
            { "si", metaValue_si },
            { "sk", "स्लोवाक" },
            { "sl", "स्लोवेनियाई" },
            { "sm", "सामोन" },
            { "sn", "शोणा" },
            { "so", "सोमाली" },
            { "sq", "अल्बानियाई" },
            { "sr", "सर्बियाई" },
            { "ss", "स्वाती" },
            { "st", "दखणे बखें सेसेथो" },
            { "su", "सुंडानी" },
            { "sv", "स्वीडिश" },
            { "sw", "स्वाहिली" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "ताजिक" },
            { "th", metaValue_th },
            { "ti", "तिग्रीन्या" },
            { "tk", "तुर्कमेन" },
            { "tn", "सेत्स्वाना" },
            { "to", "टोंगन" },
            { "tr", metaValue_TR },
            { "ts", "सोंगा" },
            { "tt", "तातार" },
            { "ty", "ताहितियन" },
            { "ug", "उइगर" },
            { "uk", "यूक्रेनियाई" },
            { "ur", "उर्दू" },
            { "uz", "उज़्बेक" },
            { "ve", "वेन्दा" },
            { "vi", "वियतनामी" },
            { "vo", "वोलापुक" },
            { "wa", "वाल्लून" },
            { "wo", "वोलोफ़" },
            { "xh", "ख़ोसा" },
            { "yi", "यहूदी" },
            { "yo", "योरूबा" },
            { "za", "ज़ुआंग" },
            { "zh", "चीनी" },
            { "zu", "ज़ुलू" },
            { "ace", "अचाइनीस" },
            { "ada", "अदान्गमे" },
            { "ady", "अदिघे" },
            { "agq", "अग्हेम" },
            { "ain", "ऐनू" },
            { "ale", "अलेउत" },
            { "alt", "दखणे बखें अल्ताई" },
            { "anp", "अंगिका" },
            { "arn", "मापूचे" },
            { "arp", "अरापाहो" },
            { "ars", "नज्दी अरबी" },
            { "asa", "असु" },
            { "ast", "अस्तुरियन" },
            { "awa", "अवधी" },
            { "ban", "बालिनीस" },
            { "bas", "बसा" },
            { "bem", "बेम्बा" },
            { "bez", "बेना" },
            { "bgn", "पश्चिमी बलोची" },
            { "bho", "भोजपुरी" },
            { "bin", "बिनी" },
            { "bla", "सिक्सिका" },
            { "brx", "बोडो" },
            { "bug", metaValue_bug },
            { "byn", "ब्लिन" },
            { "ccp", metaValue_ccp },
            { "ceb", "सिबुआनो" },
            { "cgg", "शिगा" },
            { "chk", "चूकीस" },
            { "chm", "मारी" },
            { "cho", "चोक्तौ" },
            { "chp", "शिपेव्यान" },
            { "chr", metaValue_chr },
            { "chy", "शेयेन्न" },
            { "ckb", "सोरानी कुर्दिश" },
            { "dak", "दाकोता" },
            { "dar", "दार्गवा" },
            { "dav", "तैता" },
            { "dgr", "डोग्रिब" },
            { "dje", "झार्मा" },
            { "doi", "डोगरी" },
            { "dsb", "बुरला सॉर्बियन" },
            { "dua", "दुआला" },
            { "dyo", "जोला-फोंई" },
            { "dzg", "दज़ागा" },
            { "ebu", "एम्बु" },
            { "efi", "एफिक" },
            { "eka", "एकाजुक" },
            { "ewo", "इवोन्डो" },
            { "fil", "फ़िलिपीनो" },
            { "fon", "फॉन" },
            { "frc", "केजन फ़्रांसीसी" },
            { "frr", "उत्तरी फ़्रीसियाई" },
            { "fur", "फ्रीयुलीयान" },
            { "gaa", "गा" },
            { "gez", "गीज़" },
            { "gil", "गिल्बरतीस" },
            { "gor", "गोरोन्तालो" },
            { "gsw", "स्विस जर्मन" },
            { "guz", "गुसी" },
            { "gwi", "ग्विचइन" },
            { "hai", "हैडा" },
            { "haw", "हवाई" },
            { "hil", "हिलिगेनन" },
            { "hmn", "ह्मॉंग" },
            { "hsb", "उपरली सॉर्बियन" },
            { "hup", "हूपा" },
            { "iba", "इबान" },
            { "ibb", "इबिबियो" },
            { "ilo", "इलोको" },
            { "inh", "इंगुश" },
            { "jbo", "लोज्बान" },
            { "jgo", "नगोंबा" },
            { "jmc", "मैकहैमे" },
            { "kaa", "कारा-कल्पक" },
            { "kab", "कबाइल" },
            { "kac", "काचिन" },
            { "kaj", "ज्जु" },
            { "kam", "कम्बा" },
            { "kbd", "कबार्डियन" },
            { "kcg", "त्याप" },
            { "kde", "मैकोंड" },
            { "kea", "काबुवेर्दियानु" },
            { "kfo", "कोरो" },
            { "kgp", "कइंगंग" },
            { "kha", "खासी" },
            { "khq", "कोयरा चीनी" },
            { "kkj", "काको" },
            { "kln", "कलेंजिन" },
            { "kmb", "किम्बन्दु" },
            { "kok", "कोंकणी" },
            { "kpe", "क्पेल" },
            { "krc", "कराचय-बल्कार" },
            { "krl", "करेलियन" },
            { "kru", "कुरूख" },
            { "ksb", "शम्बाला" },
            { "ksf", "बफिआ" },
            { "ksh", "कोलोनियाई" },
            { "kum", "कुमीक" },
            { "lad", "लादीनो" },
            { "lag", "लांगि" },
            { "lez", "लेज़्घीयन" },
            { "lkt", "लैकोटा" },
            { "lou", "लुईज़ियाना क्रियोल" },
            { "loz", "लोज़ी" },
            { "lrc", "उत्तरी लूरी" },
            { "lua", "ल्यूबा-लुलुआ" },
            { "lun", "लुन्डा" },
            { "luo", "ल्युओ" },
            { "lus", "मिज़ो" },
            { "luy", "ल्युईआ" },
            { "mad", "मादुरीस" },
            { "mag", "मगही" },
            { "mai", "मैथिली" },
            { "mak", "मकासर" },
            { "mas", "मसाई" },
            { "mdf", "मुगती" },
            { "men", "मेन्डे" },
            { "mer", "मेरु" },
            { "mfe", "मोरीस्येन" },
            { "mgh", "मैखुवा-मीट्टो" },
            { "mgo", "मेटा" },
            { "mic", "मिकमैक" },
            { "min", "मिनांग्काबाउ" },
            { "mni", "मणिपुरी" },
            { "moh", "मोहौक" },
            { "mos", "मोस्सी" },
            { "mua", "मुंडैंग" },
            { "mul", "इक ते जादा बोलियाँ" },
            { "mus", "क्रीक" },
            { "mwl", "मिरांडी" },
            { "myv", "एर्ज़या" },
            { "mzn", "माज़न्देरानी" },
            { "nap", "नीपोलिटन" },
            { "naq", "नामा" },
            { "nds", "बुरला जर्मन" },
            { "new", "नेवाड़ी" },
            { "nia", "नियास" },
            { "niu", "नियुआन" },
            { "nmg", "क्वासिओ" },
            { "nnh", "गैम्बू" },
            { "nog", "नोगाई" },
            { "nqo", "एन्को" },
            { "nso", "उत्तरी सोथो" },
            { "nus", "नुएर" },
            { "nyn", "न्यानकोल" },
            { "osa", "ओसेज" },
            { "pag", "पंगासीनान" },
            { "pam", "पाम्पान्गा" },
            { "pap", "पापियामेन्टो" },
            { "pau", "पलोउआन" },
            { "pcm", "नाइजीरियाई पिडगिन" },
            { "prg", "प्रुशियाई" },
            { "quc", "किश" },
            { "raj", "राजस्थानी" },
            { "rap", "रापानुई" },
            { "rar", "रारोतोंगन" },
            { "rof", "रोम्बो" },
            { "rup", "अरोमानियन" },
            { "rwk", "रवा" },
            { "sad", "सन्डावे" },
            { "sah", "याकूत" },
            { "saq", "सैम्बुरु" },
            { "sat", "संथाली" },
            { "sba", "न्गाम्बे" },
            { "sbp", "सैंगु" },
            { "scn", "सिसिलियन" },
            { "sco", "स्कॉट्स" },
            { "seh", "सेना" },
            { "ses", "कोयराबोरो सेन्नी" },
            { "shi", "तैचेल्हित" },
            { "shn", "शैन" },
            { "smn", "इनारी सामी" },
            { "sms", "स्कोल्ट सामी" },
            { "snk", "सोनिन्के" },
            { "srn", "स्रानान टॉन्गो" },
            { "ssy", "साहो" },
            { "suk", "सुकुमा" },
            { "swb", "कोमोरियन" },
            { "tem", "टिम्ने" },
            { "teo", "टेसो" },
            { "tet", "तेतुम" },
            { "tig", "टाइग्रे" },
            { "tlh", "क्लिंगन" },
            { "tli", "त्लिंगित" },
            { "tpi", "टोक पिसिन" },
            { "trv", "तारोको" },
            { "tvl", "तुवालु" },
            { "twq", "टासवाक" },
            { "tyv", "तुवीनियन" },
            { "tzm", "बिचला एटलस तमाज़ित" },
            { "udm", "उदमुर्त" },
            { "umb", "उम्बुन्डु" },
            { "und", "अणजाण बोली" },
            { "vai", metaValue_vai },
            { "vun", "वुंजो" },
            { "wae", "वाल्सर" },
            { "wal", "वलामो" },
            { "war", "वारै" },
            { "wbp", "वॉल्पेरी" },
            { "wuu", "वू चीनी" },
            { "xal", "काल्मिक" },
            { "xnr", "कांगड़ी" },
            { "xog", "सोगा" },
            { "yav", "यांगबेन" },
            { "ybb", "येंबा" },
            { "yue", "कैंटोनीज़" },
            { "zgh", "मानक मोरक्कन तामाज़ाइट" },
            { "zun", "ज़ूनी" },
            { "zxx", "कोई बोली सामग्री नी" },
            { "zza", "ज़ाज़ा" },
            { "Arab", metaValue_ar },
            { "Armi", "इम्पिरियल आर्मेनिक" },
            { "Armn", metaValue_hy },
            { "Avst", "अवेस्तन" },
            { "Bali", "बाली" },
            { "Batk", "बटकी" },
            { "Beng", metaValue_bn },
            { "Bopo", "बोपोमोफ़ो" },
            { "Brah", "ब्रह्मी" },
            { "Brai", "ब्रेल" },
            { "Bugi", metaValue_bug },
            { "Buhd", "बुहिद" },
            { "Cakm", metaValue_ccp },
            { "Cans", "युनिफाइड कैनेडियन एबोरिजनल सिलेबिक्स" },
            { "Cari", "करैन" },
            { "Cham", "चाम" },
            { "Cher", metaValue_chr },
            { "Copt", "कॉप्टिक" },
            { "Cprt", "काइप्रायट" },
            { "Cyrl", "सिरिलिक" },
            { "Cyrs", "ओल्ड चर्च स्लावोनिक सिरिलिक" },
            { "Deva", "देवनागरी" },
            { "Dsrt", "डेसरेट" },
            { "Egyp", "इजिप्शियन हाइरोग्लिफ्स" },
            { "Ethi", "इथियोपियाई" },
            { "Geor", "जॉर्जियन" },
            { "Glag", "ग्लेगोलिटिक" },
            { "Goth", "गोथिक" },
            { "Gran", "ग्रन्थ" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "गुरमुखी" },
            { "Hanb", "हांब" },
            { "Hang", "हंगुल" },
            { "Hani", "हान" },
            { "Hano", "हनुनू" },
            { "Hans", "सादी" },
            { "Hant", "पारंपरिक" },
            { "Hebr", metaValue_he },
            { "Hira", "हिरागाना" },
            { "Hmng", "पाहो ह्मोन्ग" },
            { "Hrkt", "जापानी सिलेबरीज़" },
            { "Hung", "ऑल्ड हंगेरियन" },
            { "Ital", "पराणी इटली" },
            { "Jamo", "जामो" },
            { "Java", "जावानीस" },
            { "Jpan", metaValue_ja },
            { "Kali", "कायाह ली" },
            { "Kana", "काताकाना" },
            { "Khar", "खारोशथी" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "कैथी" },
            { "Lana", "लाना" },
            { "Laoo", metaValue_lo },
            { "Latf", "फ़्रैक्टुर लातिनी" },
            { "Latg", "गेली लातिनी" },
            { "Latn", metaValue_la },
            { "Lepc", "लेपचा" },
            { "Limb", "लिम्बू" },
            { "Lina", "रेखा आली ए" },
            { "Linb", "रेखा आली बी" },
            { "Lyci", "लिशियन" },
            { "Lydi", "लिडियन" },
            { "Mand", "मनडेन" },
            { "Mani", "मनीशीन" },
            { "Mero", "मेरोइटिक" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "मेइतेइ मायेक" },
            { "Mymr", "म्यांमार" },
            { "Nkoo", "एन्‘को" },
            { "Ogam", "ओगम" },
            { "Olck", "ऑल चिकी" },
            { "Orkh", "ओरखोन" },
            { "Orya", metaValue_or },
            { "Osma", "ओस्मान्या" },
            { "Perm", "ओल्ड परमिक" },
            { "Phag", "फाग्स-पा" },
            { "Phli", "इंस्क्रिपश्नल पाहलवी" },
            { "Phlp", "सॉल्टर पाहलवी" },
            { "Phnx", "फोनिशियन" },
            { "Plrd", "पॉलार्ड फोनेटिक" },
            { "Prti", "इंस्क्रिपश्नल पार्थियन" },
            { "Rjng", "रीजांग" },
            { "Runr", "रूनिक" },
            { "Samr", "समरिटन" },
            { "Saur", "सौरासटर" },
            { "Sgnw", "सांकेतिक लेख" },
            { "Shaw", "शावियान" },
            { "Sinh", metaValue_si },
            { "Sund", "सूडानी" },
            { "Sylo", "सिलोती नागरी" },
            { "Syrc", "सिरियेक" },
            { "Syre", "एस्त्रेन्जेलो सिरिएक" },
            { "Syrj", "पश्चिम सिरिएक" },
            { "Syrn", "पूर्व सिरिएक" },
            { "Tagb", "तगबन्वा" },
            { "Tale", "ताई ली" },
            { "Talu", "नोआ ताई लु" },
            { "Taml", metaValue_ta },
            { "Tavt", "ताई विएत" },
            { "Telu", metaValue_te },
            { "Tfng", "तिफिनाघ" },
            { "Tglg", "टैगालोग" },
            { "Thaa", "थाना" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", "युगारिटिक" },
            { "Vaii", metaValue_vai },
            { "Xpeo", "पुरानी फारसी" },
            { "Xsux", "सुमेरो अक्कादियन सुनिफॉर्म" },
            { "Yiii", "यी" },
            { "Zinh", "विरासत" },
            { "Zmth", "गणिते आले संकेतन" },
            { "Zsye", "ईमोजी" },
            { "Zsym", "चिह्न" },
            { "Zxxx", "नी लखोया" },
            { "Zyyy", "सामान्य" },
            { "Zzzz", "अणजाण लिपि" },
            { "de_AT", "ऑस्ट्रिया आली जर्मन" },
            { "de_CH", "स्विस उच्च जर्मन" },
            { "en_AU", "अस्ट्रेलिया आली अंग्रेज़ी" },
            { "en_CA", "कनेडे आली अंग्रेज़ी" },
            { "en_GB", "ब्रिटेने आली अंग्रेज़ी" },
            { "en_US", "अमरिके आली अंग्रेज़ी" },
            { "es_ES", "यूरोपे आली स्पेनिश" },
            { "es_MX", "मैक्सिको आली स्पेनिश" },
            { "fa_AF", "दारी" },
            { "fr_CA", "कनेडे आली फ़्रांसीसी" },
            { "fr_CH", "स्विस फ़्रांसीसी" },
            { "nl_BE", "फ़्लेमिश" },
            { "pt_BR", "ब्राज़ीली पुर्तगाली" },
            { "pt_PT", "यूरोपीय पुर्तगाली" },
            { "%%1901", "पारम्पारिक जर्मन वर्तनी" },
            { "%%1996", "जर्मेनी दी 1996 वर्तनी" },
            { "ar_001", "आधुनिक मानक अरबी" },
            { "es_419", "लैटिन अमरिकी स्पेनिश" },
            { "key.ca", "कैलेंडर" },
            { "key.cf", "मुद्रा प्रारूप" },
            { "key.co", "सॉर्ट क्रम" },
            { "key.cu", "मुद्रा" },
            { "key.hc", "घंटेयां दा चक्र (12 कने 24)" },
            { "key.lb", "पंक्ति विच्छेद शैली" },
            { "key.ms", "मापन प्रणाली" },
            { "key.nu", "संख्यां" },
            { "%%NJIVA", "जनीवा बोली" },
            { "%%POSIX", "कम्प्यूटर" },
            { "zh_Hans", "सादी चीनी" },
            { "zh_Hant", "पारंपरिक चीनी" },
            { "%%MONOTON", "एकस्वरीय" },
            { "%%POLYTON", "बड़े सारे स्वरां आली" },
            { "%%REVISED", "संशोधित वर्तनी" },
            { "type.ca.roc", "चीनी गणतंत्र पंचांग" },
            { "type.hc.h11", "12 घंटेयां दी प्रणाली (0–11)" },
            { "type.hc.h12", "12 घंटेयां दी प्रणाली (1–12)" },
            { "type.hc.h23", "24 घंटेयां दी प्रणाली (0–23)" },
            { "type.hc.h24", "24 घंटेयां दी प्रणाली (1–24)" },
            { "type.nu.arab", "अरबी-भारतीय अंक" },
            { "type.nu.armn", "आर्मेनियाई संख्याएँ" },
            { "type.nu.beng", "बंगाली अंक" },
            { "type.nu.deva", "देवनागरी अंक" },
            { "type.nu.ethi", "इथियोपियाई संख्यां" },
            { "type.nu.geor", "जॉर्जियन संख्यां" },
            { "type.nu.grek", "यूनानी संख्यां" },
            { "type.nu.gujr", "गुजराती अंक" },
            { "type.nu.guru", "गुरमुखी अंक" },
            { "type.nu.hans", "सरलीकृत चीनी संख्यां" },
            { "type.nu.hant", "पारंपरिक चीनी संख्यां" },
            { "type.nu.hebr", "हिब्रू संख्यां" },
            { "type.nu.jpan", "जापानी संख्यां" },
            { "type.nu.khmr", "खमेर अंक" },
            { "type.nu.knda", "कन्नड़ अंक" },
            { "type.nu.laoo", "लाओ अंक" },
            { "type.nu.latn", "पश्चिमी अंक" },
            { "type.nu.mlym", "मलयालम अंक" },
            { "type.nu.mymr", "म्यांमार अंक" },
            { "type.nu.orya", "उड़िया अंक" },
            { "type.nu.taml", "पारंपरिक तमिल संख्यां" },
            { "type.nu.telu", "तेलुगू अंक" },
            { "type.nu.thai", "थाई अंक" },
            { "type.nu.tibt", "तिब्बती अंक" },
            { "type.ca.dangi", "दांगी कैलेंडर" },
            { "type.co.ducet", "डिफ़ॉल्ट यूनिकोड सॉर्ट क्रम" },
            { "type.lb.loose", "ढीली लैंण विच्छेद शैली" },
            { "type.nu.roman", "रोमन संख्यां" },
            { "type.ca.hebrew", "हिब्रू पंचांग" },
            { "type.ca.indian", "भारतीय रास्टरिया कैलेंडर" },
            { "type.co.pinyin", "पिनयीन वर्गीकरण" },
            { "type.co.search", "सामान्य-उद्देश्य खोज" },
            { "type.co.stroke", "स्ट्रोक वर्गीकरण" },
            { "type.lb.normal", "सामान्य लैंण विच्छेद शैली" },
            { "type.lb.strict", "सख्त लैंण विच्छेद शैली" },
            { "type.ms.metric", "मेट्रिक प्रणाली" },
            { "type.ca.chinese", "चीनी पंचांग" },
            { "type.ca.islamic", "इस्लामी पंचांग" },
            { "type.ca.iso8601", "आईएसओ-8601 कैलेंडर" },
            { "type.ca.persian", "फ़ारसी कैलेंडर" },
            { "type.cf.account", "लेखांकन मुद्रा प्रारूप" },
            { "type.nu.arabext", "बधायो अरबी-भारतीय अंक" },
            { "type.nu.armnlow", "आर्मेनियाई लोअरकेस संख्यां" },
            { "type.nu.greklow", "यूनानी लोअरकेस संख्यां" },
            { "type.nu.hanidec", "चीनी दशमलव संख्यां" },
            { "type.nu.hansfin", "सरलीकृत चीनी वित्तीय संख्यां" },
            { "type.nu.hantfin", "पारंपरिक चीनी वित्तीय संख्यां" },
            { "type.nu.jpanfin", "जापानी वित्तीय संख्यां" },
            { "type.nu.tamldec", "तमिल अंक" },
            { "type.ca.buddhist", "बौद्ध पंचांग" },
            { "type.ca.ethiopic", "इथियोपिक कैलेंडर" },
            { "type.ca.japanese", "जापानी पंचांग" },
            { "type.cf.standard", "मानक मुद्रा प्रारूप" },
            { "type.co.standard", "मानक सॉर्ट क्रम" },
            { "type.ms.uksystem", "इम्पीरियल मापन प्रणाली" },
            { "type.ms.ussystem", "अमरिकी मापन प्रणाली" },
            { "type.nu.fullwide", "पूरी चौड़ाई अंक" },
            { "type.nu.romanlow", "रोमन लोअरकेस संख्यां" },
            { "type.ca.gregorian", "ग्रेगोरियन कैलेंडर" },
            { "type.co.phonebook", "फोनबुक छंटाई क्रम" },
            { "type.co.traditional", "पारम्पारिक वर्गीकरण" },
            { "type.ca.islamic-civil", "इस्लामी नागरिक पंचांग" },
        };
        return data;
    }
}
