/*
 * Copyright (c) 2012, 2026, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_tg extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Вақти миёнаи Гринвич",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Apia = new String[] {
               "Вақти стандартии Апиа",
               "",
               "Вақти рӯзонаи Апиа",
               "",
               "Вақти Апиа",
               "",
            };
        final String[] Cook = new String[] {
               "Вақти стандартии Ҷазираҳои Кук",
               "",
               "Вақти нимаи тобистонаи Ҷазираҳои Кук",
               "",
               "Вақти ҷазираҳои Кук",
               "",
            };
        final String[] Cuba = new String[] {
               "Вақти стандартии Куба",
               "CST",
               "Вақти рӯзонаи Куба",
               "CDT",
               "Вақти Куба",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Вақти стандартии Фиҷи",
               "",
               "Вақти тобистонаи Фиҷи",
               "",
               "Вақти Фиҷи",
               "",
            };
        final String[] Gulf = new String[] {
               "Вақти стандартии Халиҷи Форс",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Вақти стандартии Ҳовд",
               "",
               "Вақти тобистонаи Ховд",
               "",
               "Вақти Ховд",
               "",
            };
        final String[] Iran = new String[] {
               "Вақти стандартии Эрон",
               "",
               "Вақти рӯзонаи Эрон",
               "",
               "Вақти Эрон",
               "",
            };
        final String[] Niue = new String[] {
               "Вақти Ниуэ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Омск вақти стандартӣ",
               "",
               "Вақти тобистонаи Омск",
               "",
               "Вақти Омск",
               "",
            };
        final String[] Peru = new String[] {
               "Вақти стандартии Перу",
               "",
               "Вақти тобистонаи Перу",
               "",
               "Вақти Перу",
               "",
            };
        final String[] Truk = new String[] {
               "Вақти Чук",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Вақти бедории ҷазира",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Вақти стандартии Чили",
               "",
               "Вақти тобистонаи Чили",
               "",
               "Вақти Чили",
               "",
            };
        final String[] China = new String[] {
               "Вақти стандартии Чин",
               "CST",
               "Вақти рӯзонаи Чин",
               "CDT",
               "Вақти Чин",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Вақти Ҷазираҳои Кокос",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Вақти Давис",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Вақти стандартии Ҳиндустон",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Вақти стандартии Ҷопон",
               "JST",
               "Вақти равшании Ҷопон",
               "JDT",
               "Вақти Ҷопон",
               "JT",
            };
        final String[] Korea = new String[] {
               "Вақти стандартии Корея",
               "KST",
               "Вақти рӯзонаи Корея",
               "KST",
               "Вақти Корея",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Вақти Науру",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Вақти Непал",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Вақти Палау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Вақти стандартии Самоа",
               "SST",
               "Вақти рӯзонаи Самоа",
               "SST",
               "Вақти Самоа",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Вақти Сёва",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Вақти стандартии Тонга",
               "",
               "Вақти тобистонаи Тонга",
               "",
               "Вақти Тонга",
               "",
            };
        final String[] Yukon = new String[] {
               "Вақти Юкон",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Вақти стандартии Аляска",
               "AKST",
               "Вақти рӯзонаи Аляска",
               "AKDT",
               "Вақти Аляска",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Вақти стандартии Амазон",
               "",
               "Вақти тобистонаи Амазон",
               "",
               "Вақти Амазон",
               "",
            };
        final String[] Azores = new String[] {
               "Вақти стандартии Азор",
               "",
               "Вақти тобистонаи Азор",
               "",
               "Вақти Азор",
               "",
            };
        final String[] Bhutan = new String[] {
               "Вақти Бутан",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Вақти Бруней Доруссалом",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Вақти стандартии ҷазираи Пасха",
               "",
               "Вақти тобистонаи ҷазираи Пасха",
               "",
               "Вақти ҷазираи Пасха",
               "",
            };
        final String[] Guyana = new String[] {
               "Вақти Гайана",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "Вақти стандартии Ҳавайӣ-Алеутӣ",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "Вақти стандартии Исроил",
               "IST",
               "Вақти рӯзонаи Исроил",
               "IDT",
               "Вақти Исроил",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Вақти Косрае",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Вақти Мавсон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Вақти стандартии Маскав",
               "MSK",
               "Вақти тобистонаи Маскав",
               "MSK",
               "Вақти Москва",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Ponape Time",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "Вақти Таити",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Вақти стандартии Тайбэй",
               "CST",
               "Вақти рӯзонаи Тайбэй",
               "CDT",
               "Вақти Тайбэй",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Вақти Тувалу",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Вақти Восток",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Вақти Уоллис ва Футуна",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Вақти стандартии Арабистон",
               "",
               "Вақти рӯзонаи Арабистон",
               "",
               "Вақти Арабистон",
               "",
            };
        final String[] Armenia = new String[] {
               "Вақти стандартии Арманистон",
               "",
               "Вақти рӯзонаи Арманистон",
               "",
               "Вақти Арманистон",
               "",
            };
        final String[] Bolivia = new String[] {
               "Вақти Боливия",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Вақти стандартии Чатам",
               "",
               "Вақти рӯзонаи Чатам",
               "",
               "Вақти Чатам",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Вақти ҷаҳонии ҳамоҳангсозӣ",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Вақти Эквадор",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Вақти Гамбир",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Вақти стандартии Гурҷистон",
               "",
               "Вақти тобистонаи Гурҷистон",
               "",
               "Вақти Гурҷистон",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Вақти стандартии Иркутск",
               "",
               "Вақти тобистонаи Иркутск",
               "",
               "Вақти Иркутск",
               "",
            };
        final String[] Magadan = new String[] {
               "Вақти стандартии Магадан",
               "",
               "Вақти тобистонаи Магадан",
               "",
               "Вақти Магадан",
               "",
            };
        final String[] Myanmar = new String[] {
               "Вақти Мянма",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Вақти стандартии ҷазираи Норфолк",
               "",
               "Вақти рӯзонаи ҷазираи Норфолк",
               "",
               "Вақти ҷазираи Норфолк",
               "",
            };
        final String[] Noronha = new String[] {
               "Вақти стандартии Фернандо де Норонха",
               "",
               "Вақти тобистонаи Фернандо де Норонха",
               "",
               "Вақти Фернандо де Норонха",
               "",
            };
        final String[] Reunion = new String[] {
               "Вақти Реюнион",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Вақти Ротера",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Вақти Ҷазираҳои Соломон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Вақти Токелау",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Вақти стандартии Уругвай",
               "",
               "Вақти тобистонаи Уругвай",
               "",
               "Вақти Уругвай",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Вақти стандартии Вануату",
               "",
               "Вақти тобистонаи Вануату",
               "",
               "Вақти Вануату",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Якутск вақти стандартӣ",
               "",
               "Якутск вақти тобистона",
               "",
               "Вақти Якутск",
               "",
            };
        final String[] Atlantic = new String[] {
               "Вақти стандартии атлантикӣ",
               "AST",
               "Вақти рӯзонаи атлантикӣ",
               "AST",
               "Вақти атлантикӣ",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Вақти стандартии Бразилия",
               "",
               "Вақти тобистонаи Бразилия",
               "",
               "Вақти Бразилия",
               "",
            };
        final String[] Chamorro = new String[] {
               "Вақти стандартии Чаморро",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Вақти стандартии Колумбия",
               "",
               "Вақти тобистонаи Колумбия",
               "",
               "Вақти Колумбия",
               "",
            };
        final String[] Falkland = new String[] {
               "Вақти стандартии Ҷазираҳои Фолкленд",
               "",
               "Вақти тобистонаи Ҷазираҳои Фолкленд",
               "",
               "Вақти Ҷазираҳои Фолкленд",
               "",
            };
        final String[] Malaysia = new String[] {
               "Вақти Малайзия",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Вақти Малдив",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Вақти стандартии Улан-Батор",
               "",
               "Вақти тобистонаи Улан-Батор",
               "",
               "Вақти Улан-Батор",
               "",
            };
        final String[] Pakistan = new String[] {
               "Вақти стандартии Покистон",
               "PKT",
               "Вақти тобистонаи Покистон",
               "PKST",
               "Вақти Покистон",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Вақти стандартии Парагвай",
               "",
               "Вақти тобистонаи Парагвай",
               "",
               "Вақти Парагвай",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Вақти Питкэрн",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "Вақти Суринам",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Вақти стандартии Аргентина",
               "",
               "Вақти тобистонаи Аргентина",
               "",
               "Вақти Аргентина",
               "",
            };
        final String[] Christmas = new String[] {
               "Вақти ҷазираи Мавлуди Исо",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Вақти Галапагос",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Вақти стандартии Ҳонконг",
               "HKT",
               "Вақти тобистонаи Ҳонконг",
               "HKST",
               "Вақти Ҳонконг",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Вақти Ҳиндучин",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Вақти Қирғизистон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Вақти стандартии Лорд Хоу",
               "",
               "Вақти рӯзонаи Лорд Хоу",
               "",
               "Лорд Хоу Time",
               "",
            };
        final String[] Marquesas = new String[] {
               "Вақти Маркес",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Вақти стандартии Маврикий",
               "",
               "Вақти тобистонаи Маврикий",
               "",
               "Вақти Маврикий",
               "",
            };
        final String[] Singapore = new String[] {
               "Вақти стандартии Сингапур",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Вақти Венесуэла",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "Вақти стандартии Озарбойҷон",
               "",
               "Вақти тобистонаи Озарбойҷон",
               "",
               "Вақти Озарбойҷон",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Вақти стандартии Бангладеш",
               "",
               "Вақти тобистонаи Бангладеш",
               "",
               "Вақти Бангладеш",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Вақти стандартии Кабо-Верде",
               "",
               "Вақти тобистонаи Кабо-Верде",
               "",
               "Вақти Кабо Верде",
               "",
            };
        final String[] East_Timor = new String[] {
               "Вақти Тимори Шарқӣ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Вақти Қазоқистон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Вақти Сейшел",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Вақти Тоҷикистон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Вақти стандартии Ӯзбекистон",
               "",
               "Вақти тобистонаи Ӯзбекистон",
               "",
               "Вақти Ӯзбекистон",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Вақти Афғонистон",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Вақти стандартии Красноярск",
               "",
               "Вақти тобистонаи Красноярск",
               "",
               "Вақти Красноярск",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Вақти стандартии Зеландияи Нав",
               "NZST",
               "Вақти рӯзонаи Зеландияи Нав",
               "NZDT",
               "Вақти Зеландияи Нав",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "Вақти стандартии Филиппин",
               "PST",
               "Вақти тобистонаи Филиппин",
               "PDT",
               "Вақти Филиппин",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Вақти стандартии Владивосток",
               "",
               "Вақти тобистонаи Владивосток",
               "",
               "Вақти Владивосток",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Вақти уқёнуси Ҳинд",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Вақти Ҷазираҳои Лин",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Вақти стандартии Нюфаундленд",
               "NST",
               "Вақти рӯзонаи Нюфаундленд",
               "NDT",
               "Вақти Нюфаундленд",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Вақти стандартии Туркманистон",
               "",
               "Вақти тобистонаи Туркманистон",
               "",
               "Вақти Туркманистон",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Вақти Гвианаи Фаронса",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Вақти стандартии Каледонияи Нав",
               "",
               "Вақти тобистонаи Каледонияи Нав",
               "",
               "Вақти Каледонияи Нав",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Вақти Ҷорҷияи Ҷанубӣ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Вақти стандартии Екатеринбург",
               "",
               "Вақти тобистонаи Екатеринбург",
               "",
               "Вақти Екатеринбург",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Вақти Африқои Марказӣ",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Вақти Африқои Шарқӣ",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Вақти Африқои Ғарбӣ",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Вақти Дюмон-д’Урвил",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Вақти стандартии аврупоии марказӣ",
               "CET",
               "Вақти тобистонаи аврупоии марказӣ",
               "CEST",
               "Вақти Аврупоии Марказӣ",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Вақти стандартии аврупоии шарқӣ",
               "EET",
               "Вақти тобистонаи аврупоии шарқӣ",
               "EEST",
               "Вақти аврупоии шарқӣ",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Вақти стандартии аврупоии ғарбӣ",
               "WET",
               "Вақти тобистонаи аврупоии ғарбӣ",
               "WEST",
               "Вақти аврупоии ғарбӣ",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Вақти стандартии Уқёнуси Ором Мексика",
               "MST",
               "Вақти рӯзонаи Уқёнуси Ором Мексика",
               "MDT",
               "Вақти Уқёнуси Ором Мексика",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Вақти стандартии Африқои Ҷанубӣ",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Вақти стандартии марказӣ",
               "CST",
               "Вақти рӯзонаи марказӣ",
               "CDT",
               "Вақти марказӣ",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Вақти стандартии шарқӣ",
               "EST",
               "Вақти рӯзонаи шарқӣ",
               "EST",
               "Вақти шарқӣ",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Вақти стандартии Уқёнуси Ором",
               "PST",
               "Вақти рӯзонаи Уқёнуси Ором",
               "PDT",
               "Вақти Уқёнуси Ором",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Вақти ҷанубӣ ва Антарктидаи Фаронса",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Вақти Ҷазираҳои Гилберт",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Вақти стандартии Ҳавайӣ-Алеутӣ",
               "HST",
               "Вақти рӯзонаи Ҳавайӣ-Алеутӣ",
               "HDT",
               "Вақти Ҳавайӣ-Алеутӣ",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Вақти Ҷазираҳои Финикс",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Вақти стандартии Сент-Пиер ва Микелон",
               "",
               "Вақти рӯзонаи Сент-Пиер ва Микелон",
               "",
               "Вақти Сент-Пиер ва Микелон",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Вақти стандартии кӯҳӣ",
               "MST",
               "Вақти рӯзонаи кӯҳӣ",
               "MST",
               "Вақти кӯҳӣ",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Вақти Ҷазираҳои Маршалл",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Вақти Папуа Гвинеяи Нав",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Вақти стандартии Австралияи Марказӣ",
               "ACST",
               "Вақти рӯонаи Австралияи Марказӣ",
               "ACDT",
               "Вақти Австралияи Марказӣ",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Вақти стандартии шарқии Австралия",
               "AEST",
               "Вақти рӯзонаи шарқии Австралия",
               "AEDT",
               "Вақти Австралияи Шарқӣ",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Вақти стандартии Австралияи Ғарбӣ",
               "AWST",
               "Вақти рӯзонаи Австралияи Ғарбӣ",
               "AWDT",
               "Вақти Австралияи Ғарбӣ",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Вақти Индонезияи Марказӣ",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Вақти шарқии Индонезия",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Вақти Индонезияи Ғарбӣ",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Вақти стандартии Ғарбии Австралия Марказӣ",
               "",
               "Вақти рӯзонаи Ғарбии Австралия Марказӣ",
               "",
               "Вақти Ғарбии Марказии Австралия",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Вақти миёнаи Гринвич",
                    "GMT",
                    "Вақти тобистонаи Британия",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Вақти ҷаҳонии ҳамоҳангсозӣ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Вақти миёнаи Гринвич",
                    "GMT",
                    "Вақти стандартии Ирландия",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Вақти ҷаҳонии ҳамоҳангсозӣ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Вақти ҷаҳонии ҳамоҳангсозӣ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Вақти миёнаи Гринвич",
                    "GMT",
                    "Вақти тобистонаи Британия",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Вақти ҷаҳонии ҳамоҳангсозӣ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "Вақти ҷаҳонии ҳамоҳангсозӣ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Вақти ҷаҳонии ҳамоҳангсозӣ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Вақти миёнаи Гринвич",
                    "GMT",
                    "Вақти стандартии Ирландия",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Вақти миёнаи Гринвич",
                    "GMT",
                    "Вақти тобистонаи Британия",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Вақти миёнаи Гринвич",
                    "GMT",
                    "Вақти тобистонаи Британия",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Вақти миёнаи Гринвич",
                    "GMT",
                    "Вақти тобистонаи Британия",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Вақти миёнаи Гринвич",
                    "GMT",
                    "Вақти тобистонаи Британия",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Вақти миёнаи Гринвич",
                    "GMT",
                    "Вақти тобистонаи Британия",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "Адан" },
            { "timezone.excity.Asia/Baku", "Боку" },
            { "timezone.excity.Asia/Dili", "Дили" },
            { "timezone.excity.Asia/Gaza", "Ғазза" },
            { "timezone.excity.Asia/Hovd", "Ховд" },
            { "timezone.excity.Asia/Omsk", "Омск" },
            { "timezone.excity.Asia/Oral", "Орал" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Аммон" },
            { "timezone.excity.Asia/Aqtau", "Актау" },
            { "timezone.excity.Asia/Chita", "Чита" },
            { "timezone.excity.Asia/Dhaka", "Дакка" },
            { "timezone.excity.Asia/Dubai", "Дубай" },
            { "timezone.excity.Asia/Kabul", "Кобул" },
            { "timezone.excity.Asia/Macau", "Макао" },
            { "timezone.excity.Asia/Qatar", "Қатар" },
            { "timezone.excity.Asia/Seoul", "Сеул" },
            { "timezone.excity.Asia/Tokyo", "Токио" },
            { "timezone.excity.Asia/Tomsk", "Томск" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "Ҷуба" },
            { "timezone.excity.Africa/Lome", "Ломе" },
            { "timezone.excity.Asia/Almaty", "Алмаато" },
            { "timezone.excity.Asia/Anadyr", "Анадир" },
            { "timezone.excity.Asia/Aqtobe", "Актобе" },
            { "timezone.excity.Asia/Atyrau", "Атирау" },
            { "timezone.excity.Asia/Beirut", "Бейрут" },
            { "timezone.excity.Asia/Brunei", "Бруней" },
            { "timezone.excity.Asia/Hebron", "Хеброн" },
            { "timezone.excity.Asia/Kuwait", "Кувайт" },
            { "timezone.excity.Asia/Manila", "Манила" },
            { "timezone.excity.Asia/Muscat", "Маскат" },
            { "timezone.excity.Asia/Riyadh", "Риёз" },
            { "timezone.excity.Asia/Saigon", "Хо Ши Мин" },
            { "timezone.excity.Asia/Taipei", "Тайбэй" },
            { "timezone.excity.Asia/Tehran", "Теҳрон" },
            { "timezone.excity.Asia/Urumqi", "Урумчи" },
            { "timezone.excity.Etc/Unknown", "Шаҳри номаълум" },
            { "timezone.excity.Europe/Kiev", "Киев" },
            { "timezone.excity.Europe/Oslo", "Осло" },
            { "timezone.excity.Europe/Riga", "Рига" },
            { "timezone.excity.Europe/Rome", "Рим" },
            { "timezone.excity.Indian/Mahe", "Махе" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Аккра" },
            { "timezone.excity.Africa/Cairo", "Қоҳира" },
            { "timezone.excity.Africa/Ceuta", "Сеута" },
            { "timezone.excity.Africa/Dakar", "Дакар" },
            { "timezone.excity.Africa/Lagos", "Лагос" },
            { "timezone.excity.Africa/Tunis", "Тунис" },
            { "timezone.excity.America/Adak", "Адак" },
            { "timezone.excity.America/Lima", "Лима" },
            { "timezone.excity.America/Nome", "Ном" },
            { "timezone.excity.Asia/Baghdad", "Багдод" },
            { "timezone.excity.Asia/Bahrain", "Баҳрайн" },
            { "timezone.excity.Asia/Bangkok", "Бангкок" },
            { "timezone.excity.Asia/Barnaul", "Барнаул" },
            { "timezone.excity.Asia/Bishkek", "Бишкек" },
            { "timezone.excity.Asia/Colombo", "Коломбо" },
            { "timezone.excity.Asia/Irkutsk", "Иркутск" },
            { "timezone.excity.Asia/Jakarta", "Ҷакарта" },
            { "timezone.excity.Asia/Karachi", "Карачи" },
            { "timezone.excity.Asia/Kuching", "Кучинг" },
            { "timezone.excity.Asia/Magadan", "Магадан" },
            { "timezone.excity.Asia/Nicosia", "Никосия" },
            { "timezone.excity.Asia/Rangoon", "Янгон" },
            { "timezone.excity.Asia/Tbilisi", "Тбилиси" },
            { "timezone.excity.Asia/Thimphu", "Тимфу" },
            { "timezone.excity.Asia/Yakutsk", "Якутск" },
            { "timezone.excity.Asia/Yerevan", "Ереван" },
            { "timezone.excity.Europe/Kirov", "Киров" },
            { "timezone.excity.Europe/Malta", "Малта" },
            { "timezone.excity.Europe/Minsk", "Минск" },
            { "timezone.excity.Europe/Paris", "Париж" },
            { "timezone.excity.Europe/Sofia", "София" },
            { "timezone.excity.Europe/Vaduz", "Вадуз" },
            { "timezone.excity.Indian/Cocos", "Кокос" },
            { "timezone.excity.Pacific/Apia", "Апиа" },
            { "timezone.excity.Pacific/Fiji", "Фиҷи" },
            { "timezone.excity.Pacific/Guam", "Гуам" },
            { "timezone.excity.Pacific/Niue", "Ниуэ" },
            { "timezone.excity.Pacific/Truk", "Чук" },
            { "timezone.excity.Pacific/Wake", "Вейк" },
            { "timezone.excity.Africa/Asmera", "Асмара" },
            { "timezone.excity.Africa/Bamako", "Бамако" },
            { "timezone.excity.Africa/Bangui", "Бангуи" },
            { "timezone.excity.Africa/Banjul", "Банҷул" },
            { "timezone.excity.Africa/Bissau", "Бисау" },
            { "timezone.excity.Africa/Douala", "Дуала" },
            { "timezone.excity.Africa/Harare", "Хараре" },
            { "timezone.excity.Africa/Kigali", "Кигали" },
            { "timezone.excity.Africa/Luanda", "Луанда" },
            { "timezone.excity.Africa/Lusaka", "Лусака" },
            { "timezone.excity.Africa/Malabo", "Малабо" },
            { "timezone.excity.Africa/Maputo", "Мапуту" },
            { "timezone.excity.Africa/Maseru", "Масеру" },
            { "timezone.excity.Africa/Niamey", "Ниамей" },
            { "timezone.excity.America/Aruba", "Аруба" },
            { "timezone.excity.America/Bahia", "Бахия" },
            { "timezone.excity.America/Belem", "Белем" },
            { "timezone.excity.America/Boise", "Бойз" },
            { "timezone.excity.America/Jujuy", "Ҷуҷуй" },
            { "timezone.excity.America/Sitka", "Ситка" },
            { "timezone.excity.America/Thule", "Туле" },
            { "timezone.excity.Asia/Ashgabat", "Ашхобод" },
            { "timezone.excity.Asia/Calcutta", "Колката" },
            { "timezone.excity.Asia/Damascus", "Димишқ" },
            { "timezone.excity.Asia/Dushanbe", "Душанбе" },
            { "timezone.excity.Asia/Jayapura", "Ҷаяпура" },
            { "timezone.excity.Asia/Katmandu", "Катманду" },
            { "timezone.excity.Asia/Khandyga", "Хандига" },
            { "timezone.excity.Asia/Makassar", "Макасар" },
            { "timezone.excity.Asia/Qostanay", "Кустанай" },
            { "timezone.excity.Asia/Sakhalin", "Сахалин" },
            { "timezone.excity.Asia/Shanghai", "Шанхай" },
            { "timezone.excity.Asia/Tashkent", "Тошкент" },
            { "timezone.excity.Asia/Ust-Nera", "Уст-Нера" },
            { "timezone.excity.Europe/Athens", "Афина" },
            { "timezone.excity.Europe/Berlin", "Берлин" },
            { "timezone.excity.Europe/Dublin", "Дублин" },
            { "timezone.excity.Europe/Jersey", "Ҷерси" },
            { "timezone.excity.Europe/Lisbon", "Лиссабон" },
            { "timezone.excity.Europe/London", "Лондон" },
            { "timezone.excity.Europe/Madrid", "Мадрид" },
            { "timezone.excity.Europe/Monaco", "Монако" },
            { "timezone.excity.Europe/Moscow", "Москва" },
            { "timezone.excity.Europe/Prague", "Прага" },
            { "timezone.excity.Europe/Samara", "Самара" },
            { "timezone.excity.Europe/Skopje", "Скопйе" },
            { "timezone.excity.Europe/Tirane", "Тиран" },
            { "timezone.excity.Europe/Vienna", "Вена" },
            { "timezone.excity.Europe/Warsaw", "Варшава" },
            { "timezone.excity.Europe/Zagreb", "Загреб" },
            { "timezone.excity.Europe/Zurich", "Сюрих" },
            { "timezone.excity.Indian/Chagos", "Чагос" },
            { "timezone.excity.Indian/Comoro", "Коморо" },
            { "timezone.excity.Pacific/Efate", "Эфате" },
            { "timezone.excity.Pacific/Nauru", "Науру" },
            { "timezone.excity.Pacific/Palau", "Палау" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "Абидҷон" },
            { "timezone.excity.Africa/Algiers", "Алҷазоир" },
            { "timezone.excity.Africa/Conakry", "Конакри" },
            { "timezone.excity.Africa/Kampala", "Кампала" },
            { "timezone.excity.Africa/Mbabane", "Мбабане" },
            { "timezone.excity.Africa/Nairobi", "Найроби" },
            { "timezone.excity.Africa/Tripoli", "Триполи" },
            { "timezone.excity.America/Belize", "Белиз" },
            { "timezone.excity.America/Bogota", "Богота" },
            { "timezone.excity.America/Cancun", "Канкун" },
            { "timezone.excity.America/Cayman", "Кайман" },
            { "timezone.excity.America/Cuiaba", "Куяба" },
            { "timezone.excity.America/Dawson", "Доусон" },
            { "timezone.excity.America/Denver", "Денвер" },
            { "timezone.excity.America/Guyana", "Гайана" },
            { "timezone.excity.America/Havana", "Ҳавана" },
            { "timezone.excity.America/Inuvik", "Инувик" },
            { "timezone.excity.America/Juneau", "Ҷуно" },
            { "timezone.excity.America/La_Paz", "Ла-Пас" },
            { "timezone.excity.America/Maceio", "Масейо" },
            { "timezone.excity.America/Manaus", "Манаус" },
            { "timezone.excity.America/Merida", "Мерида" },
            { "timezone.excity.America/Nassau", "Нассау" },
            { "timezone.excity.America/Panama", "Панама" },
            { "timezone.excity.America/Recife", "Ресифи" },
            { "timezone.excity.America/Regina", "Регина" },
            { "timezone.excity.Asia/Famagusta", "Фамагуста" },
            { "timezone.excity.Asia/Hong_Kong", "Ҳонконг" },
            { "timezone.excity.Asia/Jerusalem", "Йерусалим" },
            { "timezone.excity.Asia/Kamchatka", "Камчатка" },
            { "timezone.excity.Asia/Pontianak", "Понтианак" },
            { "timezone.excity.Asia/Pyongyang", "Пхенян" },
            { "timezone.excity.Asia/Qyzylorda", "Қизилорда" },
            { "timezone.excity.Asia/Samarkand", "Самарқанд" },
            { "timezone.excity.Asia/Singapore", "Сингапур" },
            { "timezone.excity.Asia/Vientiane", "Вьентян" },
            { "timezone.excity.Europe/Andorra", "Андорра" },
            { "timezone.excity.Europe/Saratov", "Саратов" },
            { "timezone.excity.Europe/Tallinn", "Таллин" },
            { "timezone.excity.Europe/Vatican", "Ватикан" },
            { "timezone.excity.Europe/Vilnius", "Вилнюс" },
            { "timezone.excity.Indian/Mayotte", "Майотта" },
            { "timezone.excity.Indian/Reunion", "Реюнион" },
            { "timezone.excity.Pacific/Easter", "Истер" },
            { "timezone.excity.Pacific/Kosrae", "Косрае" },
            { "timezone.excity.Pacific/Majuro", "Мажуро" },
            { "timezone.excity.Pacific/Midway", "Мидвей" },
            { "timezone.excity.Pacific/Noumea", "Нумеа" },
            { "timezone.excity.Pacific/Ponape", "Понпей" },
            { "timezone.excity.Pacific/Saipan", "Сайпан" },
            { "timezone.excity.Pacific/Tahiti", "Таити" },
            { "timezone.excity.Pacific/Tarawa", "Тарава" },
            { "timezone.excity.Pacific/Wallis", "Уоллис" },
            { "timezone.excity.Africa/Blantyre", "Блантайр" },
            { "timezone.excity.Africa/Djibouti", "Ҷибути" },
            { "timezone.excity.Africa/El_Aaiun", "Эл Аиун" },
            { "timezone.excity.Africa/Freetown", "Фритаун" },
            { "timezone.excity.Africa/Gaborone", "Габороне" },
            { "timezone.excity.Africa/Khartoum", "Хартум" },
            { "timezone.excity.Africa/Kinshasa", "Киншаса" },
            { "timezone.excity.Africa/Monrovia", "Монровия" },
            { "timezone.excity.Africa/Ndjamena", "Нҷамена" },
            { "timezone.excity.Africa/Sao_Tome", "Сан-Томе" },
            { "timezone.excity.Africa/Windhoek", "Виндхук" },
            { "timezone.excity.America/Antigua", "Антигуа" },
            { "timezone.excity.America/Caracas", "Каракас" },
            { "timezone.excity.America/Cayenne", "Кайен" },
            { "timezone.excity.America/Chicago", "Чикаго" },
            { "timezone.excity.America/Cordoba", "Кордоба" },
            { "timezone.excity.America/Creston", "Крестон" },
            { "timezone.excity.America/Curacao", "Кюрасао" },
            { "timezone.excity.America/Detroit", "Детройт" },
            { "timezone.excity.America/Godthab", "Нуук" },
            { "timezone.excity.America/Grenada", "Гренада" },
            { "timezone.excity.America/Halifax", "Галифакс" },
            { "timezone.excity.America/Iqaluit", "Икалуит" },
            { "timezone.excity.America/Jamaica", "Ямайка" },
            { "timezone.excity.America/Managua", "Манагуа" },
            { "timezone.excity.America/Marigot", "Мариго" },
            { "timezone.excity.America/Mendoza", "Мендоза" },
            { "timezone.excity.America/Moncton", "Монктон" },
            { "timezone.excity.America/Noronha", "Норонха" },
            { "timezone.excity.America/Ojinaga", "Ожинага" },
            { "timezone.excity.America/Phoenix", "Финикс" },
            { "timezone.excity.America/Tijuana", "Тихуана" },
            { "timezone.excity.America/Toronto", "Торонто" },
            { "timezone.excity.America/Tortola", "Тортола" },
            { "timezone.excity.America/Yakutat", "Якутат" },
            { "timezone.excity.Asia/Phnom_Penh", "Пномпен" },
            { "timezone.excity.Atlantic/Azores", "Ҷазираҳои Азор" },
            { "timezone.excity.Atlantic/Canary", "Канария" },
            { "timezone.excity.Atlantic/Faeroe", "Фарер" },
            { "timezone.excity.Australia/Eucla", "Эукла" },
            { "timezone.excity.Australia/Perth", "Перт" },
            { "timezone.excity.Europe/Belgrade", "Белград" },
            { "timezone.excity.Europe/Brussels", "Брюссел" },
            { "timezone.excity.Europe/Budapest", "Будапешт" },
            { "timezone.excity.Europe/Busingen", "Бусинген" },
            { "timezone.excity.Europe/Chisinau", "Кишинёв" },
            { "timezone.excity.Europe/Guernsey", "Гернси" },
            { "timezone.excity.Europe/Helsinki", "Хелсинки" },
            { "timezone.excity.Europe/Istanbul", "Истанбул" },
            { "timezone.excity.Europe/Sarajevo", "Сараево" },
            { "timezone.excity.Indian/Maldives", "Малдив" },
            { "timezone.excity.Pacific/Chatham", "Чатам" },
            { "timezone.excity.Pacific/Fakaofo", "Факаофо" },
            { "timezone.excity.Pacific/Gambier", "Гамбир" },
            { "timezone.excity.Pacific/Norfolk", "Норфолк" },
            { "timezone.excity.Africa/Bujumbura", "Буҷумбура" },
            { "timezone.excity.Africa/Mogadishu", "Могадишо" },
            { "timezone.excity.America/Anguilla", "Ангиля" },
            { "timezone.excity.America/Asuncion", "Асунсион" },
            { "timezone.excity.America/Barbados", "Барбадос" },
            { "timezone.excity.America/Dominica", "Доминика" },
            { "timezone.excity.America/Edmonton", "Эдмонтон" },
            { "timezone.excity.America/Eirunepe", "Эйрунепе" },
            { "timezone.excity.America/Mazatlan", "Мазатлан" },
            { "timezone.excity.America/Miquelon", "Микелон" },
            { "timezone.excity.America/New_York", "Ню-Йорк" },
            { "timezone.excity.America/Resolute", "Резолют" },
            { "timezone.excity.America/Santarem", "Сантарем" },
            { "timezone.excity.America/Santiago", "Сантьяго" },
            { "timezone.excity.America/St_Johns", "Сент Ҷонс" },
            { "timezone.excity.America/St_Kitts", "Сент Китс" },
            { "timezone.excity.America/St_Lucia", "Сент-Люсия" },
            { "timezone.excity.America/Winnipeg", "Виннипег" },
            { "timezone.excity.Antarctica/Casey", "Кейси" },
            { "timezone.excity.Antarctica/Davis", "Дэвис" },
            { "timezone.excity.Antarctica/Syowa", "Сёва" },
            { "timezone.excity.Antarctica/Troll", "Тролл" },
            { "timezone.excity.Asia/Krasnoyarsk", "Красноярск" },
            { "timezone.excity.Asia/Novosibirsk", "Новосибирск" },
            { "timezone.excity.Asia/Ulaanbaatar", "Улан-Батор" },
            { "timezone.excity.Asia/Vladivostok", "Владивосток" },
            { "timezone.excity.Atlantic/Bermuda", "Бермуда" },
            { "timezone.excity.Atlantic/Madeira", "Мадейра" },
            { "timezone.excity.Atlantic/Stanley", "Стэнли" },
            { "timezone.excity.Australia/Darwin", "Дарвин" },
            { "timezone.excity.Australia/Hobart", "Хобарт" },
            { "timezone.excity.Australia/Sydney", "Сидней" },
            { "timezone.excity.Europe/Amsterdam", "Амстердам" },
            { "timezone.excity.Europe/Astrakhan", "Астрахань" },
            { "timezone.excity.Europe/Bucharest", "Бухарест" },
            { "timezone.excity.Europe/Gibraltar", "Гибралтар" },
            { "timezone.excity.Europe/Ljubljana", "Любляна" },
            { "timezone.excity.Europe/Mariehamn", "Марихамн" },
            { "timezone.excity.Europe/Podgorica", "Подгоритса" },
            { "timezone.excity.Europe/Stockholm", "Стокголм" },
            { "timezone.excity.Europe/Ulyanovsk", "Уляновск" },
            { "timezone.excity.Europe/Volgograd", "Волгоград" },
            { "timezone.excity.Indian/Christmas", "Кристмас" },
            { "timezone.excity.Indian/Kerguelen", "Кергулен" },
            { "timezone.excity.Indian/Mauritius", "Маврикий" },
            { "timezone.excity.Pacific/Auckland", "Окленд" },
            { "timezone.excity.Pacific/Funafuti", "Фунафути" },
            { "timezone.excity.Pacific/Pitcairn", "Питкэрн" },
            { "timezone.excity.Africa/Casablanca", "Касабланка" },
            { "timezone.excity.Africa/Libreville", "Либревиль" },
            { "timezone.excity.Africa/Lubumbashi", "Лубумбаши" },
            { "timezone.excity.Africa/Nouakchott", "Нуакшот" },
            { "timezone.excity.Africa/Porto-Novo", "Порто-Ново" },
            { "timezone.excity.America/Anchorage", "Анкорич" },
            { "timezone.excity.America/Araguaina", "Арагуайна" },
            { "timezone.excity.America/Boa_Vista", "Боа Виста" },
            { "timezone.excity.America/Catamarca", "Катамарка" },
            { "timezone.excity.America/Chihuahua", "Чихуахуа" },
            { "timezone.excity.America/Coyhaique", "Койҳайке" },
            { "timezone.excity.America/Fortaleza", "Форталеза" },
            { "timezone.excity.America/Glace_Bay", "Глэйс Бэй" },
            { "timezone.excity.America/Goose_Bay", "Гус Бэй" },
            { "timezone.excity.America/Guatemala", "Гватемала" },
            { "timezone.excity.America/Guayaquil", "Гуаякил" },
            { "timezone.excity.America/Matamoros", "Матаморос" },
            { "timezone.excity.America/Menominee", "Меномин" },
            { "timezone.excity.America/Monterrey", "Монтеррей" },
            { "timezone.excity.America/Sao_Paulo", "Сан-Паулу" },
            { "timezone.excity.America/St_Thomas", "Сент Томас" },
            { "timezone.excity.America/Vancouver", "Ванкувер" },
            { "timezone.excity.Antarctica/Mawson", "Мавсон" },
            { "timezone.excity.Antarctica/Palmer", "Палмер" },
            { "timezone.excity.Antarctica/Vostok", "Восток" },
            { "timezone.excity.Asia/Kuala_Lumpur", "Куала Лумпур" },
            { "timezone.excity.Asia/Novokuznetsk", "Новокузнетск" },
            { "timezone.excity.Europe/Bratislava", "Братислава" },
            { "timezone.excity.Europe/Copenhagen", "Копенгаген" },
            { "timezone.excity.Europe/Luxembourg", "Люксембург" },
            { "timezone.excity.Europe/San_Marino", "Сан-Марино" },
            { "timezone.excity.Europe/Simferopol", "Симферопол" },
            { "timezone.excity.Pacific/Enderbury", "Кантон" },
            { "timezone.excity.Pacific/Galapagos", "Галапагос" },
            { "timezone.excity.Pacific/Kwajalein", "Кважалейн" },
            { "timezone.excity.Pacific/Marquesas", "Маркес" },
            { "timezone.excity.Pacific/Pago_Pago", "Паго Паго" },
            { "timezone.excity.Pacific/Rarotonga", "Раротонга" },
            { "timezone.excity.Pacific/Tongatapu", "Тонгатапу" },
            { "timezone.excity.Africa/Addis_Ababa", "Аддис-Абеба" },
            { "timezone.excity.Africa/Brazzaville", "Браззавил" },
            { "timezone.excity.Africa/Ouagadougou", "Уагадугу" },
            { "timezone.excity.America/Costa_Rica", "Коста Рика" },
            { "timezone.excity.America/Grand_Turk", "Гранд Терк" },
            { "timezone.excity.America/Guadeloupe", "Гваделупа" },
            { "timezone.excity.America/Hermosillo", "Эрмосилло" },
            { "timezone.excity.America/Kralendijk", "Кралендйк" },
            { "timezone.excity.America/Louisville", "Луисвилл" },
            { "timezone.excity.America/Martinique", "Мартиника" },
            { "timezone.excity.America/Metlakatla", "Метлакатла" },
            { "timezone.excity.America/Montevideo", "Монтевидео" },
            { "timezone.excity.America/Montserrat", "Монсеррат" },
            { "timezone.excity.America/Paramaribo", "Парамарибо" },
            { "timezone.excity.America/Rio_Branco", "Рио Бранко" },
            { "timezone.excity.America/St_Vincent", "Сент Винсент" },
            { "timezone.excity.America/Whitehorse", "Уайтхорс" },
            { "timezone.excity.Antarctica/McMurdo", "Макмердо" },
            { "timezone.excity.Antarctica/Rothera", "Ротера" },
            { "timezone.excity.Asia/Srednekolymsk", "Среднеколимск" },
            { "timezone.excity.Asia/Yekaterinburg", "Екатеринбург" },
            { "timezone.excity.Atlantic/Reykjavik", "Рейкявик" },
            { "timezone.excity.Atlantic/St_Helena", "Сент Елена" },
            { "timezone.excity.Australia/Adelaide", "Аделаида" },
            { "timezone.excity.Australia/Brisbane", "Брисбен" },
            { "timezone.excity.Australia/Lindeman", "Линдеман" },
            { "timezone.excity.Europe/Isle_of_Man", "Ҷазираи Ман" },
            { "timezone.excity.Europe/Kaliningrad", "Калининград" },
            { "timezone.excity.Pacific/Kiritimati", "Киритимати" },
            { "timezone.excity.Africa/Johannesburg", "Йоханнесбург" },
            { "timezone.excity.America/El_Salvador", "Сальвадор" },
            { "timezone.excity.America/Fort_Nelson", "Форт Нелсон" },
            { "timezone.excity.America/Los_Angeles", "Лос-Анҷелес" },
            { "timezone.excity.America/Mexico_City", "Мехико" },
            { "timezone.excity.America/Porto_Velho", "Порту Велхо" },
            { "timezone.excity.America/Puerto_Rico", "Пуэрто-Рико" },
            { "timezone.excity.America/Tegucigalpa", "Тегусигалпа" },
            { "timezone.excity.Arctic/Longyearbyen", "Лонгйербён" },
            { "timezone.excity.Atlantic/Cape_Verde", "Кабо-Верде" },
            { "timezone.excity.Australia/Lord_Howe", "Лорд Хоу" },
            { "timezone.excity.Australia/Melbourne", "Мелбурн" },
            { "timezone.excity.Indian/Antananarivo", "Антананариву" },
            { "timezone.excity.Pacific/Guadalcanal", "Гвадалканал" },
            { "timezone.excity.Africa/Dar_es_Salaam", "Доруссалом" },
            { "timezone.excity.America/Blanc-Sablon", "Блан-Саблон" },
            { "timezone.excity.America/Buenos_Aires", "Буэнос-Айрес" },
            { "timezone.excity.America/Campo_Grande", "Кампо Гранде" },
            { "timezone.excity.America/Danmarkshavn", "Данмаркшавн" },
            { "timezone.excity.America/Dawson_Creek", "Доусон Крик" },
            { "timezone.excity.America/Indiana/Knox", "Нокс, Индиана" },
            { "timezone.excity.America/Indianapolis", "Индианаполис" },
            { "timezone.excity.America/Punta_Arenas", "Пунта Аренас" },
            { "timezone.excity.America/Rankin_Inlet", "Ранкин Инлет" },
            { "timezone.excity.America/Scoresbysund", "Иттоккортоормиит" },
            { "timezone.excity.Antarctica/Macquarie", "Маккуари" },
            { "timezone.excity.Pacific/Bougainville", "Бугенвилл" },
            { "timezone.excity.Pacific/Port_Moresby", "Порт Морсби" },
            { "timezone.excity.America/Cambridge_Bay", "Кембриҷ Бэй" },
            { "timezone.excity.America/Ciudad_Juarez", "Сюдад Хуарес" },
            { "timezone.excity.America/Coral_Harbour", "Атикокан" },
            { "timezone.excity.America/Indiana/Vevay", "Вевай, Индиана" },
            { "timezone.excity.America/Lower_Princes", "Квартали Поёни Принс" },
            { "timezone.excity.America/Port_of_Spain", "Порти Испания" },
            { "timezone.excity.America/Santo_Domingo", "Санто Доминго" },
            { "timezone.excity.America/St_Barthelemy", "Сент Бартелеми" },
            { "timezone.excity.America/Swift_Current", "Свифт-Каррент" },
            { "timezone.excity.Australia/Broken_Hill", "Брокен-Хилл" },
            { "timezone.excity.America/Bahia_Banderas", "Бахия де Бандерас" },
            { "timezone.excity.America/Port-au-Prince", "Порт-о-Пренс" },
            { "timezone.excity.Atlantic/South_Georgia", "Ҷорҷияи Ҷанубӣ" },
            { "timezone.excity.America/Argentina/Salta", "Салта" },
            { "timezone.excity.America/Indiana/Marengo", "Маренго, Индиана" },
            { "timezone.excity.America/Indiana/Winamac", "Винамак, Индиана" },
            { "timezone.excity.America/Argentina/Tucuman", "Тукуман" },
            { "timezone.excity.America/Argentina/Ushuaia", "Ушуайя" },
            { "timezone.excity.America/Indiana/Tell_City", "Тел Сити, Индиана" },
            { "timezone.excity.America/Indiana/Vincennes", "Винсенс, Индиана" },
            { "timezone.excity.Antarctica/DumontDUrville", "Дюмон д’Урвилл" },
            { "timezone.excity.America/Argentina/La_Rioja", "Ла Риоха" },
            { "timezone.excity.America/Argentina/San_Juan", "Сан-Хуан" },
            { "timezone.excity.America/Argentina/San_Luis", "Сан Луис" },
            { "timezone.excity.America/Indiana/Petersburg", "Петербург, Индиана" },
            { "timezone.excity.America/Kentucky/Monticello", "Монтичелло, Кентукки" },
            { "timezone.excity.America/North_Dakota/Beulah", "Бейла, Дакотаи Шимолӣ" },
            { "timezone.excity.America/North_Dakota/Center", "Сентр, Дакотаи Шимолӣ" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "Рио Галлегос" },
            { "timezone.excity.America/North_Dakota/New_Salem", "Ню Салем, Дакотаи Шимолӣ" },
        };
        return data;
    }
}
