/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.core;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.core.XProcStep;
import com.xmlcalabash.io.DocumentSequence;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.model.Step;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.JSONtoXML;
import com.xmlcalabash.util.LogOptions;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.tree.iter.NamespaceIterator;
import org.xml.sax.InputSource;

public class XProcConfiguration {
    public static final QName _prefix = new QName("", "prefix");
    public static final QName _uri = new QName("", "uri");
    public static final QName _class_name = new QName("", "class-name");
    public static final QName _type = new QName("", "type");
    public static final QName _port = new QName("", "port");
    public static final QName _href = new QName("", "href");
    public static final QName _data = new QName("", "data");
    public static final QName _name = new QName("", "name");
    public static final QName _key = new QName("", "key");
    public static final QName _value = new QName("", "value");
    public static final QName _loader = new QName("", "loader");
    public static final QName _exclude_inline_prefixes = new QName("", "exclude-inline-prefixes");
    public String saxonProcessor = "he";
    public boolean schemaAware = false;
    public String saxonConfigFile = null;
    public Hashtable<String, String> nsBindings = new Hashtable();
    public boolean debug = false;
    public Hashtable<String, Vector<ReadablePipe>> inputs = new Hashtable();
    public ReadablePipe pipeline = null;
    public Hashtable<String, String> outputs = new Hashtable();
    public Hashtable<String, Hashtable<QName, String>> params = new Hashtable();
    public Hashtable<QName, String> options = new Hashtable();
    public boolean safeMode = false;
    public String stepName = null;
    public String entityResolver = null;
    public String uriResolver = null;
    public String errorListener = null;
    public Hashtable<QName, String> implementations = new Hashtable();
    public Hashtable<String, String> serializationOptions = new Hashtable();
    public LogOptions logOpt = LogOptions.WRAPPED;
    public Vector<String> extensionFunctions = new Vector();
    public String foProcessor = null;
    public String cssProcessor = null;
    public String xprocConfigurer = null;
    public String htmlParser = "validator.nu";
    public String mailHost = null;
    public String mailPort = "25";
    public String mailUser = null;
    public String mailPass = null;
    public Hashtable<String, String> loaders = new Hashtable();
    public boolean extensionValues = false;
    public boolean xpointerOnText = false;
    public boolean transparentJSON = false;
    public String jsonFlavor = "marklogic";
    public boolean useXslt10 = false;
    private Processor cfgProcessor = null;
    private boolean firstInput = false;
    private boolean firstOutput = false;

    public XProcConfiguration() {
        this.init("he", false, null);
    }

    public XProcConfiguration(boolean schemaAware) {
        this.init("he", schemaAware, null);
    }

    public XProcConfiguration(String saxoncfg) {
        this.init(null, false, saxoncfg);
    }

    public XProcConfiguration(String proctype, boolean schemaAware) {
        this.init(proctype, schemaAware, null);
    }

    public XProcConfiguration(Processor processor) {
        this.cfgProcessor = processor;
        this.loadConfiguration();
        if (this.schemaAware != processor.isSchemaAware()) {
            throw new XProcException("Schema awareness in configuration conflicts with specified processor.");
        }
    }

    public Processor getProcessor() {
        return this.cfgProcessor;
    }

    private void init(String proctype, boolean schemaAware, String saxoncfg) {
        if (schemaAware) {
            proctype = "ee";
        }
        this.createSaxonProcessor(proctype, schemaAware, saxoncfg);
        this.loadConfiguration();
        this.schemaAware = this.cfgProcessor.isSchemaAware();
        this.saxonProcessor = Configuration.softwareEdition.toLowerCase();
        if (proctype != null && !this.saxonProcessor.equals(proctype) || schemaAware != this.schemaAware || saxoncfg == null && this.saxonConfigFile != null) {
            this.nsBindings.clear();
            this.inputs.clear();
            this.outputs.clear();
            this.params.clear();
            this.options.clear();
            this.implementations.clear();
            this.extensionFunctions.clear();
            this.createSaxonProcessor(this.saxonProcessor, this.schemaAware, this.saxonConfigFile);
            this.loadConfiguration();
            this.schemaAware = this.cfgProcessor.isSchemaAware();
            this.saxonProcessor = Configuration.softwareEdition.toLowerCase();
        }
    }

    private void createSaxonProcessor(String proctype, boolean schemaAware, String saxoncfg) {
        boolean licensed;
        boolean bl = licensed = schemaAware || !"he".equals(proctype);
        if (saxoncfg != null) {
            try {
                FileInputStream instream = new FileInputStream(saxoncfg);
                SAXSource source = new SAXSource(new InputSource(instream));
                this.cfgProcessor = new Processor((Source)source);
            }
            catch (FileNotFoundException e) {
                throw new XProcException(e);
            }
            catch (SaxonApiException e) {
                throw new XProcException(e);
            }
        } else {
            this.cfgProcessor = new Processor(licensed);
        }
        String actualtype = Configuration.softwareEdition;
        if (proctype != null && !"he".equals(proctype) && !actualtype.toLowerCase().equals(proctype)) {
            System.err.println("Failed to obtain " + proctype.toUpperCase() + " processor; using " + actualtype + " instead.");
        }
    }

    private void loadConfiguration() {
        String s;
        block12: {
            XdmNode cnode;
            URI cwd;
            block11: {
                URI home = URIUtils.homeAsURI();
                cwd = URIUtils.cwdAsURI();
                URI puri = home;
                this.cfgProcessor.getUnderlyingConfiguration().setStripsAllWhiteSpace(false);
                this.cfgProcessor.getUnderlyingConfiguration().setStripsWhiteSpace(0);
                try {
                    InputStream instream = this.getClass().getResourceAsStream("/etc/configuration.xml");
                    if (instream == null) {
                        throw new UnsupportedOperationException("Failed to load configuration from JAR file");
                    }
                    SAXSource source = new SAXSource(new InputSource(instream));
                    DocumentBuilder builder = this.cfgProcessor.newDocumentBuilder();
                    builder.setLineNumbering(true);
                    builder.setBaseURI(puri);
                    this.parse(builder.build((Source)source));
                }
                catch (SaxonApiException sae) {
                    throw new XProcException(sae);
                }
                try {
                    cnode = this.readXML(".calabash", home.toASCIIString());
                    this.parse(cnode);
                }
                catch (XProcException xe) {
                    if (XProcConstants.dynamicError(11).equals((Object)xe.getErrorCode())) break block11;
                    throw xe;
                }
            }
            try {
                cnode = this.readXML(".calabash", cwd.toASCIIString());
                this.parse(cnode);
            }
            catch (XProcException xe) {
                if (XProcConstants.dynamicError(11).equals((Object)xe.getErrorCode())) break block12;
                throw xe;
            }
        }
        this.saxonProcessor = System.getProperty("com.xmlcalabash.saxon-processor", this.saxonProcessor);
        if (!("he".equals(this.saxonProcessor) || "pe".equals(this.saxonProcessor) || "ee".equals(this.saxonProcessor))) {
            throw new XProcException("Invalid Saxon processor specified in com.xmlcalabash.saxon-processor property.");
        }
        this.saxonConfigFile = System.getProperty("com.xmlcalabash.saxon-configuration", this.saxonConfigFile);
        this.schemaAware = "true".equals(System.getProperty("com.xmlcalabash.schema-aware", "" + this.schemaAware));
        this.debug = "true".equals(System.getProperty("com.xmlcalabash.debug", "" + this.debug));
        this.extensionValues = "true".equals(System.getProperty("com.xmlcalabash.general-values", "" + this.extensionValues));
        this.xpointerOnText = "true".equals(System.getProperty("com.xmlcalabash.xpointer-on-text", "" + this.xpointerOnText));
        this.transparentJSON = "true".equals(System.getProperty("com.xmlcalabash.transparent-json", "" + this.transparentJSON));
        this.jsonFlavor = System.getProperty("com.xmlcalabash.json-flavor", this.jsonFlavor);
        this.useXslt10 = "true".equals(System.getProperty("com.xmlcalabash.use-xslt-10", "" + this.useXslt10));
        this.entityResolver = System.getProperty("com.xmlcalabash.entity-resolver", this.entityResolver);
        this.uriResolver = System.getProperty("com.xmlcalabash.uri-resolver", this.uriResolver);
        this.errorListener = System.getProperty("com.xmlcalabash.error-listener", this.errorListener);
        this.foProcessor = System.getProperty("com.xmlcalabash.fo-processor", this.foProcessor);
        this.cssProcessor = System.getProperty("com.xmlcalabash.css-processor", this.cssProcessor);
        this.xprocConfigurer = System.getProperty("com.xmlcalabash.xproc-configurer", this.xprocConfigurer);
        this.htmlParser = System.getProperty("com.xmlcalabash.html-parser", this.htmlParser);
        this.mailHost = System.getProperty("com.xmlcalabash.mail-host", this.mailHost);
        this.mailPort = System.getProperty("com.xmlcalabash.mail-port", this.mailPort);
        this.mailUser = System.getProperty("com.xmlcalabash.mail-username", this.mailUser);
        this.mailPass = System.getProperty("com.xmlcalabash.mail-password", this.mailPass);
        String[] boolSerNames = new String[]{"byte-order-mark", "escape-uri-attributes", "include-content-type", "indent", "omit-xml-declaration", "undeclare-prefixes"};
        String[] strSerNames = new String[]{"doctype-public", "doctype-system", "encoding", "media-type", "normalization-form", "version", "standalone"};
        for (String name : boolSerNames) {
            s = System.getProperty("com.xmlcalabash.serial." + name);
            if (!"true".equals(s) && !"false".equals(s)) continue;
            this.serializationOptions.put(name, s);
        }
        for (String name : strSerNames) {
            s = System.getProperty("com.xmlcalabash.serial." + name);
            if (s == null) continue;
            this.serializationOptions.put(name, s);
        }
        String method = System.getProperty("com.xmlcalabash.serial.method");
        if ("html".equals(method) || "xhtml".equals(method) || "text".equals(method) || "xml".equals(method)) {
            this.serializationOptions.put(method, method);
        }
    }

    public XdmNode readXML(String href, String base) {
        SAXSource source = null;
        href = URIUtils.encode(href);
        try {
            URI baseURI = new URI(base);
            source = new SAXSource(new InputSource(baseURI.resolve(href).toASCIIString()));
        }
        catch (URISyntaxException use) {
            throw new XProcException(use);
        }
        DocumentBuilder builder = this.cfgProcessor.newDocumentBuilder();
        builder.setLineNumbering(true);
        try {
            return builder.build((Source)source);
        }
        catch (SaxonApiException sae) {
            throw new XProcException(XProcConstants.dynamicError(11), (Throwable)sae);
        }
    }

    public void parse(XdmNode doc) {
        if (doc.getNodeKind() == XdmNodeKind.DOCUMENT) {
            doc = S9apiUtils.getDocumentElement(doc);
        }
        for (XdmNode node : new RelevantNodes(null, doc, Axis.CHILD)) {
            String uri = node.getNodeName().getNamespaceURI();
            String localName = node.getNodeName().getLocalName();
            if (!"http://xmlcalabash.com/ns/configuration".equals(uri) && !"http://exproc.org/ns/configuration".equals(uri)) continue;
            if ("implementation".equals(localName)) {
                this.parseImplementation(node);
                continue;
            }
            if ("saxon-processor".equals(localName)) {
                this.parseSaxonProcessor(node);
                continue;
            }
            if ("saxon-configuration".equals(localName)) {
                this.parseSaxonConfiguration(node);
                continue;
            }
            if ("schema-aware".equals(localName)) {
                this.parseSchemaAware(node);
                continue;
            }
            if ("namespace-binding".equals(localName)) {
                this.parseNamespaceBinding(node);
                continue;
            }
            if ("debug".equals(localName)) {
                this.parseDebug(node);
                continue;
            }
            if ("entity-resolver".equals(localName)) {
                this.parseEntityResolver(node);
                continue;
            }
            if ("input".equals(localName)) {
                this.parseInput(node);
                continue;
            }
            if ("output".equals(localName)) {
                this.parseOutput(node);
                continue;
            }
            if ("with-option".equals(localName)) {
                this.parseWithOption(node);
                continue;
            }
            if ("with-param".equals(localName)) {
                this.parseWithParam(node);
                continue;
            }
            if ("safe-mode".equals(localName)) {
                this.parseSafeMode(node);
                continue;
            }
            if ("step-name".equals(localName)) {
                this.parseStepName(node);
                continue;
            }
            if ("uri-resolver".equals(localName)) {
                this.parseURIResolver(node);
                continue;
            }
            if ("step-error-listener".equals(localName)) {
                this.parseErrorListener(node);
                continue;
            }
            if ("pipeline".equals(localName)) {
                this.parsePipeline(node);
                continue;
            }
            if ("serialization".equals(localName)) {
                this.parseSerialization(node);
                continue;
            }
            if ("extension-function".equals(localName)) {
                this.parseExtensionFunction(node);
                continue;
            }
            if ("fo-processor".equals(localName)) {
                this.parseFoProcessor(node);
                continue;
            }
            if ("css-processor".equals(localName)) {
                this.parseCssProcessor(node);
                continue;
            }
            if ("xproc-configurer".equals(localName)) {
                this.parseXProcConfigurer(node);
                continue;
            }
            if ("default-system-property".equals(localName)) {
                this.parseSystemProperty(node);
                continue;
            }
            if ("extension".equals(localName)) {
                this.parseExtension(node);
                continue;
            }
            if ("html-parser".equals(localName)) {
                this.parseHtmlParser(node);
                continue;
            }
            if ("sendmail".equals(localName)) {
                this.parseSendMail(node);
                continue;
            }
            if ("saxon-configuration-property".equals(localName)) {
                this.saxonConfigurationProperty(node);
                continue;
            }
            if ("pipeline-loader".equals(localName)) {
                this.pipelineLoader(node);
                continue;
            }
            throw new XProcException(doc, "Unexpected configuration option: " + localName);
        }
        this.firstInput = true;
        this.firstOutput = true;
    }

    public boolean isStepAvailable(QName type) {
        return this.implementations.containsKey(type);
    }

    public XProcStep newStep(XProcRuntime runtime, XAtomicStep step) {
        String className = this.implementations.get(step.getType());
        if (className == null) {
            throw new UnsupportedOperationException("Misconfigured. No 'class' in configuration for " + step.getType());
        }
        if (runtime.getSafeMode() && !className.startsWith("com.xmlcalabash.")) {
            throw XProcException.dynamicError(21);
        }
        try {
            Constructor<?> constructor = Class.forName(className).getConstructor(XProcRuntime.class, XAtomicStep.class);
            return (XProcStep)constructor.newInstance(runtime, step);
        }
        catch (NoSuchMethodException nsme) {
            throw new UnsupportedOperationException("No such method: " + className, nsme);
        }
        catch (ClassNotFoundException cfne) {
            throw new UnsupportedOperationException("Class not found: " + className, cfne);
        }
        catch (InstantiationException ie) {
            throw new UnsupportedOperationException("Instantiation error", ie);
        }
        catch (IllegalAccessException iae) {
            throw new UnsupportedOperationException("Illegal access error", iae);
        }
        catch (InvocationTargetException ite) {
            throw new UnsupportedOperationException("Invocation target exception", ite);
        }
    }

    private void parseSaxonProcessor(XdmNode node) {
        String value = node.getStringValue().trim();
        if (!("he".equals(value) || "pe".equals(value) || "ee".equals(value))) {
            throw new XProcException(node, "Invalid Saxon processor: " + value + ". Must be 'he', 'pe', or 'ee'.");
        }
        this.saxonProcessor = value;
    }

    private void parseSaxonConfiguration(XdmNode node) {
        String value;
        this.saxonConfigFile = value = node.getStringValue().trim();
    }

    private void parseSchemaAware(XdmNode node) {
        String value = node.getStringValue().trim();
        if (!"true".equals(value) && !"false".equals(value)) {
            throw new XProcException(node, "Invalid configuration value for schema-aware: " + value);
        }
        this.schemaAware = "true".equals(value);
    }

    private void parseNamespaceBinding(XdmNode node) {
        String aname = node.getAttributeValue(_prefix);
        String avalue = node.getAttributeValue(_uri);
        this.nsBindings.put(aname, avalue);
    }

    private void parseDebug(XdmNode node) {
        String value = node.getStringValue().trim();
        this.debug = "true".equals(value);
        if (!"true".equals(value) && !"false".equals(value)) {
            throw new XProcException(node, "Invalid configuration value for debug: " + value);
        }
    }

    private void parseEntityResolver(XdmNode node) {
        String value;
        this.entityResolver = value = node.getAttributeValue(_class_name);
    }

    private void parseExtensionFunction(XdmNode node) {
        String value = node.getAttributeValue(_class_name);
        this.extensionFunctions.add(value);
    }

    private void parseFoProcessor(XdmNode node) {
        String value;
        this.foProcessor = value = node.getAttributeValue(_class_name);
    }

    private void parseCssProcessor(XdmNode node) {
        String value;
        this.cssProcessor = value = node.getAttributeValue(_class_name);
    }

    private void parseXProcConfigurer(XdmNode node) {
        String value;
        this.xprocConfigurer = value = node.getAttributeValue(_class_name);
    }

    private void parseSystemProperty(XdmNode node) {
        String name = node.getAttributeValue(_name);
        String value = node.getAttributeValue(_value);
        if (name == null || value == null) {
            throw new XProcException("Configuration option 'default-system-property' cannot have null name or value");
        }
        if (System.getProperty(name) == null) {
            System.setProperty(name, value);
        }
    }

    private void parseExtension(XdmNode node) {
        String name = node.getAttributeValue(_name);
        String value = node.getAttributeValue(_value);
        if (name == null || value == null) {
            throw new XProcException("Configuration option 'extension' cannot have null name or value");
        }
        if ("general-values".equals(name)) {
            this.extensionValues = "true".equals(value);
        } else if ("xpointer-on-text".equals(name)) {
            this.xpointerOnText = "true".equals(value);
        } else if ("transparent-json".equals(name)) {
            this.transparentJSON = "true".equals(value);
        } else if ("json-flavor".equals(name)) {
            this.jsonFlavor = value;
            if (!JSONtoXML.knownFlavor(this.jsonFlavor)) {
                throw new XProcException("Unrecognized JSON flavor: " + this.jsonFlavor);
            }
        } else if ("use-xslt-1.0".equals(name) || "use-xslt-10".equals(name)) {
            this.useXslt10 = "true".equals(value);
        } else {
            throw new XProcException("Unrecognized extension in configuration: " + name);
        }
    }

    private void parseHtmlParser(XdmNode node) {
        String value = node.getAttributeValue(_value);
        if (value == null) {
            throw new XProcException("Configuration option 'html-parser' cannot have null value");
        }
        if (!"validator.nu".equals(value) && !"tagsoup".equals(value)) {
            throw new XProcException("Unrecognized value in html-parser: " + value);
        }
        this.htmlParser = value;
    }

    private void parseSendMail(XdmNode node) {
        String host = node.getAttributeValue(new QName("", "host"));
        String port = node.getAttributeValue(_port);
        String user = node.getAttributeValue(new QName("", "username"));
        String pass = node.getAttributeValue(new QName("", "password"));
        if (host != null) {
            this.mailHost = host;
        }
        if (port != null) {
            this.mailPort = port;
        }
        if (user != null) {
            this.mailUser = user;
            if (pass == null) {
                throw new XProcException("Misconfigured sendmail: user specified without password");
            }
            this.mailPass = pass;
        }
    }

    private void saxonConfigurationProperty(XdmNode node) {
        String value = node.getAttributeValue(_value);
        String key = node.getAttributeValue(_key);
        String type = node.getAttributeValue(_type);
        Object valueObj = null;
        if (key == null || value == null) {
            throw new XProcException("Configuration option 'saxon-configuration-property' cannot have a null key or value");
        }
        valueObj = "boolean".equals(type) ? Boolean.valueOf("true".equals(value)) : ("integer".equals(type) ? Integer.valueOf(Integer.parseInt(value)) : value);
        try {
            this.cfgProcessor.setConfigurationProperty(key, valueObj);
        }
        catch (Exception e) {
            throw new XProcException(e);
        }
    }

    private void pipelineLoader(XdmNode node) {
        String data = node.getAttributeValue(_data);
        String href = node.getAttributeValue(_href);
        String loader = node.getAttributeValue(_loader);
        if (data == null && href == null || data != null && href != null) {
            throw new XProcException("Configuration option 'pipeline-loader' must have one of 'href' or 'data'");
        }
        if (loader == null) {
            throw new XProcException("Configuration option 'pipeline-loader' must specify a 'loader'");
        }
        if (data == null) {
            this.loaders.put("href:" + href, loader);
        } else {
            this.loaders.put("data:" + data, loader);
        }
    }

    private void parseInput(XdmNode node) {
        String port = node.getAttributeValue(_port);
        String href = node.getAttributeValue(_href);
        Vector<XdmValue> docnodes = new Vector<XdmValue>();
        boolean sawElement = false;
        for (XdmNode child : new RelevantNodes(null, node, Axis.CHILD)) {
            if (child.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (sawElement) {
                    throw new XProcException(node, "Invalid configuration value for input '" + port + "': content is not a valid XML document.");
                }
                sawElement = true;
            }
            docnodes.add((XdmValue)child);
        }
        if (this.firstInput) {
            this.inputs.clear();
            this.firstInput = false;
        }
        if (!this.inputs.containsKey(port)) {
            this.inputs.put(port, new Vector());
        }
        Vector<ReadablePipe> documents = this.inputs.get(port);
        if (href != null) {
            if (docnodes.size() > 0) {
                throw new XProcException(node, "Invalid configuration value for input '" + port + "': href and content on input.");
            }
            documents.add(new ConfigDocument(href, node.getBaseURI().toASCIIString()));
        } else {
            HashSet<String> excludeURIs = this.readExcludeInlinePrefixes(node, node.getAttributeValue(_exclude_inline_prefixes));
            documents.add(new ConfigDocument(docnodes, excludeURIs));
        }
    }

    private HashSet<String> readExcludeInlinePrefixes(XdmNode node, String prefixList) {
        HashSet<String> excludeURIs = new HashSet<String>();
        excludeURIs.add("http://www.w3.org/ns/xproc");
        if (prefixList != null) {
            NodeInfo inode = node.getUnderlyingNode();
            NamePool pool = inode.getNamePool();
            int[] inscopeNS = NamespaceIterator.getInScopeNamespaceCodes((NodeInfo)inode);
            for (String pfx : prefixList.split("\\s+")) {
                boolean found = false;
                for (int pos = 0; pos < inscopeNS.length; ++pos) {
                    int ns = inscopeNS[pos];
                    String nspfx = pool.getPrefixFromNamespaceCode(ns);
                    String nsuri = pool.getURIFromNamespaceCode(ns);
                    if (!pfx.equals(nspfx)) continue;
                    found = true;
                    excludeURIs.add(nsuri);
                }
                if (found) continue;
                throw new XProcException(XProcConstants.staticError(57), "No binding for '" + pfx + ":'");
            }
        }
        return excludeURIs;
    }

    private void parsePipeline(XdmNode node) {
        String href = node.getAttributeValue(_href);
        Vector<XdmValue> docnodes = new Vector<XdmValue>();
        boolean sawElement = false;
        for (XdmNode child : new RelevantNodes(null, node, Axis.CHILD)) {
            if (child.getNodeKind() == XdmNodeKind.ELEMENT) {
                if (sawElement) {
                    throw new XProcException(node, "Content of pipeline is not a valid XML document.");
                }
                sawElement = true;
            }
            docnodes.add((XdmValue)child);
        }
        if (href != null) {
            if (docnodes.size() > 0) {
                throw new XProcException(node, "XProcConfiguration error: href and content on pipeline");
            }
            this.pipeline = new ConfigDocument(href, node.getBaseURI().toASCIIString());
        } else {
            HashSet<String> excludeURIs = this.readExcludeInlinePrefixes(node, node.getAttributeValue(_exclude_inline_prefixes));
            this.pipeline = new ConfigDocument(docnodes, excludeURIs);
        }
    }

    private void parseOutput(XdmNode node) {
        String port = node.getAttributeValue(_port);
        String href = node.getAttributeValue(_href);
        for (XdmNode child : new RelevantNodes(null, node, Axis.CHILD)) {
            if (child.getNodeKind() != XdmNodeKind.ELEMENT) continue;
            throw new XProcException(node, "Output must be empty.");
        }
        if (this.firstOutput) {
            this.outputs.clear();
            this.firstOutput = false;
        }
        if ("-".equals(href = node.getBaseURI().resolve(href).toASCIIString()) || href.startsWith("http:") || href.startsWith("https:") || href.startsWith("file:")) {
            this.outputs.put(port, href);
        } else {
            File f = new File(href);
            String fn = URIUtils.encode(f.getAbsolutePath());
            if ("\\".equals(System.getProperty("file.separator"))) {
                fn = "/" + fn;
            }
            this.outputs.put(port, "file://" + fn);
        }
    }

    private void parseWithOption(XdmNode node) {
        String nameStr = node.getAttributeValue(_name);
        String value = node.getAttributeValue(_value);
        QName name = new QName(nameStr, node);
        this.options.put(name, value);
    }

    private void parseWithParam(XdmNode node) {
        String port = node.getAttributeValue(_port);
        String nameStr = node.getAttributeValue(_name);
        String value = node.getAttributeValue(_value);
        QName name = new QName(nameStr, node);
        if (port == null) {
            port = "*";
        }
        Hashtable<QName, String> pvalues = this.params.containsKey(port) ? this.params.get(port) : new Hashtable<QName, String>();
        pvalues.put(name, value);
        this.params.put(port, pvalues);
    }

    private void parseSafeMode(XdmNode node) {
        String value = node.getStringValue().trim();
        this.safeMode = "true".equals(value);
        if (!"true".equals(value) && !"false".equals(value)) {
            throw new XProcException(node, "Unexpected configuration value for safe-mode: " + value);
        }
    }

    private void parseStepName(XdmNode node) {
        String value;
        this.stepName = value = node.getStringValue().trim();
    }

    private void parseURIResolver(XdmNode node) {
        String value;
        this.uriResolver = value = node.getAttributeValue(_class_name);
    }

    private void parseErrorListener(XdmNode node) {
        String value;
        this.errorListener = value = node.getAttributeValue(_class_name);
    }

    private void parseImplementation(XdmNode node) {
        String nameStr = node.getAttributeValue(_type);
        String value = node.getAttributeValue(_class_name);
        if (nameStr == null || value == null) {
            throw new XProcException(node, "Unexpected implementation in configuration; must have both type and class-name attributes");
        }
        for (String tname : nameStr.split("\\s+")) {
            QName name = new QName(tname, node);
            this.implementations.put(name, value);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseSerialization(XdmNode node) {
        String[] attributeNames = new String[]{"byte-order-mark", "cdata-section-elements", "doctype-public", "doctype-system", "encoding", "escape-uri-attributes", "include-content-type", "indent", "media-type", "method", "normalization-form", "omit-xml-declaration", "standalone", "undeclare-prefixes", "version"};
        this.checkAttributes(node, attributeNames, false);
        for (String name : attributeNames) {
            String value = node.getAttributeValue(new QName(name));
            if (value == null) continue;
            if ("byte-order-mark".equals(name) || "escape-uri-attributes".equals(name) || "include-content-type".equals(name) || "indent".equals(name) || "omit-xml-declaration".equals(name) || "undeclare-prefixes".equals(name)) {
                this.checkBoolean(node, name, value);
                this.serializationOptions.put(name, value);
            } else if ("method".equals(name)) {
                QName methodName = new QName(value, node);
                if (!"".equals(methodName.getPrefix())) throw new XProcException(node, "Configuration error: only the xml, xhtml, html, and text serialization methods are supported.");
                String method = methodName.getLocalName();
                if (!"html".equals(method) && !"xhtml".equals(method) && !"text".equals(method) && !"xml".equals(method)) throw new XProcException(node, "Configuration error: only the xml, xhtml, html, and text serialization methods are supported.");
                this.serializationOptions.put(name, method);
            } else {
                this.serializationOptions.put(name, value);
            }
            Iterator<XdmNode> i$ = new RelevantNodes(null, node, Axis.CHILD).iterator();
            if (!i$.hasNext()) continue;
            XdmNode snode = i$.next();
            throw new XProcException(node, "Configuration error: serialization must be empty");
        }
    }

    private HashSet<String> checkAttributes(XdmNode node, String[] attrs, boolean optionShortcutsOk) {
        HashSet<String> hash = null;
        if (attrs != null) {
            hash = new HashSet<String>();
            for (String attr : attrs) {
                hash.add(attr);
            }
        }
        HashSet<String> options = null;
        for (XdmNode attr : new RelevantNodes(null, node, Axis.ATTRIBUTE)) {
            QName aname = attr.getNodeName();
            if ("".equals(aname.getNamespaceURI())) {
                if (hash.contains(aname.getLocalName())) continue;
                if (optionShortcutsOk) {
                    if (options == null) {
                        options = new HashSet<String>();
                    }
                    options.add(aname.getLocalName());
                    continue;
                }
                throw new XProcException(node, "Configuration error: attribute \"" + aname + "\" not allowed on " + node.getNodeName());
            }
            if (!"http://www.w3.org/ns/xproc".equals(aname.getNamespaceURI())) continue;
            throw new XProcException(node, "Configuration error: attribute \"" + aname + "\" not allowed on " + node.getNodeName());
        }
        return options;
    }

    private void checkBoolean(XdmNode node, String name, String value) {
        if (value != null && !"true".equals(value) && !"false".equals(value)) {
            throw new XProcException(node, "Configuration error: " + name + " on serialization must be 'true' or 'false'");
        }
    }

    private class ConfigDocument
    implements ReadablePipe {
        private String href = null;
        private String base = null;
        private Vector<XdmValue> nodes = null;
        private boolean read = false;
        private XdmNode doc = null;
        private HashSet<String> excludeUris = null;

        public ConfigDocument(String href, String base) {
            this.href = href;
            this.base = base;
        }

        public ConfigDocument(Vector<XdmValue> nodes, HashSet<String> excludeUris) {
            this.nodes = nodes;
            this.excludeUris = excludeUris;
        }

        @Override
        public void canReadSequence(boolean sequence) {
        }

        @Override
        public boolean readSequence() {
            return false;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public XdmNode read() throws SaxonApiException {
            this.read = true;
            if (this.doc != null) {
                return this.doc;
            }
            if (this.nodes != null) {
                XdmNode node = null;
                for (int pos = 0; pos < this.nodes.size() && node == null; ++pos) {
                    if (((XdmNode)this.nodes.get(pos)).getNodeKind() != XdmNodeKind.ELEMENT) continue;
                    node = (XdmNode)this.nodes.get(pos);
                }
                XdmDestination dest = new XdmDestination();
                try {
                    S9apiUtils.writeXdmValue(XProcConfiguration.this.cfgProcessor, this.nodes, (Destination)dest, node.getBaseURI());
                    this.doc = dest.getXdmNode();
                    if (this.excludeUris.size() == 0) return this.doc;
                    this.doc = S9apiUtils.removeNamespaces(XProcConfiguration.this.cfgProcessor, this.doc, this.excludeUris, true);
                    return this.doc;
                }
                catch (SaxonApiException sae) {
                    throw new XProcException(sae);
                }
            } else {
                this.doc = XProcConfiguration.this.readXML(this.href, this.base);
            }
            return this.doc;
        }

        @Override
        public void setReader(Step step) {
        }

        @Override
        public void resetReader() {
            this.read = false;
        }

        @Override
        public boolean moreDocuments() {
            return !this.read;
        }

        @Override
        public boolean closed() {
            return false;
        }

        @Override
        public int documentCount() {
            return 1;
        }

        @Override
        public DocumentSequence documents() {
            throw new XProcException("You can't get the document sequence of an input from the config file!");
        }
    }
}

