/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.wrapper;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Stripper;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.wrapper.SpaceStrippedNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpaceStrippedDocument
extends SpaceStrippedNode
implements DocumentInfo {
    private Stripper stripper;
    private boolean preservesSpace;
    private HashMap<String, Object> userData;

    public SpaceStrippedDocument(DocumentInfo doc, Stripper stripper) {
        this.node = doc;
        this.parent = null;
        this.docWrapper = this;
        this.stripper = stripper;
        this.preservesSpace = SpaceStrippedDocument.findPreserveSpace(doc);
    }

    public SpaceStrippedNode wrap(NodeInfo node) {
        return this.makeWrapper(node, this, null);
    }

    public Stripper getStripper() {
        return this.stripper;
    }

    @Override
    public Configuration getConfiguration() {
        return this.node.getConfiguration();
    }

    @Override
    public NamePool getNamePool() {
        return this.node.getNamePool();
    }

    @Override
    public long getDocumentNumber() {
        return this.node.getDocumentNumber();
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        NodeInfo n = ((DocumentInfo)this.node).selectID(id, false);
        if (n == null) {
            return null;
        }
        return this.makeWrapper(n, this, null);
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        return ((DocumentInfo)this.node).getUnparsedEntityNames();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        return ((DocumentInfo)this.node).getUnparsedEntity(name);
    }

    private static boolean findPreserveSpace(DocumentInfo doc) {
        NodeInfo node;
        String val;
        AxisIterator iter = doc.iterateAxis((byte)4, NodeKindTest.ELEMENT);
        do {
            if ((node = (NodeInfo)iter.next()) != null) continue;
            return false;
        } while (!"preserve".equals(val = node.getAttributeValue(386)));
        return true;
    }

    public boolean containsPreserveSpace() {
        return this.preservesSpace;
    }

    @Override
    public void setUserData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap(4);
        }
        if (value == null) {
            this.userData.remove(key);
        } else {
            this.userData.put(key, value);
        }
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }
}

