/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.io.Serializable;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.InstanceOfExpression;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.instruct.AttributeSet;
import net.sf.saxon.expr.instruct.Block;
import net.sf.saxon.expr.instruct.Choose;
import net.sf.saxon.expr.instruct.Copy;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.expr.instruct.UseAttributeSets;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.DecimalValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Whitespace;

public class XSLCopy
extends StyleElement {
    private String use;
    private AttributeSet[] attributeSets = null;
    private boolean copyNamespaces = true;
    private boolean inheritNamespaces = true;
    private int validationAction = 3;
    private SchemaType schemaType = null;
    private Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String copyNamespacesAtt = null;
        String validationAtt = null;
        String typeAtt = null;
        String inheritAtt = null;
        String selectAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("use-attribute-sets")) {
                this.use = atts.getValue(a);
                continue;
            }
            if (f.equals("copy-namespaces")) {
                copyNamespacesAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            if (f.equals("type")) {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("validation")) {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f.equals("inherit-namespaces")) {
                inheritAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (copyNamespacesAtt == null) {
            this.copyNamespaces = true;
        } else if (copyNamespacesAtt.equals("yes")) {
            this.copyNamespaces = true;
        } else if (copyNamespacesAtt.equals("no")) {
            this.copyNamespaces = false;
        } else {
            this.compileError("Value of copy-namespaces must be 'yes' or 'no'", "XTSE0020");
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The type and validation attributes must not both be specified", "XTSE1505");
        }
        if (validationAtt != null) {
            this.validationAction = Validation.getCode(validationAtt);
            if (this.validationAction != 4 && !this.getExecutable().isSchemaAware()) {
                this.validationAction = 4;
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
        } else {
            this.validationAction = this.getContainingStylesheet().getDefaultValidation();
        }
        if (typeAtt != null) {
            this.schemaType = this.getSchemaType(typeAtt);
            if (!this.getExecutable().isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.validationAction = 8;
        }
        if (inheritAtt != null) {
            if (inheritAtt.equals("yes")) {
                this.inheritNamespaces = true;
            } else if (inheritAtt.equals("no")) {
                this.inheritNamespaces = false;
            } else {
                this.compileError("The @inherit-namespaces attribute has permitted values (yes, no)", "XTSE0020");
            }
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate(Declaration decl) throws XPathException {
        if (this.use != null) {
            this.attributeSets = this.getAttributeSets(this.use, null);
        }
        if (this.select != null && this.getPreparedStylesheet().getCompilerInfo().getXsltVersion().compareTo(DecimalValue.THREE) < 0) {
            if (this.forwardsCompatibleModeIsEnabled()) {
                this.compileWarning("xsl:copy/@select is ignored in forwards-compatibility mode", "");
            } else {
                this.compileError("The xsl:copy/@select attribute is not recognized by an XSLT 2.0 processor");
            }
        }
        if (this.select == null) {
            this.select = new ContextItemExpression();
            this.select.setLocationId(this.getLineNumber());
        }
    }

    public Expression compile(Executable exec, Declaration decl) throws XPathException {
        this.select = this.typeCheck("select", this.select);
        try {
            RoleLocator role = new RoleLocator(4, (Serializable)((Object)"xsl:copy/select"), 0);
            role.setErrorCode("XTTE2170");
            this.select = TypeChecker.staticTypeCheck(this.select, SequenceType.OPTIONAL_ITEM, false, role, this.makeExpressionVisitor());
        }
        catch (XPathException err) {
            this.compileError(err);
        }
        Copy inst = new Copy(this.select, this.copyNamespaces, this.inheritNamespaces, this.schemaType, this.validationAction);
        Expression content = this.compileSequenceConstructor(exec, decl, this.iterateAxis((byte)3), true);
        if (this.attributeSets != null) {
            UseAttributeSets use = new UseAttributeSets(this.attributeSets);
            InstanceOfExpression condition = new InstanceOfExpression(new ContextItemExpression(), SequenceType.makeSequenceType(NodeKindTest.ELEMENT, 16384));
            Expression choice = Choose.makeConditional(condition, use);
            if (content == null) {
                content = choice;
            } else {
                content = Block.makeBlock(choice, content);
                content.setLocationId(this.allocateLocationId(this.getSystemId(), this.getLineNumber()));
            }
        }
        if (content == null) {
            content = Literal.makeEmptySequence();
        }
        inst.setContentExpression(content);
        return inst;
    }
}

