type token =
  | EOF
  | NPLURALS
  | SEMICOLON
  | PLURAL
  | EQUAL
  | CHARSET
  | QUESTION_MARK
  | COLON
  | OR
  | AND
  | EQ
  | NEQ
  | LE
  | L
  | GE
  | G
  | PLUS
  | MINUS
  | MUL
  | DIV
  | MOD
  | NOT
  | ID
  | RPAREN
  | LPAREN
  | FIELD_NAME of (string*string)
  | CONTENT_TYPE of (string)
  | PLURAL_FORMS of (string)
  | NUMBER of (int)
  | STRING of (string)

val main :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf ->  (string * string) list 
val plural_forms :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf ->  int * ( int -> int ) 
val content_type :
  (Lexing.lexbuf  -> token) -> Lexing.lexbuf ->  string * string 
