type token =
  | STRING of (string)
  | IDENT of (string)
  | BOOL of (bool)
  | EOF
  | LBRACKET
  | RBRACKET
  | LPAR
  | RPAR
  | LBRACE
  | RBRACE
  | COLON
  | INT of (int)
  | RELOP of (OpamParserTypes.FullPos.relop_kind)
  | AND
  | OR
  | PFXOP of (OpamParserTypes.FullPos.pfxop_kind)
  | ENVOP of (OpamParserTypes.FullPos.env_update_op_kind)

open Parsing;;
let _ = parse_error;;
# 13 "src/opamBaseParser.mly"

open OpamParserTypes.FullPos

(** Opam config file generic type parser *)

let pos_of_lexing_pos spos epos =
  Lexing.({
    filename = spos.pos_fname;
    start = spos.pos_lnum, spos.pos_cnum - spos.pos_bol;
    stop = epos.pos_lnum, epos.pos_cnum - epos.pos_bol;
  })

let get_pos_full ?(s=1) n =
  pos_of_lexing_pos (Parsing.rhs_start_pos s) (Parsing.rhs_end_pos n)

let get_pos n = get_pos_full ~s:n n

(* This must match up with the package's version; checked by the build system *)
let version = (2, 1)

# 44 "src/opamBaseParser.ml"
let yytransl_const = [|
    0 (* EOF *);
  260 (* LBRACKET *);
  261 (* RBRACKET *);
  262 (* LPAR *);
  263 (* RPAR *);
  264 (* LBRACE *);
  265 (* RBRACE *);
  266 (* COLON *);
  269 (* AND *);
  270 (* OR *);
    0|]

let yytransl_block = [|
  257 (* STRING *);
  258 (* IDENT *);
  259 (* BOOL *);
  267 (* INT *);
  268 (* RELOP *);
  271 (* PFXOP *);
  272 (* ENVOP *);
    0|]

let yylhs = "\255\255\
\001\000\005\000\005\000\004\000\004\000\004\000\002\000\002\000\
\002\000\002\000\002\000\002\000\002\000\002\000\002\000\002\000\
\003\000\003\000\006\000\006\000\006\000\006\000\000\000\000\000"

let yylen = "\002\000\
\002\000\002\000\000\000\003\000\004\000\005\000\001\000\003\000\
\003\000\004\000\003\000\003\000\003\000\003\000\002\000\002\000\
\000\000\002\000\001\000\001\000\001\000\001\000\002\000\002\000"

let yydefred = "\000\000\
\000\000\000\000\000\000\000\000\023\000\000\000\000\000\022\000\
\019\000\020\000\000\000\000\000\021\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\002\000\001\000\000\000\000\000\
\000\000\016\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\018\000\009\000\008\000\000\000\000\000\
\000\000\013\000\014\000\000\000\005\000\010\000\006\000"

let yydgoto = "\003\000\
\005\000\023\000\024\000\006\000\007\000\017\000"

let yysindex = "\009\000\
\013\255\054\255\000\000\022\255\000\000\013\255\017\000\000\000\
\000\000\000\000\054\255\054\255\000\000\003\255\054\255\021\255\
\029\255\017\255\013\255\054\255\000\000\000\000\036\255\028\255\
\019\255\000\000\035\255\054\255\054\255\054\255\003\255\003\255\
\013\255\043\255\021\255\000\000\000\000\000\000\044\255\035\255\
\255\254\000\000\000\000\050\255\000\000\000\000\000\000"

let yyrindex = "\000\000\
\061\000\000\000\000\000\000\000\000\000\002\000\000\000\000\000\
\000\000\000\000\057\255\056\255\000\000\000\000\000\000\064\000\
\001\000\000\000\058\255\000\000\000\000\000\000\063\255\000\000\
\000\000\000\000\016\000\062\255\000\000\000\000\000\000\000\000\
\058\255\000\000\054\000\000\000\000\000\000\000\000\000\031\000\
\046\000\000\000\000\000\000\000\000\000\000\000\000\000"

let yygindex = "\000\000\
\000\000\254\255\252\255\000\000\003\000\245\255"

let yytablesize = 319
let yytable = "\016\000\
\007\000\003\000\026\000\008\000\009\000\010\000\028\000\025\000\
\021\000\001\000\002\000\029\000\027\000\013\000\004\000\015\000\
\022\000\035\000\036\000\042\000\043\000\034\000\018\000\039\000\
\033\000\038\000\040\000\041\000\028\000\019\000\011\000\020\000\
\037\000\029\000\030\000\044\000\008\000\009\000\010\000\011\000\
\031\000\012\000\028\000\028\000\032\000\012\000\013\000\014\000\
\029\000\030\000\015\000\045\000\046\000\004\000\008\000\009\000\
\010\000\011\000\047\000\012\000\003\000\017\000\017\000\024\000\
\013\000\014\000\003\000\017\000\015\000\017\000\017\000\017\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\000\
\000\000\007\000\007\000\007\000\007\000\007\000\007\000\007\000\
\007\000\007\000\003\000\007\000\000\000\007\000\007\000\007\000\
\015\000\015\000\015\000\015\000\015\000\015\000\015\000\000\000\
\015\000\000\000\015\000\015\000\015\000\015\000\015\000\011\000\
\011\000\011\000\011\000\011\000\011\000\011\000\000\000\011\000\
\000\000\011\000\011\000\011\000\011\000\011\000\012\000\012\000\
\012\000\012\000\012\000\012\000\012\000\000\000\012\000\004\000\
\012\000\012\000\000\000\012\000\012\000\000\000\004\000"

let yycheck = "\002\000\
\000\000\000\000\014\000\001\001\002\001\003\001\008\001\012\000\
\006\000\001\000\002\000\013\001\015\000\011\001\002\001\000\000\
\000\000\020\000\023\000\031\000\032\000\019\000\001\001\028\000\
\008\001\007\001\029\000\030\000\008\001\008\001\000\000\010\001\
\005\001\013\001\014\001\033\000\001\001\002\001\003\001\004\001\
\012\001\006\001\008\001\008\001\016\001\000\000\011\001\012\001\
\013\001\014\001\015\001\009\001\009\001\000\000\001\001\002\001\
\003\001\004\001\009\001\006\001\000\000\005\001\007\001\000\000\
\011\001\012\001\009\001\005\001\015\001\007\001\009\001\009\001\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\255\
\255\255\001\001\002\001\003\001\004\001\005\001\006\001\007\001\
\008\001\009\001\009\001\011\001\255\255\013\001\014\001\015\001\
\001\001\002\001\003\001\004\001\005\001\006\001\007\001\255\255\
\009\001\255\255\011\001\012\001\013\001\014\001\015\001\001\001\
\002\001\003\001\004\001\005\001\006\001\007\001\255\255\009\001\
\255\255\011\001\012\001\013\001\014\001\015\001\001\001\002\001\
\003\001\004\001\005\001\006\001\007\001\255\255\009\001\002\001\
\011\001\012\001\255\255\014\001\015\001\255\255\009\001"

let yynames_const = "\
  EOF\000\
  LBRACKET\000\
  RBRACKET\000\
  LPAR\000\
  RPAR\000\
  LBRACE\000\
  RBRACE\000\
  COLON\000\
  AND\000\
  OR\000\
  "

let yynames_block = "\
  STRING\000\
  IDENT\000\
  BOOL\000\
  INT\000\
  RELOP\000\
  PFXOP\000\
  ENVOP\000\
  "

let yyact = [|
  (fun _ -> failwith "parser")
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : 'items) in
    Obj.repr(
# 68 "src/opamBaseParser.mly"
            ( fun file_name ->
        { file_contents = _1; file_name } )
# 224 "src/opamBaseParser.ml"
               : string -> OpamParserTypes.FullPos.opamfile))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : OpamParserTypes.FullPos.opamfile_item) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'items) in
    Obj.repr(
# 73 "src/opamBaseParser.mly"
             ( _1 :: _2 )
# 232 "src/opamBaseParser.ml"
               : 'items))
; (fun __caml_parser_env ->
    Obj.repr(
# 74 "src/opamBaseParser.mly"
             ( [] )
# 238 "src/opamBaseParser.ml"
               : 'items))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : OpamParserTypes.FullPos.value) in
    Obj.repr(
# 78 "src/opamBaseParser.mly"
                                   (
  { pos = get_pos_full 3;
    pelem =
      Variable ({ pos = get_pos 1; pelem =  _1 }, _3);
  }
)
# 251 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.opamfile_item))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : string) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : 'items) in
    Obj.repr(
# 84 "src/opamBaseParser.mly"
                            (
  { pos = get_pos_full 4;
    pelem =
      Section ({section_kind = { pos = get_pos 1; pelem = _1 };
                section_name = None;
                section_items =
                  { pos = get_pos_full ~s:2 4; pelem = _3 };
               })
  }
)
# 268 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.opamfile_item))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 4 : string) in
    let _2 = (Parsing.peek_val __caml_parser_env 3 : string) in
    let _4 = (Parsing.peek_val __caml_parser_env 1 : 'items) in
    Obj.repr(
# 94 "src/opamBaseParser.mly"
                                   (
  { pos = get_pos_full 5;
    pelem =
      Section ({section_kind = { pos = get_pos 1; pelem = _1 };
                section_name = Some { pos = get_pos 2; pelem = _2 };
                section_items =
                  { pos = get_pos_full ~s:3 5; pelem = _4 };
               })
  }
)
# 286 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.opamfile_item))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : 'atom) in
    Obj.repr(
# 107 "src/opamBaseParser.mly"
                             ( _1 )
# 293 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : OpamParserTypes.FullPos.value list) in
    Obj.repr(
# 108 "src/opamBaseParser.mly"
                             ({ pos = get_pos_full 3 ; pelem = Group { pos = get_pos_full ~s:1 3; pelem = _2 } })
# 300 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value))
; (fun __caml_parser_env ->
    let _2 = (Parsing.peek_val __caml_parser_env 1 : OpamParserTypes.FullPos.value list) in
    Obj.repr(
# 109 "src/opamBaseParser.mly"
                             ({ pos = get_pos_full 3 ; pelem = List { pos = get_pos_full ~s:1 3; pelem = _2 } })
# 307 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 3 : OpamParserTypes.FullPos.value) in
    let _3 = (Parsing.peek_val __caml_parser_env 1 : OpamParserTypes.FullPos.value list) in
    Obj.repr(
# 110 "src/opamBaseParser.mly"
                             ({ pos = get_pos_full 4 ;
                                pelem = Option (_1, { pos = get_pos_full ~s:2 4; pelem = _3 }) })
# 316 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : OpamParserTypes.FullPos.value) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : OpamParserTypes.FullPos.value) in
    Obj.repr(
# 112 "src/opamBaseParser.mly"
                             ({ pos = get_pos_full 3 ; pelem = Logop ({ pos = get_pos 2 ; pelem = `And },_1,_3) })
# 324 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : OpamParserTypes.FullPos.value) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : OpamParserTypes.FullPos.value) in
    Obj.repr(
# 113 "src/opamBaseParser.mly"
                             ({ pos = get_pos_full 3 ; pelem = Logop ({ pos = get_pos 2 ; pelem = `Or },_1,_3) })
# 332 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'atom) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : OpamParserTypes.FullPos.relop_kind) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'atom) in
    Obj.repr(
# 114 "src/opamBaseParser.mly"
                             ({ pos = get_pos_full 3 ; pelem = Relop ({ pos = get_pos 2 ; pelem = _2 },_1,_3) })
# 341 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 2 : 'atom) in
    let _2 = (Parsing.peek_val __caml_parser_env 1 : OpamParserTypes.FullPos.env_update_op_kind) in
    let _3 = (Parsing.peek_val __caml_parser_env 0 : 'atom) in
    Obj.repr(
# 115 "src/opamBaseParser.mly"
                             ({ pos = get_pos_full 3 ; pelem = Env_binding (_1,{ pos = get_pos 2 ; pelem = _2 },_3) })
# 350 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : OpamParserTypes.FullPos.pfxop_kind) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : OpamParserTypes.FullPos.value) in
    Obj.repr(
# 116 "src/opamBaseParser.mly"
                             ({ pos = get_pos_full 2 ; pelem = Pfxop ({ pos = get_pos 1 ; pelem = _1 },_2) })
# 358 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : OpamParserTypes.FullPos.relop_kind) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : 'atom) in
    Obj.repr(
# 117 "src/opamBaseParser.mly"
                             ({ pos = get_pos_full 2 ; pelem = Prefix_relop ({ pos = get_pos 1 ; pelem = _1 },_2) })
# 366 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value))
; (fun __caml_parser_env ->
    Obj.repr(
# 121 "src/opamBaseParser.mly"
                             ( [] )
# 372 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 1 : OpamParserTypes.FullPos.value) in
    let _2 = (Parsing.peek_val __caml_parser_env 0 : OpamParserTypes.FullPos.value list) in
    Obj.repr(
# 122 "src/opamBaseParser.mly"
                             ( _1 :: _2 )
# 380 "src/opamBaseParser.ml"
               : OpamParserTypes.FullPos.value list))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 126 "src/opamBaseParser.mly"
                             ({ pos = get_pos 1 ; pelem = Ident _1 })
# 387 "src/opamBaseParser.ml"
               : 'atom))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : bool) in
    Obj.repr(
# 127 "src/opamBaseParser.mly"
                             ({ pos = get_pos 1 ; pelem = Bool _1 })
# 394 "src/opamBaseParser.ml"
               : 'atom))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : int) in
    Obj.repr(
# 128 "src/opamBaseParser.mly"
                             ({ pos = get_pos 1 ; pelem = Int _1 })
# 401 "src/opamBaseParser.ml"
               : 'atom))
; (fun __caml_parser_env ->
    let _1 = (Parsing.peek_val __caml_parser_env 0 : string) in
    Obj.repr(
# 129 "src/opamBaseParser.mly"
                             ({ pos = get_pos 1 ; pelem = String _1 })
# 408 "src/opamBaseParser.ml"
               : 'atom))
(* Entry main *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
(* Entry value *)
; (fun __caml_parser_env -> raise (Parsing.YYexit (Parsing.peek_val __caml_parser_env 0)))
|]
let yytables =
  { Parsing.actions=yyact;
    Parsing.transl_const=yytransl_const;
    Parsing.transl_block=yytransl_block;
    Parsing.lhs=yylhs;
    Parsing.len=yylen;
    Parsing.defred=yydefred;
    Parsing.dgoto=yydgoto;
    Parsing.sindex=yysindex;
    Parsing.rindex=yyrindex;
    Parsing.gindex=yygindex;
    Parsing.tablesize=yytablesize;
    Parsing.table=yytable;
    Parsing.check=yycheck;
    Parsing.error_function=parse_error;
    Parsing.names_const=yynames_const;
    Parsing.names_block=yynames_block }
let main (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 1 lexfun lexbuf : string -> OpamParserTypes.FullPos.opamfile)
let value (lexfun : Lexing.lexbuf -> token) (lexbuf : Lexing.lexbuf) =
   (Parsing.yyparse yytables 2 lexfun lexbuf : OpamParserTypes.FullPos.value)
;;
# 133 "src/opamBaseParser.mly"

let nopatch v =
  let s =
  try
    let i = String.index v '.' in
    let i = String.index_from v (i+1) '.' in
    (String.sub v 0 i)
  with Not_found ->
    let rec f i =
      if i >= String.length v then v
      else match String.get v i with
        | '0'..'9' | '.' -> f (i+1)
        | _ -> String.sub v 0 i
    in
    f 0
  in
    try Scanf.sscanf s "%u.%u%!" (fun maj min -> (maj, min))
    with Scanf.Scan_failure _
       | Failure _
       | End_of_file ->
           try Scanf.sscanf s "%u%!" (fun maj -> (maj, 0))
           with Scanf.Scan_failure _
              | Failure _
              | End_of_file -> (0, 0)

let with_clear_parser f x =
  try
    let r = f x in
    Parsing.clear_parser ();
    r
  with e ->
    Parsing.clear_parser ();
    raise e

(* Update a lexbuf with position information prior to raising an exception *)
let reset_lexbuf_and_abort l file_name (start_line, start_col) (end_line, end_col) exn =
  let open Lexing in
  l.lex_start_p <- {pos_fname = file_name; pos_lnum = start_line; pos_bol = 0; pos_cnum = start_col};
  l.lex_curr_p <- {pos_fname = file_name; pos_lnum = end_line; pos_bol = 0; pos_cnum = end_col};
  exn ()

(* cf. OpamStd.fatal - always allow standard exceptions to propagate. *)
let not_fatal = function
| Sys.Break
| Assert_failure _
| Match_failure _ -> false
| _ -> true

let get_three_tokens lexer lexbuf = 
  let open Lexing in
  try
    let p0 = lexbuf.lex_start_p, lexbuf.lex_curr_p in
    let t1 = lexer lexbuf in
    let p1 = lexbuf.lex_start_p, lexbuf.lex_curr_p in
    let t2 = lexer lexbuf in
    let p2 = lexbuf.lex_start_p, lexbuf.lex_curr_p in
    let t3 = lexer lexbuf in
    let p3 = lexbuf.lex_start_p, lexbuf.lex_curr_p in
    ((p0, p1, p2, p3), (t1, t2, t3))
  with
  | e when not_fatal e -> raise Parsing.Parse_error

(* Wrap the ocamlyacc parser *)
let main lexer lexbuf file_name =
  (* Extract the exceptions for opam-version not at the top of the file and
     opam-version duplicated. OpamLexer has special cases for these two
     constants. If OpamLexer.token isn't used, raise Parse_error instead. *)
  let exn_not_first () =
    let _ = lexer (Lexing.from_string "version: \"42\"\nopam-version: \"2.1\"") in
    raise Parsing.Parse_error
  and exn_duplicate () =
    let _ = lexer (Lexing.from_string "opam-version: \"2.1\"\nopam-version: \"z\"") in
    raise Parsing.Parse_error
  and restore_pos (start, curr) =
    let open Lexing in
    lexbuf.lex_start_p <- start;
    lexbuf.lex_curr_p <- curr
  in
  (* Raises the exn_not_first or exn_duplicate exceptions if an invalid
     opam-version variable is found in the result. *)
  let scan_opam_version_variable format_2_1_or_greater = function
  | {pelem = Variable({pelem = "opam-version"; _}, {pelem = String ver; _}); pos = {start; stop; _}} ->
      if format_2_1_or_greater then
        (* [opam-version] can only appear once for 2.1+ *)
        reset_lexbuf_and_abort lexbuf file_name start stop exn_duplicate
      else if nopatch ver > (2, 0) then
        (* Only [opam-version: "2.0"] can appear after the first non-comment/whitespace line of the file *)
        reset_lexbuf_and_abort lexbuf file_name start stop exn_not_first
      else
        ()
  | _ -> ()
  in
  (* Now parse the header of the file manually. The smallest valid opam file
     is `ident: atom`, so if we can't read three tokens we have a parse error *)
  let ((((_, p0) as initial_pos), ((_, p1) as pos1), ((_, p2) as pos2), ((_, p3) as pos3)), (t1, t2, t3)) =
    get_three_tokens lexer lexbuf
  in
  (* Parse those three tokens if they are [opam-version: ver] *)
  let (header, format_2_1_or_greater, trap_exceptions) =
    match (t1, t2, t3) with
    | (IDENT "opam-version", COLON, STRING ver) ->
        let header =
          (* Parsing or lexing errors immediate following opam-version may cause
             an exception to be raised before the element has been fully parsed.
             In this case, we generate a single opam-version Variable to return.
           *)
          {pelem = Variable({pelem = "opam-version"; pos = pos_of_lexing_pos p0 p1},
                             {pelem = String ver; pos = pos_of_lexing_pos p2 p3});
           pos = pos_of_lexing_pos p0 p3}
        in
        (header, (nopatch ver >= (2, 1)), (nopatch ver > version))
    | _ ->
        (* Default is [opam-version: "2.0"] *)
        let pos = {filename = ""; start = (0, 0); stop = (0, 0)} in
        ({pelem = Variable ({pelem = ""; pos}, {pelem = Int 42; pos}); pos}, false, false)
  in
  (* The parser will use position information from the lexbuf, so replay the
     positions, even if we're not actually reading anything. *)
  restore_pos initial_pos;
  (* Wrap the lexer to simulate reading those three tokens a second time *)
  let lexer =
    let tokens = ref [t1, pos1; t2, pos2; t3, pos3] in
    fun lexbuf ->
      match tokens with
      | {contents = (t, p)::rest} ->
          tokens := rest;
          restore_pos p;
          t
      | {contents = []} ->
          lexer lexbuf
  in
  let result =
    try with_clear_parser (main lexer lexbuf) file_name
    with e when trap_exceptions && not_fatal e ->
      (* Append a syntactically invalid sentinel section "#" to the version
         header which was manually parsed. That is then sufficient
         information for a client to determine that the file was invalid.
         If OpamBaseParser.version = (2, 1), this would allow
         `opam-version: "2.2"`, containing no lexer or parser changes, still to
         report syntax errors in opam 2.2, by using this sentinel group to
         detect the parsing error. *)
      let sentinel =
        let pos =
          Lexing.(pos_of_lexing_pos lexbuf.lex_start_p lexbuf.lex_curr_p)
        in
        let section =
          {section_kind = {pelem = "#"; pos};
           section_name = None;
           section_items = {pelem = []; pos}}
        in
          {pelem = Section section; pos}
      in
      {file_contents = [header; sentinel]; file_name}
  in
  begin
    match result with
    | {file_contents = _::items; _} ->
        (* Ensure that there are no `opam-version` fields with a value >= "2.1"
           further down the file. *)
        List.iter (scan_opam_version_variable format_2_1_or_greater) items
    | _ -> ()
  end;
  result

let value t l = with_clear_parser (value t) l
# 603 "src/opamBaseParser.ml"
