/*
 * This file is part of libdom.
 * Licensed under the MIT License,
 *                http://www.opensource.org/licenses/mit-license.php
 * Copyright 2016 Michael Drake <michael.drake@codethink.co.uk>
 */

#if !defined(dom_html_elements_h_) || defined(DOM_HTML_ELEMENT_STRINGS_ENTRY)
#define dom_html_elements_h_

#define DOM_HTML_ELEMENT_LIST				\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(_UNKNOWN)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(A)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(ABBR)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(ACRONYM)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(ADDRESS)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(APPLET)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(AREA)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(ARTICLE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(ASIDE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(AUDIO)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(B)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(BASE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(BASEFONT)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(BDI)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(BDO)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(BGSOUND)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(BIG)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(BLOCKQUOTE)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(BODY)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(BR)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(BUTTON)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(CANVAS)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(CAPTION)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(CENTER)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(CITE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(CODE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(COL)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(COLGROUP)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(DATA)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(DATALIST)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(DD)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(DEL)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(DETAILS)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(DFN)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(DIALOG)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(DIR)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(DIV)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(DL)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(DT)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(EM)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(EMBED)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(FIELDSET)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(FIGCAPTION)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(FIGURE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(FONT)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(FOOTER)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(FORM)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(FRAME)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(FRAMESET)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(H1)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(H2)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(H3)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(H4)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(H5)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(H6)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(HEAD)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(HEADER)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(HGROUP)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(HR)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(HTML)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(I)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(IFRAME)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(IMG)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(INPUT)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(INS)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(ISINDEX)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(KBD)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(KEYGEN)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(LABEL)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(LEGEND)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(LI)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(LINK)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(MAIN)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(MAP)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(MARK)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(MARQUEE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(MENU)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(MENUITEM)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(META)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(METER)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(NAV)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(NOBR)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(NOFRAMES)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(NOSCRIPT)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(OBJECT)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(OL)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(OPTGROUP)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(OPTION)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(OUTPUT)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(P)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(PARAM)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(PICTURE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(PRE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(PROGRESS)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(Q)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(RP)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(RT)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(RUBY)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(S)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(SAMP)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(SCRIPT)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(SECTION)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(SELECT)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(SMALL)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(SOURCE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(SPACER)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(SPAN)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(STRIKE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(STRONG)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(STYLE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(SUB)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(SUMMARY)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(SUP)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TABLE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TBODY)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TD)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TEMPLATE)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TEXTAREA)	\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TFOOT)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TH)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(THEAD)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TIME)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TITLE)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TR)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TRACK)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(TT)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(U)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(UL)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(VAR)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(VIDEO)		\
	DOM_HTML_ELEMENT_STRINGS_ENTRY(WBR)

/* Generate enum containing DOM_HTML_ELEMENT_<TAG_NAME> entries,
 * unless the includer defined DOM_HTML_ELEMENT_STRINGS_ENTRY
 * to do something else.
 */
#ifndef DOM_HTML_ELEMENT_STRINGS_ENTRY
#define DOM_HTML_ELEMENT_STRINGS_ENTRY(tag)		\
	DOM_HTML_ELEMENT_TYPE_##tag,
typedef enum {
DOM_HTML_ELEMENT_LIST
	DOM_HTML_ELEMENT_TYPE__COUNT
} dom_html_element_type;
#undef DOM_HTML_ELEMENT_STRINGS_ENTRY
#else
DOM_HTML_ELEMENT_LIST
#endif

#undef DOM_HTML_ELEMENT_LIST
#endif

