/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.NameClass;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AttributePattern
extends Pattern {
    private final NameClass nameClass;
    private final Pattern p;
    private final Locator loc;

    AttributePattern(NameClass nameClass, Pattern pattern, Locator locator) {
        super(false, 0, AttributePattern.combineHashCode(29, nameClass.hashCode(), pattern.hashCode()));
        this.nameClass = nameClass;
        this.p = pattern;
        this.loc = locator;
    }

    @Override
    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        Pattern pattern = this.p.expand(schemaPatternBuilder);
        if (pattern != this.p) {
            return schemaPatternBuilder.makeAttribute(this.nameClass, pattern, this.loc);
        }
        return this;
    }

    @Override
    void checkRestrictions(int n, DuplicateAttributeDetector duplicateAttributeDetector, Alphabet alphabet) throws RestrictionViolationException {
        switch (n) {
            case 0: {
                throw new RestrictionViolationException("start_contains_attribute");
            }
            case 1: {
                if (!this.nameClass.isOpen()) break;
                throw new RestrictionViolationException("open_name_class_not_repeated");
            }
            case 3: {
                throw new RestrictionViolationException("one_or_more_contains_group_contains_attribute");
            }
            case 4: {
                throw new RestrictionViolationException("one_or_more_contains_interleave_contains_attribute");
            }
            case 6: {
                throw new RestrictionViolationException("list_contains_attribute");
            }
            case 5: {
                throw new RestrictionViolationException("attribute_contains_attribute");
            }
            case 7: {
                throw new RestrictionViolationException("data_except_contains_attribute");
            }
        }
        duplicateAttributeDetector.addAttribute(this.nameClass);
        try {
            this.p.checkRestrictions(5, null, null);
        }
        catch (RestrictionViolationException restrictionViolationException) {
            restrictionViolationException.maybeSetLocator(this.loc);
            throw restrictionViolationException;
        }
    }

    @Override
    boolean samePattern(Pattern pattern) {
        if (!(pattern instanceof AttributePattern)) {
            return false;
        }
        AttributePattern attributePattern = (AttributePattern)pattern;
        return this.nameClass.equals(attributePattern.nameClass) && this.p == attributePattern.p;
    }

    @Override
    void checkRecursion(int n) throws SAXException {
        this.p.checkRecursion(n);
    }

    @Override
    <T> T apply(PatternFunction<T> patternFunction) {
        return patternFunction.caseAttribute(this);
    }

    Pattern getContent() {
        return this.p;
    }

    NameClass getNameClass() {
        return this.nameClass;
    }

    Locator getLocator() {
        return this.loc;
    }
}

