/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.helpers;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMUtils {
    protected DOMUtils() {
    }

    public static Element getFirstElement(Element parent) {
        Node child;
        for (child = parent.getFirstChild(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static Element getNextElement(Element current) {
        Node child;
        for (child = current.getNextSibling(); child != null && child.getNodeType() != 1; child = child.getNextSibling()) {
        }
        return (Element)child;
    }

    public static String makeAbsolute(Element node, String uriString) {
        Document doc = node.getOwnerDocument();
        return DOMUtils.makeAbsolute(node, uriString, doc.getBaseURI());
    }

    public static String makeAbsolute(Element node, String uriString, String documentBaseURI) {
        try {
            URI docuri;
            URI uri = new URI(uriString);
            if (uri.isAbsolute()) {
                return uri.toString();
            }
            Vector<Element> nodes = new Vector<Element>();
            nodes.add(node);
            for (Node parent = node.getParentNode(); parent != null && parent.getNodeType() == 1; parent = parent.getParentNode()) {
                nodes.add(0, (Element)parent);
            }
            if (documentBaseURI == null) {
                documentBaseURI = "file://" + uriString;
            }
            URI baseURI = docuri = new URI(documentBaseURI);
            for (Element xbnode : nodes) {
                if (!xbnode.hasAttribute("xml:base")) continue;
                baseURI = baseURI.resolve(new URI(xbnode.getAttribute("xml:base")));
            }
            String absuriString = (uri = baseURI.resolve(uri)).toString();
            if (absuriString.startsWith("file:/") && !absuriString.startsWith("file:///")) {
                absuriString = "file:///" + absuriString.substring(6);
            }
            return absuriString;
        }
        catch (URISyntaxException use) {
            return uriString;
        }
    }

    public static boolean catalogElement(Node node, String localName) {
        return node.getNodeType() == 1 && localName.equals(node.getLocalName()) && "urn:oasis:names:tc:entity:xmlns:xml:catalog".equals(node.getNamespaceURI());
    }

    public static String attr(Element test, String name) {
        return test.hasAttribute(name) ? test.getAttribute(name) : null;
    }

    public static String attr(Element test, String uri, String localName) {
        return test.hasAttributeNS(uri, localName) ? test.getAttributeNS(uri, localName) : null;
    }
}

