/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antclipse;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Location;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ClassPathParser {
    void parse(File file, HandlerBase handler) throws BuildException {
        String fName = file.getName();
        FileInputStream fileInputStream = null;
        InputSource inputSource = null;
        try {
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            String uri = "file:" + fName.replace('\\', '/');
            fileInputStream = new FileInputStream(file);
            inputSource = new InputSource(fileInputStream);
            inputSource.setSystemId(uri);
            saxParser.parse(inputSource, handler);
        }
        catch (ParserConfigurationException pceException) {
            throw new BuildException("Parser configuration failed", (Throwable)pceException);
        }
        catch (SAXParseException exc) {
            Location location = new Location(fName.toString(), exc.getLineNumber(), exc.getColumnNumber());
            Exception throwable = exc.getException();
            if (throwable instanceof BuildException) {
                BuildException be = (BuildException)throwable;
                if (be.getLocation() == Location.UNKNOWN_LOCATION) {
                    be.setLocation(location);
                }
                throw be;
            }
            throw new BuildException(exc.getMessage(), (Throwable)throwable, location);
        }
        catch (SAXException exc) {
            Exception throwable = exc.getException();
            if (throwable instanceof BuildException) {
                throw (BuildException)throwable;
            }
            throw new BuildException(exc.getMessage(), (Throwable)throwable);
        }
        catch (FileNotFoundException exc) {
            throw new BuildException((Throwable)exc);
        }
        catch (IOException exc) {
            throw new BuildException("Error reading file", (Throwable)exc);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException ioexception) {}
            }
        }
    }
}

