/* Generated by re2c */
#line 1 "c/fill/02_fill.re"
// re2c $INPUT -o $OUTPUT
#include <assert.h>
#include <stdio.h>
#include <string.h>

#line 9 "c/fill/02_fill.c"
#define YYMAXFILL 1
#line 6 "c/fill/02_fill.re"

#define BUFSIZE (4096 - YYMAXFILL)

struct Input {
    FILE *file;
    char buf[BUFSIZE + YYMAXFILL], *lim, *cur, *tok;
    bool eof;
};

static int fill(Input &in, size_t need) {
    if (in.eof) return 1;

    const size_t shift = in.tok - in.buf;
    const size_t used = in.lim - in.tok;

    // Error: lexeme too long. In real life could reallocate a larger buffer.
    if (shift < need) return 2;

    // Shift buffer contents (discard everything up to the current token).
    memmove(in.buf, in.tok, used);
    in.lim -= shift;
    in.cur -= shift;
    in.tok -= shift;

    // Fill free space at the end of buffer with new data from file.
    in.lim += fread(in.lim, 1, BUFSIZE - used, in.file);

    // If read less than expected, this is end of input => add zero padding
    // so that the lexer can access characters at the end of buffer.
    if (in.lim < in.buf + BUFSIZE) {
        in.eof = true;
        memset(in.lim, 0, YYMAXFILL);
        in.lim += YYMAXFILL;
    }

    return 0;
}

static int lex(Input &in) {
    int count = 0;
    for (;;) {
        in.tok = in.cur;
    
#line 55 "c/fill/02_fill.c"
{
	char yych;
	if (in.lim <= in.cur) if (fill(in, 1) != 0) return -1;
	yych = *in.cur;
	switch (yych) {
		case 0x00: goto yy1;
		case ' ': goto yy3;
		case '\'': goto yy5;
		default: goto yy2;
	}
yy1:
	++in.cur;
#line 57 "c/fill/02_fill.re"
	{
            // Check that it is the sentinel, not some unexpected null.
            return in.tok == in.lim - YYMAXFILL ? count : -1;
        }
#line 73 "c/fill/02_fill.c"
yy2:
	++in.cur;
#line 63 "c/fill/02_fill.re"
	{ return -1; }
#line 78 "c/fill/02_fill.c"
yy3:
	++in.cur;
	if (in.lim <= in.cur) if (fill(in, 1) != 0) return -1;
	yych = *in.cur;
	switch (yych) {
		case ' ': goto yy3;
		default: goto yy4;
	}
yy4:
#line 62 "c/fill/02_fill.re"
	{ continue; }
#line 90 "c/fill/02_fill.c"
yy5:
	++in.cur;
	if (in.lim <= in.cur) if (fill(in, 1) != 0) return -1;
	yych = *in.cur;
	switch (yych) {
		case '\'': goto yy6;
		case '\\': goto yy7;
		default: goto yy5;
	}
yy6:
	++in.cur;
#line 61 "c/fill/02_fill.re"
	{ ++count; continue; }
#line 104 "c/fill/02_fill.c"
yy7:
	++in.cur;
	if (in.lim <= in.cur) if (fill(in, 1) != 0) return -1;
	goto yy5;
}
#line 64 "c/fill/02_fill.re"

    }
}

int main() {
    const char *fname = "input";
    const char content[] = "'qu\0tes' 'are' 'fine: \\'' ";

    // Prepare input file: a few times the size of the buffer, containing
    // strings with zeroes and escaped quotes.
    FILE *f = fopen(fname, "w");
    for (int i = 0; i < BUFSIZE; ++i) {
        fwrite(content, 1, sizeof(content) - 1, f);
    }
    fclose(f);
    int count = 3 * BUFSIZE; // number of quoted strings written to file

    // Initialize lexer state: all pointers are at the end of buffer.
    // This immediately triggers YYFILL, as the check `in.cur < in.lim` fails.
    Input in;
    in.file = fopen(fname, "r");
    in.cur = in.tok = in.lim = in.buf + BUFSIZE;
    in.eof = 0;

    // Run the lexer.
    assert(lex(in) == count);

    // Cleanup: remove input file.
    fclose(in.file);
    remove(fname);
    return 0;
}
