/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.drivers;

import com.xmlcalabash.core.XProcConfiguration;
import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadableData;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritableDocument;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.model.Serialization;
import com.xmlcalabash.runtime.XPipeline;
import com.xmlcalabash.util.LogOptions;
import com.xmlcalabash.util.ParseArgs;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.URIUtils;
import java.io.BufferedReader;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.xml.sax.InputSource;

public class Main {
    private static boolean errors = false;
    private static QName _code = new QName("code");
    private XProcRuntime runtime = null;
    private boolean readStdin = false;
    private Logger logger = Logger.getLogger(this.getClass().getName());
    private boolean debug = false;

    public static void main(String[] args) throws SaxonApiException, IOException, URISyntaxException {
        Main main = new Main();
        main.run(args);
    }

    public void run(String[] args) throws SaxonApiException, IOException, URISyntaxException {
        block84: {
            ParseArgs cmd = new ParseArgs();
            try {
                cmd.parse(args);
            }
            catch (XProcException xe) {
                System.err.println(xe.getMessage());
                this.usage();
            }
            if (cmd.saxonConfigFile != null) {
                if (cmd.schemaAware) {
                    throw new XProcException("Specifying schema-aware processing is an error if you specify a Saxon configuration file.");
                }
                if (cmd.saxonProcessor != null) {
                    throw new XProcException("Specifying a processor type is an error if you specify a Saxon configuration file.");
                }
            }
            try {
                RuntimeValue value;
                String uri;
                XProcConfiguration config = null;
                try {
                    String proc = cmd.saxonProcessor;
                    if (cmd.schemaAware) {
                        proc = "ee";
                    }
                    config = cmd.saxonConfigFile != null ? new XProcConfiguration(cmd.saxonConfigFile) : (proc != null ? new XProcConfiguration(proc, cmd.schemaAware) : new XProcConfiguration());
                }
                catch (Exception e) {
                    System.err.println("FATAL: Failed to parse configuration file.");
                    System.err.println(e);
                    System.exit(2);
                }
                if (cmd.configFile != null) {
                    String cfgURI = URIUtils.cwdAsURI().resolve(cmd.configFile).toASCIIString();
                    SAXSource source = new SAXSource(new InputSource(cfgURI));
                    DocumentBuilder builder = config.getProcessor().newDocumentBuilder();
                    XdmNode doc = builder.build((Source)source);
                    config.parse(doc);
                }
                if (cmd.logStyle != null) {
                    config.logOpt = cmd.logStyle.equals("off") ? LogOptions.OFF : (cmd.logStyle.equals("plain") ? LogOptions.PLAIN : (cmd.logStyle.equals("directory") ? LogOptions.DIRECTORY : LogOptions.WRAPPED));
                }
                if (cmd.uriResolverClass != null) {
                    config.uriResolver = cmd.uriResolverClass;
                }
                if (cmd.entityResolverClass != null) {
                    config.entityResolver = cmd.entityResolverClass;
                }
                if (cmd.safeModeExplicit) {
                    config.safeMode = cmd.safeMode;
                }
                if (cmd.debugExplicit) {
                    config.debug = cmd.debug;
                }
                config.extensionValues |= cmd.extensionValues;
                config.xpointerOnText |= cmd.allowXPointerOnText;
                config.transparentJSON |= cmd.transparentJSON;
                if (cmd.jsonFlavor != null) {
                    config.jsonFlavor = cmd.jsonFlavor;
                }
                config.useXslt10 |= cmd.useXslt10;
                this.debug = config.debug;
                this.runtime = new XProcRuntime(config);
                XPipeline pipeline = null;
                if (cmd.showVersion) {
                    this.showVersion();
                }
                if (cmd.pipelineURI != null) {
                    pipeline = this.runtime.load(cmd.pipelineURI);
                } else if (cmd.impliedPipeline()) {
                    XdmNode implicitPipeline = cmd.implicitPipeline(this.runtime);
                    if (this.debug) {
                        System.err.println("Implicit pipeline:");
                        Serializer serializer = new Serializer();
                        serializer.setOutputProperty(Serializer.Property.INDENT, "yes");
                        serializer.setOutputProperty(Serializer.Property.METHOD, "xml");
                        serializer.setOutputStream((OutputStream)System.err);
                        S9apiUtils.serialize(this.runtime, implicitPipeline, serializer);
                    }
                    pipeline = this.runtime.use(implicitPipeline);
                } else if (config.pipeline != null) {
                    XdmNode doc = config.pipeline.read();
                    pipeline = this.runtime.use(doc);
                }
                if (errors || pipeline == null) {
                    this.usage();
                }
                for (String port : config.params.keySet()) {
                    Hashtable<QName, String> hash = config.params.get(port);
                    if ("*".equals(port)) {
                        for (QName name : hash.keySet()) {
                            pipeline.setParameter(name, new RuntimeValue(hash.get(name)));
                        }
                        continue;
                    }
                    for (QName name : hash.keySet()) {
                        pipeline.setParameter(port, name, new RuntimeValue(hash.get(name)));
                    }
                }
                for (String port : cmd.getParameterPorts()) {
                    for (QName name : cmd.getParameterNames(port)) {
                        if ("*".equals(port)) {
                            pipeline.setParameter(name, new RuntimeValue(cmd.getParameter(port, name)));
                            continue;
                        }
                        pipeline.setParameter(port, name, new RuntimeValue(cmd.getParameter(port, name)));
                    }
                }
                Set<String> ports = pipeline.getInputs();
                Set<String> cmdPorts = cmd.getInputPorts();
                Set<String> cfgPorts = config.inputs.keySet();
                HashSet<String> allPorts = new HashSet<String>();
                allPorts.addAll(cmdPorts);
                allPorts.addAll(cfgPorts);
                for (String port : allPorts) {
                    if (!ports.contains(port)) {
                        throw new XProcException("There is a binding for the port '" + port + "' but the pipeline declares no such port.");
                    }
                    pipeline.clearInputs(port);
                    if (cmdPorts.contains(port)) {
                        XdmNode doc = null;
                        for (String uri2 : cmd.getInputs(port)) {
                            if (uri2.startsWith("xml:")) {
                                uri2 = uri2.substring(4);
                                Object source = null;
                                doc = "-".equals(uri2) ? this.runtime.parse(new InputSource(System.in)) : this.runtime.parse(new InputSource(uri2));
                            } else if (uri2.startsWith("data:")) {
                                uri2 = uri2.substring(5);
                                ReadableData rd = new ReadableData(this.runtime, XProcConstants.c_data, uri2, "text/plain");
                                doc = rd.read();
                            } else {
                                throw new UnsupportedOperationException("Unexpected input type: " + uri2);
                            }
                            pipeline.writeTo(port, doc);
                        }
                        continue;
                    }
                    for (ReadablePipe pipe : config.inputs.get(port)) {
                        XdmNode doc = pipe.read();
                        pipeline.writeTo(port, doc);
                    }
                }
                String stdio = null;
                for (String port : pipeline.getOutputs()) {
                    uri = null;
                    if (cmd.outputs.containsKey(port)) {
                        uri = cmd.outputs.get(port);
                    } else if (config.outputs.containsKey(port)) {
                        uri = config.outputs.get(port);
                    }
                    if (!"-".equals(uri) || stdio != null) continue;
                    stdio = port;
                }
                for (String port : pipeline.getOutputs()) {
                    uri = null;
                    if (cmd.outputs.containsKey(port)) {
                        uri = cmd.outputs.get(port);
                    } else if (config.outputs.containsKey(port)) {
                        uri = config.outputs.get(port);
                    }
                    if (uri != null) continue;
                    if (stdio == null) {
                        stdio = port;
                        continue;
                    }
                    this.warning(this.logger, null, "You didn't specify any binding for the output port '" + port + "', its output will be discard.");
                }
                for (QName optname : config.options.keySet()) {
                    value = new RuntimeValue(config.options.get(optname), null, null);
                    pipeline.passOption(optname, value);
                }
                for (QName optname : cmd.getOptionNames()) {
                    value = new RuntimeValue(cmd.getOption(optname), null, null);
                    pipeline.passOption(optname, value);
                }
                pipeline.run();
                for (String port : pipeline.getOutputs()) {
                    uri = null;
                    if (cmd.outputs.containsKey(port)) {
                        uri = cmd.outputs.get(port);
                    } else if (config.outputs.containsKey(port)) {
                        uri = config.outputs.get(port);
                    }
                    if (port.equals(stdio)) {
                        this.finest(this.logger, null, "Copy output from " + port + " to stdout");
                        uri = null;
                    } else {
                        if (uri == null) continue;
                        this.finest(this.logger, null, "Copy output from " + port + " to " + uri);
                    }
                    Serialization serial = pipeline.getSerialization(port);
                    if (serial == null) {
                        serial = new Serialization(this.runtime, pipeline.getNode());
                        for (String name : config.serializationOptions.keySet()) {
                            String value2 = config.serializationOptions.get(name);
                            if ("byte-order-mark".equals(name)) {
                                serial.setByteOrderMark("true".equals(value2));
                            }
                            if ("escape-uri-attributes".equals(name)) {
                                serial.setEscapeURIAttributes("true".equals(value2));
                            }
                            if ("include-content-type".equals(name)) {
                                serial.setIncludeContentType("true".equals(value2));
                            }
                            if ("indent".equals(name)) {
                                serial.setIndent("true".equals(value2));
                            }
                            if ("omit-xml-declaration".equals(name)) {
                                serial.setOmitXMLDeclaration("true".equals(value2));
                            }
                            if ("undeclare-prefixes".equals(name)) {
                                serial.setUndeclarePrefixes("true".equals(value2));
                            }
                            if ("method".equals(name)) {
                                serial.setMethod(new QName("", value2));
                            }
                            if ("doctype-public".equals(name)) {
                                serial.setDoctypePublic(value2);
                            }
                            if ("doctype-system".equals(name)) {
                                serial.setDoctypeSystem(value2);
                            }
                            if ("encoding".equals(name)) {
                                serial.setEncoding(value2);
                            }
                            if ("media-type".equals(name)) {
                                serial.setMediaType(value2);
                            }
                            if ("normalization-form".equals(name)) {
                                serial.setNormalizationForm(value2);
                            }
                            if ("standalone".equals(name)) {
                                serial.setStandalone(value2);
                            }
                            if (!"version".equals(name)) continue;
                            serial.setVersion(value2);
                        }
                    }
                    WritableDocument wd = null;
                    if (uri != null) {
                        URI furi = new URI(uri);
                        String filename = furi.getPath();
                        FileOutputStream outfile = new FileOutputStream(filename);
                        wd = new WritableDocument(this.runtime, filename, serial, outfile);
                    } else {
                        wd = new WritableDocument(this.runtime, uri, serial);
                    }
                    ReadablePipe rpipe = pipeline.readFrom(port);
                    while (rpipe.moreDocuments()) {
                        wd.write(rpipe.read());
                    }
                    if (uri == null) continue;
                    wd.close();
                }
                if (stdio != null) {
                    System.out.println();
                }
            }
            catch (XProcException err) {
                Throwable cause;
                if (err.getErrorCode() != null) {
                    this.error(this.logger, null, this.errorMessage(err.getErrorCode()), err.getErrorCode());
                } else {
                    this.error(this.logger, null, err.toString(), null);
                }
                for (cause = err.getCause(); cause != null && cause instanceof XProcException; cause = cause.getCause()) {
                }
                if (cause != null) {
                    this.error(this.logger, null, "Underlying exception: " + cause, null);
                }
                if (this.debug) {
                    err.printStackTrace();
                }
            }
            catch (Exception err) {
                this.error(this.logger, null, "Pipeline failed: " + err.toString(), null);
                if (err.getCause() != null) {
                    Throwable cause = err.getCause();
                    this.error(this.logger, null, "Underlying exception: " + cause, null);
                }
                if (!this.debug) break block84;
                err.printStackTrace();
            }
        }
    }

    private void showVersion() {
        System.out.println("XML Calabash version " + XProcConstants.XPROC_VERSION + ", an XProc processor.");
        if (this.runtime != null) {
            System.out.print("Running on Saxon version ");
            System.out.print(this.runtime.getConfiguration().getProcessor().getSaxonProductVersion());
            System.out.print(", ");
            System.out.print(this.runtime.getConfiguration().getProcessor().getUnderlyingConfiguration().getEditionCode());
            System.out.println(" edition.");
        }
        System.out.println("Copyright (c) 2007-2012 Norman Walsh");
        System.out.println("See http://xmlcalabash.com/");
        System.out.println("");
    }

    private void usage() throws IOException {
        this.showVersion();
        InputStream instream = this.getClass().getResourceAsStream("/etc/usage.txt");
        if (instream == null) {
            throw new UnsupportedOperationException("Failed to load usage text from JAR file. This \"can't happen\".");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(instream));
        String line = null;
        while ((line = br.readLine()) != null) {
            System.err.println(line);
        }
        instream.close();
        br.close();
        System.exit(1);
    }

    private String errorMessage(QName code) {
        InputStream instream = this.getClass().getResourceAsStream("/etc/error-list.xml");
        if (instream != null) {
            XdmNode doc = this.runtime.parse(new InputSource(instream));
            XdmSequenceIterator iter = doc.axisIterator(Axis.DESCENDANT, new QName("http://www.w3.org/ns/xproc-error", "error"));
            while (iter.hasNext()) {
                XdmNode error = (XdmNode)iter.next();
                if (!code.getLocalName().equals(error.getAttributeValue(_code))) continue;
                return error.getStringValue();
            }
        }
        return "Unknown error";
    }

    private String message(XdmNode node, String message) {
        String baseURI = "(unknown URI)";
        int lineNumber = -1;
        if (node != null) {
            baseURI = node.getBaseURI().toASCIIString();
            lineNumber = node.getLineNumber();
            return baseURI + ":" + lineNumber + ": " + message;
        }
        return message;
    }

    public void error(Logger logger, XdmNode node, String message, QName code) {
        logger.severe(this.message(node, message));
    }

    public void warning(Logger logger, XdmNode node, String message) {
        logger.warning(this.message(node, message));
    }

    public void info(Logger logger, XdmNode node, String message) {
        logger.info(this.message(node, message));
    }

    public void fine(Logger logger, XdmNode node, String message) {
        logger.fine(this.message(node, message));
    }

    public void finer(Logger logger, XdmNode node, String message) {
        logger.finer(this.message(node, message));
    }

    public void finest(Logger logger, XdmNode node, String message) {
        logger.finest(this.message(node, message));
    }
}

