/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.instruct.CopyOf;
import net.sf.saxon.expr.instruct.Executable;
import net.sf.saxon.lib.Validation;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Declaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public final class XSLCopyOf
extends StyleElement {
    private Expression select;
    private boolean copyNamespaces;
    private int validation = 3;
    private SchemaType schemaType;
    private boolean readOnce = false;

    public boolean isInstruction() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        String copyNamespacesAtt = null;
        String validationAtt = null;
        String typeAtt = null;
        String readOnceAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f == "select") {
                selectAtt = atts.getValue(a);
                continue;
            }
            if (f == "copy-namespaces") {
                copyNamespacesAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f == "validation") {
                validationAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f == "type") {
                typeAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            if (f == "{http://saxon.sf.net/}read-once") {
                readOnceAtt = Whitespace.trim(atts.getValue(a));
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (selectAtt != null) {
            this.select = this.makeExpression(selectAtt);
        } else {
            this.reportAbsence("select");
        }
        if (copyNamespacesAtt == null) {
            this.copyNamespaces = true;
        } else if (copyNamespacesAtt.equals("yes")) {
            this.copyNamespaces = true;
        } else if (copyNamespacesAtt.equals("no")) {
            this.copyNamespaces = false;
        } else {
            this.compileError("Value of copy-namespaces must be 'yes' or 'no'", "XTSE0020");
        }
        if (validationAtt != null) {
            this.validation = Validation.getCode(validationAtt);
            if (this.validation != 4 && !this.getExecutable().isSchemaAware()) {
                this.validation = 4;
                this.compileError("To perform validation, a schema-aware XSLT processor is needed", "XTSE1660");
            }
            if (this.validation == -1) {
                this.compileError("invalid value of validation attribute", "XTSE0020");
            }
        } else {
            this.validation = this.getContainingStylesheet().getDefaultValidation();
        }
        if (typeAtt != null) {
            this.schemaType = this.getSchemaType(typeAtt);
            if (!this.getExecutable().isSchemaAware()) {
                this.compileError("The @type attribute is available only with a schema-aware XSLT processor", "XTSE1660");
            }
            this.validation = 8;
        }
        if (typeAtt != null && validationAtt != null) {
            this.compileError("The @validation and @type attributes are mutually exclusive", "XTSE1505");
        }
        if (readOnceAtt != null) {
            if (readOnceAtt.equals("yes")) {
                this.readOnce = true;
            } else if (readOnceAtt.equals("no")) {
                this.readOnce = false;
            } else {
                this.compileError("saxon:read-once attribute must be 'yes' or 'no'");
            }
        }
    }

    public void validate(Declaration decl) throws XPathException {
        this.checkEmpty();
        this.select = this.typeCheck("select", this.select);
    }

    public Expression compile(Executable exec, Declaration decl) {
        CopyOf inst = new CopyOf(this.select, this.copyNamespaces, this.validation, this.schemaType, false);
        if (this.readOnce) {
            inst.setReadOnce(this.readOnce);
        }
        inst.setCopyLineNumbers(exec.getConfiguration().isLineNumbering());
        inst.setStaticBaseUri(this.getBaseURI());
        return inst;
    }
}

