/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;

public class URIUtils {
    protected URIUtils() {
    }

    public static String encode(String string) {
        String string2 = ":/?#[]@";
        String string3 = "!$&'()*+,;=";
        String string4 = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz-._~";
        String string5 = string2 + string3 + string4 + "%";
        String string6 = System.getProperty("file.separator");
        if ("\\".equals(string6)) {
            string = string.replaceAll("\\\\", "/");
        }
        String string7 = "";
        try {
            byte[] byArray = string.getBytes("UTF-8");
            for (int i = 0; i < byArray.length; ++i) {
                string7 = string5.indexOf(byArray[i]) >= 0 ? string7 + (char)byArray[i] : string7 + String.format("%%%02X", byArray[i]);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return string7;
    }

    public static URI homeAsURI() {
        return URIUtils.dirAsURI(System.getProperty("user.home"));
    }

    public static URI cwdAsURI() {
        return URIUtils.dirAsURI(System.getProperty("user.dir"));
    }

    public static URI dirAsURI(String string) {
        URI uRI = null;
        try {
            String string2 = URIUtils.encode(string);
            if (!string2.endsWith("/")) {
                string2 = string2 + "/";
            }
            if (!string2.startsWith("/")) {
                string2 = "/" + string2;
            }
            uRI = new URI("file:" + string2);
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new XProcException(uRISyntaxException);
        }
        return uRI;
    }

    public static URI makeAbsolute(String string) {
        URI uRI = URIUtils.cwdAsURI();
        return uRI.resolve(URIUtils.encode(string));
    }

    public static File getFile(String string) {
        File file;
        URL uRL;
        try {
            uRL = new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new XProcException(malformedURLException);
        }
        try {
            file = new File(uRL.toURI());
        }
        catch (URISyntaxException uRISyntaxException) {
            file = new File(uRL.getPath());
        }
        return file;
    }
}

