/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.pattern;

import java.io.Serializable;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionTool;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.MonoIterator;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.RoleLocator;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.TypeChecker;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.SlotManager;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class NodeSetPattern
extends Pattern {
    protected Expression expression;
    protected ItemType itemType;

    public NodeSetPattern(Expression exp, Configuration config) {
        this.expression = exp;
        if ((this.expression.getDependencies() & 0xE) != 0) {
            throw new IllegalArgumentException("Expression used in pattern must not depend on focus");
        }
    }

    public Pattern analyze(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        this.expression = visitor.typeCheck(this.expression, contextItemType);
        RoleLocator role = new RoleLocator(3, (Serializable)((Object)this.expression.toString()), 0);
        this.expression = TypeChecker.staticTypeCheck(this.expression, SequenceType.NODE_SEQUENCE, false, role, visitor);
        this.itemType = this.expression.getItemType(visitor.getConfiguration().getTypeHierarchy());
        return this;
    }

    public int getDependencies() {
        return this.expression.getDependencies();
    }

    public Iterator iterateSubExpressions() {
        return new MonoIterator(this.expression);
    }

    public void promote(PromotionOffer offer, Expression parent) throws XPathException {
        this.expression = this.expression.promote(offer, parent);
    }

    public boolean replaceSubExpression(Expression original, Expression replacement) {
        if (this.expression == original) {
            this.expression = replacement;
            return true;
        }
        return false;
    }

    public int allocateSlots(StaticContext env, SlotManager slotManager, int nextFree) {
        return ExpressionTool.allocateSlots(this.expression, nextFree, slotManager);
    }

    public boolean matches(NodeInfo e, XPathContext context) throws XPathException {
        NodeInfo node;
        SequenceIterator iter = this.expression.iterate(context);
        do {
            if ((node = (NodeInfo)iter.next()) != null) continue;
            return false;
        } while (!node.isSameNodeInfo(e));
        return true;
    }

    public int getNodeKind() {
        if (this.itemType instanceof NodeTest) {
            return ((NodeTest)this.itemType).getPrimitiveType();
        }
        return 0;
    }

    public NodeTest getNodeTest() {
        if (this.itemType instanceof NodeTest) {
            return (NodeTest)this.itemType;
        }
        return AnyNodeTest.getInstance();
    }

    public boolean equals(Object other) {
        return other instanceof NodeSetPattern && ((NodeSetPattern)other).expression.equals(this.expression);
    }

    public int hashCode() {
        return 0x73108728 ^ this.expression.hashCode();
    }
}

