/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ComplexType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.value.Whitespace;

public abstract class Stripper
extends ProxyReceiver {
    private byte[] stripStack = new byte[100];
    private int top = 0;
    public static final byte ALWAYS_PRESERVE = 1;
    public static final byte ALWAYS_STRIP = 2;
    public static final byte STRIP_DEFAULT = 0;
    public static final byte PRESERVE_PARENT = 4;
    public static final byte CANNOT_STRIP = 8;

    public abstract Stripper getAnother();

    public abstract byte isSpacePreserving(int var1) throws XPathException;

    public void open() throws XPathException {
        this.top = 0;
        this.stripStack[this.top] = 1;
        super.open();
    }

    public void startElement(int nameCode, int typeCode, int locationId, int properties) throws XPathException {
        SchemaType type;
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
        byte preserveParent = this.stripStack[this.top];
        byte preserve = (byte)(preserveParent & 4);
        byte elementStrip = this.isSpacePreserving(nameCode & 0xFFFFF);
        if (elementStrip == 1) {
            preserve = (byte)(preserve | 1);
        } else if (elementStrip == 2) {
            preserve = (byte)(preserve | 2);
        }
        if (preserve == 0 && typeCode != -1 && typeCode != 630 && ((type = this.getConfiguration().getSchemaType(typeCode)).isSimpleType() || ((ComplexType)type).isSimpleContent())) {
            preserve = (byte)(preserve | 8);
        }
        ++this.top;
        if (this.top >= this.stripStack.length) {
            byte[] newStack = new byte[this.top * 2];
            System.arraycopy(this.stripStack, 0, newStack, 0, this.top);
            this.stripStack = newStack;
        }
        this.stripStack[this.top] = preserve;
    }

    public void attribute(int nameCode, int typeCode, CharSequence value, int locationId, int properties) throws XPathException {
        if ((nameCode & 0xFFFFF) == 386) {
            if (((Object)value).toString().equals("preserve")) {
                int n = this.top;
                this.stripStack[n] = (byte)(this.stripStack[n] | 4);
            } else {
                int n = this.top;
                this.stripStack[n] = (byte)(this.stripStack[n] & 0xFFFFFFFB);
            }
        }
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    public void endElement() throws XPathException {
        this.nextReceiver.endElement();
        --this.top;
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (((this.stripStack[this.top] & 0xD) != 0 && (this.stripStack[this.top] & 2) == 0 || !Whitespace.isWhite(chars)) && chars.length() > 0) {
            this.nextReceiver.characters(chars, locationId, properties);
        }
    }

    public boolean usesTypeAnnotations() {
        return true;
    }
}

