/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.FrenchStemmer;
import org.apache.lucene.analysis.tokenattributes.TermAttribute;

public final class FrenchStemFilter
extends TokenFilter {
    private FrenchStemmer stemmer = new FrenchStemmer();
    private Set exclusions = null;
    private TermAttribute termAtt = (TermAttribute)this.addAttribute(TermAttribute.class);

    public FrenchStemFilter(TokenStream in) {
        super(in);
    }

    public FrenchStemFilter(TokenStream in, Set exclusiontable) {
        this(in);
        this.exclusions = exclusiontable;
    }

    public boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            String s;
            String term = this.termAtt.term();
            if (!(this.exclusions != null && this.exclusions.contains(term) || (s = this.stemmer.stem(term)) == null || s.equals(term))) {
                this.termAtt.setTermBuffer(s);
            }
            return true;
        }
        return false;
    }

    public void setStemmer(FrenchStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }

    public void setExclusionTable(Map exclusiontable) {
        this.exclusions = new HashSet(exclusiontable.keySet());
    }
}

