/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLValueOf;
import com.icl.saxon.tree.NodeImpl;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;

public abstract class XSLStringConstructor
extends StyleElement {
    private String stringValue = null;
    private Expression valueExpression = null;

    public boolean isInstruction() {
        return true;
    }

    public boolean mayContainTemplateBody() {
        return true;
    }

    protected void optimize() throws TransformerConfigurationException {
        NodeImpl nodeImpl = (NodeImpl)this.getFirstChild();
        if (nodeImpl == null) {
            this.stringValue = "";
        } else {
            NodeImpl nodeImpl2 = (NodeImpl)nodeImpl.getNextSibling();
            if (nodeImpl2 == null) {
                if (nodeImpl.getNodeType() == 3) {
                    this.stringValue = nodeImpl.getStringValue();
                } else if (nodeImpl instanceof XSLValueOf) {
                    XSLValueOf xSLValueOf = (XSLValueOf)nodeImpl;
                    this.valueExpression = xSLValueOf.getSelectExpression();
                    if (xSLValueOf.getDisableOutputEscaping()) {
                        xSLValueOf.compileError("disable-output-escaping is not allowed for a non-text node");
                    }
                }
            }
        }
    }

    public String expandChildren(Context context) throws TransformerException {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        if (this.valueExpression != null) {
            return this.valueExpression.evaluateAsString(context);
        }
        Controller controller = context.getController();
        Outputter outputter = controller.getOutputter();
        StringBuffer stringBuffer = new StringBuffer();
        controller.changeToTextOutputDestination(stringBuffer);
        this.processChildren(context);
        controller.resetOutputDestination(outputter);
        return stringBuffer.toString();
    }
}

