/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.xmlunit;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.ReadablePipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import junit.framework.AssertionFailedError;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.Serializer;
import net.sf.saxon.s9api.XdmNode;
import org.custommonkey.xmlunit.XMLAssert;
import org.custommonkey.xmlunit.XMLUnit;
import org.xml.sax.SAXException;

public class Compare
extends DefaultStep {
    private static final QName c_result = new QName("c", "http://www.w3.org/ns/xproc-step", "result");
    private static final QName _fail_if_not_equal = new QName("", "fail-if-not-equal");
    private static final QName _compare_unmatched = new QName("", "compare-unmatched");
    private static final QName _ignore_comments = new QName("", "ignore-comments");
    private static final QName _ignore_whitespace = new QName("", "ignore-whitespace");
    private static final QName _normalize = new QName("", "normalize");
    private static final QName _normalize_whitespace = new QName("", "normalize-whitespace");
    private static final QName _ignore_diff_between_text_and_cdata = new QName("", "ignore-diff-between-text-and-cdata");
    private static final boolean default_compare_unmatched = false;
    private static final boolean default_ignore_comments = false;
    private static final boolean default_ignore_whitespace = false;
    private static final boolean default_normalize = false;
    private static final boolean default_normalize_whitespace = false;
    private static final boolean default_ignore_diff_between_text_and_cdata = false;
    private ReadablePipe source = null;
    private ReadablePipe alternate = null;
    private WritablePipe result = null;

    public Compare(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setInput(String string, ReadablePipe readablePipe) {
        if ("source".equals(string)) {
            this.source = readablePipe;
        } else {
            this.alternate = readablePipe;
        }
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.source.resetReader();
        this.result.resetWriter();
    }

    private String getXMLDocument(XdmNode xdmNode) throws SaxonApiException {
        Serializer serializer = this.makeSerializer();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        serializer.setOutputStream((OutputStream)byteArrayOutputStream);
        S9apiUtils.serialize(this.runtime, xdmNode, serializer);
        try {
            return byteArrayOutputStream.toString("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XProcException(unsupportedEncodingException);
        }
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        String string = this.getXMLDocument(this.source.read());
        String string2 = this.getXMLDocument(this.alternate.read());
        boolean bl = false;
        try {
            XMLUnit.setCompareUnmatched((boolean)this.getOption(_compare_unmatched, false));
            XMLUnit.setIgnoreComments((boolean)this.getOption(_ignore_comments, false));
            XMLUnit.setIgnoreDiffBetweenTextAndCDATA((boolean)this.getOption(_ignore_diff_between_text_and_cdata, false));
            XMLUnit.setIgnoreWhitespace((boolean)this.getOption(_ignore_whitespace, false));
            XMLUnit.setNormalize((boolean)this.getOption(_normalize, false));
            XMLAssert.assertXMLEqual((String)string, (String)string2);
            bl = true;
        }
        catch (AssertionFailedError assertionFailedError) {
        }
        catch (SAXException sAXException) {
            throw new SaxonApiException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new SaxonApiException(iOException.getMessage());
        }
        catch (Exception exception) {
            throw new SaxonApiException(exception.getMessage());
        }
        if (!bl && this.getOption(_fail_if_not_equal, false)) {
            throw XProcException.stepError(19);
        }
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        treeWriter.addStartElement(c_result);
        treeWriter.startContent();
        treeWriter.addText(String.valueOf(bl));
        treeWriter.addEndElement();
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }

    static {
        XMLUnit.setTransformerFactory((String)"net.sf.saxon.TransformerFactoryImpl");
        XMLUnit.setXPathFactory((String)"net.sf.saxon.xpath.XPathFactoryImpl");
    }
}

