/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.lib;

public class NamespaceConstant {
    public static final String NULL = "";
    public static final short NULL_CODE = 0;
    public static final int NULL_NAMESPACE_CODE = 0;
    public static final String XML = "http://www.w3.org/XML/1998/namespace";
    public static final short XML_CODE = 1;
    public static final int XML_NAMESPACE_CODE = 65537;
    public static final String XSLT = "http://www.w3.org/1999/XSL/Transform";
    public static final short XSLT_CODE = 2;
    public static final String SAXON = "http://saxon.sf.net/";
    public static final short SAXON_CODE = 3;
    public static final String SCHEMA = "http://www.w3.org/2001/XMLSchema";
    public static final short SCHEMA_CODE = 4;
    public static final String SCHEMA_INSTANCE = "http://www.w3.org/2001/XMLSchema-instance";
    public static final short XSI_CODE = 5;
    public static final String SCHEMA_VERSIONING = "http://www.w3.org/2007/XMLSchema-versioning";
    public static final String SQL = "http://saxon.sf.net/sql";
    public static final String EXSLT_COMMON = "http://exslt.org/common";
    public static final String EXSLT_MATH = "http://exslt.org/math";
    public static final String EXSLT_SETS = "http://exslt.org/sets";
    public static final String EXSLT_DATES_AND_TIMES = "http://exslt.org/dates-and-times";
    public static final String EXSLT_RANDOM = "http://exslt.org/random";
    public static final String FN = "http://www.w3.org/2005/xpath-functions";
    public static final String ERR = "http://www.w3.org/2005/xqt-errors";
    public static final String LOCAL = "http://www.w3.org/2005/xquery-local-functions";
    public static final String MICROSOFT_XSL = "http://www.w3.org/TR/WD-xsl";
    public static final String XHTML = "http://www.w3.org/1999/xhtml";
    public static final String XMLNS = "http://www.w3.org/2000/xmlns/";
    public static final String JAVA_TYPE = "http://saxon.sf.net/java-type";
    public static final String DOT_NET_TYPE = "http://saxon.sf.net/clitype";
    public static final String ANONYMOUS = "http://ns.saxonica.com/anonymous-type";
    public static final String SCM = "http://ns.saxonica.com/schema-component-model";
    public static final String OBJECT_MODEL_SAXON = "http://saxon.sf.net/jaxp/xpath/om";
    public static final String OBJECT_MODEL_XOM = "http://www.xom.nu/jaxp/xpath/xom";
    public static final String OBJECT_MODEL_JDOM = "http://jdom.org/jaxp/xpath/jdom";
    public static final String OBJECT_MODEL_DOM4J = "http://www.dom4j.org/jaxp/xpath/dom4j";
    public static final String OBJECT_MODEL_DOT_NET_DOM = "http://saxon.sf.net/object-model/dotnet/dom";
    public static final String CODEPOINT_COLLATION_URI = "http://www.w3.org/2005/xpath-functions/collation/codepoint";
    public static final String SAXON_GENERATED_GLOBAL = "http://saxon.sf.net/generated-global-variable";
    public static final String SAXON_CONFIGURATION = "http://saxon.sf.net/ns/configuration";

    private NamespaceConstant() {
    }

    public static final boolean isReserved(String uri) {
        if (uri == null) {
            return false;
        }
        return uri.equals(XSLT) || uri.equals(FN) || uri.equals(XML) || uri.equals(SCHEMA) || uri.equals(SCHEMA_INSTANCE);
    }

    public static final boolean isSpecialURICode(short uriCode) {
        return uriCode <= 6;
    }

    public static final boolean isReservedInQuery(String uri) {
        return uri.equals(FN) || uri.equals(XML) || uri.equals(SCHEMA) || uri.equals(SCHEMA_INSTANCE);
    }

    public static String findSimilarNamespace(String candidate) {
        if (NamespaceConstant.isSimilar(candidate, XML)) {
            return XML;
        }
        if (NamespaceConstant.isSimilar(candidate, SCHEMA)) {
            return SCHEMA;
        }
        if (NamespaceConstant.isSimilar(candidate, XSLT)) {
            return XSLT;
        }
        if (NamespaceConstant.isSimilar(candidate, SCHEMA_INSTANCE)) {
            return SCHEMA_INSTANCE;
        }
        if (NamespaceConstant.isSimilar(candidate, FN)) {
            return FN;
        }
        if (NamespaceConstant.isSimilar(candidate, SAXON)) {
            return SAXON;
        }
        if (NamespaceConstant.isSimilar(candidate, EXSLT_COMMON)) {
            return EXSLT_COMMON;
        }
        if (NamespaceConstant.isSimilar(candidate, EXSLT_MATH)) {
            return EXSLT_MATH;
        }
        if (NamespaceConstant.isSimilar(candidate, EXSLT_DATES_AND_TIMES)) {
            return EXSLT_DATES_AND_TIMES;
        }
        if (NamespaceConstant.isSimilar(candidate, EXSLT_RANDOM)) {
            return EXSLT_RANDOM;
        }
        if (NamespaceConstant.isSimilar(candidate, XHTML)) {
            return XHTML;
        }
        if (NamespaceConstant.isSimilar(candidate, ERR)) {
            return ERR;
        }
        if (NamespaceConstant.isSimilar(candidate, JAVA_TYPE)) {
            return JAVA_TYPE;
        }
        if (NamespaceConstant.isSimilar(candidate, DOT_NET_TYPE)) {
            return DOT_NET_TYPE;
        }
        return null;
    }

    private static boolean isSimilar(String s1, String s2) {
        if (s1.equalsIgnoreCase(s2)) {
            return true;
        }
        if (s1.startsWith(s2) && s1.length() - s2.length() < 3) {
            return true;
        }
        if (s2.startsWith(s1) && s2.length() - s1.length() < 3) {
            return true;
        }
        if (s1.length() > 8 && Math.abs(s2.length() - s1.length()) < 3) {
            int diff = 0;
            for (int i = 0; i < s1.length(); ++i) {
                char c1 = s1.charAt(i);
                if (i < s2.length() && c1 == s2.charAt(i) || i > 0 && i < s2.length() - 1 && c1 == s2.charAt(i - 1) || i + 1 < s2.length() && c1 == s2.charAt(i + 1)) continue;
                ++diff;
            }
            return diff < 3;
        }
        return false;
    }
}

