/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.KeyDefinition;
import net.sf.saxon.trans.XPathException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyDefinitionSet
implements Serializable {
    StructuredQName keyName;
    int keySetNumber;
    List<KeyDefinition> keyDefinitions;
    String collationName;
    boolean backwardsCompatible;

    public KeyDefinitionSet(StructuredQName keyName, int keySetNumber) {
        this.keyName = keyName;
        this.keySetNumber = keySetNumber;
        this.keyDefinitions = new ArrayList<KeyDefinition>(3);
    }

    public void addKeyDefinition(KeyDefinition keyDef) throws XPathException {
        if (this.keyDefinitions.isEmpty()) {
            this.collationName = keyDef.getCollationName();
        } else {
            if (this.collationName == null && keyDef.getCollationName() != null || this.collationName != null && !this.collationName.equals(keyDef.getCollationName())) {
                XPathException err = new XPathException("All keys with the same name must use the same collation");
                err.setErrorCode("XTSE1220");
                throw err;
            }
            List<KeyDefinition> v = this.getKeyDefinitions();
            for (int i = 0; i < v.size(); ++i) {
                KeyDefinition other = v.get(i);
                if (!keyDef.getMatch().equals(other.getMatch()) || !keyDef.getBody().equals(other.getBody())) continue;
                return;
            }
        }
        if (keyDef.isBackwardsCompatible()) {
            this.backwardsCompatible = true;
        }
        this.keyDefinitions.add(keyDef);
    }

    public StructuredQName getKeyName() {
        return this.keyName;
    }

    public int getKeySetNumber() {
        return this.keySetNumber;
    }

    public List<KeyDefinition> getKeyDefinitions() {
        return this.keyDefinitions;
    }

    public boolean isBackwardsCompatible() {
        return this.backwardsCompatible;
    }
}

