/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.trans;

import java.io.Serializable;
import net.sf.saxon.event.RuleBasedStripper;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.pattern.NodeTestPattern;
import net.sf.saxon.style.StylesheetModule;
import net.sf.saxon.trans.Rule;

public class StripSpaceRules
implements Serializable {
    private Rule anyElementRule = null;
    private Rule unnamedElementRuleChain = null;
    private IntHashMap<Rule> namedElementRules = new IntHashMap(32);
    private int sequence = 0;

    public void addRule(NodeTest test, RuleBasedStripper.StripRuleTarget action, StylesheetModule module, int lineNumber) {
        int precedence = module.getPrecedence();
        int minImportPrecedence = module.getMinImportPrecedence();
        double priority = test.getDefaultPriority();
        NodeTestPattern pattern = new NodeTestPattern(test);
        pattern.setSystemId(module.getSourceElement().getSystemId());
        pattern.setLineNumber(lineNumber);
        Rule newRule = new Rule(pattern, action, precedence, minImportPrecedence, priority, this.sequence++);
        newRule.setRank((precedence << 16) + this.sequence);
        if (test instanceof NodeKindTest) {
            newRule.setAlwaysMatches(true);
            this.anyElementRule = this.addRuleToList(newRule, this.anyElementRule, true);
        } else if (test instanceof NameTest) {
            newRule.setAlwaysMatches(true);
            int fp = test.getFingerprint();
            Rule chain = this.namedElementRules.get(fp);
            this.namedElementRules.put(fp, this.addRuleToList(newRule, chain, true));
        } else {
            this.unnamedElementRuleChain = this.addRuleToList(newRule, this.unnamedElementRuleChain, false);
        }
    }

    private Rule addRuleToList(Rule newRule, Rule list, boolean dropRemainder) {
        Rule rule;
        if (list == null) {
            return newRule;
        }
        int precedence = newRule.getPrecedence();
        Rule prev = null;
        for (rule = list; rule != null; rule = rule.getNext()) {
            if (rule.getPrecedence() <= precedence) {
                newRule.setNext(dropRemainder ? null : rule);
                if (prev == null) {
                    return newRule;
                }
                prev.setNext(newRule);
                break;
            }
            prev = rule;
        }
        if (rule == null) {
            prev.setNext(newRule);
            newRule.setNext(null);
        }
        return list;
    }

    public Rule getRule(int fingerprint) {
        Rule bestRule = this.namedElementRules.get(fingerprint);
        if (this.unnamedElementRuleChain != null) {
            bestRule = this.searchRuleChain(fingerprint, bestRule, this.unnamedElementRuleChain);
        }
        if (this.anyElementRule != null) {
            bestRule = this.searchRuleChain(fingerprint, bestRule, this.anyElementRule);
        }
        return bestRule;
    }

    private Rule searchRuleChain(int fingerprint, Rule bestRule, Rule head) {
        while (head != null) {
            block5: {
                block3: {
                    block4: {
                        if (bestRule == null) break block3;
                        int rank = head.compareRank(bestRule);
                        if (rank < 0) break;
                        if (rank != 0) break block4;
                        if (head.isAlwaysMatches() || head.getPattern().getNodeTest().matches(1, fingerprint, -1)) {
                            bestRule = head;
                            break;
                        }
                        break block5;
                    }
                    if (!head.isAlwaysMatches() && !head.getPattern().getNodeTest().matches(1, fingerprint, -1)) break block5;
                    bestRule = head;
                    break block5;
                }
                if (head.isAlwaysMatches() || head.getPattern().getNodeTest().matches(1, fingerprint, -1)) {
                    bestRule = head;
                    break;
                }
            }
            head = head.getNext();
        }
        return bestRule;
    }
}

