# Copyright 1999-2023 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# ebuild generated by hackport 0.8.4.0.9999
#hackport: flags: build-examples:examples

CABAL_FEATURES="lib profile haddock hoogle hscolour test-suite"
inherit ghc-package haskell-cabal

DESCRIPTION="shell-like (systems) programming in Haskell"
HOMEPAGE="https://github.com/gregwebs/Shelly.hs"

LICENSE="BSD"
SLOT="0/${PV}"
KEYWORDS="~amd64 ~arm64 ~ppc64 ~riscv ~x86"
IUSE="examples lifted"

RDEPEND="
	>=dev-haskell/async-2.2.3:=[profile?]
	>=dev-haskell/enclosed-exceptions-1.0.1:=[profile?]
	>=dev-haskell/lifted-async-0.10.2:=[profile?]
	>=dev-haskell/lifted-base-0.2.3.2:=[profile?]
	>=dev-haskell/monad-control-0.3.2:=[profile?] <dev-haskell/monad-control-1.1:=[profile?]
	>=dev-haskell/text-1.2.3.1:=[profile?]
	>=dev-haskell/transformers-base-0.4.5:=[profile?]
	>=dev-haskell/unix-compat-0.4.1.1:=[profile?] <dev-haskell/unix-compat-0.8:=[profile?]
	>=dev-lang/ghc-8.10.6:=
"
DEPEND="
	${RDEPEND}
	>=dev-haskell/cabal-3.2.1.0
	test? (
		>=dev-haskell/hspec-2.2.2
		dev-haskell/hspec-contrib
		>=dev-haskell/hunit-1.2.5.2
	)
"

example_exes=(
	"drain"
	"run-handles"
	"Color"
)

src_prepare() {
	for e in "${example_exes[@]}"; do
		export CABAL_CHDEPS=(
			"${CABAL_CHDEPS[@]}"
			"Executable ${e}"
			"executable ${PN}-examples-${e}"
		)
	done

	haskell-cabal_src_prepare
}

src_configure() {
	config_flags=(
		$(cabal_flag examples build-examples)
		$(cabal_flag lifted lifted)
	)

	haskell-cabal_src_configure "${config_flags[@]}"
}

pkg_postinst() {
	ghc-package_pkg_postinst

	elog "The following example executables installed with this package have been"
	elog "renamed to help prevent name collisions:"
	elog ""

	for e in "${example_exes[@]}"; do
		elog "${e} -> ${PN}-examples-${e}"
	done
}
