/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.guihelper.gui.look;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

import net.dudesblog.guihelper.util.PropertyManager;

import com.nilo.plaf.nimrod.NimRODLookAndFeel;
import com.nilo.plaf.nimrod.NimRODTheme;

public final class MyUIManager {

	private static final Color BLUE_PRIMARY = new Color(0, 159, 166);

	private static final Color BLUE_SECONDARY = new Color(37, 53, 78);

	private static final Color BLUE_BLACK = new Color(255, 255, 255);

	private static final Color BLUE_WHITE = new Color(153, 153, 255);

	private static final Color BLACK_PRIMARY = new Color(0, 102, 255);

	private static final Color BLACK_SECONDARY = new Color(0, 0, 0);

	private static final Color BLACK_BLACK = new Color(255, 255, 255);

	private static final Color BLACK_WHITE = new Color(153, 153, 153);

	private static final Color GRAY_PRIMARY = new Color(102, 102, 102);

	private static final Color GRAY_SECONDARY = new Color(193, 199, 205);

	@SuppressWarnings("unchecked")
	public static void nimrod() throws ClassNotFoundException,
			IllegalArgumentException, SecurityException,
			IllegalAccessException, InvocationTargetException,
			NoSuchMethodException, UnsupportedLookAndFeelException {
		NimRODLookAndFeel NimRODLF = new NimRODLookAndFeel();
		String subTheme = PropertyManager.getProperty("rmc.user.lf.sub");
		if (subTheme != null && subTheme.length() > 0
				&& !subTheme.equals("default")) {
			NimRODTheme theme = new NimRODTheme();
			String themeName = "set" + subTheme + "Theme";
			Class manager = Class
					.forName("net.dudesblog.guihelper.gui.look.MyUIManager");
			Method setThemeMethod = manager.getMethod(themeName,
					NimRODTheme.class);
			setThemeMethod.invoke(null, theme);
			NimRODLookAndFeel.setCurrentTheme(theme);
		}
		UIManager.setLookAndFeel(NimRODLF);
	}

	public static void setBlueTheme(NimRODTheme theme) {
		theme.setPrimary(BLUE_PRIMARY);
		theme.setSecondary(BLUE_SECONDARY);
		// theme.setSecondary2(BLUE_BLACK);
		theme.setBlack(BLUE_BLACK);
		theme.setWhite(BLUE_WHITE);
		theme.setFrameOpacity(195);
		theme.setMenuOpacity(195);
		theme.setOpacity(195);
	}

	public static void setBlackTheme(NimRODTheme theme) {
		theme.setPrimary(BLACK_PRIMARY);
		theme.setSecondary(BLACK_SECONDARY);
		// theme.setSecondary2(BLACK_BLACK );
		theme.setBlack(BLACK_BLACK);
		theme.setWhite(BLACK_WHITE);
		theme.setFrameOpacity(195);
		theme.setMenuOpacity(195);
		theme.setOpacity(195);
	}

	public static void setGrayTheme(NimRODTheme theme) {
		theme.setPrimary(GRAY_PRIMARY);
		theme.setSecondary(GRAY_SECONDARY);
		theme.setFrameOpacity(195);
		theme.setMenuOpacity(195);
		theme.setOpacity(195);
	}

	private static void osLF() throws ClassNotFoundException,
			InstantiationException, IllegalAccessException,
			UnsupportedLookAndFeelException {
		UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	}

	public static void setLF(String property) throws ClassNotFoundException,
			InstantiationException, IllegalAccessException,
			UnsupportedLookAndFeelException {
		if (property.equals("rmc")) {
			try {
				nimrod();
			} catch (IllegalArgumentException e) {
				e.printStackTrace();
			} catch (SecurityException e) {
				e.printStackTrace();
			} catch (InvocationTargetException e) {
				e.printStackTrace();
			} catch (NoSuchMethodException e) {
				e.printStackTrace();
			}
		} else if (property.equals("os")) {
			osLF();
		}
	}

}
