/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.guihelper.gui.reusables;

import java.awt.BorderLayout;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.guihelper.util.Language_util.OreintationHelper;
import sun.awt.VerticalBagLayout;

public class LabledTextFeild extends JPanel {

	private static final long serialVersionUID = 1L;

	protected JTextField mNamedTextField = new JTextField();

	protected String mName;

	public LabledTextFeild(String pName) {
		this.setLayout(new VerticalBagLayout());
		this.mName = pName;
		JPanel aNamePanel = new JPanel();
		aNamePanel.setLayout(new BorderLayout());
		JLabel aNameLabel = new JLabel(LanguageResource.getString(pName));
		aNameLabel.setLabelFor(this.mNamedTextField);
		aNamePanel.add(OreintationHelper.setJComponentOreintation(aNameLabel),
				BorderLayout.LINE_START);
		aNamePanel.add(OreintationHelper
				.setJComponentOreintation(this.mNamedTextField),
				BorderLayout.CENTER);
		aNamePanel.setBorder(new EmptyBorder(5, 5, 5, 5));
		this.add(OreintationHelper.setJComponentOreintation(aNamePanel));
	}

	public JTextField getNamedTextField() {
		return this.mNamedTextField;
	}

	public void setNamedTextField(JTextField pNamedTextField) {
		this.mNamedTextField = pNamedTextField;
	}

	public String getValue() {
		return this.mNamedTextField.getText();
	}

	public void setValue(String pNewValue) {
		this.mNamedTextField.setText(pNewValue);
	}

}
