/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.guihelper.gui.reusables;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;

import net.dudesblog.rmc.meta.pics.ClazzPics;

public class SplashScreen extends JWindow {

	private static final long serialVersionUID = 1L;

	public SplashScreen(String pSplashName) {
		this.setSize(192, 197);
		if (isAlwaysOnTopSupported()) {
			this.setAlwaysOnTop(true);
		}
		Dimension aScreen = Toolkit.getDefaultToolkit().getScreenSize();
		this.setLocation((aScreen.width - 192) / 2, (aScreen.height - 192) / 2);

		JLabel aLabel = new JLabel();
		aLabel.setBounds(0, 0, 192, 197);
		aLabel.setIcon(new ImageIcon(ClazzPics.class.getResource(pSplashName)));

		JProgressBar aProgressBar = new JProgressBar();
		aProgressBar.setBackground(Color.BLACK);
		aProgressBar.setForeground(Color.WHITE);
		aProgressBar.setIndeterminate(true);
		aProgressBar.setBounds(192, 192, 192, 10);

		this.add(aLabel, BorderLayout.PAGE_START);
		this.add(aProgressBar, BorderLayout.CENTER);
		this.setVisible(true);
	}

	class timerActionListener implements ActionListener {
		public void actionPerformed(ActionEvent e) {
			dispose();
		}
	}

	public static void main(String[] args) {
		new SplashScreen("rmc_192.png");
	}

}
