/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.guihelper.gui.reusables;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.text.DateFormat;
import java.util.Date;

import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import javax.swing.border.BevelBorder;

public class StatusBar extends JPanel {
	private static final long serialVersionUID = 1L;
	private int widths[];
	private JPanel panels[];
	private int totalWidth;

	public static final int CLOCK = -1;

	public StatusBar(int widths[]) {
		super(new GridBagLayout());
		if (widths == null) {
			widths = new int[] { 100 };
		}
		this.widths = widths;
		createPanels();
	}

	private void createPanels() {
		this.panels = new JPanel[this.widths.length];
		GridBagConstraints c;
		this.totalWidth = 0;
		for (int i = 0; i < this.widths.length; i++) {
			this.panels[i] = new JPanel();
			this.panels[i].setBorder(new BevelBorder(BevelBorder.LOWERED));
			c = new GridBagConstraints();
			c.gridx = i;
			c.gridy = 0;
			c.ipadx = 0;
			c.weightx = this.widths[i];
			c.ipady = 1;
			c.anchor = GridBagConstraints.WEST;
			c.fill = GridBagConstraints.BOTH;
			c.anchor = GridBagConstraints.WEST;
			add(this.panels[i], c);
			this.totalWidth += this.widths[i];
		}
		addComponentListener(new ComponentAdapter() {
			public void componentResized(ComponentEvent arg0) {
				super.componentResized(arg0);
				int w = getWidth();
				for (int i = 0; i < widths.length; i++) {
					int ww = (int) (w * widths[i] / (double) totalWidth);
					panels[i].setPreferredSize(new Dimension(ww, 18));
				}
			}
		});
	}

	synchronized public void setContent(final int i, Object content) {
		if ((i > this.widths.length) || (i < 0)) {
			return;
		}
		if (content instanceof String) {
			JLabel lbl = null;
			if ((this.panels[i].getComponentCount() > 0)
					&& (this.panels[i].getComponent(0) instanceof JLabel)) {
				lbl = (JLabel) this.panels[i].getComponent(0);
			} else {
				this.panels[i].removeAll();
				lbl = new JLabel();
				lbl.setFont(new Font("Courier", 0, 12));
				FlowLayout fl = new FlowLayout();
				fl.setVgap(0);
				fl.setHgap(5);
				this.panels[i].setLayout(fl);
				this.panels[i].add(lbl);
			}
			lbl.setText(content.toString());
		} else if (content instanceof Integer) {
			if (content.equals(CLOCK)) {
				setContent(i, DateFormat.getTimeInstance(DateFormat.SHORT)
						.format(new Date()));
				final Timer timer = new Timer(60000, new ActionListener() {
					DateFormat df = DateFormat
							.getTimeInstance(DateFormat.SHORT);

					public void actionPerformed(ActionEvent arg0) {
						setContent(i, this.df.format(new Date()));
					}
				});
				timer.setRepeats(true);
				timer.start();
			} else if (((Integer) content >= 0) && ((Integer) content <= 100)) {
				JProgressBar pb;
				if ((this.panels[i].getComponentCount() > 0)
						&& (this.panels[i].getComponent(0) instanceof JProgressBar)) {
					pb = (JProgressBar) this.panels[i].getComponent(0);
				} else {
					this.panels[i].setLayout(new BorderLayout());
					this.panels[i].removeAll();
					pb = new JProgressBar(0, 100);
					// pb.setFont(new Font("Courier", 0, 12));
					this.panels[i].add(pb, "Center");
				}
				pb.setValue((Integer) content);
			}
		}
	}

	public Object getContent(int i) {
		Object result = null;
		if ((i < this.widths.length) && (i >= 0)) {
			if (this.panels[i].getComponentCount() > 0) {
				result = this.panels[i].getComponent(0);
			}
			if (result instanceof JLabel) {
				return ((JLabel) result).getText();
			} else if (result instanceof JProgressBar) {
				return ((JProgressBar) result).getValue();
			}
		}
		return result;
	}

}
