/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.guihelper.util;

import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

import javax.swing.JOptionPane;

import org.apache.log4j.Logger;

public final class ErrorHandler {

	private static final Logger LOGGER = Logger.getLogger(ErrorHandler.class);

	private static ErrorHandler sErrorHandler;

	private ErrorHandler() {

	}

	private static ErrorHandler getInstance() {
		if (sErrorHandler == null) {
			sErrorHandler = new ErrorHandler();
		}
		return sErrorHandler;
	}

	public static void handleError(Exception pException, String pErrorName,
			String pErrorMessage, Component pParent) {
		getInstance().showError(pException, pErrorName, pErrorMessage, pParent);
		if (pException != null) {
			getInstance().LogError(pException);
		}
	}

	private void showError(Exception pException, String pErrorName,
			String pErrorMessage, Component pParent) {
		JOptionPane.showMessageDialog(pParent, pErrorMessage, pErrorName,
				JOptionPane.OK_OPTION);
	}

	private void LogError(Exception pException) {
		Date aTimeStart = new Date();
		SimpleDateFormat aDateFormat = new SimpleDateFormat(
				"dd.MM.yyyy HH:mm:ss");
		String aUser = new Properties(System.getProperties())
				.getProperty("user.name");
		String aError = pException.getClass().getName();
		StackTraceElement[] aStackTrace = pException.getStackTrace();
		String aClass = aStackTrace[1].getClassName();
		String aMethode = aStackTrace[1].getMethodName();
		int aLine = aStackTrace[1].getLineNumber();
		LOGGER.error(aUser + " | " + aDateFormat.format(aTimeStart) + " | "
				+ aClass + " |  " + aMethode + " | " + aLine + " | " + aError);
		LOGGER.error("Error message" + pException.getMessage());
	}

}
