/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.guihelper.util.Language_util;

import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Properties;

public final class LanguageResource {

	private static Properties sProperties = new Properties();

	private static LanguageResource sLanguageResource;

	private static final Locale aDefaultLocale = new Locale("en");

	private static LanguageResource getInstance() {
		if (sLanguageResource == null) {
			sLanguageResource = new LanguageResource();
		}
		return sLanguageResource;
	}

	public static boolean isDefaultLanguage() {
		if (Language.getSCurrentLocaleLanguage().getLanguage() == aDefaultLocale
				.getLanguage()) {
			return true;
		}
		return false;

	}

	private LanguageResource() {
		super();
		try {
			loadProps();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private static void loadProps() throws Exception {
		File languageFile = new File("bin/"
				+ Language.getSCurrentLocaleLanguage().getLanguage() + ".xml");
		sProperties.loadFromXML(new FileInputStream(languageFile));

	}

	public static String getString(String pKey) {
		try {
			return getInstance().getProperties().getProperty(pKey);
		} catch (Exception e) {
			return "Somthing wrong in the translations";
		}
	}

	private Properties getProperties() {
		return sProperties;
	}

	public void setProperties(Properties pProperties) {
		sProperties = pProperties;
	}

}
