/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.guihelper.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

import net.dudesblog.rmc.util.constants.Constants;

public class PropertyManager {

	private static Properties sProperties = new Properties();

	private static PropertyManager sPropertyManager;

	private static PropertyManager getInstance() {
		if (sPropertyManager == null) {
			sPropertyManager = new PropertyManager();
		}
		return sPropertyManager;
	}

	private PropertyManager() {
		super();
		try {
			loadProps();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	private static void loadProps() {
		try {
			FileInputStream aFileInputStream = new FileInputStream(
					"bin/applicationProperties.xml");
			sProperties.loadFromXML(aFileInputStream);
			if (Constants.FileConstants.RMC_USER_CONFIG_FILE.exists()) {
				aFileInputStream = new FileInputStream(
						Constants.FileConstants.RMC_USER_CONFIG_FILE);
				sProperties.loadFromXML(aFileInputStream);
			} else {
				sProperties.setProperty("rmc.user.lf", "rmc");
				sProperties.setProperty("rmc.user.lf.sub", "Blue");
				sProperties.setProperty("rmc.user.lang", "en");
				sProperties.setProperty("rmc.user.lame", "lame -m s -V 4");
				sProperties.setProperty("rmc.user.mediafolder", "");
				sProperties.setProperty("rmc.user.outfolder", "");
				sProperties.setProperty("rmc.user.outformat", "mp3");
				sProperties.setProperty("rmc.user.delete", "false");
				sProperties.setProperty("rmc.user.threading", "m");
				sProperties.setProperty("rmc.user.customthreadsnumber", "");
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public static void setProperty(String pKey, String value) {
		getInstance().getProperties().setProperty(pKey, value);
	}

	public static String getProperty(String pKey) {
		try {
			return getInstance().getProperties().getProperty(pKey);
		} catch (Exception e) {
			return "";
		}
	}

	public static void saveUserSettings(Properties properties) {
		FileOutputStream stream;
		try {
			if (!Constants.FileConstants.RMC_USER_FOLDER.exists()) {
				Constants.FileConstants.RMC_USER_FOLDER.mkdir();
			}
			stream = new FileOutputStream(
					Constants.FileConstants.RMC_USER_CONFIG_FILE);
			properties
					.storeToXML(
							stream,
							"this file contains the user properties for Real Media Converter",
							"UTF-8");
			stream.close();
			for (Object key : properties.keySet()) {
				sProperties.setProperty(key.toString(), properties
						.getProperty(key.toString()));
			}
		} catch (FileNotFoundException e) {
			e.printStackTrace();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private Properties getProperties() {
		return sProperties;
	}

}
