/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

import net.dudesblog.guihelper.util.ErrorHandler;
import net.dudesblog.rmc.gui.MediaTable;

public class HelpAction extends AbstractConvertingAction implements
		ActionListener {

	private static final String OSName = System.getProperty("os.name")
			.toLowerCase();

	public HelpAction() {

	}

	@Override
	public void actionPerformed(ActionEvent arg0) {
		try {
			if (OSName.contains("mac")) {
				Runtime.getRuntime().exec("safari doc/index.html");
			} else if (OSName.contains("windows")) {
				Runtime.getRuntime().exec("explorer doc/index.html");
			} else {
				Runtime.getRuntime().exec("firefox doc/index.html");
			}
		} catch (IOException e) {
			ErrorHandler
					.handleError(
							e,
							"Error Launching default web browser",
							"<html>Error Launching default web browser,<br>you can still access documentation from :<br> {Real_Media_Converter_Home}/doc/index.html</html>",
							MediaTable.getInstance());
		}
	}

}
