/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.actions;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;

import javax.swing.JComponent;

import net.dudesblog.guihelper.util.ErrorHandler;
import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.rmc.core.JMPlayer;
import net.dudesblog.rmc.gui.ItemPanel;
import net.dudesblog.rmc.gui.MediaTable;
import net.dudesblog.rmc.gui.PlayerPanel;
import net.dudesblog.rmc.util.constants.Constants;

public class ItemSelectedAction implements MouseListener {

	@Override
	public void mouseClicked(MouseEvent event) {
		JComponent component = (JComponent) event.getSource();
		ItemPanel tempItemPanel = null;
		if (component.getName().equals(Constants.GUIConstants.PARENT)) {
			tempItemPanel = (ItemPanel) component;
		} else if (component.getName().equals(
				Constants.GUIConstants.SECOND_CHILD)) {
			tempItemPanel = (ItemPanel) component.getParent().getParent();
		} else if (component.getName().equals(
				Constants.GUIConstants.FIRST_CHILD)) {
			tempItemPanel = (ItemPanel) component.getParent();
		}
		final ItemPanel itemPanel = tempItemPanel;
		MediaTable.paintNewItem(itemPanel);
		MediaTable.getInstance().doFocus(itemPanel.getLocation());
		if (event.getClickCount() == 2) {
			new Thread(new Runnable() {
				public void run() {
					try {
						File file;
						if (itemPanel.isPathIsInvalid()) {
							file = itemPanel.getAliasFile();
						} else {
							file = itemPanel.getFile();
						}
						JMPlayer.getInstance().open(file);
					} catch (IOException e) {
						ErrorHandler.handleError(e, e.getCause().toString(),
								LanguageResource.getString("FILE_NOT_FOUND")
										+ itemPanel.getFileNameLabel()
												.getText(), null);
					}
				}
			}).start();
			PlayerPlayAction.togglePlay();
			PlayerPanel.setPauseIcon();
		}
		MediaTable.getInstance().setSelectedItemPanel(itemPanel);
	}

	@Override
	public void mouseEntered(MouseEvent event) {

	}

	@Override
	public void mouseExited(MouseEvent event) {

	}

	@Override
	public void mousePressed(MouseEvent event) {

	}

	@Override
	public void mouseReleased(MouseEvent event) {

	}

}
