/*
 *         Copyright (C) 2008 Fadi Al-katout (cutout) <cutout33@gmail.com>
 * 
 *  Real Media Converter is free software; you can redistribute it and/or modify   
 * it under the terms of the GNU General  Public Licence as published by the 
 * Free Software Foundation;  either version 2 of the Licence, 
 * or(at your option) any later version.
 * 
 * Real Media Converter is distributed in  the hope that it will be useful,
 * but WITHOUT ANY WARRANTY;  without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A  PARTICULAR PURPOSE. 
 * See the GNU General  Public Licence for more details.
 * 
 * You should have received a copy of  the GNU General Public Licence
 * along with Real Media Converter; 
 * if not, write to  the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor,  Boston, MA  02110-1301, USA
 */

package net.dudesblog.rmc.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;

import javax.swing.JFileChooser;

import net.dudesblog.guihelper.util.Language_util.LanguageResource;
import net.dudesblog.rmc.gui.ItemPanel;
import net.dudesblog.rmc.gui.MediaTable;
import net.dudesblog.rmc.util.file_filters.rmFilter;

public class OpenFileAction implements ActionListener {

	private JFileChooser mFileChooser;

	private String mediaFolder;

	public OpenFileAction(String property) {
		mediaFolder = property;
	}

	@Override
	public void actionPerformed(ActionEvent pEvent) {
		mFileChooser = new JFileChooser(mediaFolder);
		mFileChooser.setFileFilter(new rmFilter());
		mFileChooser.setMultiSelectionEnabled(true);
		mFileChooser.setDialogTitle(LanguageResource
				.getString("CHOOSE_FILES_TO_CONVERT"));
		int returnVal = mFileChooser.showOpenDialog(null);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			File[] aFiles = mFileChooser.getSelectedFiles();
			ItemPanel[] aItems = new ItemPanel[aFiles.length];
			for (int i = 0; i < aFiles.length; i++) {
				ItemPanel aItem = new ItemPanel(aFiles[i]);
				aItems[i] = aItem;
			}
			MediaTable.addFiles(aItems);
		}
	}

}
